/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.seisgram2k;

import ageco.misc.AgecPipedInputStream;
import ageco.misc.UrlToPipe;
import ageco.titan.TitanToBin;
import edu.iris.Fissures.seed.container.Blockette;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;
import net.alomax.io.GeneralInputStream;
import net.alomax.io.GeneralOutputStream;
import net.alomax.io.ZipStream;
import net.alomax.seis.BasicChannel;
import net.alomax.seis.BasicItem;
import net.alomax.seis.SEEDVolumeParser;
import net.alomax.seis.SeisDataCSMIP;
import net.alomax.seis.SeisDataINERIS;
import net.alomax.seis.SeisDataSEEDFull;
import net.alomax.seis.SeisDataTitan;
import net.alomax.seis.TitanDataSamples;
import net.alomax.seisgram2k.GatherPanel;
import net.alomax.seisgram2k.SeisGram2KFrame;
import net.alomax.seisgram2k.SeisGramText;
import net.alomax.seisgram2k.Seismogram;
import net.alomax.seisgram2k.SeismogramURL;
import net.alomax.util.StringExt;
import net.alomax.util.TimeInstant;
import sdsu.io.ASCIIInputStream;

public class DataManager {
    public static String[] channelGroupModes = new String[]{"AUTO_HEADER", "AUTO_FILENAME", "EACH_IN_OWN_GROUP", "ALL_IN_SAME_GROUP"};
    public final int AUTO_HEADER = 0;
    public final int AUTO_FILENAME = 1;
    public final int EACH_IN_OWN_GROUP = 2;
    public final int ALL_IN_SAME_GROUP = 3;
    protected int channelGroupMode = 0;
    protected int channelGroupAutoMaxCount = -1;
    protected int channelGroupAutoPosStart = -1;
    protected int channelGroupAutoPosEnd = -1;
    protected boolean concatenateChannels = false;
    protected SeisGram2KFrame seisFrame;

    protected DataManager(SeisGram2KFrame seisGram2KFrame) {
        this.seisFrame = seisGram2KFrame;
    }

    protected void writeMessage(String string) {
        this.seisFrame.writeMessage(string);
    }

    protected Vector getData(SeismogramURL[] seismogramURLArray, int n, boolean bl, boolean bl2) {
        Seismogram[] seismogramArray = this.readSeismograms(seismogramURLArray, true, bl, bl2);
        Vector vector = this.placeSeismograms(seismogramArray, n, bl);
        if (this.concatenateChannels) {
            vector = this.doConcatenateChannels(vector);
        }
        return vector;
    }

    protected Vector doConcatenateChannels(Vector vector) {
        Vector<GatherPanel> vector2 = new Vector<GatherPanel>();
        for (int i = 0; i < vector.size(); ++i) {
            GatherPanel gatherPanel = (GatherPanel)vector.elementAt(i);
            if (gatherPanel.getNumberSeismograms() < 1) continue;
            Seismogram seismogram = gatherPanel.getSeismogram(0);
            double d = seismogram.getTimeMax() - seismogram.getTimeMin();
            gatherPanel.unDoRemoveMean();
            block1: for (int j = i + 1; j < vector.size(); ++j) {
                GatherPanel gatherPanel2 = (GatherPanel)vector.elementAt(j);
                gatherPanel2.unDoRemoveMean();
                d += gatherPanel2.getSeismogram(0).getTimeMax() - gatherPanel2.getSeismogram(0).getTimeMin();
                for (int k = 0; k < gatherPanel.getNumberSeismograms(); ++k) {
                    seismogram = gatherPanel.getSeismogram(k);
                    Seismogram seismogram2 = gatherPanel2.getSeismogram(k);
                    if (seismogram2 == null || this.compareSampleInt(seismogram, seismogram2, -1.0) != 0 || !this.channelsMatch(seismogram, seismogram2)) continue block1;
                    gatherPanel.appendSeismogram(gatherPanel2.getSeismogram(k), 2.0 * d, true, true);
                    i = j;
                }
            }
            vector2.add(gatherPanel);
        }
        return vector2;
    }

    protected Vector placeSeismograms(Seismogram[] seismogramArray, int n, boolean bl) {
        Vector<GatherPanel> vector = new Vector<GatherPanel>();
        int n2 = n;
        int n3 = n;
        int n4 = 0;
        int n5 = this.seisFrame.getGatherListSize();
        while (n4 < seismogramArray.length) {
            Vector<Seismogram> vector2 = new Vector<Seismogram>();
            for (int i = 0; i < seismogramArray.length; ++i) {
                if (seismogramArray[i].seismogramURL.gatherIndex < 0) {
                    if (this.channelGroupMode == 0) {
                        if (vector2.size() >= 3) break;
                        boolean bl2 = true;
                        for (int j = 0; j < vector2.size(); ++j) {
                            if (this.goesWithAutoHeader(seismogramArray[i], (Seismogram)vector2.elementAt(j), bl)) continue;
                            bl2 = false;
                            break;
                        }
                        if (!bl2) continue;
                        seismogramArray[i].seismogramURL.gatherIndex = n2;
                        vector2.addElement(seismogramArray[i]);
                        continue;
                    }
                    if (this.channelGroupMode == 1) {
                        if (vector2.size() > 0 && !this.goesWithAutoFilename(seismogramArray[i].seismogramURL.URLname, ((Seismogram)vector2.elementAt((int)(vector2.size() - 1))).seismogramURL.URLname)) continue;
                        seismogramArray[i].seismogramURL.gatherIndex = n2;
                        vector2.addElement(seismogramArray[i]);
                        continue;
                    }
                    if (this.channelGroupMode == 3) {
                        seismogramArray[i].seismogramURL.gatherIndex = n2;
                        vector2.addElement(seismogramArray[i]);
                        continue;
                    }
                    seismogramArray[i].seismogramURL.gatherIndex = n2;
                    vector2.addElement(seismogramArray[i]);
                    break;
                }
                if (seismogramArray[i].seismogramURL.gatherIndex != n3) continue;
                seismogramArray[i].seismogramURL.gatherIndex = n2;
                vector2.addElement(seismogramArray[i]);
            }
            ++n3;
            if (vector2.size() == 0) {
                if (n3 < 9999) continue;
                break;
            }
            Object[] objectArray = new Seismogram[vector2.size()];
            vector2.copyInto(objectArray);
            GatherPanel gatherPanel = new GatherPanel(this.seisFrame, this.seisFrame.numDecimals, this.seisFrame.numberRowsInGroup, this.seisFrame.gatherFontSizeFactor, this.seisFrame.gatherFontStyle);
            gatherPanel.addSeismograms((Seismogram[])objectArray);
            gatherPanel.setDefaultSortOrder(n5++);
            vector.addElement(gatherPanel);
            ++n2;
            n4 += vector2.size();
        }
        return vector;
    }

    protected boolean getConcatenateChannels() {
        return this.concatenateChannels;
    }

    protected void setConcatenateChannels(boolean bl) {
        this.concatenateChannels = bl;
    }

    protected String getChannelGroupMode() {
        return channelGroupModes[this.channelGroupMode];
    }

    protected void setChannelGroupMode(String string) {
        if (string == null) {
            this.channelGroupMode = 0;
        } else if (string.toUpperCase().startsWith("AUTO_HEADER")) {
            this.channelGroupMode = 0;
        } else if (string.toUpperCase().startsWith("ALL")) {
            this.channelGroupMode = 3;
        } else if (string.toUpperCase().startsWith("SINGLE") || string.toUpperCase().startsWith("EACH")) {
            this.channelGroupMode = 2;
        } else if (string.toUpperCase().startsWith("AUTO")) {
            this.channelGroupMode = 1;
            String[] stringArray = StringExt.parse(string, ",");
            try {
                this.channelGroupAutoMaxCount = Integer.valueOf(stringArray[1]);
            }
            catch (Exception exception) {
                System.out.println(this.getClass().getName() + " ERROR: parsing channel groupmode <nchar>: " + string);
                this.channelGroupAutoMaxCount = -1;
            }
            try {
                this.channelGroupAutoPosStart = Integer.valueOf(stringArray[2]);
            }
            catch (Exception exception) {
                System.out.println(this.getClass().getName() + " WARNING: parsing channel groupmode <pos_start>: " + string);
                this.channelGroupAutoPosStart = -1;
            }
            try {
                this.channelGroupAutoPosEnd = Integer.valueOf(stringArray[3]);
            }
            catch (Exception exception) {
                System.out.println(this.getClass().getName() + " WARNING: parsing channel groupmode <pos_end>: " + string);
                this.channelGroupAutoPosEnd = -1;
            }
        }
    }

    protected boolean goesWithAutoHeader(Seismogram seismogram, Seismogram seismogram2, boolean bl) {
        return this.compareTimes(seismogram, seismogram2, -1.0) == 0 && this.compareSampleInt(seismogram, seismogram2, -1.0) == 0 && this.channelsMatch(seismogram, seismogram2);
    }

    protected boolean goesWithAutoFilename(String string, String string2) {
        int n = StringExt.countCharsDifferent(string, string2);
        if (n > this.channelGroupAutoMaxCount) {
            return false;
        }
        if (this.channelGroupAutoPosStart >= 0 && this.channelGroupAutoPosEnd >= 0) {
            int n2 = string.length();
            int n3 = string2.length();
            int n4 = StringExt.countCharsDifferent(string.substring(n2 - this.channelGroupAutoPosStart - 1, n2 - this.channelGroupAutoPosEnd), string2.substring(n3 - this.channelGroupAutoPosStart - 1, n3 - this.channelGroupAutoPosEnd));
            if (n4 != n) {
                return false;
            }
        }
        return true;
    }

    protected Seismogram[] readSeismograms(SeismogramURL[] seismogramURLArray, boolean bl, boolean bl2, boolean bl3) {
        Vector vector = new Vector();
        for (int i = 0; i < seismogramURLArray.length; ++i) {
            int n;
            InputStream inputStream;
            if (seismogramURLArray[i] == null || (inputStream = this.openSeismogramInputStream(seismogramURLArray[i].URLname, bl)) == null) continue;
            String string = seismogramURLArray[i].formatName;
            if (string.equalsIgnoreCase("AUTO")) {
                n = 0;
                string = Seismogram.determineFormatAuto(inputStream, seismogramURLArray[i].binaryTypeName);
                if (string == null && (seismogramURLArray[i].URLname.toUpperCase().endsWith("TIT") || seismogramURLArray[i].URLname.toUpperCase().endsWith("TITAN"))) {
                    int n2 = vector.size();
                    if ((vector = this.readTitanVolume(seismogramURLArray[i], vector, false, bl3)).size() > n2) {
                        string = "TITAN";
                        n = 1;
                    }
                }
                if (string == null) {
                    if (bl3) continue;
                    String string2 = this.getClass().getName() + ": " + "ERROR: cannot determine channel format: " + seismogramURLArray[i].URLname;
                    System.out.println(string2);
                    this.writeMessage(string2);
                    continue;
                }
                String string3 = "INFO: " + seismogramURLArray[i].URLname + ": auto channel format= " + string;
                System.out.println(string3);
                seismogramURLArray[i].formatName = string;
                if (n != 0) continue;
            }
            if (Seismogram.isVolumeFormat(string)) {
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                    if (!bl3 && (ZipStream.isGzip(seismogramURLArray[i].URLname) || ZipStream.isZip(seismogramURLArray[i].URLname))) {
                        String string4 = "WARNING: .zip and .gz compressed files not supported with FULL_SEED and TITAN volume formats.";
                        System.out.println(this.getClass().getName() + ": " + string4);
                        this.writeMessage(string4);
                    }
                    if (string.equalsIgnoreCase("FULL_SEED")) {
                        vector = this.readSEEDVolume(seismogramURLArray[i], vector, bl2, bl3);
                        continue;
                    }
                    if (string.equalsIgnoreCase("TITAN")) {
                        vector = this.readTitanVolume(seismogramURLArray[i], vector, bl2, bl3);
                        continue;
                    }
                    if (string.equalsIgnoreCase("INERIS_ASCII")) {
                        vector = this.readINERISVolume(seismogramURLArray[i], vector, bl2, bl3);
                        continue;
                    }
                    if (!string.equalsIgnoreCase("CDMG_CSMIP")) continue;
                    vector = this.readCSMIPVolume(seismogramURLArray[i], vector, bl2, bl3);
                }
                catch (IOException iOException) {}
                continue;
            }
            try {
                n = 0;
                do {
                    try {
                        Seismogram seismogram = this.readSeismogramInputStream(inputStream, seismogramURLArray[i], bl2, n > 0);
                        if (seismogram == null) break;
                        vector.addElement(seismogram);
                    }
                    catch (Exception exception) {
                        String string5 = "ERROR: " + exception;
                        System.out.println(this.getClass().getName() + ": " + string5);
                        this.writeMessage(string5);
                        break;
                    }
                    ++n;
                } while (inputStream.available() > 0);
                if (inputStream == null) continue;
                inputStream.close();
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        Object[] objectArray = new Seismogram[vector.size()];
        if (vector.size() > 0) {
            vector.copyInto(objectArray);
        }
        return objectArray;
    }

    public InputStream openSeismogramInputStream(String string, boolean bl) {
        InputStream inputStream = null;
        try {
            inputStream = GeneralInputStream.openStream(this.seisFrame.getDocumentBase(), string, bl);
        }
        catch (IOException iOException) {
            String string2 = SeisGramText.ERROR_OPENING_INPUT_FILE + string;
            System.out.println(this.getClass().getName() + ": " + string2);
            this.writeMessage(string2);
            string2 = iOException.toString();
            System.out.println(string2);
            this.writeMessage(string2);
            return null;
        }
        InputStream inputStream2 = inputStream;
        try {
            inputStream2 = ZipStream.getInputStream(new BufferedInputStream(inputStream), string);
        }
        catch (IOException iOException) {
            String string3 = iOException.toString();
            this.writeMessage("_READY");
            this.writeMessage(string3);
        }
        return inputStream2;
    }

    public OutputStream openSeismogramOutputStream(String string) {
        OutputStream outputStream = null;
        try {
            outputStream = GeneralOutputStream.openStream(this.seisFrame.getDocumentBase(), string);
        }
        catch (Exception exception) {
            String string2 = SeisGramText.ERROR_OPENING_OUTPUT_FILE + string + ": " + exception.getMessage();
            System.out.println(this.getClass().getName() + ": " + string2);
            this.writeMessage("_READY");
            this.writeMessage(string2);
            return null;
        }
        OutputStream outputStream2 = outputStream;
        try {
            outputStream2 = ZipStream.getOutputStream(new BufferedOutputStream(outputStream), string);
        }
        catch (IOException iOException) {
            String string3 = iOException.toString();
            this.writeMessage("_READY");
            this.writeMessage(string3);
        }
        return outputStream2;
    }

    public Vector readSEEDVolume(SeismogramURL seismogramURL, Vector vector, boolean bl, boolean bl2) {
        boolean bl3 = bl;
        if (bl && !bl2) {
            this.writeMessage(SeisGramText.READING_DATA_VOLUME + ": " + seismogramURL.URLname + "...");
        }
        Object var6_6 = null;
        try {
            SEEDVolumeParser sEEDVolumeParser = new SEEDVolumeParser(this.seisFrame.getDocumentBase(), seismogramURL.URLname, true);
            boolean bl4 = false;
            boolean bl5 = true;
            boolean bl6 = bl;
            sEEDVolumeParser.readHeaders(bl5, bl6);
            if (bl3) {
                String string = sEEDVolumeParser.getControlHeadersString();
                System.out.println("\nheaderFieldString\n" + string);
            }
            int n = sEEDVolumeParser.getIntValue(11, "Number of stations", 1);
            if (bl3) {
                System.out.println("\nNumber of stations = " + n);
            }
            Blockette[] blocketteArray = sEEDVolumeParser.getBlockettes(74);
            if (bl3) {
                System.out.println("\nNumber of timeSeriesIndexBlks = " + blocketteArray.length);
            }
            for (int i = 0; i < blocketteArray.length; ++i) {
                if (bl3) {
                    System.out.println(blocketteArray[i]);
                }
                SeisDataSEEDFull seisDataSEEDFull = new SeisDataSEEDFull();
                seisDataSEEDFull.read(sEEDVolumeParser, blocketteArray[i], bl);
                Seismogram seismogram = new Seismogram(this.seisFrame, seisDataSEEDFull, seismogramURL, true);
                vector.addElement(seismogram);
            }
        }
        catch (Exception exception) {
            if (!bl2) {
                String string = "ERROR: reading SEED volume: " + seismogramURL.URLname + ": " + exception;
                System.out.println(this.getClass().getName() + ": " + string);
                if (SeisGram2KFrame.PRINT_STACK_TRACES) {
                    exception.printStackTrace();
                }
                this.writeMessage("_READY");
                this.writeMessage(string);
            }
            return vector;
        }
        if (bl && bl2) {
            this.writeMessage("_READY");
        }
        return vector;
    }

    public Vector readCSMIPVolume(SeismogramURL seismogramURL, Vector vector, boolean bl, boolean bl2) {
        if (bl && !bl2) {
            this.writeMessage(SeisGramText.READING_DATA_VOLUME + ": " + seismogramURL.URLname + "...");
        }
        this.seisFrame.numDecimals = 4;
        Exception exception = null;
        int n = 0;
        try {
            while (true) {
                InputStream inputStream = this.openSeismogramInputStream(seismogramURL.URLname, false);
                ASCIIInputStream aSCIIInputStream = new ASCIIInputStream(inputStream);
                SeisDataCSMIP seisDataCSMIP = new SeisDataCSMIP(n);
                seisDataCSMIP.read(aSCIIInputStream);
                try {
                    aSCIIInputStream.close();
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                Seismogram seismogram = new Seismogram(this.seisFrame, seisDataCSMIP, seismogramURL, false);
                vector.addElement(seismogram);
                ++n;
            }
        }
        catch (Exception exception3) {
            exception = exception3;
            if (SeisGram2KFrame.PRINT_STACK_TRACES) {
                exception3.printStackTrace();
            }
            if (!bl2 && n < 1) {
                String string = "ERROR: reading CSMIP volume: " + seismogramURL.URLname + ": last Exception: " + exception;
                System.out.println(this.getClass().getName() + ": " + string);
                if (SeisGram2KFrame.PRINT_STACK_TRACES && exception != null) {
                    exception.printStackTrace();
                }
                this.writeMessage(string);
            }
            if (bl && !bl2) {
                this.writeMessage("_READY");
            }
            return vector;
        }
    }

    public Vector readINERISVolume(SeismogramURL seismogramURL, Vector vector, boolean bl, boolean bl2) {
        if (bl && !bl2) {
            this.writeMessage(SeisGramText.READING_DATA_VOLUME + ": " + seismogramURL.URLname + "...");
        }
        this.seisFrame.numDecimals = 5;
        Exception exception = null;
        int n = 0;
        try {
            while (true) {
                InputStream inputStream = this.openSeismogramInputStream(seismogramURL.URLname, false);
                ASCIIInputStream aSCIIInputStream = new ASCIIInputStream(inputStream);
                SeisDataINERIS seisDataINERIS = new SeisDataINERIS(n);
                seisDataINERIS.read(aSCIIInputStream);
                try {
                    aSCIIInputStream.close();
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                Seismogram seismogram = new Seismogram(this.seisFrame, seisDataINERIS, seismogramURL, false);
                vector.addElement(seismogram);
                ++n;
            }
        }
        catch (Exception exception3) {
            exception = exception3;
            if (SeisGram2KFrame.PRINT_STACK_TRACES) {
                exception3.printStackTrace();
            }
            if (!bl2 && n < 1) {
                String string = "ERROR: reading INERIS volume: " + seismogramURL.URLname + ": last Exception: " + exception;
                System.out.println(this.getClass().getName() + ": " + string);
                if (SeisGram2KFrame.PRINT_STACK_TRACES && exception != null) {
                    exception.printStackTrace();
                }
                this.writeMessage(string);
            }
            if (bl && !bl2) {
                this.writeMessage("_READY");
            }
            return vector;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector readTitanVolume(SeismogramURL seismogramURL, Vector vector, boolean bl, boolean bl2) {
        Object object;
        if (bl && !bl2) {
            this.writeMessage(SeisGramText.READING_DATA_VOLUME + ": " + seismogramURL.URLname + "...");
        }
        Exception exception = null;
        int n = 0;
        int n2 = 5;
        UrlToPipe urlToPipe = null;
        try {
            object = new AgecPipedInputStream();
            urlToPipe = SeisDataTitan.openTitan_UrlToPipe((AgecPipedInputStream)object, this.seisFrame.getDocumentBase(), seismogramURL.URLname);
            urlToPipe.start();
            TitanToBin titanToBin = SeisDataTitan.openTitan_TitanToBin((AgecPipedInputStream)object);
            try {
                TitanDataSamples titanDataSamples = SeisDataTitan.fillSamples(titanToBin, bl);
                for (int i = 0; i < titanDataSamples.dataSamples.length; ++i) {
                    SeisDataTitan seisDataTitan = new SeisDataTitan(titanToBin, i, titanDataSamples.dataSamples[i], titanDataSamples.startTimeCalendar[i]);
                    Seismogram seismogram = new Seismogram(this.seisFrame, seisDataTitan, seismogramURL, false);
                    vector.addElement(seismogram);
                    ++n;
                }
            }
            catch (Exception exception2) {
                exception = exception2;
                if (SeisGram2KFrame.PRINT_STACK_TRACES) {
                    exception2.printStackTrace();
                }
            }
        }
        catch (Exception exception3) {
            exception = exception3;
            if (SeisGram2KFrame.PRINT_STACK_TRACES) {
                exception3.printStackTrace();
            }
        }
        finally {
            if (urlToPipe != null) {
                urlToPipe.kill();
            }
        }
        if (!bl2 && n < 1) {
            object = "ERROR: reading TITAN volume: " + seismogramURL.URLname + ": last Exception: " + exception;
            System.out.println(this.getClass().getName() + ": " + (String)object);
            if (SeisGram2KFrame.PRINT_STACK_TRACES && exception != null) {
                exception.printStackTrace();
            }
            this.writeMessage((String)object);
        }
        if (bl && !bl2) {
            this.writeMessage("_READY");
        }
        return vector;
    }

    public Seismogram readSeismogramInputStream(InputStream inputStream, SeismogramURL seismogramURL, boolean bl) throws Exception {
        return this.readSeismogramInputStream(inputStream, seismogramURL, bl, false);
    }

    public Seismogram readSeismogramInputStream(InputStream inputStream, SeismogramURL seismogramURL, boolean bl, boolean bl2) throws Exception {
        return this.readSeismogramInputStream(inputStream, seismogramURL, bl, bl2, false);
    }

    public Seismogram readSeismogramInputStream(InputStream inputStream, SeismogramURL seismogramURL, boolean bl, boolean bl2, boolean bl3) throws Exception {
        if (bl) {
            this.writeMessage(SeisGramText.READING_SEISMOGRAM + ": " + seismogramURL.URLname);
        }
        String string = "   May indicate incorrect format, binarytype (binary data byte order), or corrupted data file header.";
        Seismogram seismogram = null;
        try {
            seismogram = new Seismogram(this.seisFrame, inputStream, seismogramURL, true);
        }
        catch (NegativeArraySizeException negativeArraySizeException) {
            if (bl2) {
                return null;
            }
            String string2 = "ERROR: negative array size reading: " + seismogramURL.URLname;
            System.out.println(this.getClass().getName() + ": " + string2);
            if (SeisGram2KFrame.PRINT_STACK_TRACES) {
                negativeArraySizeException.printStackTrace();
            }
            this.writeMessage("_READY");
            this.writeMessage(string2);
            string2 = string;
            this.writeMessage(string2);
            return null;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            if (bl2) {
                return null;
            }
            String string3 = "ERROR: out of memory reading: " + seismogramURL.URLname;
            System.out.println(this.getClass().getName() + ": " + string3);
            this.writeMessage(string3);
            string3 = string;
            this.writeMessage(string3);
            SeisGram2KFrame.doOutOfMemoryAction(true);
            return null;
        }
        catch (Exception exception) {
            if (bl2) {
                return null;
            }
            if (bl3) {
                throw exception;
            }
            String string4 = "ERROR: reading: " + seismogramURL.URLname + ": " + exception;
            System.out.println(this.getClass().getName() + ": " + string4);
            if (SeisGram2KFrame.PRINT_STACK_TRACES) {
                exception.printStackTrace();
            }
            this.writeMessage(string4);
            return null;
        }
        return seismogram;
    }

    public void closeSeismogramInputStream(InputStream inputStream) {
        try {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void closeSeismogramOutputStream(OutputStream outputStream) {
        try {
            if (outputStream != null) {
                outputStream.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int writeSeismograms(Seismogram[] seismogramArray, SeismogramURL[] seismogramURLArray, int n, boolean bl, String string) {
        int n2;
        SeismogramURL[] seismogramURLArray2 = new SeismogramURL[seismogramURLArray.length];
        OutputStream[] outputStreamArray = new OutputStream[seismogramURLArray.length];
        for (n2 = 0; n2 < seismogramURLArray.length; ++n2) {
            int n3;
            String string2 = "";
            if (bl) {
                string2 = "000" + n2;
                string2 = "." + string2.substring(string2.length() - 3, string2.length());
                if (n >= 0) {
                    String string3 = "000" + n;
                    string3 = string3.substring(string3.length() - 3, string3.length());
                    string2 = "." + string3 + string2;
                }
            }
            seismogramURLArray2[n2] = new SeismogramURL(seismogramURLArray[n2]);
            if (string != null) {
                seismogramURLArray2[n2].formatName = string;
            }
            for (n3 = 0; n3 < Seismogram.channelFormatsWrite.length && !Seismogram.channelFormatsWrite[n3].equals(seismogramURLArray2[n2].formatName); ++n3) {
            }
            if (n3 >= Seismogram.channelFormatsWrite.length) {
                seismogramURLArray2[n2].formatName = Seismogram.channelFormatsWrite[0];
            }
            String string4 = seismogramURLArray2[n2].formatName.substring(0, 3).toLowerCase();
            if (!seismogramURLArray2[n2].URLname.toLowerCase().endsWith(string4)) {
                string2 = string2 + "." + string4;
            }
            outputStreamArray[n2] = this.openSeismogramOutputStream(seismogramURLArray2[n2].URLname + string2);
        }
        n2 = 0;
        try {
            n2 = this.writeSeismograms(outputStreamArray, seismogramURLArray2, seismogramArray, true);
        }
        catch (Exception exception) {
            String string5 = "ERROR: " + exception;
            System.out.println(this.getClass().getName() + ": " + string5);
            if (SeisGram2KFrame.PRINT_STACK_TRACES) {
                exception.printStackTrace();
            }
            this.writeMessage(string5);
        }
        for (int i = 0; i < seismogramURLArray2.length; ++i) {
            try {
                if (outputStreamArray[i] == null) continue;
                outputStreamArray[i].flush();
                outputStreamArray[i].close();
                continue;
            }
            catch (IOException iOException) {
                System.out.println(iOException);
            }
        }
        return n2;
    }

    public int writeSeismograms(OutputStream[] outputStreamArray, SeismogramURL[] seismogramURLArray, Seismogram[] seismogramArray, boolean bl) throws Exception {
        int n = 0;
        for (int i = 0; i < outputStreamArray.length; ++i) {
            OutputStream outputStream = outputStreamArray[i];
            if (outputStream == null) continue;
            if (bl) {
                this.writeMessage("Writing seismogram: " + seismogramURLArray[i].URLname + "...");
            }
            seismogramArray[i].write(outputStream, seismogramURLArray[i].formatName, seismogramURLArray[i].binaryTypeName);
            ++n;
            if (!bl) continue;
            this.writeMessage("_READY");
        }
        return n;
    }

    public int compareTimes(Seismogram seismogram, Seismogram seismogram2, double d) {
        double d2;
        if (d < 0.0) {
            d = 0.9 * seismogram.timeSeries.sampleInt * (double)seismogram.timeSeries.sampleLength();
        }
        if (Math.abs(d2 = TimeInstant.secondsDifference(seismogram.refTimeInstant, seismogram2.refTimeInstant)) <= d) {
            return 0;
        }
        return d2 > 0.0 ? 1 : -1;
    }

    public int compareSampleInt(Seismogram seismogram, Seismogram seismogram2, double d) {
        double d2;
        if (d < 0.0) {
            d = 0.01 * seismogram.timeSeries.sampleInt;
        }
        if (Math.abs(d2 = seismogram.timeSeries.sampleInt - seismogram2.timeSeries.sampleInt) <= d) {
            return 0;
        }
        return d2 > 0.0 ? 1 : -1;
    }

    public boolean channelsMatch(Seismogram seismogram, Seismogram seismogram2) {
        boolean bl = false;
        if (bl) {
            System.out.println("");
        }
        if (bl && bl) {
            System.out.println("evtName P " + seismogram.evtName + " " + seismogram2.evtName);
        }
        if (seismogram.evtName.compareTo(BasicItem.UNDEF_STRING) != 0 && seismogram2.evtName.compareTo(BasicItem.UNDEF_STRING) != 0) {
            int n = StringExt.countCharsSame(seismogram.evtName, seismogram2.evtName);
            if (seismogram.evtName.length() - n > 1 || seismogram2.evtName.length() - n > 1) {
                return false;
            }
        }
        BasicChannel basicChannel = seismogram.channel;
        BasicChannel basicChannel2 = seismogram2.channel;
        if (bl && bl) {
            System.out.println(", network Y " + basicChannel.network + " " + basicChannel2.network);
        }
        if (BasicItem.compareFields(basicChannel.network, basicChannel2.network) != 0) {
            return false;
        }
        if (bl && bl) {
            System.out.println(", staName Y " + basicChannel.staName + " " + basicChannel2.staName);
        }
        if (BasicItem.compareFields(basicChannel.staName, basicChannel2.staName) != 0) {
            return false;
        }
        if (bl && bl) {
            System.out.println(", instName Y " + basicChannel.instName + " " + basicChannel2.instName);
        }
        if (BasicItem.compareFields(basicChannel.instName, basicChannel2.instName) != 0) {
            return false;
        }
        if (bl && bl) {
            System.out.println(", compName N " + basicChannel.compName + " " + basicChannel2.compName);
        }
        if (basicChannel.compName.compareTo(BasicItem.UNDEF_STRING) != 0 && basicChannel2.compName.compareTo(BasicItem.UNDEF_STRING) != 0 && BasicItem.compareFields(basicChannel.compName, basicChannel2.compName) == 0) {
            return false;
        }
        if (bl && bl) {
            System.out.println(", inclination N " + basicChannel.inclination + " " + basicChannel2.inclination);
        }
        boolean bl2 = false;
        if (basicChannel.inclination != Double.MAX_VALUE && basicChannel2.inclination != Double.MAX_VALUE && BasicItem.compareFields(basicChannel.inclination, basicChannel2.inclination, 1.0) == 0) {
            bl2 = true;
        }
        if (bl && bl) {
            System.out.println(", azimuth N " + basicChannel.azimuth + " " + basicChannel2.azimuth);
        }
        boolean bl3 = false;
        if (basicChannel.azimuth != Double.MAX_VALUE && basicChannel2.azimuth != Double.MAX_VALUE && BasicItem.compareFields(basicChannel.azimuth, basicChannel2.azimuth, 1.0) == 0) {
            bl3 = true;
        }
        if (bl2 && bl3) {
            int n;
            if (bl && bl) {
                System.out.println(", chanName P " + basicChannel.chanName + " " + basicChannel2.chanName);
            }
            if (basicChannel.chanName.compareTo(BasicItem.UNDEF_STRING) != 0 && basicChannel2.chanName.compareTo(BasicItem.UNDEF_STRING) != 0 && (n = StringExt.countCharsSame(basicChannel.chanName, basicChannel2.chanName)) > 0 && n != basicChannel.chanName.length() && n != basicChannel2.chanName.length()) {
                return false;
            }
        }
        return true;
    }
}

