/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.seisgram2k;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import java.util.Collection;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import net.alomax.seisgram2k.GatherPanel;
import net.alomax.seisgram2k.IndicatorJPanel;
import net.alomax.seisgram2k.SeisGram2KFrame;
import net.alomax.swing.JImagePanel;

public class GatherDisplayManager
extends JPanel
implements AdjustmentListener,
MouseListener,
MouseWheelListener {
    protected SeisGram2KFrame seisFrame;
    protected JPanel mainPanel = new JPanel();
    protected JScrollBar groupScrollbar;
    protected JScrollBar timeScrollbar;
    protected IndicatorJPanel readingIndicatorPanel;
    protected Collection gatherVector = new Vector();
    protected Collection gatherList = new TreeSet();
    protected int firstVisible = 0;
    protected int lastVisible = 0;
    protected int maxNumberVisible;
    protected boolean showAuxillaryPanel = false;
    protected boolean isFullWindow = false;
    protected boolean isRingDisplay = false;
    protected boolean updateAll = false;
    protected boolean updateGroupScroll = false;
    protected boolean externalTimeScrollbarChange = false;
    protected int gatherListSizeAtLastUpdate = -1;
    protected Image splashScreenImage = null;
    protected JImagePanel jImagePanel = null;
    int savedFirstVisible;
    int savedMaxNumberVisible;
    protected boolean mouseButtonDown = false;
    long timeLastTimeScrollBarAdjustment = System.currentTimeMillis();
    boolean processedLastTimeScrollBarAdjustmentEvent = true;
    int nSkip = 0;
    protected final int TIME_SCROLL_WIDTH = 100000;

    GatherDisplayManager(SeisGram2KFrame seisGram2KFrame, int n, boolean bl) {
        this.maxNumberVisible = n;
        this.seisFrame = seisGram2KFrame;
        this.gatherList = new TreeSet(this.gatherVector);
        this.showAuxillaryPanel = bl;
        this.groupScrollbar = new JScrollBar(1);
        this.groupScrollbar.addAdjustmentListener(this);
        this.addMouseWheelListener(this);
        this.timeScrollbar = new JScrollBar(0);
        this.timeScrollbar.addAdjustmentListener(this);
        this.timeScrollbar.addMouseListener(this);
        this.readingIndicatorPanel = new IndicatorJPanel();
        this.setIndicator(IndicatorJPanel.INDICATOR_OFF);
        this.setLayout(new BorderLayout(0, 0));
        this.mainPanel.setLayout(new GridLayout(0, 1, 0, 0));
        this.mainPanel = new JPanel();
        this.add((Component)this.mainPanel, "Center");
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.timeScrollbar, "Center");
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)new JLabel(" "), "Center");
        jPanel2.add((Component)this.readingIndicatorPanel, "East");
        jPanel.add((Component)jPanel2, "East");
        this.add((Component)jPanel, "South");
    }

    public synchronized Component add(GatherPanel gatherPanel) {
        this.gatherVector.add(gatherPanel);
        this.gatherList = new TreeSet(this.gatherVector);
        return gatherPanel;
    }

    public synchronized void remove(GatherPanel gatherPanel) {
        this.gatherVector.remove(gatherPanel);
        this.gatherList = new TreeSet(this.gatherVector);
        this.updateDisplay(true);
    }

    public synchronized void resetSort() {
        this.gatherList = new TreeSet(this.gatherVector);
        this.updateDisplay(true);
    }

    public synchronized void setShowAuxillaryPanel(boolean bl) {
        if (!bl && !this.showAuxillaryPanel || bl && this.showAuxillaryPanel) {
            return;
        }
        this.showAuxillaryPanel = bl;
        this.updateDisplay(true);
    }

    public void setRingDisplay(boolean bl) {
        this.isRingDisplay = bl;
    }

    public int getFirstVisible() {
        return this.firstVisible;
    }

    public int getLastVisible() {
        return this.lastVisible;
    }

    protected int getGatherListIndexOf(GatherPanel gatherPanel) {
        Iterator iterator = this.gatherList.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            GatherPanel gatherPanel2 = (GatherPanel)iterator.next();
            if (gatherPanel2.equals(gatherPanel)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    protected GatherPanel getGatherListElementAt(int n) {
        Iterator iterator = this.gatherList.iterator();
        while (iterator.hasNext() && n-- > 0) {
            iterator.next();
        }
        if (!iterator.hasNext()) {
            return null;
        }
        return (GatherPanel)iterator.next();
    }

    protected int getGatherListSize() {
        return this.gatherList.size();
    }

    public boolean setFirstVisible(GatherPanel gatherPanel) {
        int n = this.getGatherListIndexOf(gatherPanel);
        if (this.firstVisible == n) {
            return true;
        }
        if (this.isRingDisplay) {
            this.firstVisible = n;
        } else if (n <= this.getGatherListSize() - this.maxNumberVisible) {
            this.firstVisible = n;
        } else if (n > this.getLastVisible()) {
            this.firstVisible = this.getGatherListSize() - this.maxNumberVisible;
        }
        this.updateDisplay(true);
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean checkVisible(GatherPanel gatherPanel) {
        int n = this.getGatherListIndexOf(gatherPanel);
        if (this.isRingDisplay) {
            if (this.isVisible(gatherPanel)) return false;
            this.firstVisible = n;
        } else if (n < this.getFirstVisible()) {
            this.firstVisible = n;
        } else {
            if (n <= this.getLastVisible()) return false;
            this.firstVisible += n - this.getLastVisible();
        }
        this.updateDisplay(true);
        return true;
    }

    public boolean isVisible(GatherPanel gatherPanel) {
        int n = this.getGatherListIndexOf(gatherPanel);
        if (this.isRingDisplay && this.getLastVisible() < this.getFirstVisible()) {
            return n >= this.getFirstVisible() && n < this.getGatherListSize() || n >= 0 && n <= this.getLastVisible();
        }
        return n >= this.getFirstVisible() && n <= this.getLastVisible();
    }

    protected void repaintAllGathers() {
        for (GatherPanel gatherPanel : this.gatherList) {
            gatherPanel.repaint();
        }
    }

    protected void repaint(GatherPanel gatherPanel) {
        gatherPanel.repaint();
    }

    public void paint(GatherPanel gatherPanel, Graphics graphics, Dimension dimension, boolean bl, boolean bl2, boolean bl3) {
        try {
            gatherPanel.paintImp(graphics, dimension, bl, bl2, bl3);
        }
        catch (Exception exception) {
            if (SeisGram2KFrame.PRINT_IGNORED_EXCEPTIONS) {
                exception.printStackTrace();
            }
            System.out.println("INFO: GatherDisplayManager.paint(GatherPanel, ...): Exception ignored: " + exception);
        }
    }

    public void paint(Graphics graphics) {
        if (this.updateAll || this.gatherListSizeAtLastUpdate != this.getGatherListSize()) {
            this.updateDisplay();
        }
        this.updateAll = false;
        super.paint(graphics);
    }

    protected void updateDisplay(boolean bl) {
        if (bl) {
            this.updateGroupScroll = true;
        }
        this.updateAll = true;
        this.repaint();
    }

    public BufferedImage paintSnapshot(int n) {
        int n2 = 0;
        try {
            n2 = this.getGatherListElementAt((int)0).selectPanel.getWidth();
        }
        catch (Exception exception) {
            n2 = 0;
        }
        BufferedImage bufferedImage = new BufferedImage(this.mainPanel.getWidth() - n2, this.mainPanel.getHeight(), n);
        Graphics graphics = bufferedImage.getGraphics();
        this.mainPanel.paint(graphics);
        graphics.dispose();
        return bufferedImage;
    }

    protected void setSplashScreenImage(Image image) {
        this.splashScreenImage = image;
    }

    protected void updateDisplay() {
        if (!this.seisFrame.isInitialized()) {
            return;
        }
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = null;
        JPanel jPanel3 = null;
        if (this.showAuxillaryPanel) {
            jPanel.setLayout(new BorderLayout());
            jPanel2 = new JPanel(new GridLayout(0, 1, 0, 0));
            jPanel3 = new JPanel(new GridLayout(0, 1, 0, 0));
            jPanel.add((Component)jPanel2, "West");
            jPanel.add((Component)jPanel3, "Center");
        } else {
            jPanel.setLayout(new GridLayout(0, 1, 0, 0));
        }
        if (this.getGatherListSize() > 0) {
            int n;
            if (this.getGatherListSize() <= this.maxNumberVisible) {
                this.firstVisible = 0;
            } else if (!this.isRingDisplay) {
                while (this.firstVisible + this.maxNumberVisible > this.getGatherListSize()) {
                    --this.firstVisible;
                }
            }
            boolean bl = false;
            for (n = this.firstVisible; n < this.firstVisible + this.maxNumberVisible && (this.isRingDisplay || n < this.getGatherListSize()); ++n) {
                int n2 = n % this.getGatherListSize();
                GatherPanel gatherPanel = this.getGatherListElementAt(n2);
                if (gatherPanel == this.seisFrame.getActiveGather()) {
                    bl = true;
                }
                if (this.showAuxillaryPanel) {
                    JPanel jPanel4 = gatherPanel.getAuxilliaryPanel();
                    if (jPanel4 != null) {
                        jPanel2.add(gatherPanel.getAuxilliaryPanel());
                    } else {
                        jPanel2.add(new JPanel());
                    }
                    jPanel3.add(gatherPanel);
                } else {
                    jPanel.add(gatherPanel);
                }
                this.lastVisible = n2;
            }
            if (this.isRingDisplay) {
                this.getGatherListElementAt(this.firstVisible).selectGather();
            } else if (!bl) {
                n = -1;
                try {
                    n = this.getGatherListIndexOf(this.seisFrame.getActiveGather());
                }
                catch (Exception exception) {
                    n = -1;
                }
                if (n < this.firstVisible) {
                    this.getGatherListElementAt(this.firstVisible).selectGather();
                } else {
                    this.getGatherListElementAt(this.lastVisible).selectGather();
                }
            }
        } else if (this.splashScreenImage != null) {
            if (this.jImagePanel == null) {
                this.jImagePanel = new JImagePanel(this.splashScreenImage);
                this.jImagePanel.setBackground(new Color(0, 0, 123));
            }
            jPanel.add(this.jImagePanel);
        }
        this.remove(this.mainPanel);
        this.mainPanel = jPanel;
        this.add((Component)this.mainPanel, "Center");
        if (this.updateGroupScroll) {
            this.updateGroupScrollbar();
            this.updateGroupScroll = false;
        }
        this.seisFrame.validate();
        this.gatherListSizeAtLastUpdate = this.getGatherListSize();
    }

    protected synchronized void updateGroupScrollbar() {
        this.remove(this.groupScrollbar);
        if (this.getGatherListSize() > this.maxNumberVisible) {
            this.groupScrollbar.setBlockIncrement(this.maxNumberVisible);
            this.groupScrollbar.setUnitIncrement(1);
            int n = this.firstVisible;
            int n2 = this.maxNumberVisible;
            int n3 = 0;
            int n4 = this.getGatherListSize();
            this.groupScrollbar.setValues(n, n2, n3, n4);
            this.add((Component)this.groupScrollbar, "East");
        }
    }

    public boolean isFullWindow() {
        return this.isFullWindow;
    }

    public synchronized boolean setFullWindow(GatherPanel gatherPanel, boolean bl) {
        if (bl) {
            if (!this.isFullWindow) {
                int n = this.getGatherListIndexOf(gatherPanel);
                if (n < 0) {
                    return this.isFullWindow;
                }
                this.savedFirstVisible = this.firstVisible;
                this.firstVisible = n;
                this.savedMaxNumberVisible = this.maxNumberVisible;
                this.maxNumberVisible = 1;
                this.isFullWindow = true;
                this.updateDisplay(true);
            }
        } else if (this.isFullWindow) {
            this.firstVisible = this.savedFirstVisible;
            this.maxNumberVisible = this.savedMaxNumberVisible;
            this.isFullWindow = false;
            this.updateDisplay(true);
        }
        return this.isFullWindow;
    }

    public synchronized void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        if (this.getGatherListSize() < 1) {
            return;
        }
        if (adjustmentEvent.getAdjustable() == this.groupScrollbar) {
            int n = this.groupScrollbar.getValue();
            if (n != this.firstVisible && !this.groupScrollbar.getValueIsAdjusting()) {
                this.firstVisible = n;
                this.updateDisplay(false);
            }
        } else if (adjustmentEvent.getAdjustable() == this.timeScrollbar) {
            if (adjustmentEvent.getSource() == this.timeScrollbar) {
                this.mouseButtonDown = true;
            }
            if (adjustmentEvent.getSource() == this.timeScrollbar && (!this.externalTimeScrollbarChange || this.timeScrollbar.getValueIsAdjusting())) {
                this.applyTimeScrollBarAdjustment();
            }
            this.mouseButtonDown = false;
        }
    }

    public synchronized void applyTimeScrollBarAdjustment() {
        double d = (double)this.timeScrollbar.getValue() / (double)this.timeScrollbar.getMaximum();
        double d2 = (double)(this.timeScrollbar.getValue() + this.timeScrollbar.getVisibleAmount()) / (double)this.timeScrollbar.getMaximum();
        this.seisFrame.changeGatherTimeLimits(d, d2);
        this.processedLastTimeScrollBarAdjustmentEvent = true;
        this.timeLastTimeScrollBarAdjustment = System.currentTimeMillis();
    }

    public synchronized void setTimeScrollBarPosition(double d, double d2, double d3, double d4) {
        if (this.mouseButtonDown) {
            return;
        }
        this.externalTimeScrollbarChange = true;
        int n = 0;
        int n2 = 1;
        n2 = (int)(100000.0 * (d2 - d) / (d4 - d3));
        if (d < d3) {
            n = 0;
            if (d2 < d3) {
                n2 = 100000;
            }
        } else if (d2 > d4) {
            if (d > d4) {
                n2 = 100000;
            }
            n = 100000 - n2;
        } else {
            n = (int)(100000.0 * (d - d3) / (d4 - d3));
        }
        this.timeScrollbar.setValues(n + 1, n2 - 1, 0, 100000);
        this.timeScrollbar.setBlockIncrement((int)((double)n2 / 6.0));
        this.timeScrollbar.setUnitIncrement((int)((double)n2 / 20.0));
        this.externalTimeScrollbarChange = false;
    }

    public void setIndicator(int n) {
        this.readingIndicatorPanel.setIndicator(n);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (!this.processedLastTimeScrollBarAdjustmentEvent) {
            this.seisFrame.setTimeScrollBarPosition();
        }
        this.mouseButtonDown = false;
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
        if (!this.processedLastTimeScrollBarAdjustmentEvent) {
            this.seisFrame.setTimeScrollBarPosition();
        }
        this.mouseButtonDown = false;
    }

    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        if (mouseWheelEvent.getScrollType() == 0) {
            int n = mouseWheelEvent.getWheelRotation() * this.groupScrollbar.getUnitIncrement();
            this.groupScrollbar.setValue(this.groupScrollbar.getValue() + n);
        }
    }
}

