/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.seisgram2k;

import edu.sc.seis.TauP.Arrival;
import edu.sc.seis.TauP.TauP_Time;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.io.InputStream;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;
import net.alomax.awt.AJLColor;
import net.alomax.freq.Convolve;
import net.alomax.freq.FilterException;
import net.alomax.freq.FrequencyDomainProcess;
import net.alomax.freq.FrequencyProcesses;
import net.alomax.freq.Response;
import net.alomax.graphics2d.AxesHorizTime;
import net.alomax.graphics2d.AxesVertAmp;
import net.alomax.graphics2d.SpectralDisplay;
import net.alomax.math.Cmplx;
import net.alomax.math.RangeDouble;
import net.alomax.math.RangeInteger;
import net.alomax.math.TimeSeries;
import net.alomax.math.TimeSeriesFloat;
import net.alomax.multicomp.MultiCompProcess;
import net.alomax.multicomp.MultiCompProcesses;
import net.alomax.multicomp.PolarisationAnalysis;
import net.alomax.seis.BasicHypocenter;
import net.alomax.seisgram2k.DataManager;
import net.alomax.seisgram2k.ParticleMotionFrame;
import net.alomax.seisgram2k.SeisGram2KFrame;
import net.alomax.seisgram2k.SeisGramText;
import net.alomax.seisgram2k.SeisInfoEditor;
import net.alomax.seisgram2k.SeisPanel;
import net.alomax.seisgram2k.SeisPick;
import net.alomax.seisgram2k.Seismogram;
import net.alomax.seisgram2k.SeismogramURL;
import net.alomax.seisgram2k.SelectPanel;
import net.alomax.seisgram2k.liveseis.LiveSeisDescriptor;
import net.alomax.seisgram2k.liveseis.LiveSeisManager;
import net.alomax.seisgram2k.liveseis.LiveSeisManagerBase;
import net.alomax.seisgram2k.liveseis.TitanLiveSeisManager;
import net.alomax.seisgram2k.monitor.MonitorManager;
import net.alomax.swing.BufferedJPanel;
import net.alomax.swing.JCommandException;
import net.alomax.swing.JTextFrame;
import net.alomax.swing.SwingExt;
import net.alomax.timedom.PickData;
import net.alomax.timedom.TimeDomainException;
import net.alomax.timedom.TimeDomainProcess;
import net.alomax.util.NumberFormat;
import net.alomax.util.StringExt;
import net.alomax.util.TimeInstant;
import net.alomax.util.TimeInstantConverter;
import net.alomax.volume3d.SphericalTauPSlownessModel;
import net.alomax.volume3d.TauPSlownessModel;

public class GatherPanel
extends BufferedJPanel
implements TimeInstantConverter,
Comparable {
    protected static String className;
    protected boolean MODIFYING_FLAG = false;
    public static final String WINDOW_CENTER = "WINDOW_CENTER";
    public static final String WINDOW_START = "WINDOW_START";
    public static final String WINDOW_END = "WINDOW_END";
    public static final double NULL_LATENCY = Double.NaN;
    protected static final double RPD = Math.PI / 180;
    protected static final Cursor DEFAULT_CURSOR;
    protected static final Cursor MOVE_CURSOR;
    protected static final Cursor CROSSHAIR_CURSOR;
    protected static final int EVENT = 0;
    protected static final int LIVE_SEIS = 1;
    protected static final int SEED_LINK = 2;
    protected static final String SORT_STR_NONE = "NONE";
    protected static final String SORT_STR_DATE = "DATE";
    protected static final String SORT_STR_ID = "ID";
    protected static final String SORT_STR_GCARC = "GCARC";
    protected static final String SORT_STR_AZ = "AZ";
    protected static final String SORT_STR_BAZ = "BAZ";
    protected static final int SORT_NONE = -1;
    protected static final int SORT_DATE = 0;
    protected static final int SORT_ID = 1;
    protected static final int SORT_GCARC = 2;
    protected static final int SORT_AZ = 3;
    protected static final int SORT_BAZ = 4;
    protected static int sortType;
    protected static int defaultSortOrderCounter;
    protected int defaultSortOrder = 0;
    protected String sortedValueString = "";
    protected static boolean drawPanelLimits;
    protected static boolean drawGroupIdLabel;
    protected static boolean useShortSeismogramIdLabel;
    protected static boolean drawSeismogramIdLabel;
    protected boolean removeMonitorMean = false;
    public String onReadCommands = null;
    protected int numberRowsInGroup = 1;
    protected double fontSizeFactor = 1.0;
    protected int fontStyle = 0;
    protected int runMode = 0;
    protected SeisPanel seisPanel = null;
    protected SelectPanel selectPanel = null;
    protected JPanel auxilliaryPanel = null;
    protected boolean bufferFlag = true;
    protected SeisGram2KFrame seisFrame;
    protected LiveSeisManagerBase liveSeisManager = null;
    protected MonitorManager seedLinkManager = null;
    protected JTextFrame seisInfoTextFrame = null;
    public Seismogram[] seismograms = new Seismogram[0];
    public double timeMin;
    public double timeMax;
    public double lastTimeMin;
    public double lastTimeMax;
    public double initTimeMin;
    public double initTimeMax;
    public double ampMin;
    public double ampMax;
    public double lastAmpMin;
    public double lastAmpMax;
    public double initAmpMin;
    public double initAmpMax;
    protected ParticleMotionFrame particleMotionFrame = null;
    protected Vector processVector = new Vector();
    protected SpectralDisplay[] spectralDisplay = null;
    public double displayTimeShift = 0.0;
    protected String gatherTitle = "";
    protected GatherPanel storedGather = null;
    protected boolean isPainting = false;
    protected boolean killPainting = false;
    protected boolean aliveFlag = false;
    public int activeSeismogram = 0;
    protected int lastActiveSeismogram = 0;
    protected Arrival[] tauParrivals = null;
    protected SeisPick[] tauPphases = null;
    protected boolean paintTauPArrivals = false;
    public SeisPick workingPick;
    protected SeisPick highlightedPick = null;
    public int numDecimals;
    public boolean overlayFlag = false;
    protected Rectangle plotRectangle;
    protected Rectangle firstSeisRectangle;
    protected double cursorVerticalTime = -1.0;
    protected int iCursorVerticalPos = -1;
    protected Color cursorVerticalColor = null;
    public double xScale;
    public double yScale;
    public double rowTimeLength;
    public int seisRectangleHeight;
    protected static final int COLOR_MODE_NORMAL = 0;
    protected static final int COLOR_MODE_INVERT = 1;
    protected static final int COLOR_MODE_PRINT = 2;
    protected static final int COLOR_MODE_GREYSCALE = 3;
    protected static final int COLOR_MODE_GREYSCALE_INVERT = 4;
    protected static int colorModeCurrent;
    protected Color backgroundColor = null;
    protected Color foregroundColor = null;
    protected Color middlegroundColor = null;
    protected Color activeGatherHighlightColor = null;
    protected String pickString = null;
    protected Color pickStringColor = SeisPick.DEFAULT_PICK_COLOR;
    protected Color modeTextColor = Color.red;
    public boolean travelTimeInitlialized = false;
    public double travelTimeDist = 30.0;
    public double travelTimeOtime = 0.0;
    public double travelTimeDepth = 33.0;
    public double travelTimeMaximumDepth;
    public static boolean travelTimeLr;
    public int initRotationAngle = 0;
    public int rotationAngle = 0;
    public int relativeRotationAngle = 0;
    protected Seismogram otherSeismogram;
    protected double thisFactor;
    protected double otherFactor;
    protected int chanAngle;
    static boolean bufferMessageWritten;
    public static final int SIGNAL_TO_NOISE_RATIO_POWER = 0;
    public static final int SIGNAL_TO_NOISE_RATIO_AMPLITUDE = 1;
    protected double savedOtime = -1.7976931348623157E308;
    protected SeisPick savedOtimePick = null;
    protected static final double MAX_TIME_WINDOW = 3.15576E10;
    public static final double BIG_TIME_INCREMENT_FACTOR = 6.0;
    public static final double SMALL_TIME_INCREMENT_FACTOR = 20.0;
    protected JDialog dialog = null;
    protected JTextArea messageLabel = null;
    protected Cursor keySaveCursor = null;

    public GatherPanel(SeisGram2KFrame seisGram2KFrame) {
        this.seisFrame = seisGram2KFrame;
        this.setDefaultSortOrder(defaultSortOrderCounter++);
    }

    public GatherPanel(SeisGram2KFrame seisGram2KFrame, int n, int n2, double d, int n3) {
        this(seisGram2KFrame);
        className = this.getClass().getName() + ": ";
        this.numDecimals = n;
        this.numberRowsInGroup = n2;
        this.fontSizeFactor = d;
        this.fontStyle = n3;
        this.setColors(colorModeCurrent);
        this.setLayout(new BorderLayout());
        drawGroupIdLabel = seisGram2KFrame.getTrueFalseParameter(true, "display.group.id");
        drawSeismogramIdLabel = seisGram2KFrame.getTrueFalseParameter(true, "display.trace.id");
        useShortSeismogramIdLabel = seisGram2KFrame.getTrueFalseParameter(false, "display.trace.id.short");
        drawPanelLimits = seisGram2KFrame.getTrueFalseParameter(true, "display.group.separator");
        this.overlayFlag = seisGram2KFrame.getTrueFalseParameter(false, "display.overlay");
        if (seisGram2KFrame.showSelectPanel) {
            this.addSelectPanel();
        }
        this.seisPanel = new SeisPanel(seisGram2KFrame, this);
        this.add("Center", this.seisPanel);
        String string = System.getProperty("java.version");
        String string2 = System.getProperty("os.name");
        if (string != null && string.indexOf("1.2") >= 0 && string2 != null && string2.toUpperCase().indexOf("WINDOWS") < 0) {
            this.bufferFlag = false;
            if (!bufferMessageWritten) {
                System.out.println("INFO: You are using Java version " + string + ": graphics buffering disabled: " + "for best performance on UNIX or LINUX, " + "set the environment variable JAVA2D_USEPLATFORMFONT");
                bufferMessageWritten = true;
            }
        }
        this.workingPick = new SeisPick(seisGram2KFrame, this);
        this.workingPick.init();
        this.setDefaultCursor();
        this.aliveFlag = true;
    }

    public static void setSortType(String string) {
        if (string == null) {
            sortType = -1;
        } else if (string.equalsIgnoreCase(SORT_STR_NONE)) {
            sortType = -1;
        } else if (string.equalsIgnoreCase(SORT_STR_DATE)) {
            sortType = 0;
        } else if (string.equalsIgnoreCase(SORT_STR_ID)) {
            sortType = 1;
        } else if (string.equalsIgnoreCase(SORT_STR_GCARC)) {
            sortType = 2;
        } else if (string.equalsIgnoreCase(SORT_STR_AZ)) {
            sortType = 3;
        } else if (string.equalsIgnoreCase(SORT_STR_BAZ)) {
            sortType = 4;
        }
    }

    public static String getSortTypeString() {
        if (sortType == -1) {
            return SORT_STR_NONE;
        }
        if (sortType == 0) {
            return SORT_STR_DATE;
        }
        if (sortType == 1) {
            return SORT_STR_ID;
        }
        if (sortType == 2) {
            return SORT_STR_GCARC;
        }
        if (sortType == 3) {
            return SORT_STR_AZ;
        }
        if (sortType == 4) {
            return SORT_STR_BAZ;
        }
        return null;
    }

    public static void setSortType(int n) {
        sortType = n;
    }

    public void setDefaultSortOrder(int n) {
        this.defaultSortOrder = n;
    }

    public int compareTo(Object object) {
        GatherPanel gatherPanel = (GatherPanel)object;
        if (gatherPanel.equals(this)) {
            return 0;
        }
        if (gatherPanel.getNumberSeismograms() < 1 && this.getNumberSeismograms() < 1) {
            return 0;
        }
        if (gatherPanel.getNumberSeismograms() < 1) {
            return -1;
        }
        if (this.getNumberSeismograms() < 1) {
            return 1;
        }
        int n = gatherPanel.seismograms[0].getStaInstID().compareTo(this.seismograms[0].getStaInstID());
        if (n == 0) {
            n = gatherPanel.getGatherTitle().compareTo(this.getGatherTitle());
        }
        int n2 = 0;
        if (sortType == 0) {
            long l = gatherPanel.refTimeToTimeInstant(gatherPanel.timeMin).getTime();
            long l2 = this.refTimeToTimeInstant(this.timeMin).getTime();
            n2 = new Long(l).compareTo(new Long(l2));
        } else {
            n2 = sortType == 1 ? n : (sortType == 2 ? new Double(gatherPanel.seismograms[0].gcarc).compareTo(new Double(this.seismograms[0].gcarc)) : (sortType == 3 ? new Double(gatherPanel.seismograms[0].az).compareTo(new Double(this.seismograms[0].az)) : (sortType == 4 ? new Double(gatherPanel.seismograms[0].baz).compareTo(new Double(this.seismograms[0].baz)) : new Integer(gatherPanel.defaultSortOrder).compareTo(new Integer(this.defaultSortOrder)))));
        }
        if (n2 == 0) {
            n2 = n;
        }
        if (n2 != 0) {
            return -n2;
        }
        return gatherPanel.hashCode() < this.hashCode() ? -1 : 1;
    }

    protected void addSelectPanel() {
        this.removeSelectPanel();
        this.selectPanel = new SelectPanel(this);
        this.add("East", this.selectPanel);
        this.validate();
    }

    protected void removeSelectPanel() {
        if (this.selectPanel != null) {
            this.selectPanel.destroy();
            this.remove(this.selectPanel);
            this.selectPanel = null;
            this.validate();
        }
    }

    public void setAuxilliaryPanel(JPanel jPanel) {
        this.auxilliaryPanel = jPanel;
    }

    public JPanel getAuxilliaryPanel() {
        return this.auxilliaryPanel;
    }

    public SeisPanel getSeisPanel() {
        return this.seisPanel;
    }

    public void writeMessage(String string) {
        this.seisFrame.writeMessage(string);
    }

    public TimeInstant getRefTimeInstant() {
        if (this.seismograms != null && this.seismograms.length > 0 && this.seismograms[0] != null) {
            return this.seismograms[0].refTimeInstant;
        }
        return null;
    }

    public int getNumberSeismograms() {
        return this.seismograms.length;
    }

    public void setDisplayTimeShift(TimeInstant timeInstant, TimeInstant timeInstant2) {
        if (timeInstant == null || timeInstant2 == null) {
            return;
        }
        this.setDisplayTimeShift(this.timeInstantToRefTime(timeInstant2) - this.timeInstantToRefTime(timeInstant));
    }

    public void setDisplayTimeShift(double d) {
        this.displayTimeShift = d;
    }

    public void setInitAndLastAmpRange() {
        double d;
        boolean bl = true;
        String string = this.seisFrame.getParameter("display.amplitude.auto");
        if (string != null && !string.toUpperCase().equals("SMART")) {
            bl = false;
        }
        this.initAmpMin = Double.MAX_VALUE;
        this.initAmpMax = -1.7976931348623157E308;
        double d2 = -1.0;
        for (int i = 0; i < this.seismograms.length; ++i) {
            this.initAmpMin = Math.min(this.seismograms[i].getAmpMin(), this.initAmpMin);
            this.initAmpMax = Math.max(this.seismograms[i].getAmpMax(), this.initAmpMax);
            if (!bl) continue;
            d2 = Math.max(Math.sqrt(this.seismograms[i].getVariance()), d2);
        }
        double d3 = 1.1;
        if (bl) {
            d = (this.initAmpMax - this.initAmpMin) / 2.0;
            if (!(d > (double)1.4E-45f) || d2 > (double)1.4E-45f) {
                // empty if block
            }
            double d4 = 10.0 * d2 / d;
            d3 = Math.max(d3, d4);
        }
        d = (this.initAmpMin + this.initAmpMax) / 2.0;
        this.initAmpMin = d - d3 * (d - this.initAmpMin) * (double)this.seismograms.length;
        this.initAmpMax = d + d3 * (this.initAmpMax - d) * (double)this.seismograms.length;
        boolean bl2 = this.seisFrame.getTrueFalseParameter(false, "display.amplitude.zerocenter");
        if (bl2) {
            double d5;
            this.initAmpMax = d5 = Math.max(Math.abs(this.initAmpMin), Math.abs(this.initAmpMax));
            this.initAmpMin = -d5;
        }
        this.setAmpRange(this.initAmpMin, this.initAmpMax);
        this.setAmpRange(this.initAmpMin, this.initAmpMax);
    }

    public void setInitAndLastTimeRange() {
        this.initTimeMin = Double.MAX_VALUE;
        this.initTimeMax = -1.7976931348623157E308;
        for (int i = 0; i < this.seismograms.length; ++i) {
            this.initTimeMin = Math.min(this.seismograms[i].getTimeMin(), this.initTimeMin);
            this.initTimeMax = Math.max(this.seismograms[i].getTimeMax(), this.initTimeMax);
        }
        this.setTimeRange(this.initTimeMin, this.initTimeMax);
        this.setTimeRange(this.initTimeMin, this.initTimeMax);
    }

    public void setTimeAndAmpRanges() {
        this.setInitAndLastTimeRange();
        this.setInitAndLastAmpRange();
    }

    public Rectangle getPlotRectangle() {
        return this.plotRectangle;
    }

    public void setTimeRange(double d, double d2) {
        if (Math.abs(d - d2) < (double)1.4E-45f) {
            d -= 1.0;
            d2 += 1.0;
        }
        this.lastTimeMin = this.timeMin;
        this.timeMin = d;
        this.lastTimeMax = this.timeMax;
        this.timeMax = d2;
    }

    public void setTimeRange(TimeInstant timeInstant, TimeInstant timeInstant2) {
        this.setTimeRange(this.timeInstantToRefTime(timeInstant), this.timeInstantToRefTime(timeInstant2));
    }

    public void setAmpRange(double d, double d2) {
        if (Math.abs(d - d2) < (double)1.4E-45f) {
            d -= (double)1.4E-45f;
            d2 += (double)1.4E-45f;
        }
        this.lastAmpMin = this.ampMin;
        this.ampMin = d;
        this.lastAmpMax = this.ampMax;
        this.ampMax = d2;
    }

    public int timeToIy(double d) {
        return this.timeToIy(d, this.activeSeismogram);
    }

    public int timeToIy(double d, int n) {
        if (this.numberRowsInGroup == 1) {
            return this.seismograms[n].iyPlotIndexAtTime(d);
        }
        int n2 = (int)((d - this.timeMin) / this.rowTimeLength);
        return this.seismograms[n].iyPlotIndexAtTime(d) - (this.numberRowsInGroup - n2 - 1) * this.seisRectangleHeight;
    }

    public int timeToIx(double d) {
        int n = (int)(0.5 + (d - this.timeMin) * this.xScale) + this.plotRectangle.x;
        if (this.numberRowsInGroup == 1) {
            return n;
        }
        int n2 = (int)((d - this.timeMin) / this.rowTimeLength);
        return n - n2 * this.plotRectangle.width;
    }

    public double ixToTime(int n) {
        double d = this.timeMin + (double)(n - this.plotRectangle.x) / this.xScale;
        if (this.numberRowsInGroup == 1) {
            return d;
        }
        return d + (double)(this.numberRowsInGroup - 1) * this.rowTimeLength;
    }

    public double ixToTime(int n, int n2) {
        double d = this.timeMin + (double)(n - this.plotRectangle.x) / this.xScale;
        if (this.numberRowsInGroup == 1) {
            return d;
        }
        int n3 = this.iyToRowIndex(n2);
        return d + (double)n3 * this.rowTimeLength;
    }

    public int ampToIy(double d) {
        if (this.numberRowsInGroup == 1) {
            return (int)((this.ampMin - d) * this.yScale) - this.plotRectangle.y - this.plotRectangle.height;
        }
        return (int)((this.ampMin - d) * this.yScale) - this.plotRectangle.y - this.plotRectangle.height;
    }

    public double iyToAmp(int n) {
        if (this.numberRowsInGroup == 1) {
            return this.ampMin + (double)(this.plotRectangle.y + this.plotRectangle.height - n) / this.yScale;
        }
        return this.ampMin + (double)(this.plotRectangle.y + this.plotRectangle.height - (n - this.plotRectangle.y) % this.plotRectangle.height) / this.yScale;
    }

    public int iyToIyRow(int n) {
        if (this.numberRowsInGroup == 1) {
            return n - this.plotRectangle.y;
        }
        return (n - this.firstSeisRectangle.y) % this.firstSeisRectangle.height;
    }

    public int iyToRowIndex(int n) {
        return (n - this.firstSeisRectangle.y) / this.firstSeisRectangle.height;
    }

    public TimeInstant refTimeToTimeInstant(double d) {
        return this.seismograms[this.activeSeismogram].refTimeToTimeInstant(d, SeisGramText.getLocaleString());
    }

    public double timeInstantToRefTime(TimeInstant timeInstant) {
        return this.seismograms[this.activeSeismogram].timeInstantToRefTime(timeInstant);
    }

    public String timeToString(double d, int n, int n2, int n3, boolean bl) {
        TimeInstant timeInstant = this.seismograms[n].refTimeToTimeInstant(d, SeisGramText.getLocaleString());
        if (timeInstant == null) {
            return "???";
        }
        return timeInstant.toString(n2, n3, bl);
    }

    public String timeToStringInvert(double d, int n, int n2, int n3, boolean bl) {
        TimeInstant timeInstant = this.seismograms[n].refTimeToTimeInstant(d, SeisGramText.getLocaleString());
        if (timeInstant == null) {
            return "???";
        }
        return timeInstant.toStringInvert(n2, n3, bl);
    }

    public String timeToStringDateOnly(double d, int n, int n2, int n3, boolean bl) {
        TimeInstant timeInstant = this.seismograms[n].refTimeToTimeInstant(d, SeisGramText.getLocaleString());
        if (timeInstant == null) {
            return "???";
        }
        return timeInstant.toStringDateOnly(n2, n3, bl);
    }

    public String dateToString(double d, int n, int n2) {
        TimeInstant timeInstant = this.seismograms[n].refTimeToTimeInstant(d, SeisGramText.getLocaleString());
        return timeInstant.toString2(n2);
    }

    public RangeDouble getAmpRangeSeismograms(double d, double d2) {
        RangeDouble rangeDouble = new RangeDouble(Double.MAX_VALUE, -1.7976931348623157E308);
        for (int i = 0; i < this.seismograms.length; ++i) {
            RangeDouble rangeDouble2 = this.seismograms[i].calculateAmplitudeRange(this.seismograms[i].sampAtTime(d), this.seismograms[i].sampAtTime(d2), false);
            rangeDouble.min = Math.min(rangeDouble2.min, rangeDouble.min);
            rangeDouble.max = Math.max(rangeDouble2.max, rangeDouble.max);
        }
        return rangeDouble;
    }

    public void removeTrend() {
        if (this.isMonitor()) {
            return;
        }
        for (int i = 0; i < this.seismograms.length; ++i) {
            this.seismograms[i].removeTrend();
        }
        this.setInitAndLastAmpRange();
    }

    public void removeMean(int n) {
        if (this.isMonitor()) {
            return;
        }
        for (int i = 0; i < this.seismograms.length; ++i) {
            this.seismograms[i].removeMean(n);
        }
        this.setInitAndLastAmpRange();
    }

    public void removeMean(String string, double d, String string2, double d2) throws JCommandException {
        if (this.isMonitor()) {
            return;
        }
        double d3 = this.seismograms[0].getTimeMin() + this.getOffsetToFeature(0, string);
        if (Double.isNaN(d3)) {
            String string3 = this.getClass().getName() + ": removeMean : " + "ERROR: reference feature not found: " + string;
            throw new JCommandException(string3);
        }
        double d4 = this.seismograms[0].getTimeMin() + this.getOffsetToFeature(0, string2);
        if (Double.isNaN(d4)) {
            String string4 = this.getClass().getName() + ": removeMean : " + "ERROR: reference feature not found: " + string2;
            throw new JCommandException(string4);
        }
        d3 += d;
        d4 += d2;
        for (int i = 0; i < this.seismograms.length; ++i) {
            this.seismograms[i].removeMean(d3, d4);
        }
        this.setInitAndLastAmpRange();
    }

    public void unDoRemoveMean() {
        if (this.isMonitor()) {
            return;
        }
        for (int i = 0; i < this.seismograms.length; ++i) {
            this.seismograms[i].unDoRemoveMean();
        }
        this.setInitAndLastAmpRange();
    }

    public void test() {
        for (int i = 0; i < this.seismograms.length; ++i) {
            this.seismograms[i].test();
        }
        this.setInitAndLastAmpRange();
    }

    public void integrateMaxOfPosNeg(boolean bl) {
        for (int i = 0; i < this.seismograms.length; ++i) {
            this.seismograms[i].integrateMaxOfPosNeg(bl);
        }
        this.setInitAndLastAmpRange();
    }

    public void norm() {
        for (int i = 0; i < this.seismograms.length; ++i) {
            this.seismograms[i].norm();
        }
        this.setInitAndLastAmpRange();
    }

    public void chop() {
        for (int i = 0; i < this.seismograms.length; ++i) {
            this.seismograms[i].chop();
        }
        this.setInitAndLastAmpRange();
    }

    public void removeGeometricalSpreading(boolean bl) {
        for (int i = 0; i < this.seismograms.length; ++i) {
            double d = Double.valueOf(this.seismograms[i].getHeaderFieldStringValue("gcarc"));
            double d2 = Double.valueOf(this.seismograms[i].getHeaderFieldStringValue("depth"));
            if (bl) {
                System.out.println("removeGeometricalSpreading: dist=" + d + " depth=" + d2);
            }
            double d3 = this.seisFrame.getSphericalTauPSlownessModel("P,p,S,s").getGeometricalSpreadingFactor(d, d2, "P");
            if (bl) {
                System.out.println("removeGeometricalSpreading: geomSpreadFactor=" + d3);
            }
            double d4 = d * 111.111;
            double d5 = Math.sqrt(d4 * d4 + d2 * d2);
            if (bl) {
                System.out.println("dist=" + (float)d + " gs=" + (float)d3 + " r=" + (float)d5 + " ratio=" + (float)(d3 / d5));
            }
            this.seismograms[i].multiply(d3);
        }
        this.setInitAndLastAmpRange();
    }

    public void removeGain(double d, boolean bl) throws JCommandException {
        String string = "Removing gain";
        boolean bl2 = false;
        for (int i = 0; i < this.seismograms.length; ++i) {
            try {
                Response response = this.seismograms[i].getResponse(this.seisFrame.getDocumentBase(), null);
                if (response == null) {
                    string = string + ": no gain or Response information for " + this.seismograms[i].getStaInstID();
                    continue;
                }
                System.out.println("seismograms[nch].timeSeries.ampUnits " + this.seismograms[i].timeSeries.ampUnits);
                System.out.println("response.getAfterUnits()[0] " + response.getAfterUnits()[0]);
                if (!this.seismograms[i].timeSeries.ampUnits.equals(response.getAfterUnits()[0])) {
                    string = string + ": incorrect amplitude units " + this.seismograms[i].getStaInstID();
                    continue;
                }
                double d2 = response.evaluateResponse(d).mag();
                if (bl) {
                    System.out.println("removeGain: gain=" + (float)d2);
                }
                String string2 = response.convertUnitsBackward(this.seismograms[i].timeSeries.ampUnits);
                String string3 = response.convertNameBackward(this.seismograms[i].channel.instName);
                if (response.getIntegralOrDerivative() == Response.INTEGRAL) {
                    this.seismograms[i].multiply(1.0 / (d2 *= Math.PI * 2 * d));
                    this.seismograms[i].differentiate(0.0f);
                    if (bl) {
                        System.out.println("removeGain: Response.INTEGRAL");
                    }
                } else if (response.getIntegralOrDerivative() == Response.DERIVATIVE) {
                    this.seismograms[i].integrate(0.0f);
                    this.seismograms[i].multiply(1.0 / (d2 /= Math.PI * 2 * d));
                    if (bl) {
                        System.out.println("removeGain: Response.DERIVATIVE");
                    }
                } else {
                    this.seismograms[i].multiply(1.0 / d2);
                    if (bl) {
                        System.out.println("removeGain: Response.NONE");
                    }
                }
                if (bl) {
                    System.out.println("removeGain: gain=" + d2);
                }
                this.seismograms[i].timeSeries.ampUnits = string2;
                this.seismograms[i].channel.instName = string3;
                this.seismograms[i].updateStaInstID();
                bl2 = true;
                continue;
            }
            catch (Exception exception) {
                if (bl) {
                    exception.printStackTrace();
                }
                string = string + ": " + exception.getMessage();
            }
        }
        if (!bl2) {
            throw new JCommandException(string);
        }
        this.setInitAndLastAmpRange();
    }

    public void multiplyLinear(double d, double d2) {
        for (int i = 0; i < this.seismograms.length; ++i) {
            this.seismograms[i].multiplyLinear(d, d2);
        }
        this.setInitAndLastAmpRange();
    }

    public void displaySpectral(int n, int n2, double d, int n3) {
        int n4;
        int n5;
        Dimension dimension = this.seisFrame.getSize();
        int n6 = n5 = dimension.width < dimension.height ? dimension.width : dimension.height;
        if (this.spectralDisplay == null || this.spectralDisplay.length != this.getNumberSeismograms()) {
            this.spectralDisplay = new SpectralDisplay[this.getNumberSeismograms()];
        }
        if (this.spectralDisplay[n4 = this.getActiveSeismogram()] != null) {
            this.spectralDisplay[n4].dispose();
        }
        this.spectralDisplay[n4] = new SpectralDisplay(this.seisFrame, this.getSeismogram(n4).getStaInstID() + " " + this.timeToString(this.timeMin, 0, 1, this.numDecimals, true), this.getSeismogram(n4).getAmpUnits(), this.getSampleInterval(n4), this.getFFT(n4, d, n3), n, n2, this.getSeismogram(n4).getColor(), this.foregroundColor, this.middlegroundColor, this.backgroundColor, n5, n6, this.seisFrame.iconImage);
    }

    public Cmplx[] getFFT(int n, double d, int n2) {
        return this.seismograms[n].getFFT(d, n2);
    }

    public Cmplx[][] getFFTs(double d, int n) {
        Cmplx[][] cmplxArray = new Cmplx[this.seismograms.length][];
        for (int i = 0; i < this.seismograms.length; ++i) {
            cmplxArray[i] = this.getFFT(i, d, n);
        }
        return cmplxArray;
    }

    public double getSampleInterval(int n) {
        return this.seismograms[n].timeSeries.sampleInt;
    }

    public double[] getSampleIntervals() {
        double[] dArray = new double[this.seismograms.length];
        for (int i = 0; i < this.seismograms.length; ++i) {
            dArray[i] = this.getSampleInterval(i);
        }
        return dArray;
    }

    public TimeSeries getTimeSeries(int n) {
        return this.seismograms[n].timeSeries;
    }

    public TimeSeries[] getAllTimeSeries() {
        TimeSeries[] timeSeriesArray = new TimeSeries[this.seismograms.length];
        for (int i = 0; i < this.seismograms.length; ++i) {
            timeSeriesArray[i] = this.getTimeSeries(i);
        }
        return timeSeriesArray;
    }

    public int getMaxSampleLength() {
        int n = 0;
        for (int i = 0; i < this.seismograms.length; ++i) {
            if (this.seismograms[i].timeSeries.sampleLength() <= n) continue;
            n = this.seismograms[i].timeSeries.sampleLength();
        }
        return n;
    }

    protected void applyFreqProcess(FrequencyDomainProcess frequencyDomainProcess, double d, Object[] objectArray, boolean bl) throws OutOfMemoryError, FilterException {
        int n;
        if (this.isMonitor()) {
            return;
        }
        long l = 0L;
        for (n = 0; n < this.seismograms.length; ++n) {
            l += this.seismograms[n].getDataMemorySize();
        }
        if (l > Runtime.getRuntime().freeMemory()) {
            throw new OutOfMemoryError("Not enough free memory to apply frequency domain processing.: memory needed > " + l);
        }
        try {
            for (n = 0; n < this.seismograms.length; ++n) {
                FrequencyDomainProcess frequencyDomainProcess2;
                if (frequencyDomainProcess instanceof Convolve) {
                    frequencyDomainProcess2 = (Convolve)frequencyDomainProcess;
                    if (((Convolve)frequencyDomainProcess2).getMasterTimeSeries().length < n) {
                        ((Convolve)frequencyDomainProcess2).setMasterChannel(0);
                    } else {
                        ((Convolve)frequencyDomainProcess2).setMasterChannel(n);
                    }
                    ((Convolve)frequencyDomainProcess2).setTaperPercent(d);
                } else if (frequencyDomainProcess instanceof FrequencyProcesses) {
                    frequencyDomainProcess2 = (FrequencyProcesses)frequencyDomainProcess;
                    if (((FrequencyProcesses)frequencyDomainProcess2).processID == FrequencyProcesses.REMOVE_ATTENUATION) {
                        double d2 = Double.valueOf(this.seismograms[n].getHeaderFieldStringValue("gcarc"));
                        double d3 = Double.valueOf(this.seismograms[n].getHeaderFieldStringValue("depth"));
                        if (SeisGram2KFrame.VERBOSE) {
                            System.out.println("RemoveAttenuation: dist=" + d2 + " depth=" + (float)d3);
                        }
                        double d4 = this.seisFrame.getSphericalTauPSlownessModel("P,p,S,s").getTStar(d2, d3, "P", SeisGram2KFrame.VERBOSE);
                        if (SeisGram2KFrame.VERBOSE) {
                            System.out.println("RemoveAttenuation: tStar=" + (float)d4);
                        }
                        Object[] objectArray2 = new Double[2];
                        objectArray2[0] = new Double(d4);
                        try {
                            objectArray2[1] = Double.valueOf(this.seisFrame.getParameter("freq.rattenuation.fmax"));
                        }
                        catch (Exception exception) {
                            objectArray2[1] = new Double(10.0 / this.seismograms[n].timeSeries.sampleInt);
                        }
                        ((FrequencyProcesses)frequencyDomainProcess2).setParams(objectArray2);
                    }
                }
                this.seismograms[n].applyFreqProcess(frequencyDomainProcess, d, objectArray, bl);
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            throw new OutOfMemoryError(outOfMemoryError + ": needed " + l);
        }
        if (frequencyDomainProcess instanceof Convolve) {
            Convolve convolve = (Convolve)frequencyDomainProcess;
            for (int i = 0; i < this.seismograms.length; ++i) {
                this.seismograms[i].shiftReferenceTime((Double)objectArray[0]);
            }
        }
        this.setInitAndLastAmpRange();
    }

    protected void applyTimeDomainProcess(TimeDomainProcess timeDomainProcess) throws OutOfMemoryError, TimeDomainException {
        long l = 0L;
        try {
            for (int i = 0; i < this.seismograms.length; ++i) {
                this.seismograms[i].applyTimeDomainProcess(timeDomainProcess, this.isMonitor());
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            throw new OutOfMemoryError(outOfMemoryError + ": needed " + l);
        }
        if (timeDomainProcess.amplititudeModified()) {
            this.setInitAndLastAmpRange();
        }
    }

    protected void applyMultiCompProcess(MultiCompProcess multiCompProcess, GatherPanel gatherPanel) throws Exception, OutOfMemoryError {
        int n;
        int n2;
        Object object;
        float[][] fArray;
        if (this.isMonitor()) {
            return;
        }
        boolean bl = this.seisFrame.getTrueFalseParameter(false, "multicomp.align.sample");
        long l = 0L;
        double d = this.seismograms[0].timeSeries.sampleInt;
        float[][] fArrayArray = new float[this.seismograms.length][];
        int[] nArray = new int[this.seismograms.length];
        for (int i = 0; i < this.seismograms.length; ++i) {
            fArrayArray[i] = ((TimeSeriesFloat)this.seismograms[i].timeSeries).sample;
            nArray[i] = bl ? 0 : (int)Math.round(this.seismograms[0].timeAtSample(0) - this.seismograms[i].timeAtSample(0) - TimeInstant.secondsDifference(this.seismograms[0].getRefTimeInstant(), this.seismograms[i].getRefTimeInstant()) / d);
        }
        double d2 = 0.0;
        Object object2 = null;
        int[] nArray2 = null;
        if (gatherPanel != null) {
            d2 = gatherPanel.seismograms[0].timeSeries.sampleInt;
            object2 = new float[gatherPanel.seismograms.length][];
            nArray2 = new int[gatherPanel.seismograms.length];
            for (int i = 0; i < gatherPanel.seismograms.length; ++i) {
                object2[i] = ((TimeSeriesFloat)gatherPanel.seismograms[i].timeSeries).sample;
                nArray2[i] = bl ? 0 : (int)Math.round(this.seismograms[0].timeAtSample(0) - gatherPanel.seismograms[i].timeAtSample(0) - TimeInstant.secondsDifference(this.seismograms[0].getRefTimeInstant(), gatherPanel.seismograms[i].getRefTimeInstant()) / d2);
            }
        }
        if ((fArray = multiCompProcess.apply(d, fArrayArray, nArray, d2, (float[][])object2, nArray2)).length > this.seismograms.length) {
            object = this.seismograms;
            this.seismograms = new Seismogram[fArray.length];
            for (n2 = 0; n2 < fArray.length; ++n2) {
                this.seismograms[n2] = new Seismogram(object[0]);
            }
        }
        if (multiCompProcess instanceof MultiCompProcesses) {
            object = (MultiCompProcesses)multiCompProcess;
            if (object.processID == MultiCompProcesses.ANGLES) {
                for (n2 = 0; n2 < fArray[0].length; ++n2) {
                    float[] fArray2 = fArray[0];
                    int n3 = n2;
                    fArray2[n3] = fArray2[n3] + (float)this.initRotationAngle;
                    if (!((double)fArray[0][n2] > 360.0)) continue;
                    float[] fArray3 = fArray[0];
                    int n4 = n2;
                    fArray3[n4] = (float)((double)fArray3[n4] - 360.0);
                }
                if (object.processID == MultiCompProcesses.ANGLES) {
                    this.seismograms[0].channel.compName = Seismogram.AZIMUTH;
                    this.seismograms[1].channel.compName = Seismogram.DIP;
                }
                for (n2 = 0; n2 < this.seismograms.length; ++n2) {
                    this.seismograms[n2].channel.azimuth = Double.MAX_VALUE;
                    this.seismograms[n2].channel.inclination = Double.MAX_VALUE;
                }
            }
        }
        if (multiCompProcess instanceof PolarisationAnalysis) {
            object = (PolarisationAnalysis)multiCompProcess;
            if (object.type == PolarisationAnalysis.COHERENCY || object.type == PolarisationAnalysis.COVARIANCE) {
                for (n2 = 0; n2 < fArray[0].length; ++n2) {
                    float[] fArray4 = fArray[0];
                    int n5 = n2;
                    fArray4[n5] = fArray4[n5] + (float)this.initRotationAngle;
                    if (!((double)fArray[0][n2] > 360.0)) continue;
                    float[] fArray5 = fArray[0];
                    int n6 = n2;
                    fArray5[n6] = (float)((double)fArray5[n6] - 360.0);
                }
                this.seismograms[0].channel.compName = Seismogram.AZIMUTH;
                this.seismograms[1].channel.compName = Seismogram.DIP;
                this.seismograms[2].channel.compName = Seismogram.DEGREE_LINEARITY;
                this.seismograms[3].channel.compName = Seismogram.DEGREE_PLANARITY;
                for (n2 = 0; n2 < this.seismograms.length; ++n2) {
                    this.seismograms[n2].channel.azimuth = Double.MAX_VALUE;
                    this.seismograms[n2].channel.inclination = Double.MAX_VALUE;
                }
            }
        }
        for (n = 0; n < this.seismograms.length; ++n) {
            if (n >= fArray.length) continue;
            TimeSeriesFloat timeSeriesFloat = (TimeSeriesFloat)this.seismograms[n].timeSeries;
            timeSeriesFloat.sample = fArray[n];
            timeSeriesFloat.calculateAndSetAmplitudeRange(false);
            multiCompProcess.updateFields(timeSeriesFloat, n);
        }
        n = this.seismograms.length;
        Seismogram[] seismogramArray = this.seismograms;
        this.seismograms = new Seismogram[fArray.length];
        for (int i = 0; i < this.seismograms.length; ++i) {
            this.seismograms[i] = seismogramArray[i];
            if (this.seismograms.length != n) {
                this.seismograms[i].channel.azimuth = Double.MAX_VALUE;
                this.seismograms[i].channel.inclination = Double.MAX_VALUE;
            }
            this.seismograms[i].updateStaInstID();
        }
        this.setComponents();
        this.setInitAndLastAmpRange();
        if (this.activeSeismogram >= this.seismograms.length) {
            this.lastActiveSeismogram = 0;
            this.activeSeismogram = 0;
        }
    }

    public void cutInMemory(String string, double d, String string2, double d2) throws Exception {
        double d3 = this.seismograms[0].getTimeMin() + this.getOffsetToFeature(0, string);
        if (Double.isNaN(d3)) {
            String string3 = this.getClass().getName() + ": cutInMemory : " + "ERROR: reference feature not found: " + string;
            throw new JCommandException(string3);
        }
        double d4 = this.seismograms[0].getTimeMin() + this.getOffsetToFeature(0, string2);
        if (Double.isNaN(d4)) {
            String string4 = this.getClass().getName() + ": cutInMemory : " + "ERROR: reference feature not found: " + string2;
            throw new JCommandException(string4);
        }
        d3 += d;
        d4 += d2;
        for (int i = 0; i < this.seismograms.length; ++i) {
            this.seismograms[i].cutInMemory(d3, d4);
        }
        this.setTimeAndAmpRanges();
    }

    public void signalToNoiseRatio(String string, double d, String string2, double d2, String string3, double d3, String string4, double d4, String string5) throws Exception {
        this.signalToNoiseRatio(string, d, string2, d2, string3, d3, string4, d4, string5, 0);
    }

    public void signalToNoiseRatioAmplitude(String string, double d, String string2, double d2, String string3, double d3, String string4, double d4, String string5) throws Exception {
        this.signalToNoiseRatio(string, d, string2, d2, string3, d3, string4, d4, string5, 1);
    }

    public void signalToNoiseRatio(String string, double d, String string2, double d2, String string3, double d3, String string4, double d4, String string5, int n) throws Exception {
        for (int i = 0; i < this.seismograms.length; ++i) {
            double d5 = this.seismograms[i].getTimeMin() + this.getOffsetToFeature(0, string);
            if (Double.isNaN(d5)) {
                String string6 = this.getClass().getName() + ": signalToNoiseRatio : " + "ERROR: reference feature not found: " + string;
                throw new JCommandException(string6);
            }
            double d6 = this.seismograms[i].getTimeMin() + this.getOffsetToFeature(0, string2);
            if (Double.isNaN(d6)) {
                String string7 = this.getClass().getName() + ": signalToNoiseRatio : " + "ERROR: reference feature not found: " + string2;
                throw new JCommandException(string7);
            }
            double d7 = this.seismograms[i].getTimeMin() + this.getOffsetToFeature(0, string3);
            if (Double.isNaN(d7)) {
                String string8 = this.getClass().getName() + ": signalToNoiseRatio : " + "ERROR: reference feature not found: " + string3;
                throw new JCommandException(string8);
            }
            double d8 = this.seismograms[i].getTimeMin() + this.getOffsetToFeature(0, string4);
            if (Double.isNaN(d8)) {
                String string9 = this.getClass().getName() + ": signalToNoiseRatio : " + "ERROR: reference feature not found: " + string4;
                throw new JCommandException(string9);
            }
            double d9 = 0.0;
            d9 = n == 0 ? this.seismograms[i].signalToNoiseRatio(d5, d6, d7, d8) : this.seismograms[i].signalToNoiseAmplitudeRatio(d5 += d, d6 += d2, d7 += d3, d8 += d4);
            SeisPick seisPick = new SeisPick(this.seisFrame, this);
            seisPick.init();
            seisPick.setStaInst(this, i);
            seisPick.setDateTime(this.getRefTimeInstant(), d7);
            seisPick.name = "snr" + string5;
            seisPick.amplitude = d9;
            this.addElementToPickList(seisPick, true);
            this.seisFrame.writePicks();
            this.writePickMessage(seisPick);
        }
    }

    public double getOffsetToFeature(int n, String string) {
        double d = Double.NaN;
        try {
            d = Double.parseDouble(string);
            return d;
        }
        catch (Exception exception) {
            return this.getOffsetToStringFeature(n, string);
        }
    }

    public double getOffsetToStringFeature(int n, String string) {
        double d;
        block3: {
            block8: {
                block7: {
                    block6: {
                        block5: {
                            block4: {
                                block2: {
                                    d = Double.NaN;
                                    if (!string.equalsIgnoreCase(WINDOW_CENTER)) break block2;
                                    d = (this.timeMax + this.timeMin) / 2.0 - this.seismograms[n].getTimeMin();
                                    break block3;
                                }
                                if (!string.equalsIgnoreCase(WINDOW_START)) break block4;
                                d = this.timeMin - this.seismograms[n].getTimeMin();
                                break block3;
                            }
                            if (!string.equalsIgnoreCase(WINDOW_END)) break block5;
                            d = this.timeMax - this.seismograms[n].getTimeMin();
                            break block3;
                        }
                        if (!string.equalsIgnoreCase("B")) break block6;
                        d = 0.0;
                        break block3;
                    }
                    if (!string.equalsIgnoreCase("E")) break block7;
                    d = this.seismograms[n].getTimeMax() - this.seismograms[n].getTimeMin();
                    break block3;
                }
                if (!string.equalsIgnoreCase("O")) break block8;
                TimeInstant timeInstant = this.getHypocenterOtime();
                if (timeInstant == null) break block3;
                d = this.timeInstantToRefTime(timeInstant);
                break block3;
            }
            String[] stringArray = StringExt.parse(string, "|");
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    SeisPick seisPick = this.findPickByName(stringArray[i], n);
                    if (seisPick == null) continue;
                    d = seisPick.dateTimeToTime(this) - this.seismograms[n].getTimeMin();
                    break;
                }
            }
        }
        return d;
    }

    public SeisPick findPickByName(String string, int n) {
        SeisPick seisPick = null;
        double d = Double.MAX_VALUE;
        for (int i = 0; i < this.seisFrame.pickList.size(); ++i) {
            double d2;
            SeisPick seisPick2 = (SeisPick)this.seisFrame.pickList.elementAt(i);
            if (seisPick2.getStatus() == 2 || seisPick2.belongsTo(this) != n || !seisPick2.name.equals(string) || !(Math.abs(d2 = seisPick2.dateTimeToTime(this) - this.seismograms[n].getTimeMin()) < d)) continue;
            seisPick = seisPick2;
            d = Math.abs(d2);
        }
        return seisPick;
    }

    public int initLiveSeis(LiveSeisDescriptor liveSeisDescriptor) throws Exception {
        this.liveSeisManager = null;
        if (liveSeisDescriptor.numSegments < 1 || liveSeisDescriptor.numSegmentsDisplay < 1 || liveSeisDescriptor.waitTime <= 0.0) {
            return -1;
        }
        boolean bl = false;
        this.liveSeisManager = liveSeisDescriptor.type == 1 ? new TitanLiveSeisManager(this, this.seisFrame.getDocumentBase(), liveSeisDescriptor) : new LiveSeisManager(this, this.seisFrame.getDocumentBase(), liveSeisDescriptor);
        this.liveSeisManager.start();
        this.runMode = 1;
        this.setRemoveMonitorMean();
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void reInitializeLiveSeis() {
        LiveSeisDescriptor liveSeisDescriptor = this.liveSeisManager.liveSeisDescriptor;
        this.cleanUpLiveSeis();
        try {
            if (this.initLiveSeis(liveSeisDescriptor) > 0) {
                // empty if block
            }
        }
        catch (Exception exception) {
            String string = "ERROR: Re-initializing LiveSeis: " + exception;
            System.out.println(className + string);
            this.writeMessage(string);
        }
        this.repaint();
    }

    public void cleanUpLiveSeis() {
        if (this.liveSeisManager != null) {
            this.liveSeisManager.stopRunning();
            this.liveSeisManager = null;
            this.runMode = 0;
        }
    }

    public void liveSeisInitFinished() {
        this.seisFrame.addGather(this, true, true, true);
        this.seisFrame.validate();
        this.seisFrame.repaint();
    }

    public void monitorSeismogramAppended(boolean bl) {
        if (bl) {
            this.seisFrame.addGather(this, false, true, true);
        } else {
            this.monitorSeismogramAppended();
        }
    }

    public void monitorSeismogramAppended() {
        this.seisFrame.monitorSeismogramAppended(this);
    }

    public synchronized Seismogram readSeismogramInputStream(InputStream inputStream, SeismogramURL seismogramURL, boolean bl) throws Exception {
        return this.seisFrame.getDataManager().readSeismogramInputStream(inputStream, seismogramURL, bl);
    }

    public int addSeismogram(Seismogram seismogram, int n) {
        int n2;
        Seismogram[] seismogramArray = new Seismogram[this.seismograms.length + 1];
        int n3 = Math.min(this.seismograms.length, n);
        for (n2 = 0; n2 < n3; ++n2) {
            seismogramArray[n2] = this.seismograms[n2];
            if (!this.isMonitor() || !this.removeMonitorMean) continue;
            seismogramArray[n2].unDoRemoveMean();
        }
        seismogramArray[n3] = seismogram;
        for (n2 = n3 + 1; n2 < seismogramArray.length; ++n2) {
            seismogramArray[n2] = this.seismograms[n2 - 1];
            if (!this.isMonitor() || !this.removeMonitorMean) continue;
            seismogramArray[n2].unDoRemoveMean();
        }
        return this.addSeismograms(seismogramArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addSeismograms(Seismogram[] seismogramArray) {
        this.MODIFYING_FLAG = true;
        try {
            int n;
            long l;
            block8: {
                l = Long.MAX_VALUE;
                try {
                    l = this.seisFrame.getClockTime();
                }
                catch (Exception exception) {
                    l = Seismogram.NULL_TIMESTAMP;
                    if (!SeisGram2KFrame.PRINT_IGNORED_EXCEPTIONS) break block8;
                    System.out.println(exception);
                }
            }
            this.seismograms = new Seismogram[seismogramArray.length];
            for (n = 0; n < seismogramArray.length; ++n) {
                this.seismograms[n] = seismogramArray[n];
                this.seismograms[n].setTimeStamp(l);
                if (n > 0) {
                    this.seismograms[n].setReferenceTime(this.seismograms[0].refTimeInstant);
                }
                if (this.seismograms[n].readings == null || this.seismograms[n].readings.size() <= 0) continue;
                this.addChannelFileReadings(this.seismograms[n].readings, n);
            }
            this.setInitialRotationAngle(0);
            this.setComponents();
            this.setTimeAndAmpRanges();
            if (!this.isMonitor()) {
                this.sort3ComponentSets();
            }
            n = seismogramArray.length;
            return n;
        }
        finally {
            this.MODIFYING_FLAG = false;
        }
    }

    public int appendSeismogram(Seismogram seismogram, double d, boolean bl, boolean bl2) {
        int n;
        int n2;
        for (n2 = 0; n2 < this.seismograms.length && !this.seismograms[n2].channel.equals(seismogram.channel); ++n2) {
        }
        if (n2 >= this.seismograms.length) {
            return -1;
        }
        Seismogram[] seismogramArray = new Seismogram[this.seismograms.length];
        for (n = 0; n < n2; ++n) {
            seismogramArray[n] = null;
        }
        seismogramArray[n2] = seismogram;
        for (n = n2 + 1; n < seismogramArray.length; ++n) {
            seismogramArray[n] = null;
        }
        return this.appendSeismograms(seismogramArray, this.seismograms.length, d, bl, bl2);
    }

    public int appendSeismograms(Seismogram[] seismogramArray, int n, int n2, boolean bl) {
        double d = (double)n2 * (seismogramArray[0].getTimeMax() - seismogramArray[0].getTimeMin());
        return this.appendSeismograms(seismogramArray, n, d, bl, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int appendSeismograms(Seismogram[] seismogramArray, int n, double d, boolean bl, boolean bl2) {
        this.MODIFYING_FLAG = true;
        try {
            int n2;
            long l;
            block15: {
                l = Long.MAX_VALUE;
                try {
                    l = this.seisFrame.getClockTime();
                }
                catch (Exception exception) {
                    l = Long.MAX_VALUE;
                    if (!SeisGram2KFrame.PRINT_IGNORED_EXCEPTIONS) break block15;
                    System.out.println(exception);
                }
            }
            for (n2 = 0; n2 < n; ++n2) {
                if (seismogramArray[n2] != null) {
                    try {
                        if (this.isMonitor() && this.removeMonitorMean) {
                            this.seismograms[n2].unDoRemoveMean();
                        }
                        this.seismograms[n2].append(this, seismogramArray[n2], d, bl);
                        if (this.isMonitor() && this.removeMonitorMean) {
                            this.seismograms[n2].removeMean();
                        }
                    }
                    catch (Exception exception) {
                        String string = "ERROR: " + exception;
                        System.out.println(className + string);
                        if (SeisGram2KFrame.PRINT_STACK_TRACES) {
                            exception.printStackTrace();
                        }
                        this.writeMessage(string);
                        int n3 = -1;
                        this.MODIFYING_FLAG = false;
                        return n3;
                    }
                }
                this.seismograms[n2].setTimeStamp(l);
                if (n2 > 0) {
                    this.seismograms[n2].setReferenceTime(this.seismograms[0].refTimeInstant);
                }
                if (this.seismograms[n2].readings == null || this.seismograms[n2].readings.size() <= 0) continue;
                this.addChannelFileReadings(this.seismograms[n2].readings, n2);
            }
            this.setInitAndLastAmpRange();
            if (bl2) {
                this.setInitAndLastTimeRange();
            }
            n2 = n;
            return n2;
        }
        finally {
            this.MODIFYING_FLAG = false;
        }
    }

    public int copySeismograms(GatherPanel gatherPanel) {
        return this.copySeismograms(gatherPanel, false);
    }

    public int copySeismograms(GatherPanel gatherPanel, boolean bl) {
        return this.copySeismograms(gatherPanel, 0, gatherPanel.seismograms.length, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int copySeismograms(GatherPanel gatherPanel, int n, int n2, boolean bl) {
        this.MODIFYING_FLAG = true;
        try {
            int n3;
            int n4 = n2 - n;
            this.seismograms = new Seismogram[n4];
            int n5 = 0;
            for (n3 = n; n3 < n2; ++n3) {
                int n6;
                block6: {
                    n6 = n3 - n;
                    try {
                        this.seismograms[n6] = bl ? new Seismogram(this.seisFrame, gatherPanel.seismograms[n3], gatherPanel.initTimeMin, gatherPanel.initTimeMax) : new Seismogram(this.seisFrame, gatherPanel.seismograms[n3], gatherPanel.timeMin, gatherPanel.timeMax);
                    }
                    catch (Exception exception) {
                        if (!SeisGram2KFrame.PRINT_STACK_TRACES) break block6;
                        exception.printStackTrace();
                    }
                }
                ++n5;
                if (n4 <= 0) continue;
                this.seismograms[n6].setReferenceTime(this.seismograms[0].refTimeInstant);
            }
            this.setInitialRotationAngle(gatherPanel.getInitialRotationAngle());
            this.setRotationAngle(gatherPanel.getRotationAngle());
            this.setComponents();
            this.setTimeAndAmpRanges();
            n3 = n5;
            return n3;
        }
        finally {
            this.MODIFYING_FLAG = false;
        }
    }

    public void setComponents() {
        int n = 0;
        for (int i = 0; i < this.seismograms.length; ++i) {
            this.seismograms[i].setComponent();
            if (!this.seismograms[i].compCode.equals("?")) continue;
            ++n;
        }
        if (n > 1) {
            Seismogram[] seismogramArray = new Seismogram[2];
            int n2 = 0;
            for (int i = 0; i < this.seismograms.length && n2 < 2; ++i) {
                if (!this.seismograms[i].compCode.equals("?") || !(this.seismograms[i].channel.inclination > 89.99999) || !(this.seismograms[i].channel.inclination < 90.00001)) continue;
                seismogramArray[n2++] = this.seismograms[i];
            }
            if (n2 == 2) {
                float f = (float)(seismogramArray[0].channel.azimuth - seismogramArray[1].channel.azimuth);
                if ((double)f < 0.0) {
                    f = (float)((double)f + 360.0);
                } else if ((double)f > 360.0) {
                    f = (float)((double)f - 360.0);
                }
                if (f > 89.99999f && f < 90.00001f) {
                    seismogramArray[0].compCode = "X";
                    seismogramArray[1].compCode = "Y";
                    this.setInitialRotationAngle((int)Math.round(seismogramArray[1].channel.azimuth));
                } else if (f > 269.9999f && f < 270.0001f) {
                    seismogramArray[0].compCode = "Y";
                    seismogramArray[1].compCode = "X";
                    this.setInitialRotationAngle((int)Math.round(seismogramArray[0].channel.azimuth));
                }
            }
        }
    }

    public void sort3ComponentSets() {
        int n;
        if (this.seismograms.length != 3) {
            return;
        }
        Seismogram[] seismogramArray = new Seismogram[3];
        for (n = 0; n < 3; ++n) {
            seismogramArray[n] = null;
        }
        for (n = 0; n < 3; ++n) {
            if (this.seismograms[n].compCode.equals("Z")) {
                if (seismogramArray[0] != null) continue;
                seismogramArray[0] = this.seismograms[n];
                continue;
            }
            if (this.seismograms[n].compCode.equals("Y")) {
                if (seismogramArray[1] != null) continue;
                seismogramArray[1] = this.seismograms[n];
                continue;
            }
            if (!this.seismograms[n].compCode.equals("X") || seismogramArray[2] != null) continue;
            seismogramArray[2] = this.seismograms[n];
        }
        for (n = 0; n < 3; ++n) {
            if (seismogramArray[n] != null) continue;
            return;
        }
        this.seismograms = seismogramArray;
    }

    public int getRotationAngle() {
        return this.rotationAngle;
    }

    public int getInitialRotationAngle() {
        return this.initRotationAngle;
    }

    public void setInitialRotationAngle(int n) {
        while (n < 0) {
            n += 360;
        }
        this.rotationAngle = n %= 360;
        this.initRotationAngle = n;
        this.relativeRotationAngle = this.rotationAngle - this.initRotationAngle;
    }

    public void setRotationAngle(int n) {
        while (n < 0) {
            n += 360;
        }
        this.rotationAngle = n %= 360;
        this.relativeRotationAngle = this.rotationAngle - this.initRotationAngle;
    }

    public int setRotationAngle(String string) {
        int n;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            if (SeisGram2KFrame.PRINT_IGNORED_EXCEPTIONS) {
                System.out.println(numberFormatException);
            }
            return -1;
        }
        if (n == this.rotationAngle) {
            return 0;
        }
        this.setRotationAngle(n);
        return 0;
    }

    public double getTravelTimeDepth() {
        return this.travelTimeDepth;
    }

    public int setTravelTimeDepth(double d) {
        if (d < 0.0 || d > this.travelTimeMaximumDepth) {
            this.writeMessage("ERROR: Depth must be >= 0.0 and <= " + this.travelTimeMaximumDepth);
            return -1;
        }
        if (d == this.travelTimeDepth) {
            return 1;
        }
        this.travelTimeDepth = d;
        return 0;
    }

    public int setTravelTimeDepth(String string) {
        double d;
        try {
            d = Double.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            if (SeisGram2KFrame.PRINT_IGNORED_EXCEPTIONS) {
                System.out.println(numberFormatException);
            }
            return -1;
        }
        return this.setTravelTimeDepth(d);
    }

    public double getTravelTimeDist() {
        return this.travelTimeDist;
    }

    public int setTravelTimeDist(double d) {
        if (d < 0.0) {
            d = 0.0;
        }
        if (d > 360.0) {
            d = 360.0;
        }
        if (d == this.travelTimeDist) {
            return 1;
        }
        this.travelTimeDist = d;
        return 0;
    }

    public int setTravelTimeDist(String string, double d) {
        double d2;
        try {
            d2 = Double.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            if (SeisGram2KFrame.PRINT_IGNORED_EXCEPTIONS) {
                System.out.println(numberFormatException);
            }
            return -1;
        }
        return this.setTravelTimeDist(d * d2);
    }

    public double getTravelTimeOtime() {
        return this.travelTimeOtime;
    }

    public int setTravelTimeOtime(double d) {
        if (d == this.travelTimeOtime) {
            return -1;
        }
        this.travelTimeOtime = d;
        return 0;
    }

    public int setTravelTimeOtime(TimeInstant timeInstant) {
        return this.setTravelTimeOtime(this.timeInstantToRefTime(timeInstant));
    }

    public int setTravelTimeOtime(String string) {
        double d;
        try {
            d = Double.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            if (SeisGram2KFrame.PRINT_IGNORED_EXCEPTIONS) {
                System.out.println(numberFormatException);
            }
            return -1;
        }
        return this.setTravelTimeOtime(d);
    }

    public static boolean getTravelLr() {
        return travelTimeLr;
    }

    public static void setTravelTimeLr(boolean bl) {
        travelTimeLr = bl;
    }

    public void setColors(int n) {
        if (n == 0) {
            this.backgroundColor = Color.black;
            this.foregroundColor = Color.white;
            this.middlegroundColor = Color.gray;
            this.activeGatherHighlightColor = this.foregroundColor;
        } else if (n == 1) {
            this.backgroundColor = Color.white;
            this.foregroundColor = Color.black;
            this.middlegroundColor = Color.gray;
            this.activeGatherHighlightColor = this.foregroundColor;
        } else if (n == 2) {
            this.backgroundColor = Color.white;
            this.foregroundColor = Color.black;
            this.middlegroundColor = Color.black;
            this.activeGatherHighlightColor = this.foregroundColor;
        } else if (n == 3) {
            this.backgroundColor = Color.black;
            this.foregroundColor = Color.white;
            this.middlegroundColor = Color.gray;
            this.activeGatherHighlightColor = this.foregroundColor;
        } else if (n == 4) {
            this.backgroundColor = Color.white;
            this.foregroundColor = Color.black;
            this.middlegroundColor = Color.gray;
            this.activeGatherHighlightColor = this.foregroundColor;
        }
    }

    public static void setColors(boolean bl, boolean bl2) {
        colorModeCurrent = bl2 ? (bl ? 4 : 3) : (bl ? 1 : 0);
    }

    public Color requestColor(Color color, boolean bl) {
        if (colorModeCurrent == 1) {
            return AJLColor.invert(color);
        }
        if (colorModeCurrent == 2) {
            return color;
        }
        if (colorModeCurrent == 3) {
            if (bl) {
                return AJLColor.greyscale(color);
            }
            return color.equals(Color.white) ? color : Color.BLACK;
        }
        if (colorModeCurrent == 4) {
            Color color2 = AJLColor.greyscale(AJLColor.invert(color));
            if (bl) {
                return color2;
            }
            return color2.equals(Color.white) ? color2 : Color.BLACK;
        }
        return color;
    }

    public void setGatherTitle(String string) {
        this.gatherTitle = string + "  ";
    }

    public String getGatherTitle() {
        return this.gatherTitle;
    }

    public void paint(Graphics graphics) {
        this.paintBorder(graphics);
        this.paintChildren(graphics);
    }

    public void paint(boolean bl, boolean bl2) {
        Graphics graphics = this.seisPanel.getGraphics();
        if (graphics == null) {
            return;
        }
        this.paint(graphics, this.seisPanel.getSize(), false, bl, bl2);
        graphics.dispose();
    }

    public void print(Graphics graphics, Dimension dimension) {
        this.paint(graphics, dimension, true, false, false);
    }

    public void paint(Graphics graphics, Dimension dimension, boolean bl, boolean bl2, boolean bl3) {
        this.seisFrame.gatherDisplayManager.paint(this, graphics, dimension, bl, bl2, bl3);
    }

    protected void paintImp(Graphics graphics, Dimension dimension, boolean bl, boolean bl2, boolean bl3) throws Exception {
        if (!this.seisFrame.isVisible()) {
            return;
        }
        if (this.MODIFYING_FLAG) {
            return;
        }
        if (dimension.height < 1) {
            System.out.print("INFO: gather paint cancel: drawSize.height < 1");
            return;
        }
        long l = 0L;
        if (this.isPainting) {
            if (this.killPainting) {
                System.out.print("INFO: gather paint cancel: killPainting");
                return;
            }
            l = System.currentTimeMillis();
            this.killPainting = true;
            System.out.print("INFO: wait paint ");
        }
        boolean bl4 = false;
        while (this.isPainting && System.currentTimeMillis() - l < 1000L) {
            bl4 = true;
            System.out.print(".");
            try {
                Thread.currentThread();
                Thread.sleep(100L);
            }
            catch (Exception exception) {
                if (!SeisGram2KFrame.PRINT_IGNORED_EXCEPTIONS) continue;
                System.out.println(exception);
            }
        }
        if (bl4) {
            System.out.println("X");
            this.killPainting = false;
            return;
        }
        try {
            Font font;
            int n;
            Font font2;
            this.isPainting = true;
            this.killPainting = false;
            Graphics graphics2 = null;
            if (bl2 || bl) {
                graphics2 = graphics;
            } else if (this.bufferFlag) {
                if (this.backBuffer == null) {
                    this.newBackBuffer(this.seisPanel);
                } else if (!this.backSize.equals(this.seisPanel.getSize())) {
                    this.newBackBuffer(this.seisPanel);
                }
                if (this.backBuffer != null) {
                    graphics2 = this.backBufferGraphics != null ? this.backBufferGraphics : this.backBuffer.getGraphics();
                } else {
                    this.disposeOfBackBuffer();
                    graphics2 = graphics;
                }
            } else {
                this.disposeOfBackBuffer();
                graphics2 = graphics;
            }
            if (bl) {
                this.setColors(2);
            } else {
                this.setColors(colorModeCurrent);
            }
            if (!bl2 && !bl) {
                graphics2.setColor(this.backgroundColor);
                graphics2.fillRect(0, 0, dimension.width, dimension.height);
            }
            if (this.selectPanel == null && this.seisFrame.showSelectPanel || this.selectPanel != null && this.selectPanel.getNumberSeisButtons() != this.seismograms.length) {
                this.addSelectPanel();
            } else if (this.selectPanel != null && !this.seisFrame.showSelectPanel) {
                this.removeSelectPanel();
            }
            graphics2.setFont(graphics.getFont());
            FontMetrics fontMetrics = graphics2.getFontMetrics();
            int n2 = fontMetrics.getMaxAscent() + fontMetrics.getMaxDescent();
            if (n2 > dimension.height / 8) {
                font2 = graphics2.getFont();
                n = (int)(0.5 + (double)font2.getSize() * (double)(dimension.height / 8) / (double)n2);
                n = n < 6 ? 6 : n;
                font = new Font(font2.getName(), font2.getStyle(), n);
                graphics2.setFont(font);
                fontMetrics = graphics2.getFontMetrics();
                if (this.selectPanel != null) {
                    this.selectPanel.setFont(font);
                }
            }
            if (Math.abs(this.fontSizeFactor - 1.0) > 0.001 || this.fontStyle != 0) {
                font2 = graphics2.getFont();
                n = font2.getSize();
                if (!bl) {
                    n = (int)(this.fontSizeFactor * (double)font2.getSize());
                }
                font = new Font(font2.getName(), this.fontStyle, n);
                graphics2.setFont(font);
                fontMetrics = graphics2.getFontMetrics();
                if (this.selectPanel != null) {
                    this.selectPanel.setFont(font);
                }
            }
            int n3 = fontMetrics.charWidth('_');
            n = fontMetrics.getMaxAscent() + fontMetrics.getMaxDescent();
            if (this.selectPanel != null) {
                for (int i = 0; i < this.seismograms.length; ++i) {
                    this.selectPanel.setSeisButtonColor(i, this.seisFrame.getActiveGather() == this && i == this.activeSeismogram ? this.seismograms[i].color : AJLColor.control.darker().darker());
                }
                this.selectPanel.repaint();
            }
            boolean bl5 = this.seisFrame.paintUpperTimeAxis(this);
            boolean bl6 = this.seisFrame.paintLowerTimeAxis(this);
            this.plotRectangle = new Rectangle();
            this.plotRectangle.x = dimension.width / 12;
            this.plotRectangle.width = 98 * dimension.width / 100 - this.plotRectangle.x;
            this.plotRectangle.y = n;
            this.plotRectangle.height = bl6 ? dimension.height - 5 * n / 4 - this.plotRectangle.y : dimension.height - this.plotRectangle.y;
            this.rowTimeLength = (this.timeMax - this.timeMin) / (double)this.numberRowsInGroup;
            this.xScale = (double)this.plotRectangle.width / (this.timeMax - this.timeMin) * (double)this.numberRowsInGroup;
            this.yScale = (double)this.plotRectangle.height / (this.ampMax - this.ampMin) * (double)this.numberRowsInGroup;
            this.seisRectangleHeight = this.plotRectangle.height / this.numberRowsInGroup;
            this.setLimits(this.plotRectangle.x, this.plotRectangle.x + this.plotRectangle.width, this.plotRectangle.y, this.plotRectangle.y + this.plotRectangle.height);
            Rectangle rectangle = new Rectangle(this.plotRectangle.x, this.plotRectangle.y, this.plotRectangle.width, this.seisRectangleHeight);
            this.firstSeisRectangle = new Rectangle(rectangle);
            double d = this.timeMin;
            for (int i = 0; i < this.numberRowsInGroup; ++i) {
                String string;
                Object object;
                Color color;
                Object object2;
                if (!bl3 && !bl2) {
                    object2 = graphics2.create();
                    ((Graphics)object2).setClip(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                    color = bl && !this.overlayFlag ? this.foregroundColor : null;
                    for (int j = 0; j < this.seismograms.length; ++j) {
                        if (this.killPainting) {
                            this.isPainting = false;
                            this.killPainting = false;
                            return;
                        }
                        this.setRotationFields(j);
                        object = "";
                        if (i == 0) {
                            int n4;
                            if (drawSeismogramIdLabel) {
                                object = useShortSeismogramIdLabel ? this.seismograms[j].getStaInstIDShort() : this.seismograms[j].getStaInstID();
                            }
                            if ((n4 = ((String)object).indexOf(59)) > 0) {
                                object = ((String)object).substring(0, n4);
                            }
                            if (this.seismograms[j].compCode.compareTo("Z") != 0) {
                                if (this.chanAngle >= 0) {
                                    object = (String)object + " " + String.valueOf(this.chanAngle);
                                }
                            } else {
                                object = (String)object + " Z";
                            }
                        }
                        this.seismograms[j].paint((Graphics)object2, rectangle.x, rectangle.x + rectangle.width, rectangle.y - this.iyShift(j, n), rectangle.y + rectangle.height - this.iyShift(j, n), this.overlayFlag ? rectangle.y : 0 + j * (rectangle.height / this.seismograms.length), this.overlayFlag ? j : 0, d, d + this.rowTimeLength, this.ampMin, this.ampMax, this.thisFactor, this.otherFactor, this.otherSeismogram, (String)object, color);
                    }
                    ((Graphics)object2).dispose();
                }
                if (this.killPainting) {
                    this.isPainting = false;
                    this.killPainting = false;
                    return;
                }
                object2 = this.seisFrame.getActiveGather() == this && bl5 && bl6 ? this.activeGatherHighlightColor : this.middlegroundColor;
                Color color2 = color = this.seisFrame.getActiveGather() == this ? this.activeGatherHighlightColor : this.middlegroundColor;
                if (this.pickString == null) {
                    string = bl5 ? (this.seisFrame.isSchool() ? this.timeToStringDateOnly(this.timeMin, 0, 0, this.numDecimals, true) : this.timeToString(this.timeMin, 0, 1, this.numDecimals, true)) : "";
                    object = object2;
                } else {
                    string = this.pickString;
                    object = this.pickStringColor;
                }
                if (this.getNumberSeismograms() > 0) {
                    if (sortType == -1) {
                        this.sortedValueString = "";
                    } else if (sortType == 0) {
                        this.sortedValueString = "";
                    } else if (sortType == 1) {
                        this.sortedValueString = "";
                    } else if (sortType == 2) {
                        this.sortedValueString = " GCARC:" + NumberFormat.decimalString(this.seismograms[0].gcarc, this.seisFrame.numDecimals);
                        this.sortedValueString = this.sortedValueString + " AZ:" + NumberFormat.decimalString(this.seismograms[0].az, this.seisFrame.numDecimals);
                    } else if (sortType == 3) {
                        this.sortedValueString = " AZ:" + NumberFormat.decimalString(this.seismograms[0].az, this.seisFrame.numDecimals);
                        this.sortedValueString = this.sortedValueString + " GCARC:" + NumberFormat.decimalString(this.seismograms[0].gcarc, this.seisFrame.numDecimals);
                    } else if (sortType == 4) {
                        this.sortedValueString = " BAZ:" + NumberFormat.decimalString(this.seismograms[0].baz, this.seisFrame.numDecimals);
                        this.sortedValueString = this.sortedValueString + " GCARC:" + NumberFormat.decimalString(this.seismograms[0].gcarc, this.seisFrame.numDecimals);
                    }
                }
                String string2 = "";
                if (drawGroupIdLabel) {
                    string2 = this.gatherTitle + this.seismograms[this.activeSeismogram].getStaInstID() + " (" + this.seisFrame.getGatherListIndexOf(this) + ")" + this.sortedValueString;
                }
                AxesHorizTime axesHorizTime = new AxesHorizTime(this, rectangle.x, rectangle.x + rectangle.width, d, d + this.rowTimeLength, this.seismograms[this.activeSeismogram].getTimeUnits(), string, string2, rectangle.y, rectangle.y + rectangle.height, this.backgroundColor);
                axesHorizTime.paint(graphics2, (Color)object2, (Color)object, color, bl5 && i == 0, bl6);
                if (bl3) {
                    this.isPainting = false;
                    this.killPainting = false;
                    return;
                }
                Color color3 = this.seisFrame.getActiveGather() == this ? this.activeGatherHighlightColor : this.middlegroundColor;
                AxesVertAmp axesVertAmp = new AxesVertAmp(rectangle.y, rectangle.y + rectangle.height, this.ampMin, this.ampMax, i == 0 ? this.seismograms[this.activeSeismogram].getAmpUnits() : "", this.overlayFlag ? 1 : this.seismograms.length, rectangle.x, rectangle.x + rectangle.width);
                if (this.overlayFlag) {
                    axesVertAmp.paint(graphics2, 0, color3, color3, i == 0, i == this.numberRowsInGroup - 1);
                } else {
                    for (int j = 0; j < this.seismograms.length; ++j) {
                        Color color4 = this.seisFrame.getActiveGather() == this && j == this.activeSeismogram ? this.activeGatherHighlightColor : this.middlegroundColor;
                        axesVertAmp.paint(graphics2, this.iyShift(j, n), color4, color3, i == 0, i == this.numberRowsInGroup - 1);
                    }
                }
                if (this.numberRowsInGroup <= 1) continue;
                rectangle = new Rectangle(rectangle.x, rectangle.y + rectangle.height, rectangle.width, rectangle.height);
                d += this.rowTimeLength;
            }
            if (!bl3 && !bl2) {
                this.paintPicks(graphics2, false, true, bl);
                this.paintPredictedPhases(graphics2, false, true);
                this.paintArrivals(graphics2, false);
            }
            if (drawPanelLimits) {
                graphics2.setColor(this.middlegroundColor);
                graphics2.drawLine(0, 0, dimension.width, 0);
                graphics2.drawLine(0, dimension.height, dimension.width, dimension.height);
            }
            if (bl) {
                this.isPainting = false;
                this.killPainting = false;
                return;
            }
            if (bl2) {
                this.isPainting = false;
                this.killPainting = false;
                return;
            }
            if (this.isLiveSeis()) {
                graphics2.setColor(this.modeTextColor);
                graphics2.drawString("LiveSeis", 1, dimension.height - 1);
            }
            if (this.isSeedLink()) {
                graphics2.setColor(this.modeTextColor);
                graphics2.drawString("SeedLink", 1, dimension.height - 1);
            }
            if (this.backBuffer != null) {
                graphics.drawImage(this.backBuffer, 0, 0, null);
            }
            if (this.seisPanel.pickCursor) {
                this.seisPanel.redrawPickCursor(graphics, this.timeToIx(this.workingPick.dateTimeToTime(this)), this.timeToIy(this.workingPick.dateTimeToTime(this)));
            }
            if (this.particleMotionFrame != null && this.cursorVerticalTime >= 0.0) {
                this.seisPanel.drawCursorVertical(graphics, this.cursorVerticalColor, this.timeToIx(this.cursorVerticalTime));
            } else {
                this.cursorVerticalTime = -1.0;
                this.iCursorVerticalPos = -1;
            }
            this.isPainting = false;
            this.killPainting = false;
        }
        catch (Exception exception) {
            this.isPainting = false;
            this.killPainting = false;
            throw exception;
        }
    }

    public void setKillPainting() {
        this.killPainting = true;
    }

    public void setLimits(int n, int n2, int n3, int n4) {
        this.seisPanel.setLimits(n, n2, n3, n4);
    }

    public void paintPicks(Graphics graphics, boolean bl, boolean bl2, boolean bl3) {
        for (int i = 0; i < this.seisFrame.pickList.size(); ++i) {
            SeisPick seisPick = (SeisPick)this.seisFrame.pickList.elementAt(i);
            if (seisPick.getStatus() == 2) continue;
            this.paintPick(graphics, bl, bl2, seisPick, bl3);
        }
        try {
            double d = this.timeInstantToRefTime(this.getSeismogram((int)this.getActiveSeismogram()).hypocenter.otime);
            if (d != this.savedOtime || this.savedOtimePick != null) {
                this.savedOtimePick = new SeisPick(this.seisFrame, this);
                this.savedOtimePick.setDateTime(this.getRefTimeInstant(), d);
                this.savedOtimePick.name = "To";
                this.savedOtimePick.setSource(1);
                this.savedOtimePick.setStaInst(this, this.getActiveSeismogram());
            }
            if (this.savedOtimePick.getStatus() != 2) {
                this.paintPick(graphics, bl, bl2, this.savedOtimePick, bl3);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void paintPredictedPhases(Graphics graphics, boolean bl, boolean bl2) {
        if (this.seisFrame.predictedPhasesList == null) {
            return;
        }
        for (int i = 0; i < this.seisFrame.predictedPhasesList.size(); ++i) {
            SeisPick seisPick = (SeisPick)this.seisFrame.predictedPhasesList.elementAt(i);
            if (seisPick.getStatus() == 2) continue;
            this.paintPick(graphics, bl, bl2, seisPick, false);
        }
    }

    public void paintPick(Graphics graphics, boolean bl, boolean bl2, SeisPick seisPick, boolean bl3) {
        int n = seisPick.belongsTo(this);
        if (n < 0) {
            return;
        }
        seisPick.paint(graphics, this, n, bl, bl2, bl3);
    }

    public void paintPick(boolean bl, boolean bl2, SeisPick seisPick, boolean bl3) {
        Graphics graphics = this.seisPanel.getGraphics();
        if (graphics == null) {
            return;
        }
        this.paintPick(graphics, bl, bl2, seisPick, bl3);
        graphics.dispose();
    }

    public void unpaintPick(Graphics graphics, boolean bl, boolean bl2, SeisPick seisPick) {
        int n = seisPick.belongsTo(this);
        if (n < 0) {
            return;
        }
        seisPick.paint(graphics, this, n, bl2, false);
        seisPick.paintText(graphics, this, this.backgroundColor, bl, 0);
    }

    public void unpaintPick(boolean bl, boolean bl2, SeisPick seisPick) {
        Graphics graphics = this.seisPanel.getGraphics();
        if (graphics == null) {
            return;
        }
        this.unpaintPick(graphics, bl, bl2, seisPick);
        graphics.dispose();
    }

    public void paintArrivals(Graphics graphics, boolean bl) {
        if (!this.paintTauPArrivals) {
            return;
        }
        Color color = null;
        if (bl) {
            color = this.backgroundColor;
        }
        int n = -1;
        if (this.tauPphases != null) {
            if (graphics == null) {
                return;
            }
            for (int i = 0; i < this.tauPphases.length; ++i) {
                SeisPick seisPick = this.tauPphases[i];
                int n2 = this.timeToIx(seisPick.dateTimeToTime(this));
                if (n2 != n) {
                    seisPick.paintText(graphics, this, color, false, -1);
                    seisPick.paintLines(graphics, this, null, this.activeSeismogram, true);
                } else {
                    seisPick.paintText(graphics, this, color, false, -1);
                }
                n = n2;
            }
        }
    }

    public void paintArrivals(boolean bl) {
        if (!this.paintTauPArrivals) {
            return;
        }
        if (this.tauPphases != null) {
            Graphics graphics = this.seisPanel.getGraphics();
            if (graphics == null) {
                return;
            }
            this.paintArrivals(graphics, bl);
            graphics.dispose();
        }
    }

    public void convertArrivalsToPicks(boolean bl) {
        if (this.tauPphases != null) {
            for (int i = 0; i < this.tauPphases.length; ++i) {
                SeisPick seisPick = this.tauPphases[i];
                int n = this.seisFrame.addElementToPickList(seisPick, bl, 3);
            }
            this.seisFrame.writePicks();
        }
    }

    public void closeTauP(boolean bl) {
        this.paintTauPArrivals = false;
        if (bl) {
            this.repaint();
        }
    }

    public void drawCursorVertical(Color color, double d) {
        int n = this.timeToIx(d);
        if (this.cursorVerticalTime < 0.0) {
            this.seisPanel.drawCursorVertical(color, n);
        } else if (n != this.iCursorVerticalPos && d != this.cursorVerticalTime) {
            this.seisPanel.drawCursorVertical(color, this.timeToIx(this.cursorVerticalTime));
            this.seisPanel.drawCursorVertical(color, n);
        }
        this.iCursorVerticalPos = n;
        this.cursorVerticalTime = d;
        this.cursorVerticalColor = color;
    }

    public void removeCursorVertical(Color color) {
        if (this.cursorVerticalTime >= 0.0) {
            this.seisPanel.drawCursorVertical(color, this.timeToIx(this.cursorVerticalTime));
        }
        this.cursorVerticalTime = -1.0;
        this.iCursorVerticalPos = -1;
    }

    public String getConciseTitle() {
        if (this.seisFrame.isSchool()) {
            return this.seismograms[this.activeSeismogram].getStaInstID() + " " + this.dateToString(this.timeMin, 0, 0);
        }
        return this.seismograms[this.activeSeismogram].getStaInstID() + " " + this.timeToString(this.timeMin, 0, 1, this.numDecimals, true);
    }

    public void setRotationFields(int n) {
        this.otherSeismogram = null;
        this.thisFactor = 1.0;
        this.otherFactor = 0.0;
        this.chanAngle = -1;
        if (this.seismograms[n].compCode.compareTo("Z") != 0) {
            int n2;
            this.thisFactor = Math.cos(Math.PI / 180 * (double)this.relativeRotationAngle);
            this.otherFactor = Math.sin(Math.PI / 180 * (double)this.relativeRotationAngle);
            if (this.seismograms[n].compCode.compareTo("Y") == 0) {
                for (n2 = 0; n2 < this.seismograms.length; ++n2) {
                    if (this.seismograms[n2].compCode.compareTo("X") != 0) continue;
                    this.otherSeismogram = this.seismograms[n2];
                }
                this.chanAngle = this.rotationAngle;
            }
            if (this.seismograms[n].compCode.compareTo("X") == 0) {
                for (n2 = 0; n2 < this.seismograms.length; ++n2) {
                    if (this.seismograms[n2].compCode.compareTo("Y") != 0) continue;
                    this.otherSeismogram = this.seismograms[n2];
                }
                this.otherFactor *= -1.0;
                this.chanAngle = this.rotationAngle + 90;
                if (this.chanAngle > 360) {
                    this.chanAngle -= 360;
                }
            }
        }
    }

    private int iyShift(int n, int n2) {
        if (this.overlayFlag) {
            return 0;
        }
        int n3 = this.plotRectangle.height / 2 - this.plotRectangle.height / (2 * this.seismograms.length) - n * this.plotRectangle.height / this.seismograms.length;
        if (this.numberRowsInGroup > 1) {
            n3 /= this.numberRowsInGroup;
            n3 -= n2 / 3;
        }
        return n3;
    }

    public void increaseAmp(double d) {
        double d2 = (this.ampMax + this.ampMin) / 2.0;
        this.setAmpRange(d2 - (d2 - this.ampMin) / d, d2 + (this.ampMax - d2) / d);
        this.setTimeRange(this.timeMin, this.timeMax);
    }

    public void decreaseAmp(double d) {
        double d2 = (this.ampMax + this.ampMin) / 2.0;
        this.setAmpRange(d2 - (d2 - this.ampMin) * d, d2 + (this.ampMax - d2) * d);
        this.setTimeRange(this.timeMin, this.timeMax);
    }

    public void moreTime() {
        double d = (this.timeMax + this.timeMin) / 2.0;
        if (this.timeMax - this.timeMin > 3.15576E10) {
            return;
        }
        this.setTimeRange(d - (d - this.timeMin) * 1.2, d + (this.timeMax - d) * 1.2);
        this.setAmpRange(this.ampMin, this.ampMax);
    }

    public void lessTime() {
        double d = (this.timeMax + this.timeMin) / 2.0;
        if (this.timeMax - this.timeMin < d * 1.0E-10) {
            return;
        }
        this.setTimeRange(d - (d - this.timeMin) / 1.2, d + (this.timeMax - d) / 1.2);
        this.setAmpRange(this.ampMin, this.ampMax);
    }

    public void init() {
        this.setTimeRange(this.initTimeMin, this.initTimeMax);
        this.setAmpRange(this.initAmpMin, this.initAmpMax);
    }

    public void prev() {
        this.setTimeRange(this.lastTimeMin, this.lastTimeMax);
        this.setAmpRange(this.lastAmpMin, this.lastAmpMax);
    }

    public boolean bigDecreaseTime() {
        double d = (this.timeMax - this.timeMin) / 6.0;
        this.setTimeRange(this.timeMin + d, this.timeMax + d);
        this.setAmpRange(this.ampMin, this.ampMax);
        return true;
    }

    public boolean bigIncreaseTime() {
        double d = (this.timeMax - this.timeMin) / 6.0;
        this.setTimeRange(this.timeMin - d, this.timeMax - d);
        this.setAmpRange(this.ampMin, this.ampMax);
        return true;
    }

    public boolean decreaseTime() {
        double d = (this.timeMax - this.timeMin) / 20.0;
        this.setTimeRange(this.timeMin + d, this.timeMax + d);
        this.setAmpRange(this.ampMin, this.ampMax);
        return true;
    }

    public boolean increaseTime() {
        double d = (this.timeMax - this.timeMin) / 20.0;
        this.setTimeRange(this.timeMin - d, this.timeMax - d);
        this.setAmpRange(this.ampMin, this.ampMax);
        return true;
    }

    public boolean overlay() {
        this.overlayFlag = !this.overlayFlag;
        return this.overlayFlag;
    }

    public void displayPick(int n, int n2) {
        this.displayPick(n, n2, 0);
    }

    public void displayPick(int n, int n2, int n3) {
        if (n >= 0) {
            this.workingPick.setDateTime(this.seismograms[this.activeSeismogram].refTimeInstant, this.ixToTime(n, n3));
            this.workingPick.amplitude = this.seismograms[this.activeSeismogram].ampAtTimeVector(this.workingPick.dateTimeToTime(this));
            if (this.workingPick.amplitude == Double.MAX_VALUE) {
                this.workingPick.amplitude = 0.0;
            }
            if (SeisPick.isUncGauss()) {
                this.workingPick.uncertainty += (double)(-n2) / 1024.0 * (this.timeMax - this.timeMin);
                if (this.workingPick.uncertainty < 0.0) {
                    this.workingPick.uncertainty = 0.0;
                }
            }
            this.workingPick.isSet = true;
        }
        this.pickString = this.seisFrame.isSchool() ? SeisGramText.PICK + ": " + this.workingPick.toStringSchool(SeisGramText.AMP) : SeisGramText.PICK + ": " + this.workingPick.toStringDisplay(SeisGramText.AMP, this.numDecimals);
        this.paint(true, true);
        this.pickString = null;
    }

    public void clearPick() {
        this.pickString = null;
        this.paint(true, false);
        this.workingPick.init();
    }

    public void addChannelFileReadings(Vector vector, int n) {
        this.seisFrame.addChannelFileReadings(vector, this, n);
    }

    public void addElementToPickList(SeisPick seisPick, boolean bl) {
        if (this.seisFrame.addElementToPickList(seisPick, true) == 0 && this.isShowing()) {
            this.seisPanel.removePickCursor();
            this.seisPanel.redrawPickCursor(this.timeToIx(seisPick.dateTimeToTime(this)), this.timeToIy(seisPick.dateTimeToTime(this), this.activeSeismogram));
        }
    }

    public void setPick() {
        if (!this.workingPick.isSet || !this.seisPanel.pickCursor) {
            return;
        }
        this.unHighlightPick();
        SeisPick seisPick = new SeisPick(this.workingPick);
        seisPick.setStaInst(this, this.activeSeismogram);
        this.addElementToPickList(seisPick, true);
        this.seisFrame.writePicks();
        this.writePickMessage(seisPick);
        this.checkForSorPorCodaTimes(this.activeSeismogram, true);
        this.workingPick = new SeisPick(this.seisFrame, this);
        this.workingPick.init();
    }

    public void writePickMessage(SeisPick seisPick) {
        if (this.seisFrame.isSchool()) {
            this.writeMessage(SeisGramText.PICK + ": " + seisPick.toStringSchool(SeisGramText.AMP));
        } else {
            this.writeMessage(SeisGramText.SAVE + " " + SeisGramText.PICK + ": " + seisPick.toStringDisplayFull(SeisGramText.AMP, this.numDecimals));
        }
    }

    public void deleteAllPicks() {
        this.unHighlightPick();
        for (int i = this.seisFrame.pickList.size() - 1; i >= 0; --i) {
            SeisPick seisPick = (SeisPick)this.seisFrame.pickList.elementAt(i);
            if (seisPick.belongsTo(this) < 0) continue;
            this.seisFrame.deleteElementInPickList(seisPick, true);
        }
        this.seisFrame.writePicks();
        this.checkForSorPorCodaTimes(this.activeSeismogram, true);
    }

    public int highlightNearestPick(int n, int n2) {
        this.unHighlightPick();
        SeisPick seisPick = this.nearestPickToIx(n, n2);
        if (seisPick == null) {
            return -1;
        }
        seisPick.paintText(this.seisPanel.getGraphics(), this, this.backgroundColor, this.foregroundColor, false, 0);
        this.setMoveCursor();
        this.highlightedPick = seisPick;
        return this.timeToIx(this.workingPick.dateTimeToTime(this));
    }

    public void unHighlightPick() {
        if (this.highlightedPick != null) {
            this.highlightedPick.paintText(this.seisPanel.getGraphics(), this, this.highlightedPick.pickColor, this.backgroundColor, false, 0);
            this.setPickCursor();
        }
        this.highlightedPick = null;
    }

    public int makeNearestPickActive(int n, int n2) {
        this.unHighlightPick();
        SeisPick seisPick = this.nearestPickToIx(n, n2);
        if (seisPick == null) {
            return -1;
        }
        this.workingPick = new SeisPick(seisPick);
        this.workingPick.setSource(2);
        this.seisFrame.deleteElementInPickList(seisPick, true);
        this.seisFrame.writePicks();
        this.checkForSorPorCodaTimes(this.activeSeismogram, true);
        return this.timeToIx(this.workingPick.dateTimeToTime(this));
    }

    public SeisPick nearestPickToIx(int n, int n2) {
        SeisPick seisPick = null;
        int n3 = Integer.MAX_VALUE;
        for (int i = 0; i < this.seisFrame.pickList.size(); ++i) {
            int n4;
            SeisPick seisPick2 = (SeisPick)this.seisFrame.pickList.elementAt(i);
            if (seisPick2.getStatus() == 2 || seisPick2.belongsTo(this) < 0 || (n4 = Math.abs(n - this.timeToIx(seisPick2.dateTimeToTime(this)))) >= n3) continue;
            n3 = n4;
            seisPick = seisPick2;
        }
        if (seisPick != null && seisPick.textIsUnder(n, n2)) {
            return seisPick;
        }
        return null;
    }

    public void setPickAutoAmpZeroToPeakMax(String string) {
        this.unHighlightPick();
        this.seisPanel.removePickCursor();
        int n = this.seismograms[this.activeSeismogram].indexOfAmpZeroToPeakMax();
        if (n < 0) {
            return;
        }
        double d = this.seismograms[this.activeSeismogram].timeAtSample(n);
        SeisPick seisPick = new SeisPick(this.seisFrame, this);
        seisPick.setStaInst(this, this.activeSeismogram);
        seisPick.setDateTime(this.getRefTimeInstant(), d);
        seisPick.name = string != null ? string : "0-P_max";
        seisPick.amplitude = this.seismograms[this.activeSeismogram].ampAtTimeVector(d);
        seisPick.amplitudeUnits = this.seismograms[this.activeSeismogram].getAmpUnits();
        this.addElementToPickList(seisPick, true);
        this.seisFrame.writePicks();
        this.writePickMessage(seisPick);
        this.workingPick = new SeisPick(this.seisFrame, this);
        this.workingPick.init();
    }

    public void setPickAutoAmpPeakToPeakMax(double d) {
        this.unHighlightPick();
        this.seisPanel.removePickCursor();
        RangeInteger rangeInteger = this.seismograms[this.activeSeismogram].indicesOfAmpPeakToPeakMax(d);
        if (rangeInteger == null || rangeInteger.min < 0 || rangeInteger.max < 0) {
            return;
        }
        double d2 = this.seismograms[this.activeSeismogram].timeAtSample(rangeInteger.min);
        double d3 = this.seismograms[this.activeSeismogram].timeAtSample(rangeInteger.max);
        SeisPick seisPick = new SeisPick(this.seisFrame, this);
        seisPick.setStaInst(this, this.activeSeismogram);
        seisPick.setDateTime(this.getRefTimeInstant(), d2);
        seisPick.name = "P-P_min";
        seisPick.amplitude = this.seismograms[this.activeSeismogram].ampAtTimeVector(d2);
        seisPick.amplitudeUnits = this.seismograms[this.activeSeismogram].getAmpUnits();
        SeisPick seisPick2 = new SeisPick(this.seisFrame, this);
        seisPick2.setStaInst(this, this.activeSeismogram);
        seisPick2.setDateTime(this.getRefTimeInstant(), d3);
        seisPick2.name = "P-P_max";
        seisPick2.amplitude = this.seismograms[this.activeSeismogram].ampAtTimeVector(d3);
        seisPick2.amplitudeUnits = this.seismograms[this.activeSeismogram].getAmpUnits();
        this.addElementToPickList(seisPick, true);
        this.addElementToPickList(seisPick2, true);
        this.seisFrame.writePicks();
        this.writePickMessage(seisPick);
        this.writePickMessage(seisPick2);
        this.workingPick = new SeisPick(this.seisFrame, this);
        this.workingPick.init();
    }

    public void setPickAutoCumulative(double d, double d2) {
        int n;
        this.unHighlightPick();
        this.seisPanel.removePickCursor();
        int n2 = this.seismograms[this.activeSeismogram].indexOfCumulative(d);
        if (n2 < 0) {
            return;
        }
        double d3 = this.seismograms[this.activeSeismogram].timeAtSample(n2);
        double d4 = 0.0;
        int n3 = this.seismograms[this.activeSeismogram].indexOfCumulative(d - d2 / 2.0);
        if (n3 < (n = this.seismograms[this.activeSeismogram].indexOfCumulative(d + d2 / 2.0))) {
            d4 = this.seismograms[this.activeSeismogram].timeSeries.sampleInt * (double)(n - n3 - 1);
            d4 /= 2.0;
        }
        SeisPick seisPick = new SeisPick(this.seisFrame, this);
        seisPick.setStaInst(this, this.activeSeismogram);
        seisPick.setDateTime(this.getRefTimeInstant(), d3);
        seisPick.name = "Cumul_" + (int)(100.0 * d);
        seisPick.amplitude = this.seismograms[this.activeSeismogram].ampAtTimeVector(d3);
        seisPick.amplitudeUnits = this.seismograms[this.activeSeismogram].getAmpUnits();
        seisPick.setUncertainty(d4);
        this.addElementToPickList(seisPick, true);
        this.seisFrame.writePicks();
        this.writePickMessage(seisPick);
        this.workingPick = new SeisPick(this.seisFrame, this);
        this.workingPick.init();
    }

    public void setPickFromPickData(PickData pickData, String string) {
        this.setPickFromPickData(pickData, string, this.seismograms[this.activeSeismogram], 0, false);
    }

    public void setPickFromPickData(PickData pickData, String string, Seismogram seismogram, int n, boolean bl) {
        int n2 = this.getIndex(seismogram);
        if (n2 < 0) {
            String string2 = this.getClass().getName() + ": setPickFromPickData : " + "ERROR: Seismogram does not belong to this GatherPanel";
            return;
        }
        this.unHighlightPick();
        this.seisPanel.removePickCursor();
        double d = pickData.indices[0] + (double)n;
        double d2 = pickData.indices[1] + (double)n;
        double d3 = 0.0;
        d3 = (d + d2) / 2.0;
        double d4 = seismogram.timeAtSample(d3);
        double d5 = 0.0;
        if (d2 >= 0.0) {
            d5 = seismogram.timeSeries.sampleInt * Math.abs(d - d2);
            d5 /= 2.0;
        }
        SeisPick seisPick = new SeisPick(this.seisFrame, this);
        seisPick.setStaInst(this, n2);
        seisPick.setDateTime(seismogram.refTimeInstant, d4);
        seisPick.name = string;
        seisPick.amplitude = pickData.amplitude;
        seisPick.amplitudeUnits = pickData.amplitudeUnits.equals("_DATA") ? seismogram.getAmpUnits() : (pickData.amplitudeUnits.equals("_INDEP_VAR") ? seismogram.getTimeUnits() : pickData.amplitudeUnits);
        seisPick.setUncertainty(d5);
        if (pickData.polarity == 1) {
            seisPick.firstMot = "+";
        } else if (pickData.polarity == -1) {
            seisPick.firstMot = "-";
        }
        seisPick.period = pickData.period;
        this.addElementToPickList(seisPick, true);
        this.seisFrame.writePicks(bl);
        this.writePickMessage(seisPick);
        this.workingPick = new SeisPick(this.seisFrame, this);
        this.workingPick.init();
    }

    public void setPickToBox(String string, String string2) {
        this.unHighlightPick();
        this.seisPanel.removePickCursor();
        SeisPick seisPick = null;
        SeisPick seisPick2 = null;
        for (int i = 0; i < this.seisFrame.pickList.size(); ++i) {
            SeisPick seisPick3 = (SeisPick)this.seisFrame.pickList.elementAt(i);
            if (seisPick3.getStatus() == 2 || seisPick3.belongsTo(this) < 0) continue;
            if (seisPick3.name.equals(string)) {
                seisPick = seisPick3;
                continue;
            }
            if (!seisPick3.name.equals(string2)) continue;
            seisPick2 = seisPick3;
        }
        if (seisPick == null || seisPick2 == null) {
            String string3 = "WARNING: Cannot create box pick: " + string + "->" + string2;
            System.out.println(string3);
            this.seisFrame.writeMessage(string3);
            return;
        }
        double d = (seisPick2.dateTimeToTime(this) + seisPick.dateTimeToTime(this)) / 2.0;
        double d2 = (seisPick2.dateTimeToTime(this) - seisPick.dateTimeToTime(this)) / 2.0;
        SeisPick seisPick4 = new SeisPick(seisPick);
        seisPick4.setDateTime(this.getRefTimeInstant(), d);
        seisPick4.name = "Box_" + string + "-" + string2;
        seisPick4.amplitude = seisPick.uncertainty + seisPick2.uncertainty;
        seisPick4.amplitudeUnits = this.seismograms[this.activeSeismogram].getAmpUnits();
        seisPick4.setUncertainty(d2);
        seisPick4.setUncertaintyType(SeisPick.UNC_TYPE_BOX);
        this.addElementToPickList(seisPick4, true);
        this.seisFrame.writePicks();
        this.writePickMessage(seisPick4);
        this.workingPick = new SeisPick(this.seisFrame, this);
        this.workingPick.init();
    }

    public void setPickAutoPivotLine(String string, double d, double d2, double d3) {
        this.unHighlightPick();
        this.seisPanel.removePickCursor();
        SeisPick seisPick = null;
        Object var9_6 = null;
        for (int i = 0; i < this.seisFrame.pickList.size(); ++i) {
            SeisPick seisPick2 = (SeisPick)this.seisFrame.pickList.elementAt(i);
            if (seisPick2.getStatus() == 2 || seisPick2.belongsTo(this) < 0 || !seisPick2.name.equals(string)) continue;
            seisPick = seisPick2;
        }
        if (seisPick == null) {
            String string2 = "WARNING: Cannot create pivot line pick, cannot find: " + string;
            System.out.println(string2);
            this.seisFrame.writeMessage(string2);
            return;
        }
        double d4 = seisPick.dateTimeToTime(this);
        int[] nArray = this.seismograms[this.activeSeismogram].indexOfPivotLimit(d4, d, d2, d3);
        if (nArray == null) {
            return;
        }
        double d5 = this.seismograms[this.activeSeismogram].timeAtSample(nArray[0]);
        double d6 = 0.0;
        if (nArray[1] < nArray[0]) {
            d6 = this.seismograms[this.activeSeismogram].timeSeries.sampleInt * (double)(nArray[0] - nArray[1] - 1);
        }
        SeisPick seisPick3 = new SeisPick(this.seisFrame, this);
        seisPick3.setStaInst(this, this.activeSeismogram);
        seisPick3.setDateTime(this.getRefTimeInstant(), d5);
        seisPick3.name = "Pivot_" + (int)(100.0 * d2);
        seisPick3.amplitude = this.seismograms[this.activeSeismogram].ampAtTimeVector(d5);
        seisPick3.amplitudeUnits = this.seismograms[this.activeSeismogram].getAmpUnits();
        seisPick3.setUncertainty(d6);
        this.addElementToPickList(seisPick3, true);
        this.seisFrame.writePicks();
        this.writePickMessage(seisPick3);
        this.workingPick = new SeisPick(this.seisFrame, this);
        this.workingPick.init();
    }

    public void checkForSorPorCodaTimes(int n, boolean bl) {
        Object object;
        Object object2;
        int n2;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        for (n2 = this.seisFrame.pickList.size() - 1; n2 >= 0; --n2) {
            object2 = (SeisPick)this.seisFrame.pickList.elementAt(n2);
            if (((SeisPick)object2).belongsTo(this) < 0 || ((SeisPick)object2).getStatus() == 2) continue;
            if (((SeisPick)object2).name.compareTo("P") == 0) {
                d = ((SeisPick)object2).dateTimeToTime(this);
                if (bl3) {
                    bl2 = true;
                }
                bl3 = true;
                continue;
            }
            if (((SeisPick)object2).name.compareTo("S") == 0) {
                d2 = ((SeisPick)object2).dateTimeToTime(this);
                if (bl4) {
                    bl2 = true;
                }
                bl4 = true;
                continue;
            }
            if (((SeisPick)object2).name.compareTo(SeisPick.CODA_STRING) != 0) continue;
            d3 = ((SeisPick)object2).dateTimeToTime(this);
            if (bl5) {
                bl2 = true;
            }
            bl5 = true;
        }
        n2 = 0;
        object2 = "";
        boolean bl6 = false;
        if (bl3 && bl4) {
            object2 = (String)object2 + "Ts-Tp=" + NumberFormat.doubleString(d2 - d, -1, this.numDecimals) + "s   ";
            n2 = 1;
        }
        if (bl3 && bl5) {
            object2 = (String)object2 + SeisPick.CODA_STRING + "-P=" + NumberFormat.doubleString(d3 - d, -1, this.numDecimals) + "s   ";
            n2 = 1;
        }
        if (bl4 && bl5) {
            object2 = (String)object2 + SeisPick.CODA_STRING + "-S=" + NumberFormat.doubleString(d3 - d2, -1, this.numDecimals) + "s   ";
            n2 = 1;
        }
        if (this.seisFrame.isSchool() && bl3 && (object = this.getSeismogram((int)this.getActiveSeismogram()).hypocenter.otime) != BasicHypocenter.UNDEF_OTIME) {
            object2 = "Tp-To=" + NumberFormat.doubleString(d - this.timeInstantToRefTime((TimeInstant)object), -1, this.numDecimals) + "s   " + (String)object2;
            n2 = 1;
        }
        if (bl2) {
            object2 = SeisGramText.WARNING_MULTIPLE_PHASES_FOUND + "   " + (String)object2;
            n2 = 1;
            bl6 = true;
        }
        object2 = SeisGramText.PICK + ":   " + (String)object2;
        if (this.seisFrame.isSchool() && bl) {
            Object object3;
            object = SeisGramText.PICK + " - ";
            String string = "";
            if (this.seismograms[this.getActiveSeismogram()] != null && (string = this.seismograms[this.getActiveSeismogram()].channel.staName).endsWith(":")) {
                string = string.substring(0, string.length() - 1);
            }
            object = (String)object + string;
            if (this.dialog == null || this.messageLabel == null) {
                this.dialog = new JDialog(this.seisFrame, (String)object, false);
                object3 = new JButton(SeisGramText.CLOSE);
                ((AbstractButton)object3).addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        GatherPanel.this.dialog.setVisible(false);
                    }
                });
                JPanel jPanel = new JPanel();
                jPanel.setLayout(new BorderLayout());
                this.messageLabel = new JTextArea();
                this.messageLabel.setBackground(this.dialog.getBackground());
                this.messageLabel.setEditable(false);
                this.messageLabel.setFont(this.messageLabel.getFont().deriveFont(1));
                JPanel jPanel2 = new JPanel();
                jPanel2.add(this.messageLabel);
                jPanel2.setBorder(new EmptyBorder(10, 50, 5, 50));
                jPanel.add((Component)jPanel2, "Center");
                JPanel jPanel3 = new JPanel();
                jPanel3.setLayout(new FlowLayout(2));
                jPanel3.add((Component)object3);
                jPanel.add((Component)jPanel3, "South");
                this.dialog.getContentPane().add(jPanel);
                SwingExt.setLocationToCenterOfScreen(this.dialog);
            }
            if (n2 != 0) {
                if (bl6) {
                    this.messageLabel.setForeground(Color.RED.darker());
                } else {
                    this.messageLabel.setForeground(this.dialog.getForeground());
                }
                object3 = string + SeisGram2KFrame.ENDLINE + " " + SeisGram2KFrame.ENDLINE;
                object3 = (String)object3 + ((String)object2).replaceAll("   ", SeisGram2KFrame.ENDLINE + "   ");
                object3 = ((String)object3).substring(0, ((String)object3).lastIndexOf(SeisGram2KFrame.ENDLINE));
                this.messageLabel.setText((String)object3);
                this.dialog.setTitle((String)object);
                this.dialog.pack();
                this.dialog.setVisible(true);
            } else {
                this.dialog.setVisible(false);
                this.dialog.dispose();
                this.dialog = null;
                this.messageLabel = null;
            }
        }
        if (n2 != 0) {
            this.writeMessage((String)object2);
        }
    }

    public void duplicate() {
        this.seisFrame.duplicateGather(this);
    }

    public void close() {
        this.selectGather();
        this.seisFrame.removeActiveGather();
    }

    public void selectGather() {
        if (this.seisFrame.getActiveGather() == this) {
            return;
        }
        this.activeSeismogram = this.lastActiveSeismogram;
        this.seisFrame.newGatherSelected(this);
    }

    public void removePickCursor() {
        this.seisPanel.removePickCursor();
    }

    public void setDefaultCursor() {
        this.setCursor(DEFAULT_CURSOR);
    }

    public void setMoveCursor() {
        this.setCursor(MOVE_CURSOR);
    }

    public void setPickCursor() {
        this.setCursor(CROSSHAIR_CURSOR);
    }

    public void setCursor(Cursor cursor) {
        super.setCursor(cursor);
        if (this.selectPanel != null && cursor != CROSSHAIR_CURSOR) {
            this.selectPanel.setCursor(DEFAULT_CURSOR);
        }
    }

    public void drawPickCrosshair(Graphics graphics, int n, int n2, boolean bl, int n3, int n4, int n5, int n6) {
        this.workingPick.drawPickCrosshair(graphics, this, n, n2, bl, n3, n4, n5, n6);
    }

    public boolean selectSeisAtLoc(int n) {
        if (this.isOverlayed()) {
            return false;
        }
        int n2 = this.iyToIyRow(n);
        int n3 = this.seismograms.length;
        if (n3 < 1) {
            return false;
        }
        int n4 = this.plotRectangle.height;
        int n5 = n4 / n3;
        int n6 = this.getActiveSeismogram();
        int n7 = n6 * n5;
        int n8 = n7 + n5;
        if (n2 >= n7 && n2 <= n8) {
            return false;
        }
        return this.selectSeis(n2 / n5);
    }

    public boolean selectSeis(int n) {
        if (n >= this.seismograms.length) {
            return false;
        }
        if (this.seisFrame.getActiveGather() != this) {
            this.selectGather();
        }
        this.activeSeismogram = this.lastActiveSeismogram = n;
        this.seisFrame.newSeisSeleted();
        this.paint(true, false);
        return true;
    }

    public DataManager getDataManager() {
        return this.seisFrame.getDataManager();
    }

    public int getActiveSeismogram() {
        return this.activeSeismogram;
    }

    public int getIndex(Seismogram seismogram) {
        for (int i = 0; i < this.seismograms.length; ++i) {
            if (this.seismograms[i] != seismogram) continue;
            return i;
        }
        return -1;
    }

    public Seismogram getSeismogram(int n) {
        try {
            return this.seismograms[n];
        }
        catch (Exception exception) {
            if (SeisGram2KFrame.PRINT_IGNORED_EXCEPTIONS) {
                System.out.println(exception);
            }
            return null;
        }
    }

    public Seismogram[] getSeismograms() {
        return this.seismograms;
    }

    public TimeInstant getHypocenterOtime() {
        Seismogram seismogram = this.getSeismogram(0);
        if (seismogram == null) {
            return null;
        }
        return seismogram.getHypocenterOtime();
    }

    public boolean isOverlayed() {
        return this.overlayFlag;
    }

    public boolean isInitial() {
        return (float)this.initTimeMin == (float)this.timeMin && (float)this.initTimeMax == (float)this.timeMax && (float)this.initAmpMin == (float)this.ampMin && (float)this.initAmpMax == (float)this.ampMax;
    }

    public boolean hasPrevious() {
        return this.lastTimeMin != this.timeMin || this.lastTimeMax != this.timeMax || this.lastAmpMin != this.ampMin || this.lastAmpMax != this.ampMax;
    }

    public boolean isMonitor() {
        return this.runMode == 1 || this.runMode == 2;
    }

    public boolean isLiveSeis() {
        return this.runMode == 1;
    }

    public boolean isSeedLink() {
        return this.runMode == 2;
    }

    public boolean hasAllData() {
        if (!this.isMonitor()) {
            return true;
        }
        return this.seedLinkManager != null && this.seedLinkManager.isClosed();
    }

    public boolean isThreeCompSet() {
        if (this.seismograms.length != 3) {
            return false;
        }
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        for (int i = 0; i < this.seismograms.length; ++i) {
            if (this.seismograms[i].compCode.compareTo("X") == 0) {
                bl = true;
            }
            if (this.seismograms[i].compCode.compareTo("Y") == 0) {
                bl2 = true;
            }
            if (this.seismograms[i].compCode.compareTo("Z") != 0) continue;
            bl3 = true;
        }
        return bl && bl2 && bl3;
    }

    public boolean isOrthogonalSet() {
        if (this.seismograms.length > 3) {
            return false;
        }
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        for (int i = 0; i < this.seismograms.length; ++i) {
            if (this.seismograms[i].compCode.compareTo("X") == 0) {
                bl = true;
            }
            if (this.seismograms[i].compCode.compareTo("Y") == 0) {
                bl2 = true;
            }
            if (this.seismograms[i].compCode.compareTo("Z") != 0) continue;
            bl3 = true;
        }
        if (this.seismograms.length == 3 && bl && bl2 && bl3) {
            return true;
        }
        if (this.seismograms.length == 2 && (bl && bl2 || bl && bl3 || bl2 && bl3)) {
            return true;
        }
        return this.seismograms.length == 1 && (bl || bl2 || bl3);
    }

    public void doParticleMotion() {
        int n;
        if (!this.isOrthogonalSet()) {
            this.writeMessage("ERROR: Particle motion for orthogonal channel sets only.");
            return;
        }
        Seismogram seismogram = null;
        Seismogram seismogram2 = null;
        Seismogram seismogram3 = null;
        for (int i = 0; i < this.seismograms.length; ++i) {
            if (this.seismograms[i].compCode.compareTo("X") == 0) {
                seismogram = this.seismograms[i];
            }
            if (this.seismograms[i].compCode.compareTo("Y") == 0) {
                seismogram2 = this.seismograms[i];
            }
            if (this.seismograms[i].compCode.compareTo("Z") != 0) continue;
            seismogram3 = this.seismograms[i];
        }
        if (seismogram == null && seismogram2 == null && seismogram3 == null) {
            this.writeMessage("ERROR: Cannot identify orthogonal set of channels.");
            return;
        }
        if (this.particleMotionFrame != null) {
            this.particleMotionFrame.dispose();
        }
        this.particleMotionFrame = new ParticleMotionFrame(this, seismogram, seismogram2, seismogram3, this.initRotationAngle, new RangeDouble(this.timeMin, this.timeMax), this.seismograms[this.activeSeismogram].getStaInstID(), this.seisFrame.iconImage);
        Dimension dimension = this.seisFrame.getSize();
        int n2 = n = dimension.width < dimension.height ? dimension.width : dimension.height;
        this.particleMotionFrame.init(n, n2);
    }

    public boolean particleMotionFrameIsActive() {
        return this.particleMotionFrame != null && this.particleMotionFrame.isActivated();
    }

    public void printParticleMotion(Graphics graphics, Dimension dimension) {
        if (this.particleMotionFrame != null) {
            this.particleMotionFrame.print(graphics, dimension);
        }
    }

    public void cleanUp() {
        this.killPainting = true;
        if (this.particleMotionFrame != null) {
            this.particleMotionFrame.dispose();
        }
        if (this.spectralDisplay != null) {
            for (int i = 0; i < this.spectralDisplay.length; ++i) {
                if (this.spectralDisplay[i] == null) continue;
                this.spectralDisplay[i].dispose();
            }
        }
        this.aliveFlag = false;
        if (this.runMode == 2 && this.seedLinkManager != null) {
            this.seedLinkManager.gatherClosing(this);
        }
    }

    public void setRemoveMonitorMean() {
        try {
            this.removeMonitorMean = this.seisFrame.getParameter("commands.onread").indexOf("rmean") >= 0;
        }
        catch (Exception exception) {
            this.removeMonitorMean = false;
        }
    }

    public void setMonitorManager(MonitorManager monitorManager) {
        this.seedLinkManager = monitorManager;
        this.runMode = 2;
        this.onReadCommands = monitorManager.onReadCommands;
        this.setRemoveMonitorMean();
    }

    public void removeMonitorManager() {
        this.seedLinkManager = null;
        this.runMode = 0;
        this.onReadCommands = null;
        this.removeMonitorMean = false;
        this.seisFrame.setAWTStates();
    }

    public double getDataLatency() {
        if (this.getNumberSeismograms() < 1) {
            return Double.NaN;
        }
        try {
            double d = -1.7976931348623157E308;
            for (int i = 0; i < this.seismograms.length; ++i) {
                Seismogram seismogram = this.seismograms[i];
                TimeInstant timeInstant = new TimeInstant(seismogram.getTimeStamp());
                TimeInstant timeInstant2 = seismogram.refTimeToTimeInstant(seismogram.getTimeMax());
                double d2 = TimeInstant.secondsDifference(timeInstant, timeInstant2);
                d = Math.max(d2, d);
            }
            if (Math.abs(d) < (double)1.4E-45f) {
                d = 0.0;
            }
            return d;
        }
        catch (Exception exception) {
            if (SeisGram2KFrame.PRINT_IGNORED_EXCEPTIONS) {
                System.out.println(exception);
            }
            return Double.NaN;
        }
    }

    public double getFeedLatency() {
        if (this.getNumberSeismograms() < 1) {
            return Double.NaN;
        }
        try {
            double d = -1.7976931348623157E308;
            long l = this.seisFrame.getClockTime();
            for (int i = 0; i < this.seismograms.length; ++i) {
                double d2 = (double)(l - this.seismograms[i].getTimeStamp()) / 1000.0;
                d = Math.max(d2, d);
            }
            if (Math.abs(d) < (double)1.4E-45f) {
                d = 0.0;
            }
            return d;
        }
        catch (Exception exception) {
            if (SeisGram2KFrame.PRINT_IGNORED_EXCEPTIONS) {
                System.out.println(exception);
            }
            return Double.NaN;
        }
    }

    public boolean isAlive() {
        return this.aliveFlag;
    }

    public void displaySeisInfo(int n) {
        if (this.seisFrame.isSchool()) {
            this.displaySeisInfo(n, this.seisFrame.getIconImage(), false);
        } else {
            this.displaySeisInfo(n, this.seisFrame.getIconImage(), true);
        }
    }

    public void displaySeisInfo(int n, Image image, boolean bl) {
        String string = "";
        if (bl) {
            String string2 = "[read]; ";
            for (int i = 0; i < this.processVector.size(); ++i) {
                string2 = string2 + (String)this.processVector.elementAt(i) + "; ";
            }
            String string3 = System.getProperty("line.separator");
            string = "# Processing history:" + string3 + string2 + string3 + string3 + "# Seismogram info:" + string3 + this.seismograms[n].toString() + this.seismograms[n].seisDataHeaderString;
        } else {
            string = this.seismograms[n].toStringConcise();
        }
        if (this.seisInfoTextFrame != null) {
            this.seisInfoTextFrame.dispose();
        }
        this.seisInfoTextFrame = new JTextFrame(SeisGramText.SEIS_DATA_HEADER_INFO + " - " + this.seismograms[n].getStaInstID(), null, string, SeisGramText.CLOSE, image, null);
        SwingExt.setProportionalSize((Component)this.seisInfoTextFrame, this.seisFrame, 0.5, 0.75);
        SwingExt.setLocationToCenter(this.seisInfoTextFrame, this.seisFrame, this.seisFrame.getLocationOnScreen());
        this.seisInfoTextFrame.show();
    }

    public void editSeisInfo(int n) {
        if (this.seisFrame.isSchool()) {
            this.editSeisInfo(n, this.seisFrame.getIconImage(), false);
        } else {
            this.editSeisInfo(n, this.seisFrame.getIconImage(), true);
        }
    }

    public void editSeisInfo(int n, Image image, boolean bl) {
        SeisInfoEditor seisInfoEditor = new SeisInfoEditor(this, n, this.seisFrame, bl);
        seisInfoEditor.doEdit();
    }

    public String toStringStationLocation() {
        return this.seismograms[0].toStringStationLocation();
    }

    public boolean stateIsStored() {
        return this.storedGather != null;
    }

    public void storeState() {
        GatherPanel gatherPanel = null;
        try {
            try {
                gatherPanel = new GatherPanel(this.seisFrame);
            }
            catch (Exception exception) {
                if (SeisGram2KFrame.PRINT_IGNORED_EXCEPTIONS) {
                    System.out.println(exception);
                }
                gatherPanel = null;
                this.storedGather = null;
                return;
            }
            if (gatherPanel.copySeismograms(this, true) <= 0) {
                gatherPanel = null;
            }
            this.storedGather = gatherPanel;
            this.storedGather.processVector = new Vector();
            for (int i = 0; i < this.processVector.size(); ++i) {
                this.storedGather.processVector.addElement(new String((String)this.processVector.elementAt(i)));
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            String string = "ERROR: Saving initial trace group state: " + outOfMemoryError;
            System.out.println(className + string);
            this.writeMessage(string);
            gatherPanel = null;
            this.storedGather = null;
            SeisGram2KFrame.doOutOfMemoryAction(true);
        }
        catch (Error error) {
            String string = "ERROR: Saving initial trace group state: " + error;
            System.out.println(className + string);
            this.writeMessage(string);
            gatherPanel = null;
            this.storedGather = null;
        }
    }

    public boolean resetToStoredState() {
        if (this.storedGather == null) {
            return false;
        }
        if (this.copySeismograms(this.storedGather, true) <= 0) {
            return false;
        }
        this.processVector = new Vector();
        for (int i = 0; i < this.storedGather.processVector.size(); ++i) {
            this.processVector.addElement(new String((String)this.storedGather.processVector.elementAt(i)));
        }
        if (this.particleMotionFrame != null) {
            this.particleMotionFrame.dispose();
        }
        return true;
    }

    public void addProcess(String string) {
        this.processVector.addElement(string);
    }

    public int updateTauP(TauP_Time tauP_Time, boolean bl, boolean bl2) {
        try {
            tauP_Time.setSourceDepth(this.travelTimeDepth);
            tauP_Time.calculate(this.travelTimeDist);
        }
        catch (Exception exception) {
            String string = "ERROR: TauP: " + exception;
            System.out.println(string);
            if (SeisGram2KFrame.PRINT_STACK_TRACES) {
                exception.printStackTrace();
            }
            this.seisFrame.writeMessage(string);
            return -1;
        }
        Arrival arrival = null;
        if (bl && this.tauParrivals != null && this.tauParrivals.length > 0 && this.tauParrivals[0] != null) {
            arrival = (Arrival)this.tauParrivals[0].clone();
        }
        this.tauParrivals = tauP_Time.getArrivals();
        double d = 0.0;
        if (arrival != null && this.tauParrivals.length > 0 && arrival.getName().equals(this.tauParrivals[0].getName())) {
            d = arrival.getTime() - this.tauParrivals[0].getTime();
        }
        this.setTravelTimeOtime(this.travelTimeOtime + d);
        if (!bl2) {
            return 0;
        }
        this.paintArrivals(true);
        this.paintTauPArrivals = true;
        boolean bl3 = travelTimeLr;
        int n = this.tauParrivals.length + 1;
        if (bl3) {
            ++n;
        }
        this.tauPphases = new SeisPick[n];
        this.tauPphases[0] = new SeisPick(this.seisFrame, this);
        this.tauPphases[0].setDateTime(this.getRefTimeInstant(), this.travelTimeOtime);
        this.tauPphases[0].name = "To";
        this.tauPphases[0].pickColor = this.foregroundColor;
        this.tauPphases[0].setSource(3);
        this.tauPphases[0].setStaInst(this, 0);
        int n2 = 1;
        for (int i = 0; i < this.tauParrivals.length; ++i) {
            SeisPick seisPick = new SeisPick(this.seisFrame, this, this.tauParrivals[i], this.travelTimeOtime);
            if (this.seisFrame.isSchool()) {
                int n3;
                if (seisPick.name.equals("Pvmp")) {
                    seisPick.name = "PmP";
                }
                for (n3 = 0; n3 < n2 && !seisPick.name.equalsIgnoreCase(this.tauPphases[n3].name); ++n3) {
                }
                if (n3 != n2) continue;
            }
            this.tauPphases[n2] = seisPick;
            ++n2;
        }
        if (bl3) {
            this.tauPphases[n2] = new SeisPick(this.seisFrame, this);
            this.tauPphases[n2].setDateTime(this.getRefTimeInstant(), this.travelTimeOtime + this.travelTimeDist * 111.11111111111111 / TauPSlownessModel.DEFAULT_RAYLEIGH_VELOCITY);
            this.tauPphases[n2].name = "Lr";
            this.tauPphases[n2].pickColor = this.foregroundColor;
            this.tauPphases[n2].setSource(3);
            this.tauPphases[n2].setStaInst(this, 0);
            ++n2;
        }
        if (n2 != n) {
            SeisPick[] seisPickArray = this.tauPphases;
            this.tauPphases = new SeisPick[n2];
            System.arraycopy(seisPickArray, 0, this.tauPphases, 0, n2);
        }
        this.paintArrivals(false);
        return 0;
    }

    public void displayRayInfo(String string) {
        SphericalTauPSlownessModel sphericalTauPSlownessModel = this.seisFrame.getSphericalTauPSlownessModel(string);
        String string2 = "";
        for (int i = 0; i < this.tauParrivals.length; ++i) {
            Arrival arrival = this.tauParrivals[i];
            String string3 = arrival.getName();
            if (string3.equals(string2)) continue;
            string2 = string3;
            double d = sphericalTauPSlownessModel.getRayLength(this.travelTimeDist, this.travelTimeDepth, string3);
            double d2 = arrival.getTime();
            double d3 = sphericalTauPSlownessModel.getDepthMax(this.travelTimeDist, this.travelTimeDepth, string3);
            String string4 = SeisGramText.RAY_INFO + ": " + arrival.getName() + ": " + SeisGramText.TRAVEL_TIME + " " + NumberFormat.doubleString(d2, -1, 2) + " s, " + SeisGramText.LENGTH + " " + NumberFormat.doubleString(d, -1, 2) + " km, " + SeisGramText.MAX_DEPTH + " " + NumberFormat.doubleString(d3, -1, 2) + " km";
            this.seisFrame.writeMessage(string4);
        }
    }

    public String getTauPsource() {
        return this.seismograms[0].getTauPsource();
    }

    public void setIndicator(int n) {
        this.seisFrame.setIndicator(n);
    }

    public double getNominalWindowLength() {
        if (this.isLiveSeis()) {
            return this.liveSeisManager.getNominalWindowLength();
        }
        return this.timeMax - this.timeMin;
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (this.seisFrame.controlKeyDown) {
            if (this.keySaveCursor == null) {
                this.keySaveCursor = this.getCursor();
            }
            this.setCursor(DEFAULT_CURSOR);
        }
        this.seisPanel.keyPressed(keyEvent);
    }

    public void keyReleased(KeyEvent keyEvent) {
        if (!this.seisFrame.controlKeyDown) {
            if (this.keySaveCursor != null) {
                this.setCursor(this.keySaveCursor);
            }
            this.keySaveCursor = null;
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
        if (!this.seisFrame.controlKeyDown) {
            if (this.keySaveCursor != null) {
                this.setCursor(this.keySaveCursor);
            }
            this.keySaveCursor = null;
        }
    }

    static {
        DEFAULT_CURSOR = new Cursor(0);
        MOVE_CURSOR = new Cursor(13);
        CROSSHAIR_CURSOR = new Cursor(1);
        sortType = 1;
        defaultSortOrderCounter = 0;
        drawPanelLimits = true;
        drawGroupIdLabel = true;
        useShortSeismogramIdLabel = false;
        drawSeismogramIdLabel = true;
        colorModeCurrent = 0;
        travelTimeLr = false;
        bufferMessageWritten = false;
    }
}

