/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.seisgram2k;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Vector;
import net.alomax.io.ASCIIOutputStream;
import net.alomax.io.GeneralInputStream;
import net.alomax.io.SmartASCIIInputStream;
import net.alomax.seisgram2k.GatherPanel;
import net.alomax.seisgram2k.SeisGram2KFrame;
import net.alomax.seisgram2k.SeisGramText;
import net.alomax.seisgram2k.SeisPick;
import net.alomax.util.Sort;
import net.alomax.xml.Attribute;
import net.alomax.xml.SimpleXMLParser;
import orfeus.srem.BasicReading;

public class PhaseSet
extends Vector {
    public static final int SORT_STA_TIME = 0;
    public static final int SORT_TIME = 1;
    public static final int SORT_STATION = 2;
    protected int sortType = 0;
    protected SeisGram2KFrame seisFrame;
    private static boolean messageWritten = false;

    public PhaseSet(SeisGram2KFrame seisGram2KFrame) {
        this.seisFrame = seisGram2KFrame;
        String string = seisGram2KFrame.getParameter("pick.sorttype");
        if (string != null) {
            if (string.equalsIgnoreCase("STA_TIME")) {
                this.sortType = 0;
            } else if (string.equalsIgnoreCase("TIME")) {
                this.sortType = 1;
            } else if (string.equalsIgnoreCase("STATION")) {
                this.sortType = 2;
            }
        }
    }

    public void setSortType(int n) {
        this.sortType = n;
    }

    public int read(String string, int n, int n2) {
        this.seisFrame.writeMessage(SeisGramText.READING_PICK_FILE + ": " + string + "...");
        InputStream inputStream = null;
        try {
            inputStream = GeneralInputStream.openStream(this.seisFrame.getDocumentBase(), string, false);
        }
        catch (IOException iOException) {
            this.seisFrame.writeMessage("_READY");
            if (!this.seisFrame.isSchool() && !messageWritten) {
                String string2 = "INFO: Cannot find or open an existing pick file: " + string;
                System.out.println(this.getClass().getName() + ": " + string2);
                this.seisFrame.writeMessage(string2);
                messageWritten = true;
            }
            return -1;
        }
        try {
            Object object;
            SmartASCIIInputStream smartASCIIInputStream = new SmartASCIIInputStream(new BufferedInputStream(inputStream));
            boolean bl = true;
            int n3 = n;
            SimpleXMLParser simpleXMLParser = null;
            if (n == 1000) {
                simpleXMLParser = new SimpleXMLParser(smartASCIIInputStream);
                bl = false;
                String string3 = null;
                while ((string3 = simpleXMLParser.getNextTag()) != null && !string3.equals("ReadingList")) {
                }
                object = null;
                while ((object = simpleXMLParser.getNextAttribute()) != null && !((Attribute)object).name.equals("format")) {
                }
                if (object == null) {
                    this.seisFrame.writeMessage("_READY");
                    String string4 = "ERROR: Parsing XML: Cannot determine pick format.";
                    System.out.println(this.getClass().getName() + ": " + string4);
                    this.seisFrame.writeMessage(string4);
                    return -1;
                }
                n3 = SeisPick.getFileFormatFor(((Attribute)object).value);
            }
            int n4 = 0;
            while (true) {
                if (n == 1000) {
                    object = null;
                    while ((object = simpleXMLParser.getNextTag()) != null && !((String)object).equals("Reading")) {
                    }
                    if (object == null || !((String)object).equals("Reading")) break;
                    simpleXMLParser.skipToTagEnd();
                }
                if (((SeisPick)(object = new SeisPick(this.seisFrame, null))).read(smartASCIIInputStream, n3, bl) < 0) break;
                if (n == 1000) {
                    String string5 = simpleXMLParser.getNextTag();
                    simpleXMLParser.skipToTagEnd();
                }
                ((SeisPick)object).setSource(n2);
                ((SeisPick)object).setStatus(1);
                n4 += this.addElementCheckExists((SeisPick)object, false, false);
            }
            if (n4 > 0) {
                object = "WARNING: Reading pick file: Found and skipped " + n4 + " duplicate readings.";
                System.out.println(this.getClass().getName() + ": " + (String)object);
                this.seisFrame.writeMessage((String)object);
            }
            if (smartASCIIInputStream != null) {
                smartASCIIInputStream.close();
            }
            this.seisFrame.writeMessage("_READY");
        }
        catch (IOException iOException) {
            this.seisFrame.writeMessage("_READY");
            String string6 = "ERROR: Reading pick file: " + string + ": " + iOException;
            System.out.println(this.getClass().getName() + ": " + string6);
            this.seisFrame.writeMessage(string6);
        }
        this.sort();
        return this.size();
    }

    public int write(ASCIIOutputStream aSCIIOutputStream, String string, String string2, boolean bl) {
        this.sort();
        for (int i = 0; i < this.size(); ++i) {
            SeisPick seisPick;
            int n;
            SeisPick seisPick2 = (SeisPick)this.elementAt(i);
            if (seisPick2.getStatus() == 2) continue;
            double d = Math.pow(10.0, -this.seisFrame.numDecimals);
            for (n = 0; n < i && ((seisPick = (SeisPick)this.elementAt(n)).getStatus() == 2 || seisPick.compareTo(seisPick2, d) != 0 || seisPick.compareIDFieldsTo(seisPick2, d) != 0); ++n) {
            }
            if (n < i) continue;
            if (bl) {
                GatherPanel gatherPanel;
                int n2;
                for (n2 = 0; n2 < this.seisFrame.getGatherListSize() && seisPick2.belongsTo(gatherPanel = this.seisFrame.getGatherListElementAt(n2)) < 0; ++n2) {
                }
                if (n2 == this.seisFrame.getGatherListSize()) continue;
            }
            seisPick2.write(aSCIIOutputStream, string, string2);
        }
        return this.size();
    }

    public int addReadings(Vector vector, GatherPanel gatherPanel, int n, int n2, int n3) {
        int n4 = 0;
        for (int i = 0; i < vector.size(); ++i) {
            SeisPick seisPick = new SeisPick((BasicReading)vector.elementAt(i), this.seisFrame);
            seisPick.setStaInst(gatherPanel, n);
            seisPick.setSource(n2);
            seisPick.setStatus(n3);
            if (seisPick.amplitude == Double.MAX_VALUE) {
                seisPick.setAmplitude(gatherPanel, n);
            }
            n4 += this.addElementCheckExists(seisPick, false, false);
        }
        this.sort();
        return n4;
    }

    public int addElementCheckExists(SeisPick seisPick, boolean bl) {
        return this.addElementCheckExists(seisPick, bl, false);
    }

    public int addElementCheckExists(SeisPick seisPick, boolean bl, boolean bl2) {
        int n = 0;
        double d = Math.pow(10.0, -this.seisFrame.numDecimals);
        for (int i = 0; i < this.size(); ++i) {
            SeisPick seisPick2 = (SeisPick)this.elementAt(i);
            if (seisPick.compareTo(seisPick2, d) != 0 || seisPick.compareIDFieldsTo(seisPick2, d) != 0) continue;
            this.deleteElement(seisPick2);
            if (bl) {
                this.seisFrame.removePickFromGatherDisplays(seisPick2);
            }
            ++n;
        }
        this.addElement(seisPick);
        if (bl2) {
            this.sort();
        }
        return n;
    }

    public void deleteElement(SeisPick seisPick) {
        seisPick.setStatus(2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void sort() {
        int n;
        Serializable serializable;
        int n2;
        SeisPick[] seisPickArray;
        block28: {
            Object object;
            String[] stringArray;
            Object[] objectArray;
            block27: {
                if (this.size() < 2) {
                    return;
                }
                objectArray = new SeisPick[this.size()];
                this.copyInto(objectArray);
                seisPickArray = new SeisPick[this.size()];
                stringArray = new String[this.size()];
                if (this.sortType == 0) break block27;
                if (this.sortType != 1) break block28;
            }
            for (n2 = 0; n2 < objectArray.length; ++n2) {
                object = (SeisPick)this.elementAt(n2);
                serializable = new StringBuffer();
                if (((SeisPick)object).iyear < 10) {
                    ((StringBuffer)serializable).append("000");
                } else if (((SeisPick)object).iyear < 100) {
                    ((StringBuffer)serializable).append("00");
                } else if (((SeisPick)object).iyear < 1000) {
                    ((StringBuffer)serializable).append('0');
                }
                ((StringBuffer)serializable).append(((SeisPick)object).iyear);
                if (((SeisPick)object).imonth < 10) {
                    ((StringBuffer)serializable).append('0');
                }
                ((StringBuffer)serializable).append(((SeisPick)object).imonth);
                if (((SeisPick)object).idate < 10) {
                    ((StringBuffer)serializable).append('0');
                }
                ((StringBuffer)serializable).append(((SeisPick)object).idate);
                if (((SeisPick)object).ihour < 10) {
                    ((StringBuffer)serializable).append('0');
                }
                ((StringBuffer)serializable).append(((SeisPick)object).ihour);
                if (((SeisPick)object).imin < 10) {
                    ((StringBuffer)serializable).append('0');
                }
                ((StringBuffer)serializable).append(((SeisPick)object).imin);
                if (((SeisPick)object).sec < 10.0) {
                    ((StringBuffer)serializable).append('0');
                }
                ((StringBuffer)serializable).append(((SeisPick)object).sec);
                ((StringBuffer)serializable).append("#").append(n2);
                stringArray[n2] = ((StringBuffer)serializable).toString();
            }
            Sort.shellSort(stringArray, true);
            try {
                for (n2 = 0; n2 < stringArray.length; ++n2) {
                    int n3 = Integer.parseInt(stringArray[n2].substring(stringArray[n2].indexOf("#") + 1));
                    seisPickArray[n2] = objectArray[n3];
                }
            }
            catch (Exception exception) {
                object = "ERROR: Soritng picks: " + exception;
                System.out.println(this.getClass().getName() + ": " + (String)object);
                return;
            }
        }
        if (this.sortType != 0) {
            if (this.sortType != 2) {
                for (n2 = 0; n2 < this.size(); ++n2) {
                    this.setElementAt(seisPickArray[n2], n2);
                }
                return;
            }
        }
        Vector<SeisPick> vector = new Vector<SeisPick>();
        vector.setSize(this.size());
        for (n = 0; n < this.size(); ++n) {
            vector.setElementAt(seisPickArray[n], n);
        }
        n = 0;
        while (vector.size() > 0) {
            serializable = (SeisPick)vector.elementAt(0);
            String string = ((SeisPick)serializable).staName;
            this.setElementAt(serializable, n++);
            vector.removeElementAt(0);
            int n4 = 0;
            while (n4 < vector.size()) {
                serializable = (SeisPick)vector.elementAt(n4);
                if (((SeisPick)serializable).staName.equals(string)) {
                    this.setElementAt(serializable, n++);
                    vector.removeElementAt(n4);
                    continue;
                }
                ++n4;
            }
        }
    }
}

