/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.seisgram2k;

import java.awt.Component;
import java.text.NumberFormat;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import net.alomax.geog.Position;
import net.alomax.seis.BasicHypocenter;
import net.alomax.seisgram2k.GatherPanel;
import net.alomax.seisgram2k.SeisGram2KFrame;
import net.alomax.seisgram2k.SeisGramText;
import net.alomax.seisgram2k.Seismogram;
import net.alomax.swing.FormattedTextFieldsEditor;
import net.alomax.swing.SwingExt;
import net.alomax.util.TimeInstant;

public class SeisInfoEditor {
    protected static final int MAX_TEXT_COLS = 25;
    protected static final int MAX_DOUBLE_COLS = 12;
    protected static final String TEXT_DELIMITER = ",";
    protected static final NumberFormat NUMBER_FORMAT_FRACT_3 = NumberFormat.getNumberInstance();
    protected static final NumberFormat NUMBER_FORMAT_FRACT_6;
    protected static NumberFormat NUMBER_FORMAT_FRACT;
    protected GatherPanel gather;
    protected int nseis;
    protected JFrame parentFrame;
    protected boolean technical;
    protected FormattedTextFieldsEditor seisInfoEditor;
    protected JCheckBox checkBox_NETWORK;
    protected JCheckBox checkBox_STATION;
    protected JCheckBox checkBox_STATION_LATITUDE;
    protected JCheckBox checkBox_STATION_LONGITUDE;
    protected JCheckBox checkBox_STATION_ELEVATION;
    protected JCheckBox checkBox_STATION_DEPTH_KM;
    protected JCheckBox checkBox_INSTRUMENT;
    protected JCheckBox checkBox_CHANNEL;
    protected JCheckBox checkBox_COMPONENT;
    protected JCheckBox checkBox_COMPONENT_AZ;
    protected JCheckBox checkBox_COMPONENT_INC;
    protected JCheckBox checkBox_EVENT_NAME;
    protected JCheckBox checkBox_HYPOCENTER_LATITUDE;
    protected JCheckBox checkBox_HYPOCENTER_LONGITUDE;
    protected JCheckBox checkBox_HYPOCENTER_ORIGIN_TIME;
    protected JCheckBox checkBox_HYPOCENTER_ELEVATION;
    protected JCheckBox checkBox_HYPOCENTER_DEPTH_KM;
    protected JCheckBox checkBox_DISTANCE_KM;
    protected JCheckBox checkBox_DISTANCE_DEG;
    protected JCheckBox checkBox_AZIMUTH;
    protected JCheckBox checkBox_BACK_AZIMUTH;
    protected JCheckBox checkBox_MAGNITUDE;
    protected JCheckBox xxx;

    public SeisInfoEditor(GatherPanel gatherPanel, int n, JFrame jFrame, boolean bl) {
        NUMBER_FORMAT_FRACT_3.setMinimumFractionDigits(1);
        NUMBER_FORMAT_FRACT_3.setMaximumFractionDigits(3);
        NUMBER_FORMAT_FRACT_6.setMinimumFractionDigits(1);
        NUMBER_FORMAT_FRACT_6.setMaximumFractionDigits(6);
        this.gather = null;
        this.nseis = -1;
        this.parentFrame = null;
        this.technical = false;
        this.seisInfoEditor = null;
        this.checkBox_NETWORK = null;
        this.checkBox_STATION = null;
        this.checkBox_STATION_LATITUDE = null;
        this.checkBox_STATION_LONGITUDE = null;
        this.checkBox_STATION_ELEVATION = null;
        this.checkBox_STATION_DEPTH_KM = null;
        this.checkBox_INSTRUMENT = null;
        this.checkBox_CHANNEL = null;
        this.checkBox_COMPONENT = null;
        this.checkBox_COMPONENT_AZ = null;
        this.checkBox_COMPONENT_INC = null;
        this.checkBox_EVENT_NAME = null;
        this.checkBox_HYPOCENTER_LATITUDE = null;
        this.checkBox_HYPOCENTER_LONGITUDE = null;
        this.checkBox_HYPOCENTER_ORIGIN_TIME = null;
        this.checkBox_HYPOCENTER_ELEVATION = null;
        this.checkBox_HYPOCENTER_DEPTH_KM = null;
        this.checkBox_DISTANCE_KM = null;
        this.checkBox_DISTANCE_DEG = null;
        this.checkBox_AZIMUTH = null;
        this.checkBox_BACK_AZIMUTH = null;
        this.checkBox_MAGNITUDE = null;
        this.xxx = null;
        this.gather = gatherPanel;
        this.nseis = n;
        this.parentFrame = jFrame;
        this.technical = bl;
        if (!bl) {
            NUMBER_FORMAT_FRACT = NUMBER_FORMAT_FRACT_3;
        }
    }

    public void doEdit() {
        this.seisInfoEditor = new FormattedTextFieldsEditor(this.parentFrame, SeisGramText.HEADER_EDITOR, SeisGramText.SAVE, SeisGramText.CANCEL);
        this.intializeSeisInfoEditorFields();
        SwingExt.setProportionalSize((Component)this.seisInfoEditor, this.parentFrame, 0.8, 1.0);
        this.seisInfoEditor.show();
        if (this.seisInfoEditor.wasCancelled()) {
            return;
        }
        this.updateSeisInfoFields();
    }

    public void intializeSeisInfoEditorFields() {
        Seismogram seismogram = this.gather.getSeismogram(this.nseis);
        this.seisInfoEditor.addEntry("NETWORK", SeisGramText.NETWORK, seismogram.channel.network, 25);
        this.checkBox_NETWORK = new JCheckBox(SeisGramText.APPLY_TO_ALL_TRACES, true);
        this.seisInfoEditor.addAfter("NETWORK", this.checkBox_NETWORK);
        this.seisInfoEditor.addEntry("STATION", SeisGramText.STATION, seismogram.channel.staName, 25);
        this.checkBox_STATION = new JCheckBox(SeisGramText.APPLY_TO_ALL_TRACES, true);
        this.seisInfoEditor.addAfter("STATION", this.checkBox_STATION);
        Position position = seismogram.channel.staPosition;
        if (position == null) {
            position = new Position();
        }
        this.seisInfoEditor.addEntry("STATION_LATITUDE", SeisGramText.STATION + " " + SeisGramText.LATITUDE, new Double(position.latitude), 12, -90.0, 90.0, NUMBER_FORMAT_FRACT);
        this.checkBox_STATION_LATITUDE = new JCheckBox(SeisGramText.APPLY_TO_ALL_TRACES, true);
        this.seisInfoEditor.addAfter("STATION_LATITUDE", this.checkBox_STATION_LATITUDE);
        this.seisInfoEditor.addEntry("STATION_LONGITUDE", SeisGramText.STATION + " " + SeisGramText.LONGITUDE, new Double(position.longitude), 12, -360.0, 360.0, NUMBER_FORMAT_FRACT);
        this.checkBox_STATION_LONGITUDE = new JCheckBox(SeisGramText.APPLY_TO_ALL_TRACES, true);
        this.seisInfoEditor.addAfter("STATION_LONGITUDE", this.checkBox_STATION_LONGITUDE);
        this.seisInfoEditor.addEntry("STATION_ELEVATION", SeisGramText.STATION + " " + SeisGramText.ELEVATION_M, new Double(position.elevation * 1000.0), 12, NUMBER_FORMAT_FRACT);
        this.checkBox_STATION_ELEVATION = new JCheckBox(SeisGramText.APPLY_TO_ALL_TRACES, true);
        this.seisInfoEditor.addAfter("STATION_ELEVATION", this.checkBox_STATION_ELEVATION);
        if (this.technical) {
            this.seisInfoEditor.addEntry("STATION_DEPTH_KM", SeisGramText.STATION + " " + SeisGramText.DEPTH_KM, new Double(position.depth), 12, NUMBER_FORMAT_FRACT);
            this.checkBox_STATION_DEPTH_KM = new JCheckBox(SeisGramText.APPLY_TO_ALL_TRACES, true);
            this.seisInfoEditor.addAfter("STATION_DEPTH_KM", this.checkBox_STATION_DEPTH_KM);
        }
        this.seisInfoEditor.addSeparator();
        this.seisInfoEditor.addEntry("INSTRUMENT", SeisGramText.INSTRUMENT, seismogram.channel.instName, 25);
        this.checkBox_INSTRUMENT = new JCheckBox(SeisGramText.APPLY_TO_ALL_TRACES, true);
        this.seisInfoEditor.addAfter("INSTRUMENT", this.checkBox_INSTRUMENT);
        this.seisInfoEditor.addEntry("CHANNEL", SeisGramText.CHANNEL, seismogram.channel.chanName, 25);
        this.checkBox_CHANNEL = new JCheckBox(SeisGramText.APPLY_TO_ALL_TRACES, false);
        this.seisInfoEditor.addAfter("CHANNEL", this.checkBox_CHANNEL);
        this.seisInfoEditor.addEntry("COMPONENT", SeisGramText.COMPONENT, seismogram.channel.compName, 25);
        this.checkBox_COMPONENT = new JCheckBox(SeisGramText.APPLY_TO_ALL_TRACES, false);
        this.seisInfoEditor.addAfter("COMPONENT", this.checkBox_COMPONENT);
        this.seisInfoEditor.addEntry("COMPONENT_AZ", SeisGramText.COMPONENT_AZ, new Double(seismogram.channel.azimuth), 12, NUMBER_FORMAT_FRACT);
        this.checkBox_COMPONENT_AZ = new JCheckBox(SeisGramText.APPLY_TO_ALL_TRACES, false);
        this.seisInfoEditor.addAfter("COMPONENT_AZ", this.checkBox_COMPONENT_AZ);
        this.seisInfoEditor.addEntry("COMPONENT_INC", SeisGramText.COMPONENT_INC, new Double(seismogram.channel.inclination), 12, NUMBER_FORMAT_FRACT);
        this.checkBox_COMPONENT_INC = new JCheckBox(SeisGramText.APPLY_TO_ALL_TRACES, false);
        this.seisInfoEditor.addAfter("COMPONENT_INC", this.checkBox_COMPONENT_INC);
        this.seisInfoEditor.addSeparator();
        this.seisInfoEditor.addEntry("EVENT_NAME", SeisGramText.EVENT_NAME, seismogram.evtName, 25);
        this.checkBox_EVENT_NAME = new JCheckBox(SeisGramText.APPLY_TO_ALL_TRACES, true);
        this.seisInfoEditor.addAfter("EVENT_NAME", this.checkBox_EVENT_NAME);
        BasicHypocenter basicHypocenter = seismogram.hypocenter;
        if (basicHypocenter == null) {
            basicHypocenter = new BasicHypocenter();
        }
        this.seisInfoEditor.addEntry("HYPOCENTER_ORIGIN_TIME", SeisGramText.EVENT + " " + SeisGramText.ORIGIN_TIME, basicHypocenter.otime.toDelimitedString(TEXT_DELIMITER, NUMBER_FORMAT_FRACT), 25);
        this.checkBox_HYPOCENTER_ORIGIN_TIME = new JCheckBox(SeisGramText.APPLY_TO_ALL_TRACES, true);
        this.seisInfoEditor.addAfter("HYPOCENTER_ORIGIN_TIME", this.checkBox_HYPOCENTER_ORIGIN_TIME);
        this.seisInfoEditor.addEntry("HYPOCENTER_LATITUDE", SeisGramText.EVENT + " " + SeisGramText.LATITUDE, new Double(basicHypocenter.position.latitude), 12, -90.0, 90.0, NUMBER_FORMAT_FRACT);
        this.checkBox_HYPOCENTER_LATITUDE = new JCheckBox(SeisGramText.APPLY_TO_ALL_TRACES, true);
        this.seisInfoEditor.addAfter("HYPOCENTER_LATITUDE", this.checkBox_HYPOCENTER_LATITUDE);
        this.seisInfoEditor.addEntry("HYPOCENTER_LONGITUDE", SeisGramText.EVENT + " " + SeisGramText.LONGITUDE, new Double(basicHypocenter.position.longitude), 12, -360.0, 360.0, NUMBER_FORMAT_FRACT);
        this.checkBox_HYPOCENTER_LONGITUDE = new JCheckBox(SeisGramText.APPLY_TO_ALL_TRACES, true);
        this.seisInfoEditor.addAfter("HYPOCENTER_LONGITUDE", this.checkBox_HYPOCENTER_LONGITUDE);
        if (this.technical) {
            this.seisInfoEditor.addEntry("HYPOCENTER_ELEVATION", SeisGramText.EVENT + " " + SeisGramText.ELEVATION_M, new Double(basicHypocenter.position.elevation * 1000.0), 12, NUMBER_FORMAT_FRACT);
            this.checkBox_HYPOCENTER_ELEVATION = new JCheckBox(SeisGramText.APPLY_TO_ALL_TRACES, true);
            this.seisInfoEditor.addAfter("HYPOCENTER_ELEVATION", this.checkBox_HYPOCENTER_ELEVATION);
        }
        this.seisInfoEditor.addEntry("HYPOCENTER_DEPTH_KM", SeisGramText.EVENT + " " + SeisGramText.DEPTH_KM, new Double(basicHypocenter.position.depth), 12, NUMBER_FORMAT_FRACT);
        this.checkBox_HYPOCENTER_DEPTH_KM = new JCheckBox(SeisGramText.APPLY_TO_ALL_TRACES, true);
        this.seisInfoEditor.addAfter("HYPOCENTER_DEPTH_KM", this.checkBox_HYPOCENTER_DEPTH_KM);
        this.seisInfoEditor.addEntry("DISTANCE_KM", SeisGramText.DISTANCE_KM, new Double(seismogram.dist), 12, 0.0, Double.MAX_VALUE, NUMBER_FORMAT_FRACT);
        this.checkBox_DISTANCE_KM = new JCheckBox(SeisGramText.APPLY_TO_ALL_TRACES, true);
        this.seisInfoEditor.addAfter("DISTANCE_KM", this.checkBox_DISTANCE_KM);
        this.seisInfoEditor.addEntry("DISTANCE_DEG", SeisGramText.DISTANCE_DEG, new Double(seismogram.gcarc), 12, 0.0, Double.MAX_VALUE, NUMBER_FORMAT_FRACT);
        this.checkBox_DISTANCE_DEG = new JCheckBox(SeisGramText.APPLY_TO_ALL_TRACES, true);
        this.seisInfoEditor.addAfter("DISTANCE_DEG", this.checkBox_DISTANCE_DEG);
        this.seisInfoEditor.addEntry("AZIMUTH", SeisGramText.AZIMUTH, new Double(seismogram.az), 12, -360.0, 360.0, NUMBER_FORMAT_FRACT);
        this.checkBox_AZIMUTH = new JCheckBox(SeisGramText.APPLY_TO_ALL_TRACES, true);
        this.seisInfoEditor.addAfter("AZIMUTH", this.checkBox_AZIMUTH);
        this.seisInfoEditor.addEntry("BACK_AZIMUTH", SeisGramText.BACK_AZIMUTH, new Double(seismogram.baz), 12, -360.0, 360.0, NUMBER_FORMAT_FRACT);
        this.checkBox_BACK_AZIMUTH = new JCheckBox(SeisGramText.APPLY_TO_ALL_TRACES, true);
        this.seisInfoEditor.addAfter("BACK_AZIMUTH", this.checkBox_BACK_AZIMUTH);
        this.seisInfoEditor.addEntry("MAGNITUDE", SeisGramText.MAGNITUDE, new Double(seismogram.hypocenter.mag), 12, -10.0, 10.0, NUMBER_FORMAT_FRACT);
        this.checkBox_MAGNITUDE = new JCheckBox(SeisGramText.APPLY_TO_ALL_TRACES, true);
        this.seisInfoEditor.addAfter("MAGNITUDE", this.checkBox_MAGNITUDE);
    }

    public void updateSeisInfoFields() {
        Seismogram[] seismogramArray;
        block143: {
            int n;
            block142: {
                block141: {
                    block140: {
                        block139: {
                            block138: {
                                block137: {
                                    block136: {
                                        block135: {
                                            block134: {
                                                int n2;
                                                block133: {
                                                    block132: {
                                                        String string;
                                                        block129: {
                                                            block128: {
                                                                block127: {
                                                                    block126: {
                                                                        block125: {
                                                                            block124: {
                                                                                block123: {
                                                                                    String string2;
                                                                                    block122: {
                                                                                        Seismogram seismogram = this.gather.getSeismogram(this.nseis);
                                                                                        seismogramArray = this.gather.getSeismograms();
                                                                                        try {
                                                                                            string2 = (String)this.seisInfoEditor.getValue("NETWORK");
                                                                                            if (string2 != null) {
                                                                                                if (this.checkBox_NETWORK.isSelected()) {
                                                                                                    for (n2 = 0; n2 < seismogramArray.length; ++n2) {
                                                                                                        seismogramArray[n2].channel.network = new String(string2);
                                                                                                    }
                                                                                                } else {
                                                                                                    seismogram.channel.network = new String(string2);
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                        catch (Exception exception) {
                                                                                            if (!SeisGram2KFrame.PRINT_STACK_TRACES) break block122;
                                                                                            exception.printStackTrace();
                                                                                        }
                                                                                    }
                                                                                    try {
                                                                                        string2 = (String)this.seisInfoEditor.getValue("STATION");
                                                                                        if (string2 != null) {
                                                                                            if (this.checkBox_STATION.isSelected()) {
                                                                                                for (n2 = 0; n2 < seismogramArray.length; ++n2) {
                                                                                                    seismogramArray[n2].channel.staName = new String(string2);
                                                                                                }
                                                                                            } else {
                                                                                                seismogram.channel.staName = new String(string2);
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                    catch (Exception exception) {
                                                                                        if (!SeisGram2KFrame.PRINT_STACK_TRACES) break block123;
                                                                                        exception.printStackTrace();
                                                                                    }
                                                                                }
                                                                                for (int i = 0; i < seismogramArray.length; ++i) {
                                                                                    if (seismogramArray[i].channel.staPosition != null) continue;
                                                                                    seismogramArray[i].channel.staPosition = new Position();
                                                                                }
                                                                                try {
                                                                                    double d = ((Number)this.seisInfoEditor.getValue("STATION_LATITUDE")).doubleValue();
                                                                                    if (this.checkBox_STATION_LATITUDE.isSelected()) {
                                                                                        for (n = 0; n < seismogramArray.length; ++n) {
                                                                                            seismogramArray[n].channel.staPosition.latitude = d;
                                                                                        }
                                                                                    } else {
                                                                                        seismogram.channel.staPosition.latitude = d;
                                                                                    }
                                                                                }
                                                                                catch (Exception exception) {
                                                                                    if (!SeisGram2KFrame.PRINT_STACK_TRACES) break block124;
                                                                                    exception.printStackTrace();
                                                                                }
                                                                            }
                                                                            try {
                                                                                double d = ((Number)this.seisInfoEditor.getValue("STATION_LONGITUDE")).doubleValue();
                                                                                if (this.checkBox_STATION_LONGITUDE.isSelected()) {
                                                                                    for (n = 0; n < seismogramArray.length; ++n) {
                                                                                        seismogramArray[n].channel.staPosition.longitude = d;
                                                                                    }
                                                                                } else {
                                                                                    seismogram.channel.staPosition.longitude = d;
                                                                                }
                                                                            }
                                                                            catch (Exception exception) {
                                                                                if (!SeisGram2KFrame.PRINT_STACK_TRACES) break block125;
                                                                                exception.printStackTrace();
                                                                            }
                                                                        }
                                                                        try {
                                                                            double d = ((Number)this.seisInfoEditor.getValue("STATION_ELEVATION")).doubleValue();
                                                                            d /= 1000.0;
                                                                            if (this.checkBox_STATION_ELEVATION.isSelected()) {
                                                                                for (n = 0; n < seismogramArray.length; ++n) {
                                                                                    seismogramArray[n].channel.staPosition.elevation = d;
                                                                                }
                                                                            } else {
                                                                                seismogram.channel.staPosition.elevation = d;
                                                                            }
                                                                        }
                                                                        catch (Exception exception) {
                                                                            if (!SeisGram2KFrame.PRINT_STACK_TRACES) break block126;
                                                                            exception.printStackTrace();
                                                                        }
                                                                    }
                                                                    if (this.technical) {
                                                                        try {
                                                                            double d = ((Number)this.seisInfoEditor.getValue("STATION_DEPTH_KM")).doubleValue();
                                                                            if (this.checkBox_STATION_DEPTH_KM.isSelected()) {
                                                                                for (n = 0; n < seismogramArray.length; ++n) {
                                                                                    seismogramArray[n].channel.staPosition.depth = d;
                                                                                }
                                                                            } else {
                                                                                seismogram.channel.staPosition.depth = d;
                                                                            }
                                                                        }
                                                                        catch (Exception exception) {
                                                                            if (!SeisGram2KFrame.PRINT_STACK_TRACES) break block127;
                                                                            exception.printStackTrace();
                                                                        }
                                                                    }
                                                                }
                                                                try {
                                                                    string = (String)this.seisInfoEditor.getValue("INSTRUMENT");
                                                                    if (string != null) {
                                                                        if (this.checkBox_INSTRUMENT.isSelected()) {
                                                                            for (n2 = 0; n2 < seismogramArray.length; ++n2) {
                                                                                seismogramArray[n2].channel.instName = new String(string);
                                                                            }
                                                                        } else {
                                                                            seismogram.channel.instName = new String(string);
                                                                        }
                                                                    }
                                                                }
                                                                catch (Exception exception) {
                                                                    if (!SeisGram2KFrame.PRINT_STACK_TRACES) break block128;
                                                                    exception.printStackTrace();
                                                                }
                                                            }
                                                            try {
                                                                string = (String)this.seisInfoEditor.getValue("CHANNEL");
                                                                if (string != null) {
                                                                    if (this.checkBox_CHANNEL.isSelected()) {
                                                                        for (n2 = 0; n2 < seismogramArray.length; ++n2) {
                                                                            seismogramArray[n2].channel.chanName = new String(string);
                                                                        }
                                                                    } else {
                                                                        seismogram.channel.chanName = new String(string);
                                                                    }
                                                                }
                                                            }
                                                            catch (Exception exception) {
                                                                if (!SeisGram2KFrame.PRINT_STACK_TRACES) break block129;
                                                                exception.printStackTrace();
                                                            }
                                                        }
                                                        if (this.technical) {
                                                            block131: {
                                                                block130: {
                                                                    try {
                                                                        string = (String)this.seisInfoEditor.getValue("COMPONENT");
                                                                        if (string != null) {
                                                                            if (this.checkBox_COMPONENT.isSelected()) {
                                                                                for (n2 = 0; n2 < seismogramArray.length; ++n2) {
                                                                                    seismogramArray[n2].channel.compName = new String(string);
                                                                                }
                                                                            } else {
                                                                                seismogram.channel.compName = new String(string);
                                                                            }
                                                                        }
                                                                    }
                                                                    catch (Exception exception) {
                                                                        if (!SeisGram2KFrame.PRINT_STACK_TRACES) break block130;
                                                                        exception.printStackTrace();
                                                                    }
                                                                }
                                                                try {
                                                                    double d = ((Number)this.seisInfoEditor.getValue("COMPONENT_AZ")).doubleValue();
                                                                    if (this.checkBox_COMPONENT_AZ.isSelected()) {
                                                                        for (n = 0; n < seismogramArray.length; ++n) {
                                                                            seismogramArray[n].channel.azimuth = d;
                                                                        }
                                                                    } else {
                                                                        seismogram.channel.azimuth = d;
                                                                    }
                                                                }
                                                                catch (Exception exception) {
                                                                    if (!SeisGram2KFrame.PRINT_STACK_TRACES) break block131;
                                                                    exception.printStackTrace();
                                                                }
                                                            }
                                                            try {
                                                                double d = ((Number)this.seisInfoEditor.getValue("COMPONENT_INC")).doubleValue();
                                                                if (this.checkBox_COMPONENT_INC.isSelected()) {
                                                                    for (n = 0; n < seismogramArray.length; ++n) {
                                                                        seismogramArray[n].channel.inclination = d;
                                                                    }
                                                                } else {
                                                                    seismogram.channel.inclination = d;
                                                                }
                                                            }
                                                            catch (Exception exception) {
                                                                if (!SeisGram2KFrame.PRINT_STACK_TRACES) break block132;
                                                                exception.printStackTrace();
                                                            }
                                                        }
                                                    }
                                                    try {
                                                        String string = (String)this.seisInfoEditor.getValue("EVENT_NAME");
                                                        if (string != null) {
                                                            if (this.checkBox_EVENT_NAME.isSelected()) {
                                                                for (n2 = 0; n2 < seismogramArray.length; ++n2) {
                                                                    seismogramArray[n2].evtName = new String(string);
                                                                }
                                                            } else {
                                                                seismogram.evtName = new String(string);
                                                            }
                                                        }
                                                    }
                                                    catch (Exception exception) {
                                                        if (!SeisGram2KFrame.PRINT_STACK_TRACES) break block133;
                                                        exception.printStackTrace();
                                                    }
                                                }
                                                for (int i = 0; i < seismogramArray.length; ++i) {
                                                    if (seismogramArray[i].hypocenter != null) continue;
                                                    seismogramArray[i].hypocenter = new BasicHypocenter();
                                                }
                                                try {
                                                    String string = (String)this.seisInfoEditor.getValue("HYPOCENTER_ORIGIN_TIME");
                                                    if (string != null) {
                                                        if (this.checkBox_HYPOCENTER_ORIGIN_TIME.isSelected()) {
                                                            for (n2 = 0; n2 < seismogramArray.length; ++n2) {
                                                                seismogramArray[n2].hypocenter.otime = TimeInstant.create(string, TEXT_DELIMITER);
                                                            }
                                                        } else {
                                                            seismogram.hypocenter.otime = TimeInstant.create(string, TEXT_DELIMITER);
                                                        }
                                                    }
                                                }
                                                catch (Exception exception) {
                                                    if (!SeisGram2KFrame.PRINT_STACK_TRACES) break block134;
                                                    exception.printStackTrace();
                                                }
                                            }
                                            try {
                                                double d = ((Number)this.seisInfoEditor.getValue("HYPOCENTER_LATITUDE")).doubleValue();
                                                if (this.checkBox_HYPOCENTER_LATITUDE.isSelected()) {
                                                    for (n = 0; n < seismogramArray.length; ++n) {
                                                        seismogramArray[n].hypocenter.position.latitude = d;
                                                    }
                                                } else {
                                                    seismogram.hypocenter.position.latitude = d;
                                                }
                                            }
                                            catch (Exception exception) {
                                                if (!SeisGram2KFrame.PRINT_STACK_TRACES) break block135;
                                                exception.printStackTrace();
                                            }
                                        }
                                        try {
                                            double d = ((Number)this.seisInfoEditor.getValue("HYPOCENTER_LONGITUDE")).doubleValue();
                                            if (this.checkBox_HYPOCENTER_LONGITUDE.isSelected()) {
                                                for (n = 0; n < seismogramArray.length; ++n) {
                                                    seismogramArray[n].hypocenter.position.longitude = d;
                                                }
                                            } else {
                                                seismogram.hypocenter.position.longitude = d;
                                            }
                                        }
                                        catch (Exception exception) {
                                            if (!SeisGram2KFrame.PRINT_STACK_TRACES) break block136;
                                            exception.printStackTrace();
                                        }
                                    }
                                    try {
                                        double d = ((Number)this.seisInfoEditor.getValue("HYPOCENTER_ELEVATION")).doubleValue();
                                        d /= 1000.0;
                                        if (this.checkBox_HYPOCENTER_ELEVATION.isSelected()) {
                                            for (n = 0; n < seismogramArray.length; ++n) {
                                                seismogramArray[n].hypocenter.position.elevation = d;
                                            }
                                        } else {
                                            seismogram.hypocenter.position.elevation = d;
                                        }
                                    }
                                    catch (Exception exception) {
                                        if (!SeisGram2KFrame.PRINT_STACK_TRACES) break block137;
                                        exception.printStackTrace();
                                    }
                                }
                                try {
                                    double d = ((Number)this.seisInfoEditor.getValue("HYPOCENTER_DEPTH_KM")).doubleValue();
                                    if (this.checkBox_HYPOCENTER_DEPTH_KM.isSelected()) {
                                        for (n = 0; n < seismogramArray.length; ++n) {
                                            seismogramArray[n].hypocenter.position.depth = d;
                                        }
                                    } else {
                                        seismogram.hypocenter.position.depth = d;
                                    }
                                }
                                catch (Exception exception) {
                                    if (!SeisGram2KFrame.PRINT_STACK_TRACES) break block138;
                                    exception.printStackTrace();
                                }
                            }
                            try {
                                double d = ((Number)this.seisInfoEditor.getValue("DISTANCE_KM")).doubleValue();
                                if (this.checkBox_DISTANCE_KM.isSelected()) {
                                    for (n = 0; n < seismogramArray.length; ++n) {
                                        seismogramArray[n].dist = d;
                                    }
                                } else {
                                    seismogram.dist = d;
                                }
                            }
                            catch (Exception exception) {
                                if (!SeisGram2KFrame.PRINT_STACK_TRACES) break block139;
                                exception.printStackTrace();
                            }
                        }
                        try {
                            double d = ((Number)this.seisInfoEditor.getValue("DISTANCE_DEG")).doubleValue();
                            if (this.checkBox_DISTANCE_DEG.isSelected()) {
                                for (n = 0; n < seismogramArray.length; ++n) {
                                    seismogramArray[n].gcarc = d;
                                }
                            } else {
                                seismogram.gcarc = d;
                            }
                        }
                        catch (Exception exception) {
                            if (!SeisGram2KFrame.PRINT_STACK_TRACES) break block140;
                            exception.printStackTrace();
                        }
                    }
                    try {
                        double d = ((Number)this.seisInfoEditor.getValue("AZIMUTH")).doubleValue();
                        if (this.checkBox_AZIMUTH.isSelected()) {
                            for (n = 0; n < seismogramArray.length; ++n) {
                                seismogramArray[n].az = d;
                            }
                        } else {
                            seismogram.az = d;
                        }
                    }
                    catch (Exception exception) {
                        if (!SeisGram2KFrame.PRINT_STACK_TRACES) break block141;
                        exception.printStackTrace();
                    }
                }
                try {
                    double d = ((Number)this.seisInfoEditor.getValue("BACK_AZIMUTH")).doubleValue();
                    if (this.checkBox_BACK_AZIMUTH.isSelected()) {
                        for (n = 0; n < seismogramArray.length; ++n) {
                            seismogramArray[n].baz = d;
                        }
                    } else {
                        seismogram.baz = d;
                    }
                }
                catch (Exception exception) {
                    if (!SeisGram2KFrame.PRINT_STACK_TRACES) break block142;
                    exception.printStackTrace();
                }
            }
            try {
                double d = ((Number)this.seisInfoEditor.getValue("MAGNITUDE")).doubleValue();
                if (this.checkBox_MAGNITUDE.isSelected()) {
                    for (n = 0; n < seismogramArray.length; ++n) {
                        seismogramArray[n].hypocenter.mag = d;
                    }
                } else {
                    seismogram.hypocenter.mag = d;
                }
            }
            catch (Exception exception) {
                if (!SeisGram2KFrame.PRINT_STACK_TRACES) break block143;
                exception.printStackTrace();
            }
        }
        for (int i = 0; i < seismogramArray.length; ++i) {
            seismogramArray[i].setComponent();
            seismogramArray[i].updateStaInstID();
        }
    }

    static {
        NUMBER_FORMAT_FRACT = NUMBER_FORMAT_FRACT_6 = NumberFormat.getNumberInstance();
    }
}

