/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.seisgram2k;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.Point2D;
import net.alomax.graphics2d.JGraphPanel;
import net.alomax.seisgram2k.GatherPanel;
import net.alomax.seisgram2k.SeisGram2KFrame;
import net.alomax.seisgram2k.SeisPick;
import net.alomax.util.NumberFormat;

public class SeisPanel
extends JGraphPanel
implements MouseListener,
MouseMotionListener,
MouseWheelListener {
    protected SeisGram2KFrame seisFrame;
    public GatherPanel gather = null;
    public int prevx;
    public int prevy;
    public boolean pickCursor = false;
    protected int prevxDraw;
    protected int prevAmpy;
    protected int mouseDownx;
    protected int mouseDowny;
    protected int ixZoom;
    protected double timeZoom;
    protected boolean inTimeZoom = false;
    protected boolean inZoom = false;
    protected int ix0;
    protected int ix1;
    protected int iy0;
    protected int iy1;
    public int ixMin;
    public int ixMax;
    public int iyMin;
    public int iyMax;
    protected Color zoomColor = Color.green;
    protected Color pickColor = SeisPick.DEFAULT_PICK_COLOR;

    SeisPanel(SeisGram2KFrame seisGram2KFrame, GatherPanel gatherPanel) {
        this.seisFrame = seisGram2KFrame;
        this.gather = gatherPanel;
        super.setDisplayCursorPosition(true);
        this.enableEvents(48L);
        this.addKeyListener(this.seisFrame);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addMouseWheelListener(this);
        this.setRequestFocusEnabled(true);
    }

    SeisPanel(SeisGram2KFrame seisGram2KFrame) {
        this(seisGram2KFrame, null);
    }

    public void setGather(GatherPanel gatherPanel) {
        this.gather = gatherPanel;
    }

    public void setLimits(int n, int n2, int n3, int n4) {
        this.ixMin = n;
        this.ixMax = n2;
        this.iyMin = n3;
        this.iyMax = n4;
    }

    public boolean locInTraceWin(int n, int n2) {
        return n > this.ixMin && n < this.ixMax && n2 > this.iyMin && n2 < this.iyMax;
    }

    public void setCursor(Cursor cursor) {
        super.setCursor(cursor);
    }

    public void paint(Graphics graphics) {
        this.gather.setKillPainting();
        this.gather.paint(graphics, this.getSize(), false, false, false);
        if (this.inTimeZoom) {
            this.drawCursorVertical(graphics, this.zoomColor, this.gather.timeToIx(this.timeZoom));
        }
    }

    public void drawCursorVertical(Graphics graphics, Color color, int n) {
        graphics.setColor(Color.black);
        graphics.setXORMode(color);
        graphics.drawLine(n, this.iyMin, n, this.iyMax);
    }

    public void drawCursorVertical(Color color, int n) {
        Graphics graphics = this.getGraphics();
        this.drawCursorVertical(graphics, color, n);
        graphics.dispose();
    }

    protected boolean checkActiveSeismogram(int n) {
        if (!this.seisFrame.toolManagerIsActive()) {
            return false;
        }
        return this.gather.selectSeisAtLoc(n);
    }

    public boolean mousePressedDisplay(int n, int n2) {
        this.mouseDownx = this.prevx = n;
        this.mouseDowny = this.prevy = n2;
        return true;
    }

    public boolean mouseDraggedDisplay(int n, int n2) {
        if (this.mouseDownx < 0) {
            return true;
        }
        if (this.inTimeZoom) {
            this.drawCursorVertical(this.zoomColor, this.gather.timeToIx(this.timeZoom));
            this.inTimeZoom = false;
        }
        if (n != this.mouseDownx || n2 != this.mouseDowny) {
            Graphics graphics = this.getGraphics();
            graphics.setColor(Color.black);
            graphics.setXORMode(this.zoomColor);
            if (this.inZoom) {
                graphics.drawRect(this.ix0, this.iy0, this.ix1 - this.ix0, this.iy1 - this.iy0);
            }
            if (this.mouseDownx < n) {
                this.ix0 = this.mouseDownx;
                this.ix1 = n;
            } else {
                this.ix0 = n;
                this.ix1 = this.mouseDownx;
            }
            if (this.mouseDowny < n2) {
                this.iy0 = this.mouseDowny;
                this.iy1 = n2;
            } else {
                this.iy0 = n2;
                this.iy1 = this.mouseDowny;
            }
            graphics.drawRect(this.ix0, this.iy0, this.ix1 - this.ix0, this.iy1 - this.iy0);
            graphics.dispose();
            this.inZoom = true;
            this.inTimeZoom = false;
        }
        this.prevx = n;
        this.prevy = n2;
        return true;
    }

    public boolean mouseReleasedDisplay(int n, int n2) {
        if (this.mouseDownx < 0) {
            return true;
        }
        if (this.inZoom) {
            this.inZoom = false;
            if (this.mouseDownx == n || this.mouseDowny == n2) {
                Graphics graphics = this.getGraphics();
                graphics.setColor(Color.black);
                graphics.setXORMode(this.zoomColor);
                graphics.drawRect(this.ix0, this.iy0, this.ix1 - this.ix0, this.iy1 - this.iy0);
                graphics.dispose();
            } else {
                if (this.mouseDownx < n) {
                    this.gather.setTimeRange(this.gather.ixToTime(this.mouseDownx), this.gather.ixToTime(n));
                } else {
                    this.gather.setTimeRange(this.gather.ixToTime(n), this.gather.ixToTime(this.mouseDownx));
                }
                if (this.gather.isOverlayed() || this.gather.getNumberSeismograms() == 1) {
                    if (this.mouseDowny < n2) {
                        this.gather.setAmpRange(this.gather.iyToAmp(n2), this.gather.iyToAmp(this.mouseDowny));
                    } else {
                        this.gather.setAmpRange(this.gather.iyToAmp(this.mouseDowny), this.gather.iyToAmp(n2));
                    }
                }
                this.seisFrame.paintGather();
                this.pickCursor = false;
            }
        } else if (!this.inTimeZoom) {
            this.ixZoom = n;
            this.inTimeZoom = true;
            this.drawCursorVertical(this.zoomColor, this.ixZoom);
            this.timeZoom = this.gather.ixToTime(this.ixZoom);
        } else if (this.inTimeZoom) {
            if (n > this.ixZoom) {
                this.gather.setTimeRange(this.timeZoom, this.gather.ixToTime(n));
            } else if (n == this.ixZoom) {
                this.gather.setTimeRange(this.gather.lastTimeMin, this.gather.lastTimeMax);
            } else if (n < this.ixZoom) {
                this.gather.setTimeRange(this.gather.initTimeMin, this.gather.initTimeMax);
            }
            this.seisFrame.paintGather();
            this.inTimeZoom = false;
        }
        return true;
    }

    public void newPickCursor(int n, int n2, int n3) {
        Graphics graphics = this.getGraphics();
        graphics.setColor(Color.black);
        graphics.setXORMode(this.pickColor);
        this.gather.displayPick(n, 0);
        this.gather.drawPickCrosshair(graphics, n, n3, true, this.ixMin, this.ixMax, this.iyMin, this.iyMax);
        graphics.dispose();
        this.pickCursor = true;
        this.prevxDraw = n;
        this.prevAmpy = n3;
    }

    public void updatePickCursor(int n, int n2, int n3, boolean bl) {
        Graphics graphics = this.getGraphics();
        graphics.setColor(Color.black);
        graphics.setXORMode(this.pickColor);
        if (bl || Math.abs(n - this.prevx) > Math.abs(n2 - this.prevy)) {
            if (this.pickCursor) {
                this.gather.drawPickCrosshair(graphics, this.prevxDraw, this.prevAmpy, true, this.ixMin, this.ixMax, this.iyMin, this.iyMax);
            }
            this.gather.displayPick(n, 0);
            this.gather.drawPickCrosshair(graphics, n, n3, true, this.ixMin, this.ixMax, this.iyMin, this.iyMax);
            this.prevxDraw = n;
            this.prevAmpy = n3;
        } else if (SeisPick.isUncGauss() && Math.abs(n - this.prevx) < Math.abs(n2 - this.prevy)) {
            if (this.pickCursor) {
                this.gather.drawPickCrosshair(graphics, this.prevxDraw, this.prevAmpy, true, this.ixMin, this.ixMax, this.iyMin, this.iyMax);
            }
            this.gather.displayPick(this.prevxDraw, n2 - this.prevy);
            this.gather.drawPickCrosshair(graphics, this.prevxDraw, this.prevAmpy, true, this.ixMin, this.ixMax, this.iyMin, this.iyMax);
        }
        graphics.dispose();
        this.pickCursor = true;
        this.prevx = n;
        this.prevy = n2;
    }

    public void removePickCursor() {
        if (this.pickCursor) {
            Graphics graphics = this.getGraphics();
            graphics.setColor(Color.black);
            graphics.setXORMode(this.pickColor);
            this.gather.drawPickCrosshair(graphics, this.prevxDraw, this.prevAmpy, true, this.ixMin, this.ixMax, this.iyMin, this.iyMax);
            graphics.dispose();
        }
        this.pickCursor = false;
    }

    public void redrawPickCursor(int n, int n2) {
        this.prevx = n;
        this.prevxDraw = n;
        this.prevAmpy = n2;
        if (this.pickCursor && n >= this.ixMin && n <= this.ixMax) {
            Graphics graphics = this.getGraphics();
            this.redrawPickCursor(graphics, n, n2);
            graphics.dispose();
        }
    }

    public void redrawPickCursor(Graphics graphics, int n, int n2) {
        this.prevx = n;
        this.prevxDraw = n;
        this.prevAmpy = n2;
        if (this.pickCursor && n >= this.ixMin && n <= this.ixMax) {
            graphics.setColor(Color.black);
            graphics.setXORMode(this.pickColor);
            this.gather.drawPickCrosshair(graphics, this.prevxDraw, n2, true, this.ixMin, this.ixMax, this.iyMin, this.iyMax);
            this.pickCursor = true;
        }
    }

    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        if (mouseWheelEvent.getScrollType() == 0) {
            int n = mouseWheelEvent.getWheelRotation();
            if (this.seisFrame.shiftKeyIsDown()) {
                n *= 3;
            }
            if (n == 0) {
                return;
            }
            double d = 1.2;
            if (n < 0) {
                n = -n;
                d = 1.0 / d;
            }
            int n2 = mouseWheelEvent.getX();
            double d2 = this.gather.ixToTime(n2);
            int n3 = 0;
            while (n3++ < n) {
                double d3 = d * (this.gather.timeMax - this.gather.timeMin);
                if (d3 < (double)1.4E-45f) {
                    d3 = 1.4E-45f;
                }
                double d4 = (this.gather.timeMax + this.gather.timeMin) / 2.0;
                d4 += (d4 - d2) * d - (d4 - d2);
                this.gather.setTimeRange(d4 - d3 / 2.0, d4 + d3 / 2.0);
            }
            GatherPanel gatherPanel = this.seisFrame.getActiveGather();
            this.seisFrame.setActiveGather(this.gather);
            this.seisFrame.paintGather();
            this.seisFrame.setActiveGather(gatherPanel);
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (n == 27 && this.inTimeZoom) {
            this.drawCursorVertical(this.zoomColor, this.gather.timeToIx(this.timeZoom));
            this.inTimeZoom = false;
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        super.mouseDragged(mouseEvent);
        if (this.seisFrame.mouseDraggedDisplay(mouseEvent)) {
            return;
        }
        if (this.mouseDraggedDisplay(mouseEvent.getX(), mouseEvent.getY())) {
            return;
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        if (this.seisFrame.mouseMovedDisplay(mouseEvent)) {
            return;
        }
        super.mouseMoved(mouseEvent);
    }

    public Point dataToScreen(double d, double d2) {
        return new Point(this.gather.timeToIx(d), this.gather.ampToIy(d2));
    }

    public String dataToString(Point2D.Double double_) {
        return this.gather.timeToString(double_.x, 0, 1, this.gather.numDecimals, true) + "  amp=" + NumberFormat.doubleString(double_.y);
    }

    public double getXMaximum() {
        return this.gather.timeMax;
    }

    public double getXMinimum() {
        return this.gather.timeMin;
    }

    public double getYMaximum() {
        return this.gather.ampMax;
    }

    public double getYMinimum() {
        return this.gather.ampMin;
    }

    public Point2D.Double screenToData(Point point) {
        return new Point2D.Double(this.gather.ixToTime(point.x), this.gather.iyToAmp(point.y));
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() != this) {
            return;
        }
        if (mouseEvent.isPopupTrigger()) {
            this.seisFrame.processPopupTrigger(this, mouseEvent.getX(), mouseEvent.getY());
        } else if (mouseEvent.getModifiers() == 0 || (mouseEvent.getModifiers() & 0x10) != 0) {
            if (this.seisFrame.getActiveGather() != this.gather) {
                this.seisFrame.getActiveGather().removePickCursor();
                this.seisFrame.getActiveGather().clearPick();
                this.gather.selectGather();
                this.mouseDownx = -1;
            }
            if (this.checkActiveSeismogram(mouseEvent.getY())) {
                this.mouseDownx = -1;
            }
            if (this.mouseDownx < 0) {
                return;
            }
            if (this.seisFrame.mousePressedDisplay(mouseEvent)) {
                return;
            }
            if (this.mousePressedDisplay(mouseEvent.getX(), mouseEvent.getY())) {
                return;
            }
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.mouseDownx < 0) {
            this.mouseDownx = 0;
            return;
        }
        if (this.seisFrame.mouseReleasedDisplay(mouseEvent)) {
            return;
        }
        if (this.mouseReleasedDisplay(mouseEvent.getX(), mouseEvent.getY())) {
            return;
        }
    }
}

