/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.seisgram2k;

import edu.sc.seis.TauP.Arrival;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.io.IOException;
import net.alomax.graphics2d.Axes;
import net.alomax.io.ASCIIOutputStream;
import net.alomax.seisgram2k.GatherPanel;
import net.alomax.seisgram2k.SeisGram2KFrame;
import net.alomax.seisgram2k.SeisGramText;
import net.alomax.seisgram2k.Seismogram;
import net.alomax.util.Date2;
import net.alomax.util.NumberFormat;
import net.alomax.util.TimeInstant;
import orfeus.srem.BasicReading;
import sdsu.io.ASCIIInputStream;

public class SeisPick
extends BasicReading {
    public static final int HYPO71 = 0;
    public static final int NON_LIN_LOC = 1;
    public static final int SAC_STD_OFFSET = 2;
    public static final int EARTHWORM = 3;
    public static final int NON_LIN_LOC_PRED = 4;
    public static final int XML_STANDARD = 1000;
    private static int fileFormat = 1;
    private static String fileFormatString = "NON_LIN_LOC";
    public static String CODA_STRING = "_CODA";
    public static final String AMP_STRING = "_AMP";
    public static final String ZERO_TO_PEAK_MAX_STRING = "0-P_max";
    public static final String PEAK_TO_PEAK_MIN_STRING = "P-P_min";
    public static final String PEAK_TO_PEAK_MAX_STRING = "P-P_max";
    public static final String PICK_CMULATIVE_STRING = "Cumul";
    public static final String PICK_PIVOT_LINE_STRING = "Pivot";
    public static final String PICK_BOX_STRING = "Box";
    public static final int UNKNOWN_SOURCE = 0;
    public static final int FILE_SOURCE = 1;
    public static final int PICK_SOURCE = 2;
    public static final int TAUP_SOURCE = 3;
    public static final int PREDICTED_PHASE_SOURCE = 4;
    protected int sourceType = 2;
    public static final Color DEFAULT_PICK_COLOR = Color.green;
    public static final Color FILE_SOURCE_COLOR = Color.lightGray;
    public static final Color PICK_SOURCE_COLOR = Color.orange;
    public static final Color PREDICTED_PHASE_SOURCE_COLOR = Color.blue;
    public static final Color HARDCOPY_COLOR = Color.darkGray;
    protected Color pickColor = PICK_SOURCE_COLOR;
    public static final int UNKNOWN_STATUS = 0;
    public static final int EXISTING_STATUS = 1;
    public static final int DELETED_STATUS = 2;
    public static final int INSERTED_STATUS = 3;
    protected int statusType = 0;
    private static boolean uncGauss = false;
    protected static int topOfCrosshair = -1;
    protected int textXmin = -1;
    protected int textXmax = -1;
    protected int textYmin = -1;
    protected int textYmax = -1;
    protected SeisGram2KFrame seisFrame;
    protected boolean isSet = false;
    protected static SeisPick lastCrosshairPick = null;
    protected static int lastCrosshairIxdraw = -1;
    protected static int lastIydrawCrosshair = -1;

    public static int setFileFormat(String string, boolean bl) {
        fileFormat = SeisPick.getFileFormatFor(string);
        uncGauss = false;
        fileFormatString = string;
        if (fileFormat != 2) {
            if (fileFormat == 1 || fileFormat == 4) {
                if (!bl) {
                    uncGauss = true;
                }
            } else if (fileFormat == 3) {
                if (!bl) {
                    uncGauss = true;
                }
            } else if (fileFormat != 0) {
                fileFormat = 1;
                fileFormatString = "NON_LIN_LOC";
                if (!bl) {
                    uncGauss = true;
                }
                return -1;
            }
        }
        if (bl) {
            CODA_STRING = SeisGramText.OTHER_PHASE;
        }
        return 0;
    }

    public static int getFileFormatFor(String string) {
        if (string.equalsIgnoreCase("SAC_STD_OFFSET")) {
            return 2;
        }
        if (string.equalsIgnoreCase("NON_LIN_LOC")) {
            return 1;
        }
        if (string.equalsIgnoreCase("NON_LIN_LOC_PRED")) {
            return 4;
        }
        if (string.equalsIgnoreCase("EARTHWORM")) {
            return 3;
        }
        if (string.equalsIgnoreCase("HYPO71")) {
            return 0;
        }
        if (string.equalsIgnoreCase("XML_STANDARD")) {
            return 1000;
        }
        return -1;
    }

    public static int getFileFormat() {
        return fileFormat;
    }

    public static String getFileFormatString() {
        return fileFormatString;
    }

    public static boolean isUncGauss() {
        return uncGauss;
    }

    public SeisPick(SeisGram2KFrame seisGram2KFrame, GatherPanel gatherPanel) {
        this.seisFrame = seisGram2KFrame;
        this.uncertainty = 0.0;
        TimeInstant timeInstant = null;
        if (gatherPanel != null) {
            timeInstant = gatherPanel.getRefTimeInstant();
        }
        if (timeInstant != null) {
            this.setDateTime(timeInstant, 0.0);
        } else {
            this.setDateTime(20000101, 0, 0.0);
        }
    }

    public SeisPick(SeisPick seisPick) {
        this(seisPick, seisPick.seisFrame);
        this.isSet = seisPick.isSet;
        this.sourceType = seisPick.sourceType;
        this.pickColor = seisPick.pickColor;
    }

    public SeisPick(BasicReading basicReading, SeisGram2KFrame seisGram2KFrame) {
        this.network = basicReading.network;
        this.staName = basicReading.staName;
        this.instName = basicReading.instName;
        this.compName = basicReading.compName;
        this.compCode = basicReading.compCode;
        this.azimuth = basicReading.azimuth;
        this.inclination = basicReading.inclination;
        this.iyear = basicReading.iyear;
        this.imonth = basicReading.imonth;
        this.idate = basicReading.idate;
        this.ihour = basicReading.ihour;
        this.imin = basicReading.imin;
        this.sec = basicReading.sec;
        this.onset = basicReading.onset;
        this.name = basicReading.name;
        this.firstMot = basicReading.firstMot;
        this.quality = basicReading.quality;
        this.uncertainty = basicReading.uncertainty;
        this.amplitude = basicReading.amplitude;
        this.seisFrame = seisGram2KFrame;
    }

    public SeisPick(SeisGram2KFrame seisGram2KFrame, GatherPanel gatherPanel, Arrival arrival, double d) {
        this.seisFrame = seisGram2KFrame;
        this.setStaInst(gatherPanel, 0);
        this.setDateTime(gatherPanel.getRefTimeInstant(), arrival.getTime() + d);
        this.name = arrival.getName();
        this.uncertainty = 0.0;
        String string = this.name.toUpperCase();
        this.pickColor = string.lastIndexOf("P") > string.lastIndexOf("S") ? Color.green : Color.red;
        this.sourceType = 3;
    }

    public void init() {
        this.onset = "?";
        this.name = "?";
        this.firstMot = "?";
        this.quality = Integer.MAX_VALUE;
        this.uncertainty = 0.0;
        this.amplitude = Double.MAX_VALUE;
        boolean bl = false;
    }

    protected void setSource(int n) {
        this.sourceType = n;
        if (this.sourceType == 2) {
            this.pickColor = PICK_SOURCE_COLOR;
        } else if (this.sourceType == 1) {
            this.pickColor = FILE_SOURCE_COLOR;
        } else if (this.sourceType == 4) {
            this.pickColor = PREDICTED_PHASE_SOURCE_COLOR;
        }
    }

    public int getSource() {
        return this.sourceType;
    }

    protected void setStatus(int n) {
        this.statusType = n;
    }

    public int getStatus() {
        return this.statusType;
    }

    public void setColor(Color color) {
        this.pickColor = color;
    }

    public boolean isSameAs(SeisPick seisPick) {
        return this.isSameAs(seisPick, -1.0);
    }

    public boolean isSameAs(SeisPick seisPick, double d) {
        if (d < 0.0) {
            d = Math.pow(10.0, -(this.seisFrame != null ? this.seisFrame.numDecimals : 4));
        }
        return this.compareTo(seisPick, d) == 0 && this.compareIDFieldsTo(seisPick, d) == 0;
    }

    public int compareTo(SeisPick seisPick, double d) {
        int n = this.compareFields(this.iyear, seisPick.iyear);
        if (n != 0) {
            return n;
        }
        n = this.compareFields(this.imonth, seisPick.imonth);
        if (n != 0) {
            return n;
        }
        n = this.compareFields(this.idate, seisPick.idate);
        if (n != 0) {
            return n;
        }
        n = this.compareFields(this.ihour, seisPick.ihour);
        if (n != 0) {
            return n;
        }
        n = this.compareFields(this.imin, seisPick.imin);
        if (n != 0) {
            return n;
        }
        n = this.compareFields(this.sec, seisPick.sec, d);
        if (n != 0) {
            return n;
        }
        return 0;
    }

    public int compareIDFieldsTo(SeisPick seisPick, double d) {
        int n = this.compareFields(this.network, seisPick.network);
        if (n != 0) {
            return n;
        }
        n = this.compareFields(this.staName, seisPick.staName);
        if (n != 0) {
            return n;
        }
        n = this.compareFields(this.instName, seisPick.instName);
        if (n != 0) {
            return n;
        }
        n = this.compareFields(this.compName, seisPick.compName);
        if (n != 0) {
            return n;
        }
        n = this.compareFields(this.compCode, seisPick.compCode);
        if (n != 0) {
            return n;
        }
        n = this.compareFields(this.azimuth, seisPick.azimuth, d);
        if (n != 0) {
            return n;
        }
        n = this.compareFields(this.inclination, seisPick.inclination, d);
        if (n != 0) {
            return n;
        }
        n = this.compareFields(this.onset, seisPick.onset);
        if (n != 0) {
            return n;
        }
        n = this.compareFields(this.name, seisPick.name);
        if (n != 0) {
            return n;
        }
        n = this.compareFields(this.firstMot, seisPick.firstMot);
        if (n != 0) {
            return n;
        }
        n = this.compareFields(this.quality, seisPick.quality);
        if (n != 0) {
            return n;
        }
        n = this.compareFields(this.uncertainty, seisPick.uncertainty, d);
        if (n != 0) {
            return n;
        }
        n = this.compareFields(this.amplitude, seisPick.amplitude, d);
        if (n != 0) {
            return n;
        }
        return 0;
    }

    public int compareFields(String string, String string2) {
        if (string.compareTo("?") == 0 || string2.compareTo("?") == 0) {
            return 0;
        }
        return string.compareTo(string2);
    }

    public int compareFields(int n, int n2) {
        if (n == Integer.MAX_VALUE || n2 == Integer.MAX_VALUE) {
            return 0;
        }
        if (n - n2 > 0) {
            return 1;
        }
        if (n - n2 < 0) {
            return -1;
        }
        return 0;
    }

    public int compareFields(double d, double d2, double d3) {
        if (d == Double.MAX_VALUE || d2 == Double.MAX_VALUE) {
            return 0;
        }
        if (d - d2 > d3) {
            return 1;
        }
        if (d - d2 < -d3) {
            return -1;
        }
        return 0;
    }

    public void setStaInst(GatherPanel gatherPanel, int n) {
        this.network = gatherPanel.seismograms[n].channel.network.trim().length() == 0 ? "?" : gatherPanel.seismograms[n].channel.network.trim();
        this.staName = gatherPanel.seismograms[n].channel.staName.trim().length() == 0 ? "?" : gatherPanel.seismograms[n].channel.staName.trim();
        this.instName = gatherPanel.seismograms[n].channel.instName.trim().length() == 0 ? "?" : gatherPanel.seismograms[n].channel.instName.trim();
        this.compName = gatherPanel.seismograms[n].channel.compName.trim().length() == 0 ? "?" : gatherPanel.seismograms[n].channel.compName.trim();
        this.compCode = gatherPanel.seismograms[n].compCode.trim().length() == 0 ? "?" : gatherPanel.seismograms[n].compCode.trim();
        this.azimuth = gatherPanel.seismograms[n].channel.azimuth;
        this.inclination = gatherPanel.seismograms[n].channel.inclination;
    }

    public void setAmplitude(GatherPanel gatherPanel, int n) {
        double d;
        Seismogram seismogram = gatherPanel.getSeismogram(n);
        if (seismogram == null) {
            return;
        }
        double d2 = this.dateTimeToTime(gatherPanel);
        this.amplitude = d = seismogram.ampAtTime(d2);
    }

    public void setUncertainty(double d) {
        this.uncertainty = d;
    }

    public void setUncertaintyType(String string) {
        this.uncertaintyType = string;
    }

    public String getTimeStringSeparated(String string, String string2, String string3) {
        TimeInstant timeInstant = new TimeInstant(this.iyear, this.imonth, this.idate, this.ihour, this.imin, this.sec);
        return timeInstant.toStringSeparated(string, string2, string3, this.seisFrame.numDecimals);
    }

    public String getTimeString() {
        TimeInstant timeInstant = new TimeInstant(this.iyear, this.imonth, this.idate, this.ihour, this.imin, this.sec);
        return timeInstant.toString(3, this.seisFrame != null ? (this.seisFrame != null ? this.seisFrame.numDecimals : 4) : 4, false);
    }

    public String getTimeStringSchool() {
        TimeInstant timeInstant = new TimeInstant(this.iyear, this.imonth, this.idate, this.ihour, this.imin, this.sec);
        return timeInstant.toStringInvert(0, this.seisFrame != null ? this.seisFrame.numDecimals : 4, true);
    }

    public String toStringSchool(String string) {
        String string2 = this.name + " = " + " " + this.getTimeStringSchool();
        if (this.amplitude != Double.MAX_VALUE) {
            string2 = string2 + "  " + string + ": " + NumberFormat.doubleString(this.amplitude, 0, 3, false);
        }
        return string2;
    }

    public String toStringPhaseTime() {
        return this.onset + " " + this.name + " " + this.firstMot + " " + (this.quality == Integer.MAX_VALUE ? "?" : String.valueOf(this.quality)) + " " + this.getTimeString();
    }

    public String toStringPhaseTimeTrim() {
        String string = this.toStringPhaseTime();
        return string.trim();
    }

    public String toStringDisplay(String string, int n) {
        String string2 = this.toStringPhaseTimeTrim();
        if (uncGauss && this.uncertainty != Double.MAX_VALUE) {
            string2 = string2 + " +/- " + NumberFormat.doubleString(this.uncertainty, 0, n, false) + "s";
        }
        if (this.duration != Double.MAX_VALUE) {
            string2 = string2 + "  D: " + NumberFormat.doubleString(this.duration, 0, 5, false) + "s";
        }
        if (this.amplitude != Double.MAX_VALUE) {
            string2 = string2 + "  " + string + ": " + NumberFormat.doubleString(this.amplitude, 0, 5, false);
        }
        if (this.period != Double.MAX_VALUE) {
            string2 = string2 + "  T: " + NumberFormat.doubleString(this.period, 0, 5, false) + "s";
        }
        return string2;
    }

    public String toStringDisplayFull(String string, int n) {
        String string2 = "";
        string2 = string2 + this.staName + " " + this.compName + " " + this.network + " " + this.instName + " " + this.compCode + " ";
        string2 = string2 + this.toStringDisplay(string, n);
        return string2;
    }

    public boolean textIsUnder(int n, int n2) {
        return n >= this.textXmin && n <= this.textXmax && n2 >= this.textYmin && n2 <= this.textYmax;
    }

    public void paint(Graphics graphics, GatherPanel gatherPanel, int n, boolean bl, boolean bl2) {
        this.paint(graphics, gatherPanel, n, bl, bl, bl2);
    }

    public void paint(Graphics graphics, GatherPanel gatherPanel, int n, boolean bl, boolean bl2, boolean bl3) {
        Color color = this.pickColor;
        if (bl3) {
            color = HARDCOPY_COLOR;
        }
        this.paintText(graphics, gatherPanel, color, bl, 0);
        this.paintLines(graphics, gatherPanel, color, n, bl2);
    }

    public void paintText(Graphics graphics, GatherPanel gatherPanel, Color color, boolean bl, int n) {
        this.paintText(graphics, gatherPanel, color, null, bl, n);
    }

    public void paintText(Graphics graphics, GatherPanel gatherPanel, Color color, Color color2, boolean bl, int n) {
        int n2;
        int n3 = gatherPanel.timeToIx(this.dateTimeToTime(gatherPanel));
        Rectangle rectangle = gatherPanel.getPlotRectangle();
        int n4 = rectangle.x;
        int n5 = rectangle.x + rectangle.width;
        int n6 = rectangle.y;
        int n7 = rectangle.y + rectangle.height;
        if (n3 < n4 || n3 > n5) {
            return;
        }
        if (bl) {
            graphics.setXORMode(Color.black);
        } else {
            graphics.setPaintMode();
        }
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n8 = fontMetrics.getMaxAscent();
        topOfCrosshair = n6 + Axes.getTickLength(n6, n7) + n8 + 2 + n;
        if (this.sourceType == 3 || this.sourceType == 4) {
            topOfCrosshair += n8;
        }
        String string = "";
        if (this.onset.compareTo("?") != 0) {
            string = string + this.onset + " ";
        }
        if (this.name.compareTo("?") != 0) {
            string = string + this.name + " ";
        }
        if (this.firstMot.compareTo("?") != 0) {
            string = string + this.firstMot + " ";
        }
        if (this.quality != Integer.MAX_VALUE) {
            string = string + String.valueOf(this.quality) + " ";
        }
        if ((n2 = fontMetrics.stringWidth(string)) < 1) {
            n2 = fontMetrics.stringWidth(" ");
        }
        int n9 = fontMetrics.getHeight();
        if (color2 != null) {
            graphics.setColor(color2);
            graphics.fillRect(n3, topOfCrosshair - n9 + fontMetrics.getMaxDescent(), n2, n9);
        }
        if (color == null) {
            color = this.pickColor;
        }
        color = gatherPanel.requestColor(color, false);
        graphics.setColor(color);
        graphics.drawString(string, n3, topOfCrosshair);
        if (gatherPanel == this.seisFrame.getActiveGather()) {
            this.textXmin = n3;
            this.textXmax = n3 + n2;
            this.textYmin = topOfCrosshair - n9 + fontMetrics.getMaxDescent();
            this.textYmax = topOfCrosshair + fontMetrics.getMaxDescent();
        }
        graphics.setPaintMode();
        topOfCrosshair += fontMetrics.getMaxDescent() + 1;
    }

    public void paintLines(Graphics graphics, GatherPanel gatherPanel, Color color, int n, boolean bl) {
        int n2 = gatherPanel.timeToIx(this.dateTimeToTime(gatherPanel));
        Rectangle rectangle = gatherPanel.getPlotRectangle();
        int n3 = rectangle.x;
        int n4 = rectangle.x + rectangle.width;
        int n5 = rectangle.y;
        int n6 = rectangle.y + rectangle.height;
        if (n2 < n3 || n2 > n4) {
            return;
        }
        Color color2 = gatherPanel.requestColor(color != null ? color : this.pickColor, false);
        graphics.setColor(color2);
        if (bl) {
            graphics.setXORMode(color2.equals(Color.BLACK) ? Color.WHITE : Color.BLACK);
        } else {
            graphics.setPaintMode();
        }
        int n7 = gatherPanel.timeToIy(gatherPanel.ixToTime(n2), n);
        this.drawPickCrosshair(graphics, gatherPanel, n2, n7, false, n3, n4, topOfCrosshair, n6);
        graphics.setPaintMode();
    }

    public void drawPickCrosshair(Graphics graphics, GatherPanel gatherPanel, int n, int n2, boolean bl, int n3, int n4, int n5, int n6) {
        int n7 = n;
        if (lastCrosshairPick != null && lastCrosshairPick != this && n == lastCrosshairIxdraw) {
            n7 = n < n4 ? ++n7 : --n7;
        }
        graphics.drawLine(n7, n5, n7, n6);
        lastCrosshairIxdraw = n;
        lastCrosshairPick = this;
        if (bl && n2 >= n5 && n2 <= n6) {
            graphics.drawLine(n3, n2, n4, n2);
        }
        if (SeisPick.isUncGauss()) {
            this.drawUncertainty(graphics, gatherPanel, n, n2);
        }
    }

    public void drawUncertainty(Graphics graphics, GatherPanel gatherPanel, int n, int n2) {
        double d = this.uncertainty == Double.MAX_VALUE ? 0.0 : this.uncertainty;
        Rectangle rectangle = gatherPanel.getPlotRectangle();
        int n3 = rectangle.height / 25;
        double d2 = this.dateTimeToTime(gatherPanel);
        int n4 = gatherPanel.timeToIx(d2 - d);
        int n5 = gatherPanel.timeToIx(d2 + d);
        graphics.drawLine(n4, n2 + n3, n4, n2 - n3);
        graphics.drawLine(n4, n2, n5, n2);
        graphics.drawLine(n5, n2 + n3, n5, n2 - n3);
    }

    public void write(ASCIIOutputStream aSCIIOutputStream) {
        this.write(aSCIIOutputStream, null, System.getProperty("line.separator"));
    }

    public void write(ASCIIOutputStream aSCIIOutputStream, String string, String string2) {
        if (string != null) {
            aSCIIOutputStream.writeWord(string);
        }
        if (fileFormat == 1) {
            this.writeNLLoc(aSCIIOutputStream, fileFormat);
        } else if (fileFormat == 3) {
            this.writeNLLoc(aSCIIOutputStream, fileFormat);
        } else {
            this.writeNLLoc(aSCIIOutputStream, fileFormat);
        }
        if (string2 != null) {
            aSCIIOutputStream.writeWord(string2);
        }
    }

    public void writeNLLoc(ASCIIOutputStream aSCIIOutputStream, int n) {
        aSCIIOutputStream.writeWord(this.staName);
        aSCIIOutputStream.writeWord(" ");
        if (n == 3) {
            aSCIIOutputStream.writeWord(this.compName);
            aSCIIOutputStream.writeWord(" ");
            aSCIIOutputStream.writeWord(this.network);
            aSCIIOutputStream.writeWord(" ");
        }
        aSCIIOutputStream.writeWord(this.instName);
        aSCIIOutputStream.writeWord(" ");
        aSCIIOutputStream.writeWord(this.compCode);
        aSCIIOutputStream.writeWord(" ");
        aSCIIOutputStream.writeWord(this.onset.trim().length() == 0 ? "?" : this.onset.trim());
        aSCIIOutputStream.writeWord(" ");
        aSCIIOutputStream.writeWord(this.name.trim().length() == 0 ? "?" : this.name.trim());
        aSCIIOutputStream.writeWord(" ");
        aSCIIOutputStream.writeWord(this.firstMot.trim().length() == 0 ? "?" : this.firstMot.trim());
        aSCIIOutputStream.writeWord(" ");
        String string = this.getTimeString().replace(',', '.');
        aSCIIOutputStream.writeWord(string);
        aSCIIOutputStream.writeWord(" ");
        if (n == 0) {
            aSCIIOutputStream.writeWord(UNC_TYPE_QUALITY_INT);
            aSCIIOutputStream.writeWord(" ");
            aSCIIOutputStream.writeWord(this.quality == Integer.MAX_VALUE ? "?" : String.valueOf(this.quality));
            aSCIIOutputStream.writeWord(" ");
        } else {
            aSCIIOutputStream.writeWord(this.uncertaintyType);
            aSCIIOutputStream.writeWord(" ");
            aSCIIOutputStream.writeFloat((float)(this.uncertainty == Double.MAX_VALUE ? 0.0 : this.uncertainty));
            aSCIIOutputStream.writeWord(" ");
        }
        aSCIIOutputStream.writeFloat((float)(this.duration == Double.MAX_VALUE ? 0.0 : this.duration));
        aSCIIOutputStream.writeWord(" ");
        aSCIIOutputStream.writeFloat((float)(this.amplitude == Double.MAX_VALUE ? 0.0 : this.amplitude));
        aSCIIOutputStream.writeWord(" ");
        aSCIIOutputStream.writeFloat((float)(this.period == Double.MAX_VALUE ? 0.0 : this.period));
    }

    public int read(ASCIIInputStream aSCIIInputStream, int n, boolean bl) {
        try {
            if (aSCIIInputStream.eof()) {
                return -1;
            }
        }
        catch (IOException iOException) {
            return -1;
        }
        if (n == 1 || n == 4) {
            return this.readNLLoc(aSCIIInputStream, n, bl);
        }
        if (n == 3 || n == 0) {
            return this.readNLLoc(aSCIIInputStream, n, bl);
        }
        return -1;
    }

    public int readNLLoc(ASCIIInputStream aSCIIInputStream, int n, boolean bl) {
        try {
            this.staName = aSCIIInputStream.readWord();
            if (n == 3) {
                this.compName = aSCIIInputStream.readWord();
                this.network = aSCIIInputStream.readWord();
            }
            this.instName = aSCIIInputStream.readWord();
            this.compCode = aSCIIInputStream.readWord();
            this.onset = aSCIIInputStream.readWord();
            this.name = aSCIIInputStream.readWord();
            this.firstMot = aSCIIInputStream.readWord();
            int n2 = aSCIIInputStream.readInt();
            int n3 = aSCIIInputStream.readInt();
            double d = aSCIIInputStream.readDouble();
            this.setDateTime(n2, n3, d);
            String string = aSCIIInputStream.readWord();
            if (string.equals(UNC_TYPE_QUALITY_INT)) {
                try {
                    this.quality = Integer.parseInt(aSCIIInputStream.readWord());
                }
                catch (Exception exception) {
                    this.quality = Integer.MAX_VALUE;
                }
            } else {
                try {
                    this.uncertainty = Double.parseDouble(aSCIIInputStream.readWord());
                }
                catch (Exception exception) {
                    this.uncertainty = Double.MAX_VALUE;
                }
            }
            this.duration = aSCIIInputStream.readDouble();
            this.amplitude = aSCIIInputStream.readDouble();
            this.period = aSCIIInputStream.readDouble();
            if (n == 4) {
                this.onset = "?";
                this.firstMot = "?";
                String string2 = aSCIIInputStream.readWord();
                double d2 = aSCIIInputStream.readDouble();
                double d3 = aSCIIInputStream.readDouble();
                this.setDateTime(new TimeInstant(this.iyear, this.imonth, this.idate, this.ihour, this.imin, this.sec), -d3);
            }
        }
        catch (IOException iOException) {
            String string = "ERROR: " + SeisGramText.READING_PICK_FILE;
            System.out.println(this.getClass().getName() + ": " + string);
            return -1;
        }
        catch (NumberFormatException numberFormatException) {
            String string = "ERROR: parsing number in pick file";
            System.out.println(this.getClass().getName() + ": " + string);
            numberFormatException.printStackTrace();
            return -1;
        }
        return 1;
    }

    public double dateTimeToTime(GatherPanel gatherPanel) {
        return this.dateTimeToTime(this.iyear, this.imonth, this.idate, this.ihour, this.imin, this.sec, gatherPanel);
    }

    public double dateTimeToTime(int n, int n2, double d, GatherPanel gatherPanel) {
        int n3 = n / 10000;
        int n4 = (n %= 10000) / 100;
        int n5 = n %= 100;
        int n6 = n2 / 100;
        int n7 = n2 %= 100;
        return this.dateTimeToTime(n3, n4, n5, n6, n7, d, gatherPanel);
    }

    public double dateTimeToTime(int n, int n2, int n3, int n4, int n5, double d, GatherPanel gatherPanel) {
        TimeInstant timeInstant = new TimeInstant(n, n2, n3, n4, n5, d);
        double d2 = gatherPanel.timeInstantToRefTime(timeInstant);
        return d2;
    }

    public void setDateTime(GatherPanel gatherPanel, double d) {
        this.setDateTime(gatherPanel.getRefTimeInstant(), d);
    }

    public void setDateTime(TimeInstant timeInstant, double d) {
        Date2 date2 = null;
        try {
            date2 = new TimeInstant(timeInstant.getMillisecondTime() + d * 1000.0);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.iyear = date2.getYear();
        this.imonth = date2.getMonth();
        this.idate = date2.getDate();
        this.ihour = ((TimeInstant)date2).getHours();
        this.imin = ((TimeInstant)date2).getMinutes();
        this.sec = ((TimeInstant)date2).getSeconds();
    }

    public void setDateTime(int n, int n2, double d) {
        this.iyear = n / 10000;
        this.imonth = (n %= 10000) / 100;
        this.idate = n %= 100;
        this.ihour = n2 / 100;
        this.imin = n2 %= 100;
        this.sec = d;
    }

    public int belongsTo(GatherPanel gatherPanel) {
        for (int i = 0; i < gatherPanel.seismograms.length; ++i) {
            if (!this.belongsToSeismogram(gatherPanel.seismograms[i])) continue;
            return i;
        }
        return -1;
    }

    public boolean belongsToSeismogram(Seismogram seismogram) {
        double d = 4.9E-323;
        if (this.network.compareTo("?") != 0 && this.compareFields(this.network, seismogram.channel.network.trim()) != 0) {
            return false;
        }
        if (this.staName.compareTo("?") != 0 && this.compareFields(this.staName, seismogram.channel.staName.trim()) != 0) {
            return false;
        }
        if (this.compName.compareTo("?") != 0 && this.compareFields(this.compName, seismogram.channel.compName.trim()) != 0) {
            return false;
        }
        if (this.compCode.compareTo("?") != 0 && this.compareFields(this.compCode, seismogram.compCode.trim()) != 0) {
            return false;
        }
        if (this.azimuth != Double.MAX_VALUE && this.compareFields(this.azimuth, seismogram.channel.azimuth, d) != 0) {
            return false;
        }
        return this.inclination == Double.MAX_VALUE || this.compareFields(this.inclination, seismogram.channel.inclination, d) == 0;
    }

    public Seismogram seismogramFor() {
        Seismogram seismogram = null;
        for (int i = 0; i < this.seisFrame.getGatherListSize(); ++i) {
            GatherPanel gatherPanel = this.seisFrame.getGatherListElementAt(i);
            int n = this.belongsTo(gatherPanel);
            if (n < 0) continue;
            seismogram = gatherPanel.getSeismogram(n);
            break;
        }
        return seismogram;
    }

    public GatherPanel gatherFor() {
        int n;
        GatherPanel gatherPanel = null;
        for (int i = 0; i < this.seisFrame.getGatherListSize() && (n = this.belongsTo(gatherPanel = this.seisFrame.getGatherListElementAt(i))) < 0; ++i) {
        }
        return gatherPanel;
    }
}

