/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.seisgram2k;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.text.NumberFormat;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Vector;
import javax.swing.JOptionPane;
import net.alomax.awt.AJLColor;
import net.alomax.freq.Response;
import net.alomax.freq.ResponseException;
import net.alomax.freq.SimpleAmplificationResponse;
import net.alomax.geog.Position;
import net.alomax.io.ASCIIOutputStream;
import net.alomax.io.BinaryInputStream;
import net.alomax.io.BinaryOutputStream;
import net.alomax.io.DirectoryLister;
import net.alomax.math.TimeSeriesFloat;
import net.alomax.seis.BasicChannel;
import net.alomax.seis.BasicHypocenter;
import net.alomax.seis.BasicSeismogram;
import net.alomax.seis.SeisData;
import net.alomax.seis.SeisDataASCII;
import net.alomax.seis.SeisDataCSMIP;
import net.alomax.seis.SeisDataDeprem;
import net.alomax.seis.SeisDataEarthwormTrace;
import net.alomax.seis.SeisDataFVGN;
import net.alomax.seis.SeisDataGSE21;
import net.alomax.seis.SeisDataPepp;
import net.alomax.seis.SeisDataSEEDFull;
import net.alomax.seis.SeisDataSEEDMini;
import net.alomax.seis.SeisDataSEESLO;
import net.alomax.seis.SeisDataSMC;
import net.alomax.seis.SeisDataSac;
import net.alomax.seis.SeisDataTitan;
import net.alomax.seis.SeisDataWAV;
import net.alomax.seisgram2k.GatherPanel;
import net.alomax.seisgram2k.SeisGram2KColors;
import net.alomax.seisgram2k.SeisGram2KFrame;
import net.alomax.seisgram2k.SeisGramText;
import net.alomax.seisgram2k.SeisPick;
import net.alomax.seisgram2k.SeismogramURL;
import net.alomax.timedom.PickData;
import net.alomax.timedom.TimeDomainException;
import net.alomax.timedom.TimeDomainProcess;
import net.alomax.util.BinaryType;
import net.alomax.util.PhysicalUnits;
import net.alomax.util.StringExt;
import net.alomax.util.TimeInstant;
import sdsu.io.ASCIIInputStream;

public class Seismogram
extends BasicSeismogram
implements Cloneable {
    public static final String GENERIC_IDENTIFIER_STRING = "seismogram";
    protected SeisGram2KFrame seisFrame;
    public TimeInstant refTimeInstant;
    public String staInstID;
    public String staInstIDShort;
    public String compCode;
    protected Color color;
    public String seisDataHeaderString;
    public String copyPostfix;
    public static Color colorZcomp = SeisGram2KColors.colorZComp;
    public static Color colorXcomp = SeisGram2KColors.colorXComp;
    public static Color colorYcomp = SeisGram2KColors.colorYComp;
    public static Color colorOtherComp = SeisGram2KColors.colorOtherComp;
    public static String[] channelFormatsRead = new String[]{"AUTO", "SAC_BINARY", "SAC_ALPHA", "SG2K_ASCII", "FULL_SEED", "MINI_SEED", "TITAN", "GSE21", "PEPP", "USGS_SMC", "CDMG_CSMIP", "EW_TRACEBUF", "EW_ASCII", "FVGN", "DEPREM_ASCII", "INERIS_ASCII", "SEESLO"};
    public static String[] channelFormatsWrite = new String[]{"SAC_BINARY", "SG2K_ASCII", "WAV"};
    public static final String DEFAULT_CHANNEL_FORMAT = "AUTO";
    public static String AZIMUTH = "AZIMUTH";
    public static String DIP = "DIP";
    public static String DEGREE_POLARISATION = "POLARISATION STRENGTH";
    public static String DEGREE_ELLIPTICITY = "DEGREE OF ELLIPTICITY";
    public static String DEGREE_LINEARITY = "DEGREE OF LINEARITY";
    public static String DEGREE_PLANARITY = "DEGREE OF PLANARITY";
    public static int GAP_FILL_UNSET = -1;
    public static int GAP_FILL_NO_DATA = 0;
    public static int GAP_FILL_LAST_VALID_DATA = 1;
    protected int gapFillMode;
    public static long NULL_TIMESTAMP = Long.MAX_VALUE;
    protected long timestamp;
    protected Vector readings;
    protected int INVALID_SAMPLE_VALUE;
    protected int iymax;
    protected boolean combineSeismograms;
    protected double xscale;
    protected double yscale;
    protected double amin;
    protected double thisFactor;
    protected double otherFactor;
    protected Seismogram otherSeismogram;
    protected SeismogramURL seismogramURL;
    protected double sampleIntPrecision;
    protected LinkedHashMap seismogramFieldsHashMap;
    protected LinkedHashMap seisDataFieldsHashMap;
    protected Vector onReadTimeDomainProcesses;
    protected SimpleAmplificationResponse simpleAmplificationResponse;
    protected static final int MARK_READLIMIT = 10000000;
    private static final int MAX_LINE_LEN = 16384;
    private int[] ixPts;
    private int[] iyPts;
    protected static double sampelRateFactor = -1.0;
    protected static final NumberFormat NUMBER_FORMAT_FRACT_6 = NumberFormat.getNumberInstance();
    protected static final NumberFormat NUMBER_FORMAT_FRACT_3 = NumberFormat.getNumberInstance();

    public void setSeisGram2KFrame(SeisGram2KFrame seisGram2KFrame) {
        this.seisFrame = seisGram2KFrame;
    }

    public Seismogram(SeisGram2KFrame seisGram2KFrame) {
        this(seisGram2KFrame, 1.0, 0);
    }

    public Seismogram(SeisGram2KFrame seisGram2KFrame, double d, int n) {
        block2: {
            this.seisFrame = null;
            this.staInstID = "?";
            this.staInstIDShort = "?";
            this.compCode = "?";
            this.color = Color.lightGray;
            this.seisDataHeaderString = GENERIC_IDENTIFIER_STRING;
            this.copyPostfix = "";
            this.gapFillMode = GAP_FILL_UNSET;
            this.timestamp = NULL_TIMESTAMP;
            this.readings = null;
            this.INVALID_SAMPLE_VALUE = 0;
            this.seismogramURL = new SeismogramURL(GENERIC_IDENTIFIER_STRING);
            this.sampleIntPrecision = 0.001;
            this.seismogramFieldsHashMap = null;
            this.seisDataFieldsHashMap = null;
            this.onReadTimeDomainProcesses = null;
            this.simpleAmplificationResponse = null;
            this.ixPts = new int[16384];
            this.iyPts = new int[16384];
            NUMBER_FORMAT_FRACT_6.setMinimumFractionDigits(1);
            NUMBER_FORMAT_FRACT_6.setMaximumFractionDigits(6);
            NUMBER_FORMAT_FRACT_3.setMinimumFractionDigits(1);
            NUMBER_FORMAT_FRACT_3.setMaximumFractionDigits(3);
            this.seisFrame = seisGram2KFrame;
            try {
                this.refTimeInstant = new TimeInstant(0.0);
            }
            catch (Exception exception) {
                if (!SeisGram2KFrame.PRINT_STACK_TRACES) break block2;
                exception.printStackTrace();
            }
        }
        float[] fArray = new float[n];
        this.timeSeries = new TimeSeriesFloat(fArray, d, 0.0, "counts", "sec");
    }

    public static void setColors(boolean bl, boolean bl2) {
        if (bl2) {
            colorZcomp = SeisGram2KColors.colorZCompGrayscale;
            colorXcomp = SeisGram2KColors.colorXCompGrayscale;
            colorYcomp = SeisGram2KColors.colorYCompGrayscale;
            colorOtherComp = SeisGram2KColors.colorOtherCompGrayscale;
        } else {
            colorZcomp = SeisGram2KColors.colorZComp;
            colorXcomp = SeisGram2KColors.colorXComp;
            colorYcomp = SeisGram2KColors.colorYComp;
            colorOtherComp = SeisGram2KColors.colorOtherComp;
        }
        if (bl) {
            colorZcomp = AJLColor.invert(colorZcomp);
            colorXcomp = AJLColor.invert(colorXcomp);
            colorYcomp = AJLColor.invert(colorYcomp);
            colorOtherComp = AJLColor.invert(colorOtherComp);
        }
    }

    public static String determineFormatAuto(InputStream inputStream, String string) {
        try {
            inputStream.mark(10000000);
            ASCIIInputStream aSCIIInputStream = new ASCIIInputStream(inputStream);
            try {
                if (SeisDataSac.canRead(aSCIIInputStream) == 1) {
                    inputStream.reset();
                    return "SAC_ALPHA";
                }
                inputStream.reset();
                if (SeisDataASCII.canRead(aSCIIInputStream) == 1) {
                    inputStream.reset();
                    return "SG2K_ASCII";
                }
                inputStream.reset();
                if (SeisDataGSE21.canRead(aSCIIInputStream) == 1) {
                    inputStream.reset();
                    return "GSE21";
                }
                inputStream.reset();
                if (SeisDataSMC.canRead(aSCIIInputStream) == 1) {
                    inputStream.reset();
                    return "USGS_SMC";
                }
                inputStream.reset();
                if (SeisDataCSMIP.canRead(aSCIIInputStream) == 1) {
                    inputStream.reset();
                    return "CDMG_CSMIP";
                }
                inputStream.reset();
                if (SeisDataFVGN.canRead(aSCIIInputStream) == 1) {
                    inputStream.reset();
                    return "FVGN";
                }
                inputStream.reset();
                if (SeisDataDeprem.canRead(aSCIIInputStream) == 1) {
                    inputStream.reset();
                    return "DEPREM_ASCII";
                }
                inputStream.reset();
                if (SeisDataSEESLO.canRead(aSCIIInputStream) == 1) {
                    inputStream.reset();
                    return "SEESLO";
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            inputStream.reset();
            BinaryInputStream binaryInputStream = new BinaryInputStream(inputStream, string);
            boolean bl = true;
            while (bl) {
                try {
                    if (SeisDataPepp.canRead(binaryInputStream) == 1) {
                        inputStream.reset();
                        return "PEPP";
                    }
                    inputStream.reset();
                    if (SeisDataSEEDFull.canRead(binaryInputStream) == 1) {
                        inputStream.reset();
                        return "FULL_SEED";
                    }
                    inputStream.reset();
                    if (SeisDataSEEDMini.canRead(binaryInputStream) == 1) {
                        inputStream.reset();
                        return "MINI_SEED";
                    }
                    if (SeisDataTitan.canRead(binaryInputStream) == 1) {
                        inputStream.reset();
                        return "TITAN";
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                inputStream.reset();
                if (bl) {
                    binaryInputStream = new BinaryInputStream(inputStream, BinaryType.invert(string));
                }
                bl = false;
            }
            binaryInputStream = new BinaryInputStream(inputStream, string);
            try {
                if (SeisDataSac.canRead(binaryInputStream) == 1) {
                    inputStream.reset();
                    return "SAC_BINARY";
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            inputStream.reset();
            try {
                binaryInputStream = new BinaryInputStream(inputStream, BinaryType.invert(string));
                if (SeisDataSac.canRead(binaryInputStream) == 1) {
                    inputStream.reset();
                    return "SAC_BINARY";
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            inputStream.reset();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public static boolean isVolumeFormat(String string) {
        return string.equalsIgnoreCase("FULL_SEED") || string.equalsIgnoreCase("TITAN") || string.equalsIgnoreCase("INERIS_ASCII") || string.equalsIgnoreCase("CDMG_CSMIP");
    }

    public Seismogram(SeisGram2KFrame seisGram2KFrame, InputStream inputStream, SeismogramURL seismogramURL, boolean bl) throws Exception {
        Object object;
        Object object2;
        SeisData seisData;
        block43: {
            boolean bl2;
            String string;
            block41: {
                this.seisFrame = null;
                this.staInstID = "?";
                this.staInstIDShort = "?";
                this.compCode = "?";
                this.color = Color.lightGray;
                this.seisDataHeaderString = GENERIC_IDENTIFIER_STRING;
                this.copyPostfix = "";
                this.gapFillMode = GAP_FILL_UNSET;
                this.timestamp = NULL_TIMESTAMP;
                this.readings = null;
                this.INVALID_SAMPLE_VALUE = 0;
                this.seismogramURL = new SeismogramURL(GENERIC_IDENTIFIER_STRING);
                this.sampleIntPrecision = 0.001;
                this.seismogramFieldsHashMap = null;
                this.seisDataFieldsHashMap = null;
                this.onReadTimeDomainProcesses = null;
                this.simpleAmplificationResponse = null;
                this.ixPts = new int[16384];
                this.iyPts = new int[16384];
                NUMBER_FORMAT_FRACT_6.setMinimumFractionDigits(1);
                NUMBER_FORMAT_FRACT_6.setMaximumFractionDigits(6);
                NUMBER_FORMAT_FRACT_3.setMinimumFractionDigits(1);
                NUMBER_FORMAT_FRACT_3.setMaximumFractionDigits(3);
                this.seisFrame = seisGram2KFrame;
                this.seismogramURL = new SeismogramURL(seismogramURL);
                string = seismogramURL.formatName;
                seisData = null;
                bl2 = false;
                try {
                    inputStream.mark(10000000);
                }
                catch (Exception exception) {
                    if (SeisGram2KFrame.PRINT_IGNORED_EXCEPTIONS) {
                        System.out.println(exception);
                    }
                    if (!SeisGram2KFrame.PRINT_STACK_TRACES) break block41;
                    exception.printStackTrace();
                }
            }
            String string2 = seismogramURL.binaryTypeName;
            while (true) {
                block42: {
                    try {
                        inputStream.reset();
                    }
                    catch (Exception exception) {
                        if (SeisGram2KFrame.PRINT_IGNORED_EXCEPTIONS) {
                            System.out.println(exception);
                        }
                        if (!SeisGram2KFrame.PRINT_STACK_TRACES) break block42;
                        exception.printStackTrace();
                    }
                }
                try {
                    if (string.equalsIgnoreCase("SAC_BINARY")) {
                        object2 = new BinaryInputStream(inputStream, string2);
                        seisData = new SeisDataSac();
                        this.readSeisData(seisData, (BinaryInputStream)object2);
                    } else if (string.equalsIgnoreCase("PEPP")) {
                        object2 = new BinaryInputStream(inputStream, string2);
                        seisData = new SeisDataPepp();
                        this.readSeisData(seisData, (BinaryInputStream)object2);
                    } else {
                        if (!string.toUpperCase().startsWith("EW_")) break;
                        object2 = new BinaryInputStream(inputStream, string2);
                        seisData = new SeisDataEarthwormTrace(string);
                        this.readSeisData(seisData, (BinaryInputStream)object2);
                        this.sampleIntPrecision = 0.05;
                    }
                    break block43;
                }
                catch (NegativeArraySizeException negativeArraySizeException) {
                    if (bl2) {
                        throw negativeArraySizeException;
                    }
                    bl2 = true;
                    object = "WARNING: " + seismogramURL.URLname + ": negative array size reading seismogram, inverting binary byte order.";
                    System.out.println((String)object);
                    seisGram2KFrame.writeMessage((String)object);
                    string2 = BinaryType.invert(string2);
                    continue;
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    if (bl2) {
                        throw outOfMemoryError;
                    }
                    bl2 = true;
                    object = "WARNING: " + seismogramURL.URLname + ": out of memory reading seismogram, inverting binary byte order.";
                    System.out.println((String)object);
                    seisGram2KFrame.writeMessage((String)object);
                    SeisGram2KFrame.doOutOfMemoryAction(false);
                    string2 = BinaryType.invert(string2);
                    continue;
                }
                catch (Throwable throwable) {
                    if (SeisGram2KFrame.PRINT_STACK_TRACES) {
                        throwable.printStackTrace();
                    }
                    if (bl2) {
                        throw new Exception(throwable);
                    }
                    bl2 = true;
                    object = "WARNING: " + seismogramURL.URLname + ": error reading seismogram " + ": " + throwable + ": inverting binary byte order.";
                    System.out.println((String)object);
                    seisGram2KFrame.writeMessage((String)object);
                    string2 = BinaryType.invert(string2);
                    continue;
                }
                break;
            }
            if (string.equalsIgnoreCase("MINI_SEED")) {
                object2 = new BinaryInputStream(inputStream, string2);
                seisData = new SeisDataSEEDMini();
                this.readSeisData(seisData, (BinaryInputStream)object2);
            } else if (string.equalsIgnoreCase("SAC_ALPHA")) {
                object2 = new ASCIIInputStream(inputStream);
                seisData = new SeisDataSac();
                this.readSeisData(seisData, (ASCIIInputStream)object2);
            } else if (string.equalsIgnoreCase("SG2K_ASCII")) {
                object2 = new ASCIIInputStream(inputStream);
                seisData = new SeisDataASCII();
                this.readSeisData(seisData, (ASCIIInputStream)object2);
            } else if (string.equalsIgnoreCase("GSE21")) {
                object2 = new ASCIIInputStream(inputStream);
                seisData = new SeisDataGSE21();
                this.readSeisData(seisData, (ASCIIInputStream)object2);
            } else if (string.equalsIgnoreCase("USGS_SMC")) {
                object2 = new ASCIIInputStream(inputStream);
                seisData = new SeisDataSMC();
                this.readSeisData(seisData, (ASCIIInputStream)object2);
            } else if (string.equalsIgnoreCase("CDMG_CSMIP")) {
                object2 = new ASCIIInputStream(inputStream);
                seisData = new SeisDataCSMIP(0);
                this.readSeisData(seisData, (ASCIIInputStream)object2);
            } else if (string.equalsIgnoreCase("FVGN")) {
                object2 = new ASCIIInputStream(inputStream);
                seisData = new SeisDataFVGN();
                this.readSeisData(seisData, (ASCIIInputStream)object2);
            } else if (string.equalsIgnoreCase("DEPREM_ASCII")) {
                object2 = new ASCIIInputStream(inputStream);
                seisData = new SeisDataDeprem();
                this.readSeisData(seisData, (ASCIIInputStream)object2);
            } else if (string.equalsIgnoreCase("SEESLO")) {
                object2 = new ASCIIInputStream(inputStream);
                seisData = new SeisDataSEESLO();
                this.readSeisData(seisData, (ASCIIInputStream)object2);
            } else {
                object2 = this.getClass().getName() + ": " + "ERROR: unrecognized or unsupported channel format for stream reading: " + string;
                System.out.println((String)object2);
                throw new Exception((String)object2);
            }
        }
        if (seisData == null) {
            throw new Exception("SeisData object not initialized");
        }
        if (seisGram2KFrame.getTrueFalseParameter(false, "channel.merge.sg2kascii")) {
            object2 = null;
            try {
                object2 = seismogramURL.cleanedURLname() + ".sg2k";
                object = seisGram2KFrame.getDataManager().openSeismogramInputStream((String)object2, true);
                SeisDataASCII seisDataASCII = new SeisDataASCII();
                this.readSeisData((SeisData)seisDataASCII, new ASCIIInputStream((InputStream)object));
                seisData.mergeMetaData(seisDataASCII);
                ((InputStream)object).close();
            }
            catch (Exception exception) {
                String string = this.getClass().getName() + ": " + "ERROR: reading channel.merge.sg2kascii file: " + (String)object2;
                System.out.println(string);
                seisGram2KFrame.writeMessage(string);
            }
        }
        this.consumeSeisData(seisData, bl);
    }

    protected void readSeisData(SeisData seisData, ASCIIInputStream aSCIIInputStream) throws Exception {
        this.seisFrame.readingData(true);
        seisData.read(aSCIIInputStream);
        this.seisFrame.readingData(false);
    }

    protected void readSeisData(SeisData seisData, BinaryInputStream binaryInputStream) throws Exception {
        this.seisFrame.readingData(true);
        seisData.read(binaryInputStream);
        this.seisFrame.readingData(false);
    }

    public Seismogram(SeisGram2KFrame seisGram2KFrame, SeisData seisData, SeismogramURL seismogramURL, boolean bl) throws Exception {
        this.seisFrame = null;
        this.staInstID = "?";
        this.staInstIDShort = "?";
        this.compCode = "?";
        this.color = Color.lightGray;
        this.seisDataHeaderString = GENERIC_IDENTIFIER_STRING;
        this.copyPostfix = "";
        this.gapFillMode = GAP_FILL_UNSET;
        this.timestamp = NULL_TIMESTAMP;
        this.readings = null;
        this.INVALID_SAMPLE_VALUE = 0;
        this.seismogramURL = new SeismogramURL(GENERIC_IDENTIFIER_STRING);
        this.sampleIntPrecision = 0.001;
        this.seismogramFieldsHashMap = null;
        this.seisDataFieldsHashMap = null;
        this.onReadTimeDomainProcesses = null;
        this.simpleAmplificationResponse = null;
        this.ixPts = new int[16384];
        this.iyPts = new int[16384];
        NUMBER_FORMAT_FRACT_6.setMinimumFractionDigits(1);
        NUMBER_FORMAT_FRACT_6.setMaximumFractionDigits(6);
        NUMBER_FORMAT_FRACT_3.setMinimumFractionDigits(1);
        NUMBER_FORMAT_FRACT_3.setMaximumFractionDigits(3);
        this.seisFrame = seisGram2KFrame;
        this.seismogramURL = new SeismogramURL(seismogramURL);
        String string = seismogramURL.formatName;
        if (seisData == null) {
            throw new Exception("SeisData object not initialized");
        }
        this.consumeSeisData(seisData, bl);
    }

    protected void consumeSeisData(SeisData seisData, boolean bl) throws Exception {
        if (!this.setSeismogramFields(seisData, bl)) {
            throw new Exception("Initializing seismogram header fields. (see console messages)");
        }
        this.refTimeInstant = new TimeInstant(this.iyear, this.ijday, this.ihour, this.imin, this.sec);
        this.updateStaInstID();
        if (this.seismogramURL.inclination != -1.7976931348623157E308) {
            this.channel.inclination = this.seismogramURL.inclination;
        }
        if (this.seismogramURL.azimuth != -1.7976931348623157E308) {
            this.channel.azimuth = this.seismogramURL.azimuth;
        }
        if (this.seismogramURL.multiplier != -1.7976931348623157E308) {
            this.multiply(this.seismogramURL.multiplier);
        }
        this.readings = seisData.setReadings();
        this.simpleAmplificationResponse = seisData.getSimpleAmplificationResponse();
    }

    public Seismogram(Seismogram seismogram) throws Exception {
        this(seismogram.seisFrame, seismogram, seismogram.getTimeMin(), seismogram.getTimeMax());
    }

    public Seismogram(SeisGram2KFrame seisGram2KFrame, Seismogram seismogram, double d, double d2) throws Exception {
        this.seisFrame = null;
        this.staInstID = "?";
        this.staInstIDShort = "?";
        this.compCode = "?";
        this.color = Color.lightGray;
        this.seisDataHeaderString = GENERIC_IDENTIFIER_STRING;
        this.copyPostfix = "";
        this.gapFillMode = GAP_FILL_UNSET;
        this.timestamp = NULL_TIMESTAMP;
        this.readings = null;
        this.INVALID_SAMPLE_VALUE = 0;
        this.seismogramURL = new SeismogramURL(GENERIC_IDENTIFIER_STRING);
        this.sampleIntPrecision = 0.001;
        this.seismogramFieldsHashMap = null;
        this.seisDataFieldsHashMap = null;
        this.onReadTimeDomainProcesses = null;
        this.simpleAmplificationResponse = null;
        this.ixPts = new int[16384];
        this.iyPts = new int[16384];
        NUMBER_FORMAT_FRACT_6.setMinimumFractionDigits(1);
        NUMBER_FORMAT_FRACT_6.setMaximumFractionDigits(6);
        NUMBER_FORMAT_FRACT_3.setMinimumFractionDigits(1);
        NUMBER_FORMAT_FRACT_3.setMaximumFractionDigits(3);
        this.seisFrame = seisGram2KFrame;
        this.seismogramURL = new SeismogramURL(seismogram.seismogramURL);
        if (d < seismogram.getTimeMin()) {
            d = seismogram.getTimeMin();
        }
        if (d2 > seismogram.getTimeMax()) {
            d2 = seismogram.getTimeMax();
        }
        int n = seismogram.sampAtTime(d);
        int n2 = seismogram.sampAtTime(d2);
        float[] fArray = seismogram.timeSeries.getSampleSubsetAsFloat(n, n2);
        this.timeSeries = new TimeSeriesFloat(fArray, seismogram.timeSeries.sampleInt, seismogram.timeSeries.lagTime, seismogram.timeSeries.ampUnits, seismogram.timeSeries.timeUnits);
        this.channel.network = new String(seismogram.channel.network);
        this.channel.staName = new String(seismogram.channel.staName);
        this.channel.instName = new String(seismogram.channel.instName);
        this.channel.chanName = new String(seismogram.channel.chanName);
        this.channel.locName = new String(seismogram.channel.locName);
        this.channel.compName = new String(seismogram.channel.compName);
        this.evtName = new String(seismogram.evtName);
        this.channel.azimuth = seismogram.channel.azimuth;
        this.channel.inclination = seismogram.channel.inclination;
        this.channel.staPosition = new Position(seismogram.channel.staPosition);
        this.hypocenter = new BasicHypocenter();
        this.hypocenter.position = new Position(seismogram.hypocenter.position);
        this.hypocenter.otime = new TimeInstant(seismogram.hypocenter.otime);
        this.hypocenter.ms = seismogram.hypocenter.ms;
        this.hypocenter.mb = seismogram.hypocenter.mb;
        this.hypocenter.mw = seismogram.hypocenter.mw;
        this.hypocenter.ml = seismogram.hypocenter.ml;
        this.hypocenter.mo = seismogram.hypocenter.mo;
        this.hypocenter.mag = seismogram.hypocenter.mag;
        this.gcarc = seismogram.gcarc;
        this.dist = seismogram.dist;
        this.az = seismogram.az;
        this.baz = seismogram.baz;
        this.timeMin = d;
        this.refTimeInstant = new TimeInstant(seismogram.getRefTimeInstant());
        this.iyear = this.refTimeInstant.getYear();
        this.ijday = this.refTimeInstant.getDoY();
        this.ihour = this.refTimeInstant.getHours();
        this.imin = this.refTimeInstant.getMinutes();
        this.sec = this.refTimeInstant.getSeconds();
        this.copyPostfix = new String(seismogram.copyPostfix);
        this.copyPostfix = this.copyPostfix + "X";
        this.updateStaInstID();
        this.seisDataHeaderString = new String(seismogram.seisDataHeaderString);
        this.seismogramFieldsHashMap = seismogram.seismogramFieldsHashMap == null ? null : new LinkedHashMap(seismogram.seismogramFieldsHashMap);
        LinkedHashMap linkedHashMap = this.seisDataFieldsHashMap = seismogram.seisDataFieldsHashMap == null ? null : new LinkedHashMap(seismogram.seisDataFieldsHashMap);
        if (seismogram.simpleAmplificationResponse != null) {
            this.simpleAmplificationResponse = new SimpleAmplificationResponse(seismogram.simpleAmplificationResponse);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public Color getColor() {
        return this.color;
    }

    public String getStaInstID() {
        return this.staInstID;
    }

    public String getStaInstIDShort() {
        return this.staInstIDShort;
    }

    public void updateStaInstID() {
        String string = this.channel.chanName;
        if (this.channel.locName != BasicChannel.UNDEF_STRING) {
            string = string + "." + this.channel.locName;
        }
        String string2 = this.channel.network + ":" + this.channel.staName + ":" + this.channel.instName + ":" + string + ":" + this.channel.compName;
        if (this.evtName != null && this.evtName.length() > 0) {
            string2 = string2 + ";" + this.evtName;
        }
        if (this.copyPostfix != null && this.copyPostfix.length() > 0) {
            string2 = string2 + ";" + this.copyPostfix;
        }
        this.staInstID = StringExt.replace(string2, BasicSeismogram.UNDEF_STRING, "");
        string2 = this.channel.network + ":" + this.channel.staName + ":" + this.channel.compName;
        this.staInstIDShort = StringExt.replace(string2, BasicSeismogram.UNDEF_STRING, "");
    }

    protected boolean setSeismogramFields(SeisData seisData, boolean bl) {
        seisData.setSeismogramFields();
        if (!seisData.checkFields(true, bl)) {
            return false;
        }
        String string = this.seisFrame.getParameter("header.ampunits");
        if (string != null) {
            seisData.timeSeries.setAmpUnits(string);
        }
        this.timeSeries = seisData.timeSeries;
        this.channel.network = seisData.channel.network;
        this.channel.staName = seisData.channel.staName;
        this.channel.staPosition = seisData.channel.staPosition;
        this.channel.instName = seisData.channel.instName;
        if (this.channel.instName.equals(BasicSeismogram.UNDEF_STRING)) {
            this.channel.instName = "(" + this.timeSeries.ampUnits + ")";
        }
        this.channel.chanName = seisData.channel.chanName;
        this.channel.locName = seisData.channel.locName;
        this.channel.compName = seisData.channel.compName;
        this.evtName = seisData.evtName.trim();
        this.iyear = seisData.iyear;
        this.ijday = seisData.ijday;
        this.ihour = seisData.ihour;
        this.imin = seisData.imin;
        this.sec = seisData.sec;
        this.channel.azimuth = seisData.channel.azimuth;
        this.channel.inclination = seisData.channel.inclination;
        this.timeMin = seisData.timeMin;
        this.hypocenter = seisData.hypocenter;
        this.gcarc = seisData.gcarc;
        this.dist = seisData.dist;
        this.az = seisData.az;
        this.baz = seisData.baz;
        this.seismogramFieldsHashMap = this.getSeismogramFieldsHashMap();
        this.seisDataFieldsHashMap = seisData.getHeaderFields();
        String string2 = System.getProperty("line.separator");
        this.seisDataHeaderString = "# Original data channel URL:" + string2 + this.seismogramURL.URLname + string2 + string2;
        this.seisDataHeaderString = this.seisDataHeaderString + "# Original data channel header fields:" + string2 + this.getHeaderFieldsAsString();
        this.seisDataHeaderString = StringExt.checkPrintable(this.seisDataHeaderString, true, '$', false, "seisDataHeaderString");
        return true;
    }

    public LinkedHashMap getSeismogramFieldsHashMap() {
        if (this.seismogramFieldsHashMap != null) {
            return this.seismogramFieldsHashMap;
        }
        this.seismogramFieldsHashMap = new LinkedHashMap();
        String string = this.toString();
        String[] stringArray = StringExt.parse(string);
        for (int i = 1; i < stringArray.length - 1; ++i) {
            if (!stringArray[i].equals("=")) continue;
            this.seismogramFieldsHashMap.put(stringArray[i - 1], stringArray[i + 1]);
        }
        return this.seismogramFieldsHashMap;
    }

    public String getHeaderFieldsAsString() {
        if (this.seisDataFieldsHashMap == null) {
            return "No seismogram header information available.";
        }
        String string = System.getProperty("line.separator");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("# [SAC Data Format]" + string);
        for (String string2 : this.seisDataFieldsHashMap.keySet()) {
            stringBuffer.append(string2).append(" = ").append((String)this.seisDataFieldsHashMap.get(string2)).append(string);
        }
        return stringBuffer.toString();
    }

    public String getHeaderFieldStringValue(String string) {
        if (!string.startsWith("&")) {
            if (this.seismogramFieldsHashMap != null && this.seismogramFieldsHashMap.containsKey(string)) {
                return (String)this.seismogramFieldsHashMap.get(string);
            }
        } else {
            string = string.substring(1);
        }
        if (this.seisDataFieldsHashMap != null && this.seisDataFieldsHashMap.containsKey(string)) {
            return (String)this.seisDataFieldsHashMap.get(string);
        }
        return UNDEF_STRING;
    }

    public synchronized double append(GatherPanel gatherPanel, Seismogram seismogram, double d, boolean bl) throws Exception {
        Object object;
        String string = null;
        if (seismogram.timeSeries.sampleInt < (double)1.4E-45f) {
            throw new Exception(this.getClass().getName() + ": " + "Cannot append: " + seismogram.seismogramURL.URLname + ": append has invalid sample rate: dt append: " + (float)seismogram.timeSeries.sampleInt);
        }
        if (d > 0.0 && d < seismogram.getTimeMax() - seismogram.getTimeMin()) {
            d = 2.0 * (seismogram.getTimeMax() - seismogram.getTimeMin());
            string = "WARNING: " + seismogram.seismogramURL.URLname + ": " + "Append: window length is less than append trace length: increasing window length to " + (float)d + "s";
            this.seisFrame.writeMessage(string);
        }
        TimeInstant timeInstant = this.refTimeInstant;
        double d2 = this.timeSeries.sampleInt;
        double d3 = this.timeMin;
        if (this.onReadTimeDomainProcesses != null && this.onReadTimeDomainProcesses.size() > 0) {
            Enumeration enumeration = this.onReadTimeDomainProcesses.elements();
            while (enumeration.hasMoreElements()) {
                TimeDomainProcess timeDomainProcess = (TimeDomainProcess)enumeration.nextElement();
                seismogram.applyTimeDomainProcess(timeDomainProcess);
            }
        }
        double d4 = 0.0;
        double d5 = 0.0;
        if (bl) {
            d4 = this.doubleSampAtTimeNoVerify(0.0);
            d5 = seismogram.doubleSampAtTimeNoVerify(0.0);
        }
        this.setReferenceTime(seismogram.refTimeInstant);
        if (Math.abs(this.timeSeries.sampleInt - seismogram.timeSeries.sampleInt) > this.timeSeries.sampleInt * this.sampleIntPrecision) {
            this.setReferenceTime(timeInstant);
            this.timeSeries.sampleInt = d2;
            this.timeMin = d3;
            throw new Exception(this.getClass().getName() + ": " + "Cannot append " + seismogram.seismogramURL.URLname + ": seismograms do not have the same sample rate within " + this.sampleIntPrecision * 100.0 + "%: dt existing:" + (float)this.timeSeries.sampleInt + " dt append: " + (float)seismogram.timeSeries.sampleInt);
        }
        int n = this.sampAtTimeNoVerify(seismogram.timeAtSample(0));
        double d6 = seismogram.timeAtSample(0) - this.timeAtSample(n);
        boolean bl2 = false;
        if (n > this.timeSeries.sampleLength()) {
            float f = 0.0f;
            f = this.getGapFillMode() == GAP_FILL_LAST_VALID_DATA ? (float)this.timeSeries.sampleAt(this.timeSeries.sampleLength() - 1) : -3.4028235E38f;
            String string2 = "";
            try {
                string2 = this.refTimeToTimeInstant(this.timeAtSample(n)).toString();
            }
            catch (Exception exception) {
                if (SeisGram2KFrame.PRINT_STACK_TRACES) {
                    exception.printStackTrace();
                }
                string2 = "INVALID";
            }
            object = "";
            try {
                object = this.refTimeToTimeInstant(this.timeAtSample(this.timeSeries.sampleLength() - 1)).toString();
            }
            catch (Exception exception) {
                if (SeisGram2KFrame.PRINT_STACK_TRACES) {
                    exception.printStackTrace();
                }
                object = "INVALID";
            }
            string = "WARNING: " + seismogram.seismogramURL.URLname + ": " + "Append: start index: " + n + " (" + string2 + ")" + " is " + (n - this.timeSeries.sampleLength() + 1) + " sample(s) past end of current data: " + (this.timeSeries.sampleLength() - 1) + " (" + (String)object + ")" + ": filling gap with " + (f == -3.4028235E38f ? "NO_DATA" : "" + f);
            this.seisFrame.writeMessage(string);
            int n2 = (int)(d / this.timeSeries.sampleInt) + 1;
            int n3 = 2 * n2;
            if (d > 0.0 && n - this.timeSeries.sampleLength() > n2) {
                if (n2 < 0) {
                    System.out.println("creating fillArray of maxLength: " + n2 + " sibd: " + n + " tssl: " + this.timeSeries.sampleLength());
                    this.setReferenceTime(timeInstant);
                    this.timeSeries.sampleInt = d2;
                    this.timeMin = d3;
                    throw new Exception("Cannot append: " + seismogram.seismogramURL.URLname + ": invalid fill array length: " + n2);
                }
                if (n2 > n3) {
                    bl2 = true;
                } else {
                    float[] fArray = new float[n2];
                    for (int i = 0; i < fArray.length; ++i) {
                        fArray[i] = f;
                    }
                    n = fArray.length - seismogram.timeSeries.sampleLength();
                    this.timeSeries.appendFloat(0, fArray, 0);
                    this.timeMin = seismogram.getTimeMax() - (double)(fArray.length - 1) * this.timeSeries.sampleInt;
                }
            } else {
                int n4 = n - this.timeSeries.sampleLength();
                if (n4 < 0) {
                    System.out.println("creating fillArray of length:" + n4 + " sibd:" + n + " tssl:" + this.timeSeries.sampleLength() + " tas0:" + seismogram.timeAtSample(0));
                    System.out.println("this seismogram:" + this.toString());
                    System.out.println("seismogramToAppend:" + seismogram.toString());
                    System.out.println("");
                    this.setReferenceTime(timeInstant);
                    this.timeSeries.sampleInt = d2;
                    this.timeMin = d3;
                    throw new Exception("Cannot append: " + seismogram.seismogramURL.URLname + ": invalid fill array length: " + n4);
                }
                if (n4 > n3) {
                    bl2 = true;
                }
                float[] fArray = new float[n - this.timeSeries.sampleLength()];
                for (int i = 0; i < fArray.length; ++i) {
                    fArray[i] = f;
                }
                this.timeSeries.appendFloat(0, fArray, this.timeSeries.sampleLength());
            }
        }
        if (n < 0 && this.sampAtTimeNoVerify(seismogram.timeAtSample(seismogram.timeSeries.sampleLength())) < this.timeSeries.sampleLength()) {
            this.setReferenceTime(timeInstant);
            this.timeSeries.sampleInt = d2;
            this.timeMin = d3;
            throw new Exception("Cannot append: " + seismogram.seismogramURL.URLname + ": start index: " + n + " (" + seismogram.refTimeToTimeInstant(seismogram.timeAtSample(0)) + ")" + "\n   before beginning of current data:" + " (" + this.refTimeToTimeInstant(this.timeAtSample(0)) + ")");
        }
        int n5 = 0;
        if (bl2) {
            this.timeSeries.setSampleFloat(seismogram.timeSeries.getSampleAsFloat());
            this.timeMin = seismogram.getTimeMin();
            n = 0;
        } else {
            int n6;
            if (d > 0.0 && (n5 = (n6 = n + seismogram.timeSeries.sampleLength()) - ((int)(d / this.timeSeries.sampleInt) + 1)) < 0) {
                n5 = 0;
            }
            this.timeSeries.appendFloat(n5, seismogram.timeSeries.getSampleAsFloat(), n);
            this.timeMin += (double)n5 * this.timeSeries.sampleInt;
        }
        this.staInstID = new String(seismogram.getStaInstID());
        this.staInstIDShort = new String(seismogram.getStaInstIDShort());
        if (this.onReadTimeDomainProcesses != null && this.onReadTimeDomainProcesses.size() > 0) {
            Enumeration enumeration = this.onReadTimeDomainProcesses.elements();
            while (enumeration.hasMoreElements()) {
                object = (TimeDomainProcess)enumeration.nextElement();
                Vector vector = ((TimeDomainProcess)object).getPickData();
                if (vector == null) continue;
                String string3 = ((TimeDomainProcess)object).getPickPrefix();
                for (int i = 0; i < vector.size(); ++i) {
                    PickData pickData = (PickData)vector.elementAt(i);
                    String string4 = string3 + i;
                    gatherPanel.setPickFromPickData(pickData, string4, this, n - n5, true);
                }
                ((TimeDomainProcess)object).clearTriggerPickData();
            }
        }
        return d6;
    }

    public void setTimeStamp(long l) {
        this.timestamp = l;
    }

    public long getTimeStamp() {
        return this.timestamp;
    }

    public void setComponent() {
        this.compCode = "?";
        double d = this.channel.inclination;
        double d2 = this.channel.azimuth;
        if (d > -1.0E-5 && d < 1.0E-5) {
            this.compCode = "Z";
        } else if (d > 179.99999 && d < 180.00001) {
            this.compCode = "Z";
            this.invertPolarity();
            this.channel.inclination = 0.0;
        } else if (d > 89.99999 && d < 90.00001) {
            if (d2 > -1.0E-5 && d2 < 1.0E-5) {
                this.compCode = "Y";
            } else if (d2 > 89.99999 && d2 < 90.00001) {
                this.compCode = "X";
            } else if (d2 > 179.99999 && d2 < 180.00001) {
                this.compCode = "Y";
                this.invertPolarity();
                this.channel.azimuth = 0.0;
            } else if (d2 > 269.99999 && d2 < 270.00001) {
                this.compCode = "X";
                this.invertPolarity();
                this.channel.azimuth = 90.0;
            }
        } else if (d != Double.MAX_VALUE || d2 != Double.MAX_VALUE) {
            System.out.println(this.getClass().getName() + ": " + "WARNING: " + this.seismogramURL.URLname + ": " + "Invalid or undetermined Seismogram inclination: " + d + " or azimuth: " + d2);
        }
    }

    public void setColors() {
        this.color = this.compCode == "Z" ? colorZcomp : (this.compCode == "Y" ? colorYcomp : (this.compCode == "X" ? colorXcomp : colorOtherComp));
    }

    public int getGapFillMode() {
        if (this.gapFillMode < 0) {
            try {
                boolean bl = this.seisFrame.getTrueFalseParameter(true, "channel.gapmode");
                this.gapFillMode = bl ? GAP_FILL_LAST_VALID_DATA : GAP_FILL_NO_DATA;
            }
            catch (Exception exception) {
                this.gapFillMode = GAP_FILL_NO_DATA;
            }
        }
        return this.gapFillMode;
    }

    public void paint(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, double d, double d2, double d3, double d4, double d5, double d6, Seismogram seismogram, String string, Color color) {
        int n7;
        this.amin = d3;
        this.iymax = n4;
        this.INVALID_SAMPLE_VALUE = n4 + 1;
        this.thisFactor = d5;
        this.otherFactor = d6;
        this.otherSeismogram = seismogram;
        Color color2 = color;
        if (color2 == null) {
            this.setColors();
            color2 = this.color;
        }
        graphics.setColor(color2);
        this.xscale = (double)(n2 - n) / (d2 - d);
        this.yscale = (double)(n4 - n3) / (d4 - d3);
        this.combineSeismograms = false;
        if (seismogram != null) {
            this.combineSeismograms = true;
        }
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n8 = fontMetrics.charWidth('_');
        int n9 = fontMetrics.getMaxAscent();
        int n10 = n9 + fontMetrics.getMaxDescent();
        graphics.drawString(string, n + n8, n5 + n10 + n9 + n6 * n10);
        int n11 = this.sampAtTime(d);
        if (n11 > 0) {
            --n11;
        }
        if ((n7 = this.sampAtTime(d2)) > this.timeSeries.sampleLength() - 1) {
            n7 = this.timeSeries.sampleLength() - 1;
        } else if (n7 < this.timeSeries.sampleLength() - 1) {
            ++n7;
        }
        double d7 = (double)n + ((double)n11 * this.timeSeries.sampleInt + this.timeMin - d) * this.xscale;
        int n12 = (int)d7;
        int n13 = this.getIy(n11);
        int n14 = n12;
        int n15 = 0;
        this.ixPts[n15] = n12;
        this.iyPts[n15++] = n13;
        int n16 = n13;
        int n17 = n13;
        boolean bl = false;
        double d8 = this.timeSeries.sampleInt * this.xscale;
        for (int i = n11 + 1; i <= n7; ++i) {
            int n18 = n12;
            double d9 = d7;
            n12 = (int)(d7 += d8);
            n13 = this.getIy(i);
            if (n12 != n18 || n13 == this.INVALID_SAMPLE_VALUE) {
                if (bl) {
                    this.ixPts[n15] = n18;
                    this.iyPts[n15++] = n16;
                    if (n17 != n16) {
                        this.ixPts[n15] = n18;
                        this.iyPts[n15++] = n17;
                    }
                }
                bl = false;
                if (n13 != this.INVALID_SAMPLE_VALUE) {
                    n16 = n17 = n13;
                    this.ixPts[n15] = n12;
                    this.iyPts[n15++] = n13;
                } else {
                    n16 = n4;
                    n17 = 0;
                }
            } else {
                n16 = n13 < n16 ? n13 : n16;
                n17 = n13 > n17 ? n13 : n17;
                bl = true;
            }
            if (n15 <= 16381 && (n13 != this.INVALID_SAMPLE_VALUE || n15 <= 1)) continue;
            graphics.drawPolyline(this.ixPts, this.iyPts, n15);
            n15 = 0;
            if (n13 == this.INVALID_SAMPLE_VALUE) continue;
            this.ixPts[n15] = n12;
            this.iyPts[n15++] = n13;
        }
        this.ixPts[n15] = n12;
        this.iyPts[n15++] = n16;
        this.ixPts[n15] = n12;
        this.iyPts[n15++] = n17;
        graphics.drawPolyline(this.ixPts, this.iyPts, n15);
    }

    public final int getIy(int n) {
        double d = this.timeSeries.sampleAt(n);
        if (d == -1.7976931348623157E308) {
            return this.INVALID_SAMPLE_VALUE;
        }
        if (!this.combineSeismograms) {
            return this.iymax - (int)((d - this.amin) * this.yscale);
        }
        int n2 = this.otherSeismogram.sampAtTime(this.timeAtSample(n));
        if (n2 < 0 || n2 >= this.otherSeismogram.timeSeries.sampleLength()) {
            return this.INVALID_SAMPLE_VALUE;
        }
        double d2 = this.otherSeismogram.timeSeries.sampleAt(n2);
        if (d2 == -1.7976931348623157E308) {
            return this.INVALID_SAMPLE_VALUE;
        }
        return this.iymax - (int)((this.thisFactor * d + this.otherFactor * d2 - this.amin) * this.yscale);
    }

    public double ampAtTimeVector(double d) {
        if (d < this.timeMin - (double)1.4E-45f) {
            return 0.0;
        }
        double d2 = (d - this.timeMin) / this.timeSeries.sampleInt;
        int n = (int)d2;
        if (n < 0 || n >= this.timeSeries.sampleLength()) {
            return 0.0;
        }
        int n2 = n + 1;
        double d3 = d2 - (double)n;
        if (n == this.timeSeries.sampleLength() - 1) {
            if (d3 > (double)1.4E-45f) {
                return 0.0;
            }
            n2 = n - 1;
            d3 = 0.0;
        }
        if (!this.combineSeismograms) {
            double d4 = this.timeSeries.sampleAt(n);
            double d5 = this.timeSeries.sampleAt(n2);
            return d4 + (d5 - d4) * d3;
        }
        double d6 = this.thisFactor * this.timeSeries.sampleAt(n);
        int n3 = this.otherSeismogram.sampAtTime(this.timeAtSample(n));
        if (n3 >= 0 && n3 < this.otherSeismogram.timeSeries.sampleLength()) {
            d6 += this.otherFactor * this.otherSeismogram.timeSeries.sampleAt(n3);
        }
        double d7 = this.thisFactor * this.timeSeries.sampleAt(n2);
        n3 = this.otherSeismogram.sampAtTime(this.timeAtSample(n2));
        if (n3 >= 0 && n3 < this.otherSeismogram.timeSeries.sampleLength()) {
            d7 += this.otherFactor * this.otherSeismogram.timeSeries.sampleAt(n3);
        }
        return d6 + (d7 - d6) * d3;
    }

    public TimeInstant refTimeToTimeInstant(double d, String string) {
        TimeInstant timeInstant;
        block2: {
            double d2 = this.refTimeInstant.getMillisecondTime() + 1000.0 * d;
            timeInstant = null;
            try {
                timeInstant = new TimeInstant(d2, string);
            }
            catch (Exception exception) {
                if (!SeisGram2KFrame.PRINT_IGNORED_EXCEPTIONS) break block2;
                System.out.println("Seismogram.refTimeToTimeInstant(): " + this.seismogramURL.URLname + " time: " + d + ", localeName: " + string);
                exception.printStackTrace();
            }
        }
        return timeInstant;
    }

    public TimeInstant refTimeToTimeInstant(double d) throws Exception {
        return this.refTimeToTimeInstant(d, null);
    }

    public double timeInstantToRefTime(TimeInstant timeInstant) {
        double d = timeInstant.getMillisecondTime() - this.refTimeInstant.getMillisecondTime();
        return d / 1000.0;
    }

    public void setReferenceTime(TimeInstant timeInstant) {
        this.iyear = timeInstant.getYear();
        this.ijday = timeInstant.getDoY();
        this.ihour = timeInstant.getHours();
        this.imin = timeInstant.getMinutes();
        this.sec = timeInstant.getSeconds();
        double d = (timeInstant.getMillisecondTime() - this.refTimeInstant.getMillisecondTime()) / 1000.0;
        this.timeMin -= d;
        this.refTimeInstant = new TimeInstant(timeInstant);
    }

    public void shiftReferenceTime(double d) {
        this.timeMin += d;
    }

    public int iyPlotIndexAtTime(double d) {
        double d2 = (d - this.timeMin) / this.timeSeries.sampleInt;
        if (d2 <= 0.0) {
            return this.getIy(0);
        }
        int n = (int)d2;
        if (n < 0) {
            return this.getIy(0);
        }
        if (n >= this.timeSeries.sampleLength() - 1) {
            return this.getIy(this.timeSeries.sampleLength() - 1);
        }
        int n2 = n + 1;
        double d3 = this.getIy(n);
        double d4 = this.getIy(n2);
        return (int)(d3 + (d4 - d3) * (d2 % 1.0));
    }

    public Vector getPicks() {
        Vector<SeisPick> vector = new Vector<SeisPick>();
        for (int i = this.seisFrame.pickList.size() - 1; i >= 0; --i) {
            SeisPick seisPick = (SeisPick)this.seisFrame.pickList.elementAt(i);
            if (seisPick.getStatus() == 2 || !seisPick.belongsToSeismogram(this)) continue;
            vector.add(seisPick);
        }
        return vector;
    }

    public void write(OutputStream outputStream, String string, String string2) throws Exception {
        SeisData seisData;
        block15: {
            seisData = null;
            try {
                if (string.equalsIgnoreCase("SAC_BINARY")) {
                    BinaryOutputStream binaryOutputStream = new BinaryOutputStream(outputStream, string2);
                    seisData = new SeisDataSac();
                    seisData.getSeismogramFields(this);
                    seisData.getReadings(this.getPicks());
                    seisData.setSimpleAmplificationResponse(this.simpleAmplificationResponse);
                    seisData.write(binaryOutputStream);
                    break block15;
                }
                if (string.equalsIgnoreCase("SG2K_ASCII")) {
                    ASCIIOutputStream aSCIIOutputStream = new ASCIIOutputStream(outputStream);
                    seisData = new SeisDataASCII();
                    seisData.getSeismogramFields(this);
                    seisData.write(aSCIIOutputStream);
                    break block15;
                }
                if (string.equalsIgnoreCase("WAV")) {
                    Object object;
                    if (sampelRateFactor < 0.0) {
                        sampelRateFactor = 1000.0 * this.timeSeries.sampleInt;
                        try {
                            sampelRateFactor = Double.parseDouble(this.seisFrame.getParameter("sound.ratefactor"));
                        }
                        catch (Exception exception) {
                            sampelRateFactor = 1000.0 * this.timeSeries.sampleInt;
                        }
                    }
                    if (this.seisFrame.isVisible()) {
                        try {
                            object = (String)JOptionPane.showInputDialog(this.seisFrame, SeisGramText.SOUND_RATE_FACTOR + ":", "WAV " + SeisGramText.SOUND_RATE_FACTOR, 3, null, null, "" + (float)sampelRateFactor);
                            if (object == null) {
                                return;
                            }
                            sampelRateFactor = Double.parseDouble((String)object);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                    System.out.println("sound.ratefactor " + sampelRateFactor);
                    try {
                        object = new BinaryOutputStream(outputStream, string2);
                        seisData = new SeisDataWAV(sampelRateFactor);
                        seisData.getSeismogramFields(this);
                        seisData.write((BinaryOutputStream)object);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        BinaryOutputStream binaryOutputStream = new BinaryOutputStream(outputStream, BinaryType.invert(string2));
                        seisData = new SeisDataWAV(sampelRateFactor);
                        seisData.getSeismogramFields(this);
                        seisData.write(binaryOutputStream);
                    }
                    break block15;
                }
                String string3 = this.getClass().getName() + ": " + "WARNING: unsupported write format: " + string + ": using SAC_BINARY";
                System.out.println(string3);
                BinaryOutputStream binaryOutputStream = new BinaryOutputStream(outputStream, string2);
                seisData = new SeisDataSac();
                seisData.getSeismogramFields(this);
                seisData.getReadings(this.getPicks());
                seisData.write(binaryOutputStream);
            }
            catch (IOException iOException) {
                System.out.println(this.getClass().getName() + ": " + "ERROR: writing " + string + " seismogram file.");
                throw iOException;
            }
        }
        if (seisData == null) {
            throw new Exception("SeisData object not initialized");
        }
    }

    public String getTauPsource() {
        if (this.seismogramURL.tauPsource != null) {
            return this.seismogramURL.tauPsource;
        }
        if (this.hypocenter != null) {
            if (this.hypocenter.otime != BasicHypocenter.UNDEF_OTIME && this.gcarc != Double.MAX_VALUE) {
                TimeInstant timeInstant = this.hypocenter.otime;
                double d = this.hypocenter.position.depth;
                if (d == Double.MAX_VALUE) {
                    d = 0.0;
                }
                String string = "" + timeInstant.getYear() + "," + timeInstant.getMonth() + "," + timeInstant.getDate() + "," + timeInstant.getHours() + "," + timeInstant.getMinutes() + "," + (float)timeInstant.getSeconds() + "," + (float)d + "," + (float)this.gcarc + ",deg;";
                return string;
            }
        }
        return null;
    }

    public Response getResponse(URL uRL, String string) throws ResponseException {
        Object object;
        String string2;
        Response response;
        block20: {
            String string3;
            if (string == null) {
                string = this.seismogramURL.getResponseFileName();
            }
            if (string == null) {
                throw new ResponseException("No response file available for this channel");
            }
            response = null;
            String string4 = null;
            string2 = null;
            if (string.equals("SIMPLE_AMPLIFICATION")) {
                response = this.simpleAmplificationResponse;
            } else {
                if (string.equals("RDSEED_SAC_PZ") || string.equals("PAZ")) {
                    string4 = "m";
                    string2 = "counts";
                    string3 = SeismogramURL.defaultResponseFilePath;
                    if (this.seismogramURL.defaultResponseFilePathNet) {
                        if (this.channel.network != BasicChannel.UNDEF_STRING) {
                            string3 = string3 + File.separator + this.channel.network;
                        }
                    }
                    if (string3 == null) {
                        object = new File(this.seismogramURL.URLname);
                        string3 = ((File)object).getAbsoluteFile().getParent();
                    }
                    try {
                        string = this.getRdseedSacPzFileName(string3);
                    }
                    catch (Exception exception) {
                        String string5 = "Error finding RDSEED_SAC_PZ response file for this channel: " + exception;
                        try {
                            string = this.getDefaultPzFileName(string3);
                        }
                        catch (Exception exception2) {
                            String string6 = "Error finding PAZ response file for this channel: " + exception2;
                            throw new ResponseException(string5 + "; " + string6);
                        }
                    }
                }
                response = Response.createResponse(uRL, string, SeismogramURL.defaultResponseFileType, this.refTimeInstant, this.channel, this.timeSeries);
            }
            if (response == null) {
                return response;
            }
            string3 = this.seisFrame.getParameter("channel.response.units.before");
            if (string3 == null && string4 != null) {
                string3 = string4;
            }
            if (string3 != null) {
                response.setBeforeUnits(string3);
            }
            try {
                PhysicalUnits.setDefaultLengthUnits(response.getBeforeUnits()[0]);
            }
            catch (Exception exception) {
                if (SeisGram2KFrame.PRINT_IGNORED_EXCEPTIONS) {
                    System.out.println("WARNING: " + exception);
                }
                if (!SeisGram2KFrame.PRINT_STACK_TRACES) break block20;
                exception.printStackTrace();
            }
        }
        object = this.seisFrame.getParameter("channel.response.units.after");
        if (object == null && string2 != null) {
            object = string2;
        }
        if (object != null) {
            response.setAfterUnits((String)object);
        }
        return response;
    }

    protected String getRdseedSacPzFileName(String string) throws Exception {
        String string2 = "SAC_PZs_" + this.channel.network + "_" + this.channel.staName + "_" + this.channel.chanName;
        if (!this.channel.locName.equals(BasicChannel.UNDEF_STRING)) {
            string2 = string2 + "_" + this.channel.locName;
        }
        String[] stringArray = null;
        String[] stringArray2 = DirectoryLister.getDirectoryList(string, stringArray, false);
        String string3 = null;
        boolean bl = false;
        for (int i = 0; i < stringArray2.length; ++i) {
            if (!stringArray2[i].startsWith(string2)) continue;
            if (string3 != null) {
                bl = true;
            }
            string3 = stringArray2[i];
        }
        if (bl) {
            System.out.println(this.getClass().getName() + ": " + "WARNING: multiple RDSEED_SAC_PZ response files found for this channel, using last found: " + string3);
        }
        if (string3 == null) {
            throw new Exception("No file in data directory with prefix: " + string2);
        }
        String string4 = string + File.separator + string3;
        return string4;
    }

    protected String getDefaultPzFileName(String string) throws Exception {
        String string2 = "";
        String string3 = System.getProperty("line.separator");
        String string4 = null;
        try {
            string4 = this.getDefaultPzFileName(string, "", ".pz");
        }
        catch (Exception exception) {
            string2 = string2 + exception.getMessage() + string3;
        }
        try {
            string4 = this.getDefaultPzFileName(string, "", ".zp");
        }
        catch (Exception exception) {
            string2 = string2 + exception.getMessage() + string3;
        }
        try {
            string4 = this.getDefaultPzFileName(string, "", ".paz");
        }
        catch (Exception exception) {
            string2 = string2 + exception.getMessage() + string3;
        }
        if (string4 == null) {
            throw new Exception(string2);
        }
        return string4;
    }

    protected String getDefaultPzFileName(String string, String string2, String string3) throws Exception {
        File file = new File(this.seismogramURL.URLname);
        String string4 = string2 + file.getName() + string3;
        String[] stringArray = null;
        String[] stringArray2 = DirectoryLister.getDirectoryList(string, stringArray, false);
        String string5 = null;
        for (int i = 0; i < stringArray2.length; ++i) {
            if (!stringArray2[i].equals(string4)) continue;
            if (string5 == null) {
                string5 = stringArray2[i];
                continue;
            }
            System.out.println(this.getClass().getName() + ": " + "WARNING: multiple PAZ response files found for this channel, using first found: " + string5);
        }
        if (string5 == null) {
            throw new Exception("No file in directory: " + string + " with name: " + string4);
        }
        String string6 = string + File.separator + string5;
        return string6;
    }

    public TimeInstant getRefTimeInstant() {
        return this.refTimeInstant;
    }

    public SeismogramURL getSeismogramURL() {
        return this.seismogramURL;
    }

    public String toString() {
        String string = System.getProperty("line.separator");
        String string2 = super.toString();
        string2 = string2 + "responseFileName:" + this.seismogramURL.responseFileName + string;
        string2 = string2 + string;
        return string2;
    }

    public String toStringConcise() {
        String string;
        String string2 = System.getProperty("line.separator");
        String string3 = SeisGramText.NETWORK + ": " + this.channel.network + string2 + SeisGramText.STATION + ": " + this.channel.staName + string2;
        if (this.seisFrame.isSchool() && (string = this.getHeaderFieldStringValue("KUSER0")) != UNDEF_STRING) {
            string3 = string3 + SeisGramText.EMPLACEMENT + ": " + string.replace('_', ' ');
            string = this.getHeaderFieldStringValue("KUSER1");
            if (string != UNDEF_STRING) {
                string3 = string3 + string.replace('_', ' ');
                string = this.getHeaderFieldStringValue("KUSER2");
                if (string != UNDEF_STRING) {
                    string3 = string3 + string.replace('_', ' ');
                }
            }
            string3 = string3 + string2;
        }
        if (this.channel.staPosition != null) {
            if (this.channel.staPosition.latitude != Double.MAX_VALUE) {
                string3 = string3 + SeisGramText.STATION + " " + SeisGramText.LATITUDE + ": " + NUMBER_FORMAT_FRACT_3.format(this.channel.staPosition.latitude) + string2;
            }
            if (this.channel.staPosition.longitude != Double.MAX_VALUE) {
                string3 = string3 + SeisGramText.STATION + " " + SeisGramText.LONGITUDE + ": " + NUMBER_FORMAT_FRACT_3.format(this.channel.staPosition.longitude) + string2;
            }
            if (this.channel.staPosition.elevation != Double.MAX_VALUE) {
                string3 = string3 + SeisGramText.STATION + " " + SeisGramText.ELEVATION_M + ": " + NUMBER_FORMAT_FRACT_3.format(this.channel.staPosition.elevation * 1000.0) + string2;
            }
            if (!this.seisFrame.isSchool() && this.channel.staPosition.depth != Double.MAX_VALUE) {
                string3 = string3 + SeisGramText.STATION + " " + SeisGramText.DEPTH_KM + ": " + NUMBER_FORMAT_FRACT_3.format(this.channel.staPosition.depth) + string2;
            }
        }
        string3 = string3 + SeisGramText.INSTRUMENT + ": " + this.channel.instName + string2;
        string3 = string3 + SeisGramText.CHANNEL + ": " + this.channel.chanName + string2;
        if (!this.seisFrame.isSchool()) {
            string3 = string3 + SeisGramText.LOCATION + ": " + this.channel.locName + string2;
            string3 = string3 + SeisGramText.COMPONENT + ": " + this.channel.compName + string2;
        }
        string3 = string3 + string2;
        string3 = string3 + SeisGramText.EVENT_NAME + ": " + this.evtName + string2;
        if (this.hypocenter != null) {
            this.hypocenter.otime.setLocale(SeisGramText.getLocaleString());
            string3 = string3 + SeisGramText.ORIGIN_TIME + ": " + this.hypocenter.otime + string2;
            if (this.hypocenter.position.latitude != Double.MAX_VALUE) {
                string3 = string3 + SeisGramText.LATITUDE + ": " + NUMBER_FORMAT_FRACT_3.format(this.hypocenter.position.latitude) + string2;
            }
            if (this.hypocenter.position.longitude != Double.MAX_VALUE) {
                string3 = string3 + SeisGramText.LONGITUDE + ": " + NUMBER_FORMAT_FRACT_3.format(this.hypocenter.position.longitude) + string2;
            }
            if (this.hypocenter.position.elevation != Double.MAX_VALUE) {
                string3 = string3 + SeisGramText.ELEVATION_M + ": " + NUMBER_FORMAT_FRACT_3.format(this.hypocenter.position.elevation * 1000.0) + string2;
            }
            if (this.hypocenter.position.depth != Double.MAX_VALUE) {
                string3 = string3 + SeisGramText.DEPTH_KM + ": " + NUMBER_FORMAT_FRACT_3.format(this.hypocenter.position.depth) + string2;
            }
            if (this.hypocenter.mag != Double.MAX_VALUE) {
                string3 = string3 + SeisGramText.MAGNITUDE + ": " + NUMBER_FORMAT_FRACT_3.format(this.hypocenter.mag) + string2;
            }
            if (this.seisFrame.isSchool()) {
                string3 = string3 + string2;
            }
            if (this.dist != Double.MAX_VALUE) {
                string3 = string3 + SeisGramText.DISTANCE_KM + ": " + NUMBER_FORMAT_FRACT_3.format(this.dist) + string2;
            }
            if (this.gcarc != Double.MAX_VALUE) {
                string3 = string3 + SeisGramText.DISTANCE_DEG + ": " + NUMBER_FORMAT_FRACT_3.format(this.gcarc) + string2;
            }
            if (this.az != Double.MAX_VALUE) {
                string3 = string3 + SeisGramText.AZIMUTH + (this.seisFrame.isSchool() ? SeisGramText.FROM_EARTHQUAKE_TO_STATION : "") + ": " + NUMBER_FORMAT_FRACT_3.format(this.az) + string2;
            }
            if (!this.seisFrame.isSchool() && this.baz != Double.MAX_VALUE) {
                string3 = string3 + SeisGramText.BACK_AZIMUTH + ": " + NUMBER_FORMAT_FRACT_3.format(this.baz) + string2;
            }
        }
        return string3;
    }

    public String toStringStationLocation() {
        String string = System.getProperty("line.separator");
        String string2 = "GTSRCE  " + this.channel.staName + "  LATLON  ";
        if (this.channel.staPosition != null) {
            string2 = this.channel.staPosition.latitude != Double.MAX_VALUE ? string2 + (float)this.channel.staPosition.latitude + "  " : string2 + "0  ";
            string2 = this.channel.staPosition.longitude != Double.MAX_VALUE ? string2 + (float)this.channel.staPosition.longitude + "  " : string2 + "0  ";
            string2 = this.channel.staPosition.depth != Double.MAX_VALUE ? string2 + (float)this.channel.staPosition.depth + "  " : string2 + "0  ";
            string2 = this.channel.staPosition.elevation != Double.MAX_VALUE ? string2 + (float)this.channel.staPosition.elevation : string2 + "0  ";
        }
        return string2;
    }

    public void applyTimeDomainProcess(TimeDomainProcess timeDomainProcess, boolean bl) throws TimeDomainException {
        if (bl) {
            if (this.onReadTimeDomainProcesses == null) {
                this.onReadTimeDomainProcesses = new Vector();
            }
            timeDomainProcess = TimeDomainProcess.copy(timeDomainProcess);
            this.onReadTimeDomainProcesses.add(timeDomainProcess);
            timeDomainProcess.setUseMemory(true);
        }
        super.applyTimeDomainProcess(timeDomainProcess);
    }
}

