/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.seisgram2k.calc;

import java.io.File;
import java.io.Serializable;
import java.util.Vector;
import net.alomax.io.LogFile;
import net.alomax.math.XMath;
import net.alomax.math.stat.StatUtils;
import net.alomax.math.stat.WeightedValue;
import net.alomax.seis.BasicSeismogram;
import net.alomax.seisgram2k.GatherPanel;
import net.alomax.seisgram2k.PhaseSet;
import net.alomax.seisgram2k.SeisGram2KFrame;
import net.alomax.seisgram2k.SeisPick;
import net.alomax.seisgram2k.Seismogram;
import net.alomax.seisgram2k.calc.Calculator;
import net.alomax.seisgram2k.calc.CalculatorException;
import net.alomax.seisgram2k.calc.CalculatorText;
import net.alomax.util.NumberFormat;
import net.alomax.util.PhysicalUnits;
import org.apache.commons.math.stat.descriptive.DescriptiveStatistics;

public class AmplitudeDurationMagnitudeCalculator
implements Calculator {
    public static final double VELOCITY_POWER = 1.0;
    public static final double VELOCITY_CONST = 1.26E10;
    public static final double ENERGY_CONST = 2.17E15;
    public static final double MWPD_CONST = 1.886E19;
    public static final double MWPD_MO_CORR_POWER = 0.45;
    public static final double MWPD_MO_MIN = 7.94E19;
    public static final double MWP_CONST = 42725.66008882118 * Math.pow(7900.0, 3.0) * 2.0 * 1000.0;
    public static double MW_MULTIPLIER = 0.6666666666666666;
    public static double MW_CONSTANT = 9.1;
    public static double SIGNAL_TO_NOISE_RATIO_MIN = 2.0;
    public static final int MODE_ACTIVE_GATHER = 0;
    public static final int MODE_ALL_GATHERS = 1;
    protected int mode = 0;
    public static final int TYPE_VELOCITY = 0;
    public static final int TYPE_DISPLACEMNT = 1;
    public static final int TYPE_DURATION = 2;
    protected int algorithmType = 0;
    public static final int VARIANT_NULL = 0;
    public static final int VARIANT_MWPD = 1;
    public static final int VARIANT_MWP = 2;
    protected int variant = 0;
    public static final String MAG_NAME_NULL = "Mdur-amp";
    public static final String MAG_NAME_MWPD = "Mwpd";
    public static final String MAG_NAME_MWP = "Mwp";
    protected String magnitudeName = "Mdur-amp";
    protected String durationName = "To";
    protected static double MWPD_DISTANCE_MIN = 30.0;
    public static double DEFAULT_MAG_PERCENTILE = 10.0;
    protected double magnitudePercentile = DEFAULT_MAG_PERCENTILE;
    protected SeisGram2KFrame seisFrame = null;
    protected boolean verbose = false;
    public String logFileName = null;
    protected LogFile logFile = null;
    public String csvFileName = null;
    protected LogFile csvFile = null;
    public String sumFileName = null;
    protected LogFile sumFile = null;
    public String stationLogFileName = null;
    protected LogFile stationLogFile = null;
    public static final double COEFF_MED = 1.55E10;
    public static double AZ_WT_CUTOFF_DISTANCE = 15.0;

    public AmplitudeDurationMagnitudeCalculator(int n, int n2, SeisGram2KFrame seisGram2KFrame) {
        this(n, n2, seisGram2KFrame, 0, DEFAULT_MAG_PERCENTILE);
    }

    public AmplitudeDurationMagnitudeCalculator(int n, int n2, SeisGram2KFrame seisGram2KFrame, int n3, double d) {
        String string;
        this.mode = n;
        this.algorithmType = n2;
        this.seisFrame = seisGram2KFrame;
        this.variant = n3;
        this.magnitudePercentile = d;
        this.magnitudeName = MAG_NAME_NULL;
        if (n3 == 1) {
            this.magnitudeName = MAG_NAME_MWPD;
        }
        if (n3 == 2) {
            this.magnitudeName = MAG_NAME_MWP;
            this.durationName = "T";
        }
        string = (string = seisGram2KFrame.getIOPath()) == null ? "" : string + File.separator;
        this.stationLogFileName = string + this.magnitudeName + ".station.csv";
        this.stationLogFile = new LogFile(this.stationLogFileName);
        this.logFileName = string + this.magnitudeName + ".log";
        this.logFile = new LogFile(this.logFileName);
        this.csvFileName = string + this.magnitudeName + ".csv";
        this.csvFile = new LogFile(this.csvFileName);
        this.sumFileName = string + this.magnitudeName + ".sum";
        this.sumFile = new LogFile(this.sumFileName);
    }

    public void calculate() throws CalculatorException {
        if (this.mode == 0) {
            this.seisFrame.writeMessage(" ");
            GatherPanel gatherPanel = this.seisFrame.getActiveGather();
            if (this.algorithmType == 2) {
                this.calculateDuration(gatherPanel);
            } else {
                this.calculate(gatherPanel, null, null);
            }
        } else if (this.mode == 1) {
            this.seisFrame.writeMessage(" ");
            GatherPanel gatherPanel = null;
            Vector vector = new Vector();
            for (int i = 0; i < this.seisFrame.getGatherListSize(); ++i) {
                GatherPanel gatherPanel2 = this.seisFrame.getGatherListElementAt(i);
                try {
                    this.calculate(gatherPanel2, gatherPanel, vector);
                }
                catch (CalculatorException calculatorException) {
                    this.seisFrame.writeMessage(calculatorException.getMessage());
                    System.out.println(calculatorException.getMessage());
                }
                gatherPanel = gatherPanel2;
            }
            this.calculateAverage(this.seisFrame);
        }
    }

    public double calculateTheta(double d, double d2) {
        double d3 = XMath.log10(d / Math.pow(d2, 3.0) / Math.pow(1.55E10, 2.0));
        return d3;
    }

    public double calculateMoment(double d, double d2) {
        double d3 = 0.0;
        d3 = this.algorithmType == 1 ? (this.variant == 1 ? 1.886E19 * d : MWP_CONST * d) : 1.26E10 * Math.sqrt(d) * Math.pow(d2, 1.0);
        return d3;
    }

    public double calculateCorrectedMoment(double d) {
        double d2 = 0.0;
        d2 = this.algorithmType == 1 ? (this.variant == 1 && d > 7.94E19 ? d * Math.pow(d / 7.94E19, 0.45) : d) : d;
        return d2;
    }

    public double calculateMagnitude(double d) {
        return MW_MULTIPLIER * (XMath.log10(d) - MW_CONSTANT);
    }

    public void calculate(GatherPanel gatherPanel, GatherPanel gatherPanel2, Vector vector) throws CalculatorException {
        double d;
        Object object;
        PhaseSet phaseSet = this.seisFrame.getPickList();
        String string = "";
        boolean bl = false;
        double d2 = 0.0;
        boolean bl2 = false;
        double d3 = 0.0;
        boolean bl3 = false;
        double d4 = 0.0;
        boolean bl4 = false;
        double d5 = 0.0;
        double d6 = Double.MAX_VALUE;
        double d7 = Double.MAX_VALUE;
        double d8 = Double.MAX_VALUE;
        SeisPick seisPick = null;
        for (int i = 0; i < phaseSet.size(); ++i) {
            seisPick = (SeisPick)phaseSet.elementAt(i);
            if (seisPick.getStatus() == 2 || seisPick.belongsTo(gatherPanel) < 0) continue;
            if (gatherPanel2 != null && seisPick.belongsTo(gatherPanel2) >= 0) {
                return;
            }
            if (vector != null) {
                for (int j = 0; j < vector.size(); ++j) {
                    object = (SeisPick)vector.elementAt(j);
                    if (((SeisPick)object).belongsTo(gatherPanel) < 0) continue;
                    return;
                }
            }
            if (seisPick.name.equalsIgnoreCase("To")) {
                if (bl && seisPick.dateTimeToTime(gatherPanel) > d2) continue;
                bl = true;
                d2 = seisPick.dateTimeToTime(gatherPanel);
            }
            if (seisPick.name.equalsIgnoreCase("P")) {
                if (bl2 && seisPick.dateTimeToTime(gatherPanel) > d3) continue;
                bl2 = true;
                d3 = seisPick.dateTimeToTime(gatherPanel);
                string = this.createPickID(seisPick);
                continue;
            }
            if (seisPick.name.equalsIgnoreCase("S")) {
                if (bl3 && seisPick.dateTimeToTime(gatherPanel) > d4) continue;
                bl3 = true;
                d4 = seisPick.dateTimeToTime(gatherPanel);
                continue;
            }
            if (seisPick.name.equals("Int_" + this.magnitudeName)) {
                bl4 = true;
                d5 = seisPick.amplitude;
                continue;
            }
            if (seisPick.name.equals("snrHF")) {
                d6 = seisPick.amplitude;
                continue;
            }
            if (seisPick.name.equals("snr_DISP_trans")) {
                d7 = seisPick.amplitude;
                continue;
            }
            if (!seisPick.name.equals("snr_DISP_rgain")) continue;
            d8 = seisPick.amplitude;
        }
        if (!bl2) {
            throw new CalculatorException(CalculatorText.missing_P_pick);
        }
        if (!bl3) {
            throw new CalculatorException(CalculatorText.missing_S_pick);
        }
        if (!bl4) {
            throw new CalculatorException(CalculatorText.missing_0P_max_pick + "\n 0-P_max id changed to Int_Mwpd, Int_Mwp, etc. AJL 20071121");
        }
        double d9 = d5;
        if (PhysicalUnits.getDefaultLengthUnits() != "m") {
            d9 *= PhysicalUnits.scaleFactor(PhysicalUnits.getDefaultLengthUnits(), "m");
        }
        if (this.algorithmType == 0) {
            d9 *= 2.17E15;
        }
        object = this.calculateDuration(gatherPanel);
        if (this.variant != 2 && (d = d4 - d3) < ((WeightedValue)object).value) {
            d9 *= ((WeightedValue)object).value / d;
            String string2 = "INFO: " + seisPick.toStringConcise() + ": Ts-Tp < Tdur, amplitudeIntegral scaled by Tdur/(Ts-Tp)= " + (float)(((WeightedValue)object).value / d);
            this.seisFrame.writeMessage(string2);
            System.out.println(string2);
        }
        d = this.calculateMoment(d9, ((WeightedValue)object).value);
        double d10 = this.calculateMagnitude(d);
        double d11 = d6 / SIGNAL_TO_NOISE_RATIO_MIN;
        double d12 = d7 / SIGNAL_TO_NOISE_RATIO_MIN;
        double d13 = d8 / SIGNAL_TO_NOISE_RATIO_MIN;
        double d14 = 0.0;
        d14 = this.variant == 2 ? d13 : Math.min(d11, d12);
        String string3 = this.magnitudeName + ": " + string + ": " + this.infoString(false, d9, -999.0, ((WeightedValue)object).value, -999.0, d, -999.0, d10, -999.0) + ", snrWeightHF: " + d11 + ", snrWeightDispTrans: " + d12 + ", snrWeightDispRgain: " + d13;
        if (this.verbose) {
            this.seisFrame.writeMessage(" " + string3);
            System.out.println(string3);
        }
        SeisPick seisPick2 = new SeisPick(this.seisFrame, gatherPanel);
        seisPick2.init();
        seisPick2.setStaInst(gatherPanel, 0);
        seisPick2.setDateTime(gatherPanel, d3);
        seisPick2.name = "Mo";
        seisPick2.amplitude = d;
        this.seisFrame.addElementToPickList(seisPick2, false);
        seisPick2 = new SeisPick(this.seisFrame, gatherPanel);
        seisPick2.init();
        seisPick2.setStaInst(gatherPanel, 0);
        seisPick2.setDateTime(gatherPanel, d2);
        seisPick2.name = this.magnitudeName;
        seisPick2.amplitude = d10;
        seisPick2.duration = ((WeightedValue)object).value;
        seisPick2.uncertainty = d14;
        seisPick2.uncertaintyType = "wt_snr";
        seisPick2.period = d9;
        this.seisFrame.addElementToPickList(seisPick2, false);
        this.seisFrame.writePicks(false, false);
        vector.add(seisPick2);
    }

    public WeightedValue calculateDuration(GatherPanel gatherPanel) throws CalculatorException {
        Object object;
        PhaseSet phaseSet = this.seisFrame.getPickList();
        String string = "";
        boolean bl = false;
        double d = 0.0;
        boolean bl2 = false;
        double d2 = 0.0;
        boolean bl3 = false;
        double d3 = 0.0;
        boolean bl4 = false;
        double d4 = 0.0;
        boolean bl5 = false;
        double d5 = 0.0;
        for (int i = 0; i < phaseSet.size(); ++i) {
            SeisPick seisPick = (SeisPick)phaseSet.elementAt(i);
            if (seisPick.getStatus() == 2 || seisPick.belongsTo(gatherPanel) < 0) continue;
            if (seisPick.name.equalsIgnoreCase("P")) {
                if (bl && seisPick.dateTimeToTime(gatherPanel) > d) continue;
                bl = true;
                d = seisPick.dateTimeToTime(gatherPanel);
                string = this.createPickID(seisPick);
            }
            if (seisPick.name.equals("T0.9")) {
                bl2 = true;
                d2 = seisPick.dateTimeToTime(gatherPanel);
            } else if (seisPick.name.equals("T0.8")) {
                bl3 = true;
                d3 = seisPick.dateTimeToTime(gatherPanel);
            } else if (seisPick.name.startsWith("T0.5")) {
                bl4 = true;
                d4 = seisPick.dateTimeToTime(gatherPanel);
            } else if (seisPick.name.equals("T0.2")) {
                bl5 = true;
                d5 = seisPick.dateTimeToTime(gatherPanel);
            }
            if (bl && bl2 && bl3 && bl4 && bl5) break;
        }
        if (!bl) {
            throw new CalculatorException(CalculatorText.missing_P_pick);
        }
        if (!bl2) {
            throw new CalculatorException(CalculatorText.missing_T_pick + ": T09");
        }
        if (!bl3) {
            throw new CalculatorException(CalculatorText.missing_T_pick + ": T08");
        }
        if (!bl4) {
            throw new CalculatorException(CalculatorText.missing_T_pick + ": T05");
        }
        if (!bl5) {
            throw new CalculatorException(CalculatorText.missing_T_pick + ": T02");
        }
        double d6 = (d4 + d3) / 2.0 - d;
        double d7 = (d6 - 20.0) / 40.0;
        if (d7 < 0.0) {
            d7 = 0.0;
        } else if (d7 > 1.0) {
            d7 = 1.0;
        }
        double d8 = (d2 - d) * (1.0 - d7) + (d5 - d) * d7;
        double d9 = 1.0 - (d5 - d4) / d8;
        if (d9 < 0.0) {
            d9 = 0.0;
        }
        if (d8 < 0.0) {
            d8 = 0.0;
            d9 = 0.0;
        }
        if (this.verbose) {
            object = this.magnitudeName + ": " + string + ": Tdur: " + (float)d8 + " wt_dur: " + (float)d9 + ")";
            this.seisFrame.writeMessage(" " + (String)object);
            System.out.println((String)object);
        }
        object = new SeisPick(this.seisFrame, gatherPanel);
        ((SeisPick)object).init();
        ((SeisPick)object).setStaInst(gatherPanel, 0);
        ((SeisPick)object).setDateTime(gatherPanel, d + d8);
        ((SeisPick)object).name = "Tdur";
        ((SeisPick)object).amplitude = d8;
        ((SeisPick)object).uncertainty = d9;
        ((SeisPick)object).uncertaintyType = "wt_dur";
        this.seisFrame.addElementToPickList((SeisPick)object, false);
        this.seisFrame.writePicks(false, false);
        return new WeightedValue(d8, d9);
    }

    public void calculateAverage(SeisGram2KFrame seisGram2KFrame) throws CalculatorException {
        Serializable serializable;
        double d;
        double d2;
        double d3;
        double d4;
        double d5;
        Object object;
        String string = null;
        String string2 = null;
        PhaseSet phaseSet = seisGram2KFrame.getPickList();
        Vector<DurationAmplitudeValues> vector = new Vector<DurationAmplitudeValues>();
        String string3 = "";
        String string4 = "";
        String string5 = "";
        String string6 = "";
        boolean bl = false;
        for (int i = 0; i < phaseSet.size(); ++i) {
            int n;
            SeisPick seisPick = (SeisPick)phaseSet.elementAt(i);
            if (seisPick.getStatus() == 2) continue;
            for (n = 0; !(n >= i || ((SeisPick)(object = (SeisPick)phaseSet.elementAt(n))).getStatus() != 2 && seisPick.isSameAs((SeisPick)object)); ++n) {
            }
            if (n < i || !seisPick.name.equals(this.magnitudeName)) continue;
            string3 = seisPick.getTimeStringSeparated(".", ".", ".");
            if (!bl) {
                this.logFile.write(this.magnitudeName + " Duration-Amplitude results for event: " + string3 + " ==============");
                bl = true;
            }
            object = this.createPickID(seisPick);
            double d6 = seisPick.duration;
            double d7 = 1.0;
            d5 = seisPick.uncertainty;
            d4 = seisPick.period;
            double d8 = Double.MAX_VALUE;
            d3 = Double.MAX_VALUE;
            GatherPanel gatherPanel = seisPick.gatherFor();
            d2 = -1.7976931348623158E307;
            if (gatherPanel != null) {
                d2 = seisPick.dateTimeToTime(gatherPanel);
            }
            d = 1.7976931348623158E307;
            serializable = seisPick.seismogramFor();
            if (serializable != null) {
                d8 = ((Seismogram)serializable).az;
                d3 = ((Seismogram)serializable).gcarc;
                d = ((BasicSeismogram)serializable).getTimeMax();
            }
            if (d3 == Double.MAX_VALUE) {
                string = "WARNING: skipping channel with undefined gcarc distance > 10.0: " + seisPick.toStringConcise();
                seisGram2KFrame.writeMessage(string);
                this.logFile.write(string);
                System.out.println(string);
                continue;
            }
            if (this.variant == 1 && d3 < MWPD_DISTANCE_MIN) {
                string4 = string4 + seisPick.toStringConcise() + ", ";
                continue;
            }
            DurationAmplitudeValues durationAmplitudeValues = new DurationAmplitudeValues((String)object, new WeightedValue(d6, d7), d4, d8, d3);
            durationAmplitudeValues.moment = this.calculateMoment(durationAmplitudeValues.amplitudeIntegral, durationAmplitudeValues.duration.value);
            durationAmplitudeValues.magnitude = this.calculateMagnitude(durationAmplitudeValues.moment);
            if (this.verbose) {
                string = this.magnitudeName + " Duration-Amplitude Ave: " + durationAmplitudeValues.pickID + ": " + this.infoString(false, durationAmplitudeValues.amplitudeIntegral, -999.0, durationAmplitudeValues.duration.value, -999.0, durationAmplitudeValues.moment, -999.0, durationAmplitudeValues.magnitude, -999.0);
                seisGram2KFrame.writeMessage(" " + string);
                this.logFile.write(string);
                System.out.println(string);
            }
            this.stationLogFile.write(durationAmplitudeValues.toStringCSV());
            if (d5 < 1.0) {
                string5 = string5 + seisPick.toStringConcise() + ", ";
                continue;
            }
            if (durationAmplitudeValues.duration.value > 0.95 * (d - d2)) {
                string = "WARNING: skipping channel with duration > 0.95 * trace length: " + seisPick.toStringConcise();
                seisGram2KFrame.writeMessage(string);
                this.logFile.write(string);
                System.out.println(string);
                continue;
            }
            if (durationAmplitudeValues.magnitude > 10.0) {
                string = "WARNING: skipping channel with magnitude > 10.0 (gain problem?): " + seisPick.toStringConcise();
                seisGram2KFrame.writeMessage(string);
                this.logFile.write(string);
                System.out.println(string);
                continue;
            }
            if (durationAmplitudeValues.magnitude < 2.0) {
                string = "WARNING: skipping channel with magnitude < 2.0 (gain problem?): " + seisPick.toStringConcise();
                seisGram2KFrame.writeMessage(string);
                this.logFile.write(string);
                System.out.println(string);
                continue;
            }
            string6 = string6 + seisPick.toStringConcise() + ", ";
            System.out.println("accepted pick: " + seisPick.toStringConcise());
            vector.add(durationAmplitudeValues);
        }
        if (string6.length() > 0) {
            string = "INFO: channels used: " + string6;
            seisGram2KFrame.writeMessage(string);
            this.logFile.write(string);
            System.out.println(string);
        }
        if (string4.length() > 0) {
            string = "INFO: skipped channels with distance < " + MWPD_DISTANCE_MIN + " deg: " + string4;
            seisGram2KFrame.writeMessage(string);
            this.logFile.write(string);
            System.out.println(string);
        }
        if (string5.length() > 0) {
            string = "INFO: skipped channels with BB or HF S/N amplitude ratio < " + SIGNAL_TO_NOISE_RATIO_MIN + ": " + string5;
            seisGram2KFrame.writeMessage(string);
            this.logFile.write(string);
            System.out.println(string);
        }
        if (vector.size() < 1) {
            this.csvFile.write("ERROR: " + CalculatorText.no_da_picks_found);
            this.logFile.write("ERROR: " + CalculatorText.no_da_picks_found);
            this.logFile.write("");
            this.logFile.close();
            this.csvFile.close();
            this.sumFile.close();
            this.stationLogFile.close();
            throw new CalculatorException(CalculatorText.no_da_picks_found);
        }
        DescriptiveStatistics descriptiveStatistics = DescriptiveStatistics.newInstance();
        DescriptiveStatistics descriptiveStatistics2 = DescriptiveStatistics.newInstance();
        object = DescriptiveStatistics.newInstance();
        DescriptiveStatistics descriptiveStatistics3 = DescriptiveStatistics.newInstance();
        for (int i = 0; i < vector.size(); ++i) {
            DurationAmplitudeValues durationAmplitudeValues = (DurationAmplitudeValues)vector.elementAt(i);
            descriptiveStatistics.addValue(durationAmplitudeValues.amplitudeIntegral);
            descriptiveStatistics2.addValue(durationAmplitudeValues.duration.value);
            ((DescriptiveStatistics)object).addValue(durationAmplitudeValues.magnitude);
            descriptiveStatistics3.addValue(durationAmplitudeValues.moment);
        }
        String string7 = "";
        if (this.algorithmType == 0) {
            string7 = "E(N-m)";
        } else if (this.algorithmType == 2) {
            string7 = "ampInt";
        }
        if (this.verbose) {
            string = this.magnitudeName + " Duration-Amplitude Statistics: for " + vector.size() + " entries individually:" + "\n   " + string7 + ": " + " mean=" + NumberFormat.doubleString(descriptiveStatistics.getMean(), -1, 2) + ", geom_mean=" + NumberFormat.doubleString(descriptiveStatistics.getGeometricMean(), -1, 2) + ", std_dev=" + NumberFormat.doubleString(descriptiveStatistics.getStandardDeviation(), -1, 2) + ", kurt=" + NumberFormat.doubleString(descriptiveStatistics.getKurtosis(), -1, 2) + ", skew=" + NumberFormat.doubleString(descriptiveStatistics.getSkewness(), -1, 2) + ", 10%=" + NumberFormat.doubleString(descriptiveStatistics.getPercentile(10.0), -1, 2) + ", 20%=" + NumberFormat.doubleString(descriptiveStatistics.getPercentile(20.0), -1, 2) + ", 50%=" + NumberFormat.doubleString(descriptiveStatistics.getPercentile(50.0), -1, 2) + ", 80%=" + NumberFormat.doubleString(descriptiveStatistics.getPercentile(80.0), -1, 2) + ", 90%=" + NumberFormat.doubleString(descriptiveStatistics.getPercentile(90.0), -1, 2) + "\n   " + this.durationName + "(s): " + " mean=" + NumberFormat.doubleString(descriptiveStatistics2.getMean(), -1, 2) + ", geom_mean=" + NumberFormat.doubleString(descriptiveStatistics2.getGeometricMean(), -1, 2) + ", std_dev=" + NumberFormat.doubleString(descriptiveStatistics2.getStandardDeviation(), -1, 2) + ", kurt=" + NumberFormat.doubleString(descriptiveStatistics2.getKurtosis(), -1, 2) + ", skew=" + NumberFormat.doubleString(descriptiveStatistics2.getSkewness(), -1, 2) + ", 10%=" + NumberFormat.doubleString(descriptiveStatistics2.getPercentile(10.0), -1, 2) + ", 20%=" + NumberFormat.doubleString(descriptiveStatistics2.getPercentile(20.0), -1, 2) + ", 50%=" + NumberFormat.doubleString(descriptiveStatistics2.getPercentile(50.0), -1, 2) + ", 80%=" + NumberFormat.doubleString(descriptiveStatistics2.getPercentile(80.0), -1, 2) + ", 90%=" + NumberFormat.doubleString(descriptiveStatistics2.getPercentile(90.0), -1, 2) + "\n   Mo: " + " mean=" + NumberFormat.doubleString(descriptiveStatistics3.getMean(), -1, 2) + ", geom_mean=" + NumberFormat.doubleString(descriptiveStatistics3.getGeometricMean(), -1, 2) + ", std_dev=" + NumberFormat.doubleString(descriptiveStatistics3.getStandardDeviation(), -1, 2) + ", kurt=" + NumberFormat.doubleString(descriptiveStatistics3.getKurtosis(), -1, 2) + ", skew=" + NumberFormat.doubleString(descriptiveStatistics3.getSkewness(), -1, 2) + ", 10%=" + NumberFormat.doubleString(descriptiveStatistics3.getPercentile(10.0), -1, 2) + ", 20%=" + NumberFormat.doubleString(descriptiveStatistics3.getPercentile(20.0), -1, 2) + ", 50%=" + NumberFormat.doubleString(descriptiveStatistics3.getPercentile(50.0), -1, 2) + ", 80%=" + NumberFormat.doubleString(descriptiveStatistics3.getPercentile(80.0), -1, 2) + ", 90%=" + NumberFormat.doubleString(descriptiveStatistics3.getPercentile(90.0), -1, 2) + "\n   M: " + " mean=" + NumberFormat.doubleString(((DescriptiveStatistics)object).getMean(), -1, 2) + ", geom_mean=" + NumberFormat.doubleString(((DescriptiveStatistics)object).getGeometricMean(), -1, 2) + ", std_dev=" + NumberFormat.doubleString(((DescriptiveStatistics)object).getStandardDeviation(), -1, 2) + ", kurt=" + NumberFormat.doubleString(((DescriptiveStatistics)object).getKurtosis(), -1, 2) + ", skew=" + NumberFormat.doubleString(((DescriptiveStatistics)object).getSkewness(), -1, 2) + ", 10%=" + NumberFormat.doubleString(((DescriptiveStatistics)object).getPercentile(10.0), -1, 2) + ", 20%=" + NumberFormat.doubleString(((DescriptiveStatistics)object).getPercentile(20.0), -1, 2) + ", 50%=" + NumberFormat.doubleString(((DescriptiveStatistics)object).getPercentile(50.0), -1, 2) + ", 80%=" + NumberFormat.doubleString(((DescriptiveStatistics)object).getPercentile(80.0), -1, 2) + ", 90%=" + NumberFormat.doubleString(((DescriptiveStatistics)object).getPercentile(90.0), -1, 2);
            seisGram2KFrame.writeMessage(" " + string);
            this.logFile.write(string);
            System.out.println(string);
        }
        string = this.magnitudeName + " Duration-Amplitude Statistics: for " + vector.size() + " channels total:";
        seisGram2KFrame.writeMessage(" " + string);
        this.logFile.write("");
        this.logFile.write(string);
        System.out.println(string);
        for (double d9 = 1.0E-5; d9 < 50.0; d9 += 10.0) {
            d5 = descriptiveStatistics.getPercentile(d9);
            d4 = descriptiveStatistics.getPercentile(100.0 - d9);
            DescriptiveStatistics descriptiveStatistics4 = DescriptiveStatistics.newInstance();
            int n = 0;
            while ((long)n < descriptiveStatistics.getN()) {
                d3 = descriptiveStatistics.getElement(n);
                if (d3 >= d5 && d3 <= d4) {
                    descriptiveStatistics4.addValue(d3);
                }
                ++n;
            }
            double d10 = descriptiveStatistics4.getGeometricMean();
            double d11 = descriptiveStatistics4.getStandardDeviation();
            d2 = descriptiveStatistics2.getPercentile(d9);
            d = descriptiveStatistics2.getPercentile(100.0 - d9);
            serializable = DescriptiveStatistics.newInstance();
            int n2 = 0;
            while ((long)n2 < descriptiveStatistics2.getN()) {
                double d12 = descriptiveStatistics2.getElement(n2);
                if (d12 >= d2 && d12 <= d) {
                    ((DescriptiveStatistics)serializable).addValue(d12);
                }
                ++n2;
            }
            double d13 = ((DescriptiveStatistics)serializable).getGeometricMean();
            double d14 = ((DescriptiveStatistics)serializable).getStandardDeviation();
            double d15 = descriptiveStatistics3.getPercentile(d9);
            double d16 = descriptiveStatistics3.getPercentile(100.0 - d9);
            DescriptiveStatistics descriptiveStatistics5 = DescriptiveStatistics.newInstance();
            int n3 = 0;
            while ((long)n3 < descriptiveStatistics3.getN()) {
                double d17 = descriptiveStatistics3.getElement(n3);
                if (d17 >= d15 && d17 <= d16) {
                    descriptiveStatistics5.addValue(d17);
                }
                ++n3;
            }
            double d18 = descriptiveStatistics5.getGeometricMean();
            double d19 = descriptiveStatistics5.getStandardDeviation();
            double d20 = ((DescriptiveStatistics)object).getPercentile(d9);
            double d21 = ((DescriptiveStatistics)object).getPercentile(100.0 - d9);
            DescriptiveStatistics descriptiveStatistics6 = DescriptiveStatistics.newInstance();
            int n4 = 0;
            while ((long)n4 < ((DescriptiveStatistics)object).getN()) {
                double d22 = ((DescriptiveStatistics)object).getElement(n4);
                if (d22 >= d20 && d22 <= d21) {
                    descriptiveStatistics6.addValue(d22);
                }
                ++n4;
            }
            double d23 = descriptiveStatistics6.getMean();
            double d24 = descriptiveStatistics6.getStandardDeviation();
            string = "   " + Math.round(d9) + "-" + Math.round(100.0 - d9) + "% trimmed stats (" + " NumInt=" + descriptiveStatistics4.getN();
            string = string + " NumTo=" + ((DescriptiveStatistics)serializable).getN();
            string = string + "):\n      Mean: " + this.infoString(false, d10, d11, d13, d14, d18, d19, d23, d24);
            seisGram2KFrame.writeMessage(" " + string);
            this.logFile.write(string);
            System.out.println(string);
            if (!(d9 > this.magnitudePercentile - 1.0) || !(d9 < this.magnitudePercentile + 1.0)) continue;
            boolean bl2 = false;
            if (!bl2) {
                this.sumFile.write(string);
                string = string3 + " " + this.infoString(true, d10, d11, d13, d14, d18, d19, d23, d24);
                string2 = string = string + " " + descriptiveStatistics4.getN();
                this.csvFile.write(string);
                continue;
            }
            this.sumFile.write(string);
            System.out.println("Azimuth test:");
            d10 = AmplitudeDurationMagnitudeCalculator.azimuthalWeightedGeometricMeanAmplitudeIntegral(descriptiveStatistics4, vector);
            d11 = 1.0;
            d13 = AmplitudeDurationMagnitudeCalculator.azimuthalWeightedGeometricMeanDuration((DescriptiveStatistics)serializable, vector);
            d14 = 1.0;
            d18 = AmplitudeDurationMagnitudeCalculator.azimuthalWeightedGeometricMeanMoment(descriptiveStatistics5, vector);
            d19 = 1.0;
            d23 = AmplitudeDurationMagnitudeCalculator.azimuthalWeightedMeanMagnitude(descriptiveStatistics6, vector);
            d24 = 1.0;
            string = string3 + " " + this.infoString(true, d10, d11, d13, d14, d18, d19, d23, d24);
            string2 = string = string + " " + descriptiveStatistics4.getN();
            this.csvFile.write(string);
            System.out.println();
            System.out.println(string);
        }
        this.logFile.write("");
        this.logFile.write(string2);
        this.logFile.write("");
        this.logFile.close();
        this.csvFile.close();
        this.sumFile.close();
        this.stationLogFile.close();
    }

    public String createPickID(SeisPick seisPick) {
        String string = seisPick.getTimeStringSeparated(".", ".", ".") + "." + seisPick.network + "." + seisPick.staName + "." + seisPick.instName + "." + seisPick.compName + "." + seisPick.compCode;
        return string;
    }

    public static double azimuthalWeightedMeanMagnitude(DescriptiveStatistics descriptiveStatistics, Vector vector) {
        double[] dArray = new double[(int)descriptiveStatistics.getN()];
        double[] dArray2 = new double[(int)descriptiveStatistics.getN()];
        double d = descriptiveStatistics.getMin();
        double d2 = descriptiveStatistics.getMax();
        int n = 0;
        for (int i = 0; i < vector.size(); ++i) {
            DurationAmplitudeValues durationAmplitudeValues = (DurationAmplitudeValues)vector.elementAt(i);
            if (!(durationAmplitudeValues.magnitude >= d) || !(durationAmplitudeValues.magnitude <= d2)) continue;
            dArray[n] = durationAmplitudeValues.magnitude;
            dArray2[n] = durationAmplitudeValues.azimuth;
            ++n;
        }
        return AmplitudeDurationMagnitudeCalculator.getAzumuthalWeightedMean(dArray, dArray2, AZ_WT_CUTOFF_DISTANCE, 360.0);
    }

    public static double azimuthalWeightedGeometricMeanDuration(DescriptiveStatistics descriptiveStatistics, Vector vector) {
        double[] dArray = new double[(int)descriptiveStatistics.getN()];
        double[] dArray2 = new double[(int)descriptiveStatistics.getN()];
        double d = descriptiveStatistics.getMin();
        double d2 = descriptiveStatistics.getMax();
        int n = 0;
        for (int i = 0; i < vector.size(); ++i) {
            DurationAmplitudeValues durationAmplitudeValues = (DurationAmplitudeValues)vector.elementAt(i);
            if (!(durationAmplitudeValues.duration.value >= d) || !(durationAmplitudeValues.duration.value <= d2)) continue;
            dArray[n] = durationAmplitudeValues.duration.value;
            dArray2[n] = durationAmplitudeValues.azimuth;
            ++n;
        }
        return AmplitudeDurationMagnitudeCalculator.getAzumuthalWeightedGeometricMean(dArray, dArray2, AZ_WT_CUTOFF_DISTANCE, 360.0);
    }

    public static double azimuthalWeightedGeometricMeanAmplitudeIntegral(DescriptiveStatistics descriptiveStatistics, Vector vector) {
        double[] dArray = new double[(int)descriptiveStatistics.getN()];
        double[] dArray2 = new double[(int)descriptiveStatistics.getN()];
        double d = descriptiveStatistics.getMin();
        double d2 = descriptiveStatistics.getMax();
        int n = 0;
        for (int i = 0; i < vector.size(); ++i) {
            DurationAmplitudeValues durationAmplitudeValues = (DurationAmplitudeValues)vector.elementAt(i);
            if (!(durationAmplitudeValues.amplitudeIntegral >= d) || !(durationAmplitudeValues.amplitudeIntegral <= d2)) continue;
            dArray[n] = durationAmplitudeValues.amplitudeIntegral;
            dArray2[n] = durationAmplitudeValues.azimuth;
            ++n;
        }
        return AmplitudeDurationMagnitudeCalculator.getAzumuthalWeightedGeometricMean(dArray, dArray2, AZ_WT_CUTOFF_DISTANCE, 360.0);
    }

    public static double azimuthalWeightedGeometricMeanMoment(DescriptiveStatistics descriptiveStatistics, Vector vector) {
        double[] dArray = new double[(int)descriptiveStatistics.getN()];
        double[] dArray2 = new double[(int)descriptiveStatistics.getN()];
        double d = descriptiveStatistics.getMin();
        double d2 = descriptiveStatistics.getMax();
        int n = 0;
        for (int i = 0; i < vector.size(); ++i) {
            DurationAmplitudeValues durationAmplitudeValues = (DurationAmplitudeValues)vector.elementAt(i);
            if (!(durationAmplitudeValues.moment >= d) || !(durationAmplitudeValues.moment <= d2)) continue;
            dArray[n] = durationAmplitudeValues.moment;
            dArray2[n] = durationAmplitudeValues.azimuth;
            ++n;
        }
        return AmplitudeDurationMagnitudeCalculator.getAzumuthalWeightedGeometricMean(dArray, dArray2, AZ_WT_CUTOFF_DISTANCE, 360.0);
    }

    public static double getAzumuthalWeightedMean(double[] dArray, double[] dArray2, double d, double d2) {
        double[] dArray3 = AmplitudeDurationMagnitudeCalculator.getAzumuthalWeights(dArray2, d, d2);
        double d3 = 0.0;
        try {
            d3 = StatUtils.mean(dArray, dArray3);
        }
        catch (Exception exception) {
            String string = "ERROR: Calculating azimuthal weighted mean: " + exception.getMessage();
            System.out.println(string);
        }
        return d3;
    }

    public static double getAzumuthalWeightedGeometricMean(double[] dArray, double[] dArray2, double d, double d2) {
        double[] dArray3 = AmplitudeDurationMagnitudeCalculator.getAzumuthalWeights(dArray2, d, d2);
        double d3 = 0.0;
        try {
            d3 = StatUtils.geometricMean(dArray, dArray3);
        }
        catch (Exception exception) {
            String string = "ERROR: Calculating azimuthal weighted geometric mean: " + exception.getMessage();
            System.out.println(string);
        }
        return d3;
    }

    public static double[] getAzumuthalWeights(double[] dArray, double d, double d2) {
        int n;
        double[] dArray2 = new double[dArray.length];
        double d3 = 0.0;
        double d4 = -1.7976931348623157E308;
        for (n = 0; n < dArray.length; ++n) {
            double d5 = dArray[n];
            double d6 = 1.0;
            for (int i = 0; i < dArray.length; ++i) {
                if (i == n) continue;
                double d7 = Math.abs(d5 - dArray[i]);
                if (d7 > d2 / 2.0) {
                    d7 = d2 - d7;
                }
                d6 += d7 <= d ? 1.0 : 0.0;
            }
            dArray2[n] = d6 = 1.0 / d6;
            d3 += d6;
            if (!(d6 > d4)) continue;
            d4 = d6;
        }
        for (n = 0; n < dArray2.length; ++n) {
            int n2 = n;
            dArray2[n2] = dArray2[n2] / d3;
            System.out.println("v=" + dArray[n] + " w=" + dArray2[n] * d3 / d4);
        }
        return dArray2;
    }

    public static void main(String[] stringArray) {
        try {
            double[] dArray = new double[]{332.1553649902344, 45.4438362121582, 112.2158966064453, 41.60821533203125, 338.1138610839844, 42.07159423828125, 136.6978759765625, 29.43756675720215, 339.8769226074219, 132.200454711914, 282.3717346191406, 98.47132873535156, 338.7247314453125, 346.7470092773437, 233.5596618652343, 148.0027770996093, 5.52504301071167, 236.3924255371093, 26.95026016235351, 248.9105224609375, 10.29242610931396, 10.29242610931396, 244.5242919921875, 243.5817413330078, 250.1191101074218, 249.296142578125, 249.5583801269531, 37.5554f, 247.6892547607422};
            AmplitudeDurationMagnitudeCalculator.getAzumuthalWeights(dArray, 15.0, 360.0);
        }
        catch (Exception exception) {
            System.err.println("ERROR: " + exception);
            exception.printStackTrace();
        }
    }

    public String infoString(boolean bl, double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
        boolean bl2 = false;
        String string = "";
        if (!bl2 || d > 0.0) {
            if (bl) {
                string = string + " ";
            } else if (this.algorithmType == 0) {
                string = string + "E(N-m)=";
            } else if (this.algorithmType == 1) {
                string = string + "ampInt=";
            }
            string = string + NumberFormat.doubleString(d, -1, 2);
        }
        if (!bl2 || d2 > 0.0) {
            string = bl ? string + " " : string + "+/-";
            string = string + NumberFormat.doubleString(d2, -1, 2);
        }
        if (!bl2 || d3 > 0.0) {
            string = bl ? string + " " : string + ", " + this.durationName + "(s)=";
            string = string + NumberFormat.doubleString(d3, -1, 2);
        }
        if (!bl2 || d4 > 0.0) {
            string = bl ? string + " " : string + "+/-";
            string = string + NumberFormat.doubleString(d4, -1, 2);
        }
        if (!bl2 || d5 > 0.0) {
            string = bl ? string + " " : string + ", Mo(N-m)=";
            string = string + NumberFormat.doubleString(d5, -1, 2);
        }
        if (!bl2 || d6 > 0.0) {
            string = bl ? string + " " : string + "+/-";
            string = string + NumberFormat.doubleString(d6, -1, 2);
        }
        if (!bl2 || d7 > -999.0) {
            string = bl ? string + " " : string + ", M=";
            string = string + NumberFormat.doubleString(d7, -1, 2);
        }
        if (!bl2 || d8 > 0.0) {
            string = bl ? string + " " : string + "+/-";
            string = string + NumberFormat.doubleString(d8, -1, 2);
        }
        if (this.variant != 2 && (!bl2 || d5 > 0.0)) {
            string = bl ? string + " " : string + ", Mcorr=";
            double d9 = this.calculateMagnitude(this.calculateCorrectedMoment(d5));
            string = string + NumberFormat.doubleString(d9, -1, 2);
            if (!bl2 || d6 > 0.0) {
                string = bl ? string + " " : string + "+/-";
                double d10 = d9 / d7 * d8;
                string = string + NumberFormat.doubleString(d10, -1, 2);
            }
        }
        if (this.variant != 2 && (!bl2 || d5 > 0.0 && d3 > 0.0)) {
            string = bl ? string + " " : string + ", Theta=";
            string = string + NumberFormat.doubleString(this.calculateTheta(d5, d3), -1, 2);
        }
        return string;
    }

    public static double durationWeightedMeanMagnitude(Vector vector) {
        double[] dArray = new double[vector.size()];
        double[] dArray2 = new double[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            DurationAmplitudeValues durationAmplitudeValues = (DurationAmplitudeValues)vector.elementAt(i);
            dArray[i] = durationAmplitudeValues.magnitude;
            dArray2[i] = durationAmplitudeValues.duration.weight;
        }
        double d = 0.0;
        try {
            d = StatUtils.mean(dArray, dArray2);
        }
        catch (Exception exception) {
            String string = "ERROR: Calculating duration weighted mean: " + exception.getMessage();
            System.out.println(string);
        }
        return d;
    }

    public static double durationWeightedGeometricMeanDuration(Vector vector) {
        double[] dArray = new double[vector.size()];
        double[] dArray2 = new double[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            DurationAmplitudeValues durationAmplitudeValues = (DurationAmplitudeValues)vector.elementAt(i);
            dArray[i] = durationAmplitudeValues.duration.value;
            dArray2[i] = durationAmplitudeValues.duration.weight;
        }
        double d = 0.0;
        try {
            d = StatUtils.geometricMean(dArray, dArray2);
        }
        catch (Exception exception) {
            String string = "ERROR: Calculating duration weighted mean: " + exception.getMessage();
            System.out.println(string);
        }
        return d;
    }

    public static double durationWeightedGeometricMeanAmplitudeIntegral(Vector vector) {
        double[] dArray = new double[vector.size()];
        double[] dArray2 = new double[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            DurationAmplitudeValues durationAmplitudeValues = (DurationAmplitudeValues)vector.elementAt(i);
            dArray[i] = durationAmplitudeValues.amplitudeIntegral;
            dArray2[i] = durationAmplitudeValues.duration.weight;
        }
        double d = 0.0;
        try {
            d = StatUtils.geometricMean(dArray, dArray2);
        }
        catch (Exception exception) {
            String string = "ERROR: Calculating duration weighted mean: " + exception.getMessage();
            System.out.println(string);
        }
        return d;
    }

    public static double durationWeightedGeometricMeanMoment(Vector vector) {
        double[] dArray = new double[vector.size()];
        double[] dArray2 = new double[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            DurationAmplitudeValues durationAmplitudeValues = (DurationAmplitudeValues)vector.elementAt(i);
            dArray[i] = durationAmplitudeValues.moment;
            dArray2[i] = durationAmplitudeValues.duration.weight;
        }
        double d = 0.0;
        try {
            d = StatUtils.geometricMean(dArray, dArray2);
        }
        catch (Exception exception) {
            String string = "ERROR: Calculating duration weighted mean: " + exception.getMessage();
            System.out.println(string);
        }
        return d;
    }

    public class DurationAmplitudeValues {
        String pickID;
        WeightedValue duration;
        double tSminusP;
        double amplitudeIntegral;
        double moment;
        double magnitude;
        double azimuth;
        double distance;

        public DurationAmplitudeValues(String string, WeightedValue weightedValue, double d, double d2, double d3) {
            this.pickID = string;
            this.duration = weightedValue;
            this.tSminusP = this.tSminusP;
            this.amplitudeIntegral = d;
            this.azimuth = d2;
            this.distance = d3;
        }

        public String toStringCSV() {
            return this.pickID + " " + (float)this.distance + " " + (float)this.azimuth + " " + (float)this.tSminusP + " " + (float)this.amplitudeIntegral + " " + (float)this.duration.value + " " + (float)this.moment + " " + (float)this.magnitude + " ";
        }
    }
}

