/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.seisgram2k.commandmenu;

import java.text.NumberFormat;
import javax.swing.JCheckBox;
import net.alomax.seisgram2k.SeisGram2KFrame;
import net.alomax.seisgram2k.SeisGramText;
import net.alomax.seisgram2k.Seismogram;
import net.alomax.swing.FormattedTextFieldsEditor;
import net.alomax.swing.SwingText;

public class SyntheticDialog {
    protected int type = 0;
    protected static final int MAX_TEXT_COLS = 25;
    protected static final int MAX_DOUBLE_COLS = 12;
    protected static final String TEXT_DELIMITER = ",";
    protected static final NumberFormat NUMBER_FORMAT_FRACT_6 = NumberFormat.getNumberInstance();
    protected SeisGram2KFrame seisFrame;
    protected Seismogram seismogram;
    protected FormattedTextFieldsEditor syntheticEditor;
    protected JCheckBox xxx;
    public double sampleInt;
    public int numberPoints;
    public int index;
    public double frequency;
    public double phase;

    public SyntheticDialog(SeisGram2KFrame seisGram2KFrame, Seismogram seismogram, int n) {
        NUMBER_FORMAT_FRACT_6.setMinimumFractionDigits(1);
        NUMBER_FORMAT_FRACT_6.setMaximumFractionDigits(6);
        this.seisFrame = null;
        this.seismogram = null;
        this.syntheticEditor = null;
        this.xxx = null;
        this.sampleInt = 1.0;
        this.numberPoints = 1024;
        this.index = 0;
        this.frequency = 1.0;
        this.phase = 0.0;
        this.seisFrame = seisGram2KFrame;
        this.seismogram = seismogram;
        this.type = n;
    }

    public boolean doEdit() {
        this.syntheticEditor = new FormattedTextFieldsEditor(this.seisFrame, SeisGramText.SYNTHETIC_TRACE, SwingText.INSERT, SwingText.CANCEL);
        this.intializeSyntheticEditorFields();
        this.syntheticEditor.show();
        if (this.syntheticEditor.wasCancelled()) {
            return false;
        }
        this.updateSyntheticFields();
        return true;
    }

    public void intializeSyntheticEditorFields() {
        if (this.type == 0) {
            this.syntheticEditor.addLabel("Impulse");
            this.index = this.seismogram == null ? 0 : this.seismogram.timeSeries.sampleLength() / 2;
            this.syntheticEditor.addEntry("INDEX", SeisGramText.INDEX, new Integer(this.index), 12, 0.0, 2.147483647E9);
        } else if (this.type == 1) {
            this.syntheticEditor.addLabel("Sine");
            this.syntheticEditor.addEntry("FREQUENCY", SeisGramText.FREQUENCY + " (Hz)", new Double(1.0), 12, Double.MIN_VALUE, Double.MAX_VALUE, NUMBER_FORMAT_FRACT_6);
            this.syntheticEditor.addEntry("PHASE", SeisGramText.PHASE + " (deg)", new Double(0.0), 12, Double.MIN_VALUE, Double.MAX_VALUE, NUMBER_FORMAT_FRACT_6);
        }
        this.sampleInt = this.seismogram == null ? 0.01 : this.seismogram.timeSeries.sampleInt;
        this.numberPoints = this.seismogram == null ? 1024 : this.seismogram.timeSeries.sampleLength();
        this.syntheticEditor.addEntry("SAMPLE_INTERVAL", SeisGramText.SAMPLE_INTERVAL + " (sec)", new Double(this.sampleInt), 12, Double.MIN_VALUE, Double.MAX_VALUE, NUMBER_FORMAT_FRACT_6);
        this.syntheticEditor.addEntry("NUMBER_POINTS", SeisGramText.NUMBER_POINTS + " (sec)", new Integer(this.numberPoints), 12, 1.0, 2.147483647E9);
    }

    public void updateSyntheticFields() {
        try {
            this.sampleInt = ((Number)this.syntheticEditor.getValue("SAMPLE_INTERVAL")).doubleValue();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.numberPoints = ((Number)this.syntheticEditor.getValue("NUMBER_POINTS")).intValue();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.index = ((Number)this.syntheticEditor.getValue("INDEX")).intValue();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.frequency = ((Number)this.syntheticEditor.getValue("FREQUENCY")).doubleValue();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.phase = ((Number)this.syntheticEditor.getValue("PHASE")).doubleValue();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

