/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.seisgram2k.liveseis;

import java.util.StringTokenizer;
import net.alomax.seisgram2k.SeismogramURL;

public class LiveSeisDescriptor {
    public static final String SEPARATOR = "#";
    public static final int TYPE_LIVESEIS = 0;
    public static final int TYPE_TITANLIVE = 1;
    public int type = 0;
    public int numSegments = 0;
    public int numSegmentsDisplay = 0;
    public double waitTime = 0.0;
    public double minPeakToPeakAmplitude = -1.0;
    public double maxPeakToPeakAmplitude = Double.MAX_VALUE;
    public String title = "";
    public SeismogramURL[] segmentURLTemplate;
    public boolean contiguous = false;

    public LiveSeisDescriptor(int n, int n2) {
        this(n, new SeismogramURL[n2], 0, 0, 0.0, -1.0, Double.MAX_VALUE, "", false);
    }

    public LiveSeisDescriptor(int n, SeismogramURL[] seismogramURLArray, int n2, int n3, double d, double d2, double d3, String string, boolean bl) {
        this.type = n;
        this.segmentURLTemplate = new SeismogramURL[seismogramURLArray.length];
        for (int i = 0; i < seismogramURLArray.length; ++i) {
            this.segmentURLTemplate[i] = seismogramURLArray[i] != null ? new SeismogramURL(seismogramURLArray[i]) : new SeismogramURL();
        }
        this.numSegments = n2;
        this.numSegmentsDisplay = n3;
        this.minPeakToPeakAmplitude = d2;
        this.maxPeakToPeakAmplitude = d3;
        this.title = string;
        this.waitTime = d;
        this.contiguous = bl;
    }

    public LiveSeisDescriptor(int n, String string, SeismogramURL[] seismogramURLArray, boolean bl) {
        this(n, seismogramURLArray, 0, 0, 0.0, -1.0, Double.MAX_VALUE, "", false);
        StringTokenizer stringTokenizer = new StringTokenizer(string, SEPARATOR);
        if (stringTokenizer.hasMoreTokens()) {
            this.numSegments = Integer.valueOf(stringTokenizer.nextToken());
        }
        if (stringTokenizer.hasMoreTokens()) {
            this.numSegmentsDisplay = Integer.valueOf(stringTokenizer.nextToken());
        }
        if (stringTokenizer.hasMoreTokens()) {
            this.waitTime = Double.valueOf(stringTokenizer.nextToken());
        }
        if (stringTokenizer.hasMoreTokens()) {
            this.minPeakToPeakAmplitude = Double.valueOf(stringTokenizer.nextToken());
        }
        if (stringTokenizer.hasMoreTokens()) {
            this.maxPeakToPeakAmplitude = Double.valueOf(stringTokenizer.nextToken());
        }
        if (stringTokenizer.hasMoreTokens()) {
            this.title = stringTokenizer.nextToken();
        }
        this.contiguous = bl;
    }

    public LiveSeisDescriptor(LiveSeisDescriptor liveSeisDescriptor) {
        this(liveSeisDescriptor.type, liveSeisDescriptor.segmentURLTemplate, liveSeisDescriptor.numSegments, liveSeisDescriptor.numSegmentsDisplay, liveSeisDescriptor.waitTime, liveSeisDescriptor.minPeakToPeakAmplitude, liveSeisDescriptor.maxPeakToPeakAmplitude, liveSeisDescriptor.title, liveSeisDescriptor.contiguous);
    }

    public String toString() {
        String string = "numSegments " + this.numSegments + " numSegmentsDisplay " + this.numSegmentsDisplay + " waitTime " + this.waitTime + " minPeakToPeakAmplitude " + this.minPeakToPeakAmplitude + " maxPeakToPeakAmplitude " + this.maxPeakToPeakAmplitude + " title " + this.title + " contiguous " + this.contiguous;
        for (int i = 0; i < this.segmentURLTemplate.length; ++i) {
            string = string + "\n   " + this.segmentURLTemplate[i].toString();
        }
        return string;
    }

    public boolean fieldsAreValid() {
        if (this.type == 0) {
            if (this.numSegments <= 0) {
                return false;
            }
            if (this.numSegmentsDisplay <= 0 || this.numSegmentsDisplay > this.numSegments) {
                return false;
            }
        } else if (this.type == 1 && this.numSegmentsDisplay <= 0) {
            return false;
        }
        if (this.waitTime <= Double.MIN_VALUE) {
            return false;
        }
        return this.segmentURLTemplate != null && this.segmentURLTemplate[0] != null && this.segmentURLTemplate[0].URLname != null;
    }
}

