/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.seisgram2k.liveseis;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import net.alomax.awt.AJLButton;
import net.alomax.awt.AWTExt;
import net.alomax.awt.MessageDialog;
import net.alomax.seisgram2k.SeisGram2KFrame;
import net.alomax.seisgram2k.SeisGramText;
import net.alomax.seisgram2k.Seismogram;
import net.alomax.seisgram2k.SeismogramURL;
import net.alomax.seisgram2k.SeismogramURLDialog;
import net.alomax.seisgram2k.liveseis.LiveSeisDescriptor;
import net.alomax.util.BinaryType;

public class LiveSeisDialog
extends Dialog
implements ActionListener,
KeyListener {
    protected SeisGram2KFrame parentFrame;
    protected int gatherIndex;
    protected int numURLMax;
    protected AJLButton openButton;
    protected AJLButton cancelButton;
    protected TextField[] textFieldURL;
    protected AJLButton URLButton;
    protected TextField textFieldNumSegments;
    protected TextField textFieldNumSegmentsDisplay;
    protected TextField textFieldWaitTime;
    protected TextField textFieldMinPeakToPeakAmplitude;
    protected String channelFormat = null;
    protected String binaryType = null;
    protected LiveSeisDescriptor liveSeisDesc;
    protected static String currentChannelFormat = null;
    protected static String currentBinaryType = null;
    public static LiveSeisDescriptor currentLiveSeisDesc = null;

    public LiveSeisDialog(SeisGram2KFrame seisGram2KFrame, int n, int n2, String[] stringArray, String string, String[] stringArray2, String string2, LiveSeisDescriptor liveSeisDescriptor) {
        super(seisGram2KFrame, SeisGramText.LIVESEIS_DIALOG_TITLE, true);
        Object object;
        this.parentFrame = seisGram2KFrame;
        this.gatherIndex = n2;
        this.numURLMax = n;
        this.channelFormat = currentChannelFormat == null ? string : currentChannelFormat;
        this.binaryType = currentBinaryType == null ? string2 : currentBinaryType;
        currentLiveSeisDesc = liveSeisDescriptor;
        this.liveSeisDesc = currentLiveSeisDesc != null ? new LiveSeisDescriptor(currentLiveSeisDesc) : new LiveSeisDescriptor(0, n);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                for (int i = 0; i < LiveSeisDialog.this.liveSeisDesc.segmentURLTemplate.length; ++i) {
                    LiveSeisDialog.this.liveSeisDesc.segmentURLTemplate[i] = null;
                }
                LiveSeisDialog.this.setVisible(false);
            }
        });
        this.openButton = new AJLButton(this, this, SeisGramText.OPEN);
        this.cancelButton = new AJLButton(this, this, SeisGramText.CANCEL);
        this.setLayout(new BorderLayout(0, 1));
        Panel panel = new Panel();
        panel.setLayout(new GridLayout(0, 1));
        Panel[] panelArray = new Panel[n];
        this.textFieldURL = new TextField[n];
        for (int i = 0; i < n; ++i) {
            panelArray[i] = new Panel();
            panelArray[i].setLayout(new FlowLayout());
            if (this.liveSeisDesc.segmentURLTemplate != null && this.liveSeisDesc.segmentURLTemplate.length > i) {
                object = this.liveSeisDesc.segmentURLTemplate[i].URLname;
                if (object == null) {
                    object = "";
                }
                this.textFieldURL[i] = new TextField("URL: " + (String)object, 50);
            } else {
                this.textFieldURL[i] = new TextField("URL: ", 50);
            }
            this.textFieldURL[i].setEditable(false);
            this.textFieldURL[i].setBackground(Color.lightGray);
            panelArray[i].add(this.textFieldURL[i]);
            panel.add(panelArray[i]);
        }
        object = new Panel();
        this.URLButton = new AJLButton(this, this, SeisGramText.SET + "...");
        ((Container)object).add(this.URLButton);
        Panel panel2 = new Panel();
        panel2.setLayout(new FlowLayout(0));
        panel2.add(panel);
        panel2.add((Component)object);
        Panel panel3 = new Panel();
        panel3.setLayout(new GridLayout(0, 1));
        Panel panel4 = new Panel();
        panel4.setLayout(new FlowLayout(2));
        panel4.add(new Label(SeisGramText.NUMBER_SEGMENTS_IN_LOOP + ":", 2));
        this.textFieldNumSegments = AWTExt.newTextField(this, this, String.valueOf(this.liveSeisDesc.numSegments), 6);
        panel4.add(this.textFieldNumSegments);
        panel3.add(panel4);
        Panel panel5 = new Panel();
        panel5.setLayout(new FlowLayout(2));
        panel5.add(new Label(SeisGramText.NUMBER_SEGMENTS_TO_DISPLAY + ":", 2));
        this.textFieldNumSegmentsDisplay = AWTExt.newTextField(this, this, String.valueOf(this.liveSeisDesc.numSegmentsDisplay), 6);
        panel5.add(this.textFieldNumSegmentsDisplay);
        panel3.add(panel5);
        Panel panel6 = new Panel();
        panel6.setLayout(new FlowLayout(2));
        panel6.add(new Label(SeisGramText.WAIT_TIME + " " + ":", 2));
        this.textFieldWaitTime = AWTExt.newTextField(this, this, String.valueOf(this.liveSeisDesc.waitTime), 6);
        panel6.add(this.textFieldWaitTime);
        panel3.add(panel6);
        Panel panel7 = new Panel();
        panel7.setLayout(new FlowLayout(2));
        panel7.add(new Label(SeisGramText.MIN_P2P_AMP + " " + ":", 2));
        this.textFieldMinPeakToPeakAmplitude = AWTExt.newTextField(this, this, String.valueOf(this.liveSeisDesc.minPeakToPeakAmplitude), 6);
        panel7.add(this.textFieldMinPeakToPeakAmplitude);
        panel3.add(panel7);
        panel2.add(panel3);
        Panel panel8 = new Panel();
        panel8.setLayout(new FlowLayout(2));
        panel8.add(this.openButton);
        panel8.add(this.cancelButton);
        this.add("North", panel2);
        this.add("Center", panel3);
        this.add("South", panel8);
        this.pack();
        this.setEnabled(true);
    }

    protected SeismogramURL[] getSeismogramURLs(int n, int n2) {
        SeismogramURLDialog seismogramURLDialog = new SeismogramURLDialog(this.parentFrame, n, this.liveSeisDesc.segmentURLTemplate, n2, null, null, Seismogram.channelFormatsRead, this.channelFormat, BinaryType.binaryTypes, this.binaryType, true, false);
        AWTExt.setLocationToCenter(seismogramURLDialog, this, this.getLocationOnScreen(), 0.1);
        seismogramURLDialog.show();
        SeismogramURL[] seismogramURLArray = seismogramURLDialog.getURLs();
        if (seismogramURLArray.length > 0) {
            this.channelFormat = seismogramURLDialog.getCurrentChannelFormat();
            this.binaryType = seismogramURLDialog.getCurrentBinaryType();
            this.liveSeisDesc.segmentURLTemplate = seismogramURLArray;
        }
        seismogramURLDialog.dispose();
        return seismogramURLArray;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this.URLButton)) {
            this.getSeismogramURLs(this.numURLMax, this.gatherIndex);
            for (int i = 0; i < this.liveSeisDesc.segmentURLTemplate.length; ++i) {
                this.textFieldURL[i].setText("URL: " + this.liveSeisDesc.segmentURLTemplate[i].URLname);
            }
            this.pack();
            return;
        }
        if (actionEvent.getSource().equals(this.textFieldNumSegments)) {
            this.textFieldNumSegmentsValidate();
            return;
        }
        if (actionEvent.getSource().equals(this.textFieldNumSegmentsDisplay)) {
            this.textFieldNumSegmentsDisplayValidate();
            return;
        }
        if (actionEvent.getSource().equals(this.textFieldWaitTime)) {
            this.textFieldWaitTimeValidate();
            return;
        }
        if (actionEvent.getSource().equals(this.textFieldMinPeakToPeakAmplitude)) {
            this.textFieldMinPeakToPeakAmplitudeValidate();
            return;
        }
        if (actionEvent.getSource().equals(this.cancelButton)) {
            currentLiveSeisDesc = null;
            this.setVisible(false);
            return;
        }
        if (actionEvent.getSource().equals(this.openButton)) {
            this.textFieldNumSegmentsValidate();
            this.textFieldNumSegmentsDisplayValidate();
            this.textFieldWaitTimeValidate();
            this.textFieldMinPeakToPeakAmplitudeValidate();
            if (!this.liveSeisDesc.fieldsAreValid()) {
                MessageDialog messageDialog = new MessageDialog(this.parentFrame, this.getLocationOnScreen(), SeisGramText.ERROR + ": " + SeisGramText.LIVESEIS_DIALOG_TITLE, SeisGramText.ERROR_INVALID_LIVE_SEIS_PARAMETERS, SeisGramText.OK);
                return;
            }
            if (this.liveSeisDesc.segmentURLTemplate.length > 0) {
                currentChannelFormat = this.channelFormat;
                currentBinaryType = this.binaryType;
                currentLiveSeisDesc = new LiveSeisDescriptor(this.liveSeisDesc);
            }
            this.setVisible(false);
            return;
        }
    }

    protected void textFieldNumSegmentsValidate() {
        try {
            int n;
            this.liveSeisDesc.numSegments = n = Integer.valueOf(this.textFieldNumSegments.getText()).intValue();
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.textFieldNumSegments.setText(String.valueOf(this.liveSeisDesc.numSegments));
    }

    protected void textFieldNumSegmentsDisplayValidate() {
        try {
            int n;
            this.liveSeisDesc.numSegmentsDisplay = n = Integer.valueOf(this.textFieldNumSegmentsDisplay.getText()).intValue();
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.textFieldNumSegmentsDisplay.setText(String.valueOf(this.liveSeisDesc.numSegmentsDisplay));
    }

    protected void textFieldWaitTimeValidate() {
        try {
            double d;
            this.liveSeisDesc.waitTime = d = Double.valueOf(this.textFieldWaitTime.getText()).doubleValue();
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.textFieldWaitTime.setText(String.valueOf(this.liveSeisDesc.waitTime));
    }

    protected void textFieldMinPeakToPeakAmplitudeValidate() {
        try {
            double d;
            this.liveSeisDesc.minPeakToPeakAmplitude = d = Double.valueOf(this.textFieldMinPeakToPeakAmplitude.getText()).doubleValue();
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.textFieldMinPeakToPeakAmplitude.setText(String.valueOf(this.liveSeisDesc.minPeakToPeakAmplitude));
    }

    public LiveSeisDescriptor getLiveSeisDescriptor() {
        return currentLiveSeisDesc;
    }

    public void setLiveSeisDescriptor(LiveSeisDescriptor liveSeisDescriptor) {
        currentLiveSeisDesc = liveSeisDescriptor;
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }
}

