/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.seisgram2k.liveseis;

import java.net.URL;
import java.util.Date;
import net.alomax.seisgram2k.GatherPanel;
import net.alomax.seisgram2k.liveseis.LiveSeisDescriptor;

public abstract class LiveSeisManagerBase
extends Thread {
    protected static int numberManagers = 0;
    protected int managerIndex = numberManagers++;
    protected boolean initialized = false;
    protected boolean stopRunning = false;
    protected GatherPanel client;
    protected URL documentBase;
    protected int numChannels;
    protected static final int READ_SEG = 0;
    protected static final int APPEND_SEG = 1;
    public LiveSeisDescriptor liveSeisDescriptor;

    public LiveSeisManagerBase(GatherPanel gatherPanel, URL uRL, LiveSeisDescriptor liveSeisDescriptor) {
        this.client = gatherPanel;
        this.liveSeisDescriptor = liveSeisDescriptor;
        this.documentBase = uRL;
        this.numChannels = liveSeisDescriptor.segmentURLTemplate.length;
    }

    public void stopRunning() {
        this.stopRunning = true;
    }

    protected boolean checkForStop() {
        return this.stopRunning || this.client == null || !this.client.isAlive();
    }

    protected void writeMessageWithDateStamp(String string) {
        this.client.writeMessage(string + "  [" + new Date().toString() + "]");
    }

    protected String formatMessage(String string) {
        return "LiveSeisManagerBase(" + this.managerIndex + "): " + string;
    }

    public double getNominalWindowLength() {
        return this.liveSeisDescriptor.waitTime * (double)this.liveSeisDescriptor.numSegmentsDisplay;
    }

    protected synchronized void doPreDisplay() {
        double d;
        double d2;
        double d3;
        if (this.numChannels != 1) {
            this.client.removeMean(Integer.MAX_VALUE);
        }
        if (this.liveSeisDescriptor.minPeakToPeakAmplitude > 0.0 && this.client.ampMax - this.client.ampMin < this.liveSeisDescriptor.minPeakToPeakAmplitude) {
            d3 = (this.client.ampMin + this.client.ampMax) / 2.0;
            d2 = d3 - this.liveSeisDescriptor.minPeakToPeakAmplitude / 2.0;
            d = d3 + this.liveSeisDescriptor.minPeakToPeakAmplitude / 2.0;
            this.client.setAmpRange(d2, d);
        }
        if (this.liveSeisDescriptor.maxPeakToPeakAmplitude > 0.0 && this.client.ampMax - this.client.ampMin > this.liveSeisDescriptor.maxPeakToPeakAmplitude) {
            d3 = (this.client.ampMin + this.client.ampMax) / 2.0;
            d2 = d3 - this.liveSeisDescriptor.maxPeakToPeakAmplitude / 2.0;
            d = d3 + this.liveSeisDescriptor.maxPeakToPeakAmplitude / 2.0;
            this.client.setAmpRange(d2, d);
        }
        this.client.setGatherTitle(this.liveSeisDescriptor.title);
    }
}

