/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.seisgram2k.toolmanager;

import java.awt.event.ActionEvent;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import javax.swing.JLabel;
import javax.swing.JToolBar;
import net.alomax.freq.FreqException;
import net.alomax.freq.FrequencyProcesses;
import net.alomax.seisgram2k.SeisGram2KFrame;
import net.alomax.seisgram2k.SeisGramText;
import net.alomax.seisgram2k.toolmanager.ConvolveToolManager;
import net.alomax.seisgram2k.toolmanager.TransferToolManager;
import net.alomax.swing.AJLJButton;
import net.alomax.swing.JCommandException;
import net.alomax.swing.JToolManager;
import net.alomax.swing.JToolManagerException;

public class FrequencyToolManager
extends JToolManager {
    protected SeisGram2KFrame seisFrame = null;
    protected AJLJButton buttonPlotSpectral;
    protected AJLJButton buttonIntegFreq;
    protected AJLJButton buttonDiffFreq;
    protected AJLJButton buttonHilbertFreq;
    protected AJLJButton buttonEnvelopeFreq;
    protected AJLJButton buttonRemAttenFreq;
    protected AJLJButton buttonTransfer;
    protected AJLJButton buttonConvolve;
    protected TransferToolManager transferToolManager = null;
    protected ConvolveToolManager convolveToolManager = null;
    protected static final int PLOT_SPECTRAL = 0;
    protected static final int INTEGRATE = 1;
    protected static final int DIFFERENTIATE = 2;
    protected static final int HILBERT = 3;
    protected static final int ENVELOPE = 4;
    protected static final int REMOVE_ATTENUATION = 5;
    protected String[] commandNames = new String[0];
    protected String[] commandNamesShort = new String[0];
    protected int variant = 0;
    protected String argumentString = "";

    public FrequencyToolManager(SeisGram2KFrame seisGram2KFrame) {
        this.seisFrame = seisGram2KFrame;
        this.updateLabel();
        this.commandNames = new String[]{"plotspectral", "fintegrate", "fdifferentiate", "hilbert", "envelope", "rattenuation"};
        this.commandNamesShort = new String[]{"plotsp", "fint", "fdif", "hil", "env", "ratt"};
    }

    public void updateLabel() {
        this.label = SeisGramText.FREQ;
        this.button = new AJLJButton(this.seisFrame, this.seisFrame, this.label + "...");
    }

    public void layoutComponents(JToolBar jToolBar) {
        jToolBar.add(new JLabel(this.label + ":"));
        jToolBar.addSeparator();
        this.buttonPlotSpectral = new AJLJButton(this, this, SeisGramText.PLOT_SPECTRAL);
        jToolBar.add(this.buttonPlotSpectral);
        this.buttonIntegFreq = new AJLJButton(this, this, SeisGramText.INTEGRATE);
        jToolBar.add(this.buttonIntegFreq);
        this.buttonDiffFreq = new AJLJButton(this, this, SeisGramText.DIFFERENTIATE);
        jToolBar.add(this.buttonDiffFreq);
        this.buttonHilbertFreq = new AJLJButton(this, this, SeisGramText.HILBERT);
        jToolBar.add(this.buttonHilbertFreq);
        this.buttonEnvelopeFreq = new AJLJButton(this, this, SeisGramText.ENVELOPE);
        jToolBar.add(this.buttonEnvelopeFreq);
        this.buttonRemAttenFreq = new AJLJButton(this, this, SeisGramText.REMOVE_ATTENUATION);
        jToolBar.add(this.buttonRemAttenFreq);
        this.buttonTransfer = new AJLJButton(this, this, SeisGramText.TRANSFER);
        jToolBar.add(this.buttonTransfer);
        this.buttonConvolve = new AJLJButton(this, this, SeisGramText.CONVOLVE);
        jToolBar.add(this.buttonConvolve);
        jToolBar.addSeparator();
        jToolBar.addSeparator();
        jToolBar.validate();
    }

    public void updateComponents() {
    }

    public void setAWTStates() {
        this.button.setEnabled(this.seisFrame.getActiveGather() != null && !this.seisFrame.getActiveGather().isMonitor());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        try {
            if (actionEvent.getSource().equals(this.buttonPlotSpectral)) {
                this.variant = 0;
            } else if (actionEvent.getSource().equals(this.buttonIntegFreq)) {
                this.variant = 1;
            } else if (actionEvent.getSource().equals(this.buttonDiffFreq)) {
                this.variant = 2;
            } else if (actionEvent.getSource().equals(this.buttonHilbertFreq)) {
                this.variant = 3;
            } else if (actionEvent.getSource().equals(this.buttonEnvelopeFreq)) {
                this.variant = 4;
            } else if (actionEvent.getSource().equals(this.buttonRemAttenFreq)) {
                this.variant = 5;
            } else {
                if (actionEvent.getSource().equals(this.buttonTransfer)) {
                    if (this.transferToolManager == null) {
                        this.transferToolManager = new TransferToolManager(this.seisFrame);
                    }
                    this.seisFrame.initializeInteractionPanel(this.transferToolManager);
                    return;
                }
                if (actionEvent.getSource().equals(this.buttonConvolve)) {
                    if (this.convolveToolManager == null) {
                        this.convolveToolManager = new ConvolveToolManager(this.seisFrame);
                    }
                    this.seisFrame.initializeInteractionPanel(this.convolveToolManager);
                    return;
                }
                return;
            }
            this.apply();
        }
        catch (FreqException freqException) {
            this.seisFrame.writeMessage("ERROR: " + freqException.toString());
        }
        catch (JCommandException jCommandException) {
            this.seisFrame.writeMessage("ERROR: " + jCommandException.toString());
        }
    }

    protected void apply() throws FreqException, JCommandException {
        if (this.variant == 0) {
            this.seisFrame.applyCommand(this.getCommandString());
        } else if (this.variant == 1) {
            this.seisFrame.applyFreqProcess(new FrequencyProcesses(FrequencyProcesses.INTEGRATE), null, this.getCommandString());
        } else if (this.variant == 2) {
            this.seisFrame.applyFreqProcess(new FrequencyProcesses(FrequencyProcesses.DIFFERENTIATE), null, this.getCommandString());
        } else if (this.variant == 3) {
            this.seisFrame.applyFreqProcess(new FrequencyProcesses(FrequencyProcesses.HILBERT), null, this.getCommandString());
        } else if (this.variant == 4) {
            this.seisFrame.applyFreqProcess(new FrequencyProcesses(FrequencyProcesses.ENVELOPE), null, this.getCommandString());
        } else if (this.variant == 5) {
            this.seisFrame.applyFreqProcess(new FrequencyProcesses(FrequencyProcesses.REMOVE_ATTENUATION), null, this.getCommandString());
        }
    }

    public boolean isCommandHandler(String string) {
        String string2 = string.trim().toLowerCase();
        try {
            string2 = string2.substring(0, string2.indexOf(32));
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (int i = 0; i < this.commandNames.length; ++i) {
            if (!string2.equals(this.commandNames[i]) && !string2.equals(this.commandNamesShort[i])) continue;
            this.variant = i;
            return true;
        }
        if (this.transferToolManager == null) {
            try {
                this.transferToolManager = new TransferToolManager(this.seisFrame);
            }
            catch (FreqException freqException) {
                // empty catch block
            }
        }
        if (this.transferToolManager != null && this.transferToolManager.isCommandHandler(string)) {
            return true;
        }
        if (this.convolveToolManager == null) {
            this.convolveToolManager = new ConvolveToolManager(this.seisFrame);
        }
        return this.convolveToolManager != null && this.convolveToolManager.isCommandHandler(string);
    }

    public void applyCommand(String string) throws JCommandException {
        if (!this.isCommandHandler(string)) {
            throw new JToolManagerException("Not command handler: " + string);
        }
        if (this.transferToolManager != null && this.transferToolManager.isCommandHandler(string)) {
            this.transferToolManager.applyCommand(string);
            return;
        }
        if (this.convolveToolManager != null && this.convolveToolManager.isCommandHandler(string)) {
            this.convolveToolManager.applyCommand(string);
            return;
        }
        String string2 = " ";
        StringTokenizer stringTokenizer = new StringTokenizer(this.argumentString);
        try {
            if (this.variant >= 0) {
                while (stringTokenizer.hasMoreTokens()) {
                    string2 = stringTokenizer.nextToken();
                }
                this.apply();
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new JCommandException("Parsing or applying command", string, string2);
        }
        catch (FreqException freqException) {
            throw new JCommandException("Parsing or applying command: ERROR: " + freqException.toString(), string, string2);
        }
    }

    public String getCommandString() {
        if (this.variant < 0) {
            return "???";
        }
        String string = this.commandNamesShort[this.variant];
        return string;
    }
}

