/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.seisgram2k.toolmanager;

import java.awt.event.ActionEvent;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import net.alomax.seisgram2k.SeisGram2KFrame;
import net.alomax.seisgram2k.SeisGramText;
import net.alomax.swing.AJLJButton;
import net.alomax.swing.JToolManager;
import net.alomax.swing.JToolManagerException;
import net.alomax.swing.SwingExt;
import net.alomax.timedom.InstantPeriod;
import net.alomax.timedom.TimeDomainException;

public class InstantPeriodToolManager
extends JToolManager {
    protected SeisGram2KFrame seisFrame = null;
    protected InstantPeriod instantPeriod;
    protected AJLJButton buttonApplyInstantPeriod;
    protected JTextField textFieldCenterFreq;
    protected JTextField textFieldAlpha;
    protected static final int DEFAULT = 0;
    protected String[] commandNames = new String[0];
    protected String[] commandNamesShort = new String[0];
    protected int variant = 0;
    protected String argumentString = "";

    public InstantPeriodToolManager(SeisGram2KFrame seisGram2KFrame) {
        this.seisFrame = seisGram2KFrame;
        this.updateLabel();
        this.instantPeriod = new InstantPeriod(SeisGramText.getLocaleString(), 1.0);
        this.commandNames = new String[]{"instper"};
        this.commandNamesShort = new String[]{"iper"};
    }

    public void updateLabel() {
        this.label = SeisGramText.INSTANT_PERIOD;
        this.button = new AJLJButton(this.seisFrame, this.seisFrame, this.label + "...");
    }

    public void layoutComponents(JToolBar jToolBar) {
        jToolBar.add(new JLabel(this.label + ":"));
        jToolBar.addSeparator();
        this.buttonApplyInstantPeriod = new AJLJButton(this, this, SeisGramText.APPLY);
        jToolBar.add(this.buttonApplyInstantPeriod);
        jToolBar.addSeparator();
        jToolBar.add(new JLabel(SeisGramText.ALPHA + ":", 4));
        this.textFieldAlpha = SwingExt.newJTextField(this, this, String.valueOf(this.instantPeriod.alpha), 5);
        jToolBar.add(this.textFieldAlpha);
        jToolBar.addSeparator();
        jToolBar.validate();
    }

    public void updateComponents() {
    }

    public void setAWTStates() {
        this.button.setEnabled(this.seisFrame.getActiveGather() != null && !this.seisFrame.getActiveGather().isMonitor());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this.buttonApplyInstantPeriod)) {
            boolean bl = false;
            try {
                this.instantPeriod.setAlpha(this.textFieldAlpha.getText());
            }
            catch (TimeDomainException timeDomainException) {
                this.seisFrame.writeMessage("ERROR: " + timeDomainException.toString());
                bl = true;
            }
            this.textFieldAlpha.setText(String.valueOf(this.instantPeriod.alpha));
            if (bl) {
                return;
            }
            try {
                this.instantPeriod.checkSettings();
            }
            catch (TimeDomainException timeDomainException) {
                this.seisFrame.writeMessage("ERROR: " + timeDomainException.toString());
                return;
            }
            this.variant = 0;
            try {
                this.apply();
            }
            catch (TimeDomainException timeDomainException) {
                this.seisFrame.writeMessage("ERROR: " + timeDomainException.toString());
            }
            return;
        }
        if (actionEvent.getSource().equals(this.textFieldAlpha)) {
            try {
                this.instantPeriod.setAlpha(this.textFieldAlpha.getText());
            }
            catch (TimeDomainException timeDomainException) {
                this.seisFrame.writeMessage("ERROR: " + timeDomainException.toString());
            }
            this.textFieldAlpha.setText(String.valueOf(this.instantPeriod.alpha));
            return;
        }
    }

    protected void apply() throws TimeDomainException {
        this.instantPeriod.checkSettings();
        this.seisFrame.applyTimeDomainProcess(this.instantPeriod, this.getCommandString());
    }

    public boolean isCommandHandler(String string) {
        String string2 = string.trim().toLowerCase();
        try {
            string2 = string2.substring(0, string2.indexOf(32));
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (int i = 0; i < this.commandNames.length; ++i) {
            if (!string2.equals(this.commandNames[i]) && !string2.equals(this.commandNamesShort[i])) continue;
            this.variant = i;
            return true;
        }
        return false;
    }

    public void applyCommand(String string) throws JToolManagerException {
        if (!this.isCommandHandler(string)) {
            throw new JToolManagerException("Not command handler: " + string);
        }
        String string2 = " ";
        this.argumentString = string;
        StringTokenizer stringTokenizer = new StringTokenizer(this.argumentString);
        try {
            stringTokenizer.nextToken();
            if (this.variant >= 0) {
                while (stringTokenizer.hasMoreTokens()) {
                    string2 = stringTokenizer.nextToken();
                    if (string2.toLowerCase().startsWith("alpha")) {
                        this.instantPeriod.setAlpha(stringTokenizer.nextToken());
                        continue;
                    }
                    throw new JToolManagerException("Parsing or applying command", string, string2);
                }
                this.apply();
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new JToolManagerException("Parsing or applying command", string, string2);
        }
        catch (TimeDomainException timeDomainException) {
            throw new JToolManagerException("Parsing or applying command: ERROR: " + timeDomainException.toString(), string, string2);
        }
    }

    public String getCommandString() {
        if (this.variant < 0) {
            return "???";
        }
        String string = this.commandNamesShort[this.variant];
        string = string + " alpha " + this.instantPeriod.alpha;
        return string;
    }
}

