/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.seisgram2k.toolmanager;

import java.awt.event.ActionEvent;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import net.alomax.seisgram2k.SeisGram2KFrame;
import net.alomax.seisgram2k.SeisGramText;
import net.alomax.swing.AJLJButton;
import net.alomax.swing.JToolManager;
import net.alomax.swing.JToolManagerException;
import net.alomax.swing.SwingExt;
import net.alomax.timedom.PickData;
import net.alomax.timedom.ShortLongTermAve;
import net.alomax.timedom.TimeDomainException;

public class ShortLongTermAveToolManager
extends JToolManager {
    protected String[] typeNames = new String[]{"FORWARD", "BACKWARD"};
    protected String[] resultNames = new String[]{"PICKS", "CHAR_FUNC", "TRIGGERS"};
    protected SeisGram2KFrame seisFrame = null;
    protected ShortLongTermAve shortLongTermAve;
    protected AJLJButton buttonApplyShortLongTermAve;
    protected JTextField textFieldCenterFreq;
    protected JTextField textFieldShortTermWindow;
    protected JTextField textFieldLongTermWindow;
    protected JTextField textFieldRatio;
    protected JComboBox choiceDirection;
    protected JComboBox choiceResults;
    protected static final int DEFAULT = 0;
    protected String[] commandNames = new String[0];
    protected String[] commandNamesShort = new String[0];
    protected int variant = 0;
    protected String argumentString = "";

    public ShortLongTermAveToolManager(SeisGram2KFrame seisGram2KFrame, String string) {
        String string2;
        double d;
        long l;
        this.seisFrame = seisGram2KFrame;
        this.updateLabel();
        double d2 = 0.05;
        try {
            d2 = seisGram2KFrame.getActiveGather().getSeismogram((int)0).timeSeries.sampleInt;
        }
        catch (Exception exception) {
            // empty catch block
        }
        double d3 = 10.0 * d2;
        long l2 = Math.round(d3 * 1000.0);
        if (l2 > 1L) {
            d3 = (double)l2 / 1000.0;
        }
        if ((l = Math.round((d = 10.0 * d3) * 1000.0)) > 1L) {
            d = (double)l / 1000.0;
        }
        this.shortLongTermAve = new ShortLongTermAve(SeisGramText.getLocaleString(), d3, d, 3.0, 1);
        try {
            this.shortLongTermAve.setResultsType(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            string2 = null;
            string2 = seisGram2KFrame.getParameter("timedom.stalta.stw");
            if (string2 != null) {
                this.shortLongTermAve.setShortTermWindow(string2);
            }
        }
        catch (TimeDomainException timeDomainException) {
            seisGram2KFrame.writeMessage("ERROR: " + timeDomainException.toString());
        }
        try {
            string2 = null;
            string2 = seisGram2KFrame.getParameter("timedom.stalta.ltw");
            if (string2 != null) {
                this.shortLongTermAve.setLongTermWindow(string2);
            }
        }
        catch (TimeDomainException timeDomainException) {
            seisGram2KFrame.writeMessage("ERROR: " + timeDomainException.toString());
        }
        try {
            string2 = null;
            string2 = seisGram2KFrame.getParameter("timedom.stalta.ratio");
            if (string2 != null) {
                this.shortLongTermAve.setRatio(string2);
            }
        }
        catch (TimeDomainException timeDomainException) {
            seisGram2KFrame.writeMessage("ERROR: " + timeDomainException.toString());
        }
        try {
            string2 = null;
            string2 = seisGram2KFrame.getParameter("timedom.stalta.dir");
            if (string2 != null) {
                this.shortLongTermAve.setDirection(string2);
            }
        }
        catch (TimeDomainException timeDomainException) {
            seisGram2KFrame.writeMessage("ERROR: " + timeDomainException.toString());
        }
        this.commandNames = new String[]{"stalta"};
        this.commandNamesShort = new String[]{"sla"};
    }

    public void updateLabel() {
        this.label = SeisGramText.SHORT_LONG_TERM_AVE;
        this.button = new AJLJButton(this.seisFrame, this.seisFrame, this.label + "...");
    }

    public void layoutComponents(JToolBar jToolBar) {
        jToolBar.add(new JLabel(this.label + ":"));
        jToolBar.addSeparator();
        this.buttonApplyShortLongTermAve = new AJLJButton(this, this, SeisGramText.APPLY);
        jToolBar.add(this.buttonApplyShortLongTermAve);
        jToolBar.addSeparator();
        jToolBar.add(new JLabel(SeisGramText.SHORT_TERM_WINDOW + ":", 4));
        this.textFieldShortTermWindow = SwingExt.newJTextField(this, this, String.valueOf(this.shortLongTermAve.shortTermWindow), 5);
        jToolBar.add(this.textFieldShortTermWindow);
        jToolBar.addSeparator();
        jToolBar.add(new JLabel(SeisGramText.LONG_TERM_WINDOW + ":", 4));
        this.textFieldLongTermWindow = SwingExt.newJTextField(this, this, String.valueOf(this.shortLongTermAve.longTermWindow), 5);
        jToolBar.add(this.textFieldLongTermWindow);
        jToolBar.addSeparator();
        jToolBar.add(new JLabel(SeisGramText.TRIGGER_RATIO + ":", 4));
        this.textFieldRatio = SwingExt.newJTextField(this, this, String.valueOf(this.shortLongTermAve.triggerRatio), 5);
        jToolBar.add(this.textFieldRatio);
        jToolBar.addSeparator();
        jToolBar.add(new JLabel(SeisGramText.DIRECTION + ":", 4));
        this.choiceDirection = SwingExt.newChoice(this, this.typeNames);
        this.choiceDirection.setSelectedItem(this.shortLongTermAve.getDirectionString());
        jToolBar.add(this.choiceDirection);
        jToolBar.addSeparator();
        jToolBar.add(new JLabel(SeisGramText.RESULT + ":", 4));
        this.choiceResults = SwingExt.newChoice(this, this.resultNames);
        this.choiceResults.setSelectedItem(this.shortLongTermAve.getResultsTypeString());
        jToolBar.add(this.choiceResults);
        jToolBar.addSeparator();
        jToolBar.validate();
    }

    public void updateComponents() {
    }

    public void setAWTStates() {
        this.button.setEnabled(this.seisFrame.getActiveGather() != null && !this.seisFrame.getActiveGather().isMonitor());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this.buttonApplyShortLongTermAve)) {
            boolean bl = false;
            try {
                this.shortLongTermAve.setShortTermWindow(this.textFieldShortTermWindow.getText());
            }
            catch (TimeDomainException timeDomainException) {
                this.seisFrame.writeMessage("ERROR: " + timeDomainException.toString());
                bl = true;
            }
            this.textFieldShortTermWindow.setText(String.valueOf(this.shortLongTermAve.shortTermWindow));
            try {
                this.shortLongTermAve.setLongTermWindow(this.textFieldLongTermWindow.getText());
            }
            catch (TimeDomainException timeDomainException) {
                this.seisFrame.writeMessage("ERROR: " + timeDomainException.toString());
                bl = true;
            }
            this.textFieldLongTermWindow.setText(String.valueOf(this.shortLongTermAve.longTermWindow));
            try {
                this.shortLongTermAve.setRatio(this.textFieldRatio.getText());
            }
            catch (TimeDomainException timeDomainException) {
                this.seisFrame.writeMessage("ERROR: " + timeDomainException.toString());
                bl = true;
            }
            this.textFieldRatio.setText(String.valueOf(this.shortLongTermAve.triggerRatio));
            try {
                this.shortLongTermAve.setDirection((String)this.choiceDirection.getSelectedItem());
            }
            catch (TimeDomainException timeDomainException) {
                this.seisFrame.writeMessage("ERROR: " + timeDomainException.toString());
                bl = true;
            }
            try {
                this.shortLongTermAve.setResultsType((String)this.choiceResults.getSelectedItem());
            }
            catch (TimeDomainException timeDomainException) {
                this.seisFrame.writeMessage("ERROR: " + timeDomainException.toString());
                bl = true;
            }
            if (bl) {
                return;
            }
            try {
                this.shortLongTermAve.checkSettings();
            }
            catch (TimeDomainException timeDomainException) {
                this.seisFrame.writeMessage("ERROR: " + timeDomainException.toString());
                return;
            }
            this.variant = 0;
            try {
                this.apply();
            }
            catch (TimeDomainException timeDomainException) {
                this.seisFrame.writeMessage("ERROR: " + timeDomainException.toString());
            }
            return;
        }
        if (actionEvent.getSource().equals(this.textFieldShortTermWindow)) {
            try {
                this.shortLongTermAve.setShortTermWindow(this.textFieldShortTermWindow.getText());
            }
            catch (TimeDomainException timeDomainException) {
                this.seisFrame.writeMessage("ERROR: " + timeDomainException.toString());
            }
            this.textFieldShortTermWindow.setText(String.valueOf(this.shortLongTermAve.shortTermWindow));
            return;
        }
        if (actionEvent.getSource().equals(this.textFieldLongTermWindow)) {
            try {
                this.shortLongTermAve.setLongTermWindow(this.textFieldLongTermWindow.getText());
            }
            catch (TimeDomainException timeDomainException) {
                this.seisFrame.writeMessage("ERROR: " + timeDomainException.toString());
            }
            this.textFieldLongTermWindow.setText(String.valueOf(this.shortLongTermAve.longTermWindow));
            return;
        }
        if (actionEvent.getSource().equals(this.textFieldRatio)) {
            try {
                this.shortLongTermAve.setRatio(this.textFieldRatio.getText());
            }
            catch (TimeDomainException timeDomainException) {
                this.seisFrame.writeMessage("ERROR: " + timeDomainException.toString());
            }
            this.textFieldRatio.setText(String.valueOf(this.shortLongTermAve.triggerRatio));
            return;
        }
        if (actionEvent.getSource().equals(this.choiceDirection)) {
            try {
                this.shortLongTermAve.setDirection((String)this.choiceDirection.getSelectedItem());
            }
            catch (TimeDomainException timeDomainException) {
                this.seisFrame.writeMessage("ERROR: " + timeDomainException.toString());
            }
            return;
        }
        if (actionEvent.getSource().equals(this.choiceResults)) {
            try {
                this.shortLongTermAve.setResultsType((String)this.choiceResults.getSelectedItem());
            }
            catch (TimeDomainException timeDomainException) {
                this.seisFrame.writeMessage("ERROR: " + timeDomainException.toString());
            }
            return;
        }
    }

    protected void setPickShortLongTermAve() {
        Vector vector = this.shortLongTermAve.getPickData();
        String string = this.shortLongTermAve.getDirection() > 0 ? "P" : "Pb";
        for (int i = 0; i < vector.size(); ++i) {
            PickData pickData = (PickData)vector.elementAt(i);
            String string2 = string + i;
            this.seisFrame.getActiveGather().setPickFromPickData(pickData, string2);
        }
    }

    protected void apply() throws TimeDomainException {
        this.shortLongTermAve.checkSettings();
        this.seisFrame.applyTimeDomainProcess(this.shortLongTermAve, this.getCommandString());
        if (this.shortLongTermAve.getResultsType() == 0) {
            this.setPickShortLongTermAve();
        }
    }

    public boolean isCommandHandler(String string) {
        String string2 = string.trim().toLowerCase();
        try {
            string2 = string2.substring(0, string2.indexOf(32));
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (int i = 0; i < this.commandNames.length; ++i) {
            if (!string2.equals(this.commandNames[i]) && !string2.equals(this.commandNamesShort[i])) continue;
            this.variant = i;
            return true;
        }
        return false;
    }

    public void applyCommand(String string) throws JToolManagerException {
        if (!this.isCommandHandler(string)) {
            throw new JToolManagerException("Not command handler: " + string);
        }
        String string2 = " ";
        this.argumentString = string;
        StringTokenizer stringTokenizer = new StringTokenizer(this.argumentString);
        try {
            stringTokenizer.nextToken();
            if (this.variant >= 0) {
                while (stringTokenizer.hasMoreTokens()) {
                    string2 = stringTokenizer.nextToken();
                    if (string2.toLowerCase().startsWith("stw")) {
                        this.shortLongTermAve.setShortTermWindow(stringTokenizer.nextToken());
                        continue;
                    }
                    if (string2.toLowerCase().startsWith("ltw")) {
                        this.shortLongTermAve.setLongTermWindow(stringTokenizer.nextToken());
                        continue;
                    }
                    if (string2.toLowerCase().startsWith("ra")) {
                        this.shortLongTermAve.setRatio(stringTokenizer.nextToken());
                        continue;
                    }
                    if (string2.toLowerCase().startsWith("dir")) {
                        this.shortLongTermAve.setDirection(stringTokenizer.nextToken());
                        continue;
                    }
                    if (string2.toLowerCase().startsWith("res")) {
                        this.shortLongTermAve.setResultsType(stringTokenizer.nextToken());
                        continue;
                    }
                    throw new JToolManagerException("Parsing or applying command", string, string2);
                }
                this.apply();
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new JToolManagerException("Parsing or applying command", string, string2);
        }
        catch (TimeDomainException timeDomainException) {
            throw new JToolManagerException("Parsing or applying command: ERROR: " + timeDomainException.toString(), string, string2);
        }
    }

    public String getCommandString() {
        if (this.variant < 0) {
            return "???";
        }
        String string = this.commandNamesShort[this.variant];
        string = string + " stw " + this.shortLongTermAve.shortTermWindow;
        string = string + " ltw " + this.shortLongTermAve.longTermWindow;
        string = string + " ra " + this.shortLongTermAve.triggerRatio;
        string = string + " dir " + this.shortLongTermAve.getDirectionString();
        string = string + " res " + this.shortLongTermAve.getResultsTypeString();
        return string;
    }
}

