/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.seisgram2k.toolmanager;

import edu.sc.seis.TauP.Arrival;
import edu.sc.seis.TauP.TauP_Time;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.text.DecimalFormat;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import net.alomax.seisgram2k.GatherPanel;
import net.alomax.seisgram2k.SeisGram2KFrame;
import net.alomax.seisgram2k.SeisGramText;
import net.alomax.seisgram2k.Seismogram;
import net.alomax.seisgram2k.TravelTimeDialog;
import net.alomax.swing.AJLJButton;
import net.alomax.swing.JToolManager;
import net.alomax.swing.JToolManagerException;
import net.alomax.swing.LeftRightJButton;
import net.alomax.swing.SwingExt;
import net.alomax.util.TimeInstant;

public class TravelTimeToolManager
extends JToolManager {
    public static final String DEFAULT_PHASES = "p,s,P,S,Pn,Sn,PcP,ScS,Pdiff,Sdiff,PKP,SKS,pP,sS,sP,PP,SS,PPP,SSS";
    public static final String DEFAULT_PHASES_SCHOOL = "P,S,PmP,PcP,PP,SS,PKP,PKiKP,PKIKP,Lr";
    protected DecimalFormat decFormat = new DecimalFormat("0.00");
    protected SeisGram2KFrame seisFrame = null;
    protected AJLJButton buttonOptionsTravelTime;
    protected AJLJButton buttonRayInfoTravelTime;
    protected AJLJButton buttonToPicks;
    protected static final double DEG_PER_KM = 0.009;
    protected static String travelTimeDistanceUnits;
    protected static double travelTimeDepthStep;
    protected static double travelTimeDistMultiplier;
    protected static boolean travelTimeFixOtime;
    protected static boolean travelTimeFixFirstArrival;
    public boolean shiftKeyDown = false;
    protected TimeInstant travelTimeOtime;
    protected LeftRightJButton buttonTravelTimeDist;
    protected JTextField textFieldTravelTimeDist;
    protected JLabel labelTravelTimeDistanceUnits;
    protected LeftRightJButton buttonTravelTimeDepth;
    protected JTextField textFieldTravelTimeDepth;
    protected LeftRightJButton buttonTravelTimeOtimeHour;
    protected JTextField textFieldTravelTimeOtimeHour;
    protected JTextField textFieldTravelTimeOtimeMin;
    protected LeftRightJButton buttonTravelTimeOtimeMin;
    protected JTextField textFieldTravelTimeOtimeSec;
    protected LeftRightJButton buttonTravelTimeOtimeSec;
    protected TauP_Time tauPtime = null;
    protected String tauPmodelName = null;
    protected String travelTimePhaseList = null;
    public static String tauPmodelNameStatic;
    protected static final int MARKTIMES = 0;
    protected String[] commandNames = new String[]{"marktimes"};
    protected String[] commandNamesShort = new String[]{"markt"};
    protected int variant = 0;
    protected String argumentString = "";

    public TravelTimeToolManager(SeisGram2KFrame seisGram2KFrame) throws Exception {
        this.seisFrame = seisGram2KFrame;
        this.decFormat = new DecimalFormat("0.00");
        this.updateLabel();
        TravelTimeToolManager.initializeTauP(seisGram2KFrame);
        this.tauPmodelName = tauPmodelNameStatic;
    }

    public static void initializeTauP(SeisGram2KFrame seisGram2KFrame) throws Exception {
        if (!seisGram2KFrame.getFrameParent().isApplet()) {
            try {
                Class.forName("edu.sc.seis.TauP.TauPException");
                travelTimeDistanceUnits = SeisGramText.DEG;
                travelTimeDistMultiplier = 1.0;
                if (seisGram2KFrame.isSchool()) {
                    TravelTimeToolManager.setTravelTimeFixOtime();
                } else {
                    TravelTimeToolManager.setTravelTimeFixFirstArrival();
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                seisGram2KFrame.printOptionalClassesNotFoundMessage("TauP toolkit");
                throw classNotFoundException;
            }
        }
        if ((tauPmodelNameStatic = seisGram2KFrame.getParameter("taup.model")) == null) {
            try {
                tauPmodelNameStatic = "iasp91.taup";
            }
            catch (Exception exception) {
                String string = "ERROR: Locating TauP model file: " + exception;
                System.out.println(string);
                seisGram2KFrame.writeMessage(string);
                throw exception;
            }
            if (!tauPmodelNameStatic.endsWith(".taup")) {
                tauPmodelNameStatic = tauPmodelNameStatic + ".taup";
            }
        }
        System.out.println("INFO: TauP model name: " + tauPmodelNameStatic);
    }

    public void updateLabel() {
        this.label = SeisGramText.PHASES;
        this.button = new AJLJButton(this.seisFrame, this.seisFrame, this.label + "...");
        if (this.iconButton == null) {
            this.iconButton = new AJLJButton(this.seisFrame, this.seisFrame, null);
        }
        if (!SwingExt.setImage(this.seisFrame, this.iconButton, "TravelTime.gif")) {
            this.iconButton.setText(SeisGramText.PHASES);
        }
        this.iconButton.setToolTipText(SeisGramText.TRAVEL_TIME_TOOLTIP);
    }

    public boolean useButton() {
        return !this.seisFrame.isSchool();
    }

    public void activate() {
        this.activate(null, true);
    }

    public void activate(GatherPanel gatherPanel, boolean bl) {
        try {
            if (this.seisFrame.isSchool()) {
                this.initTauP(gatherPanel, false);
            } else {
                this.initTauP(gatherPanel, bl);
            }
            return;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            String string = "ERROR: Initializing TauP: " + noClassDefFoundError;
            System.out.println(string);
            this.seisFrame.writeMessage(string);
            this.seisFrame.printOptionalClassesNotFoundMessage("TauP toolkit");
            return;
        }
        catch (Error error) {
            System.out.println(this.getClass().getName() + ": " + "CAUGHT: Error:");
            error.printStackTrace();
            return;
        }
        catch (Exception exception) {
            System.out.println(this.getClass().getName() + ": " + "CAUGHT: Exception:");
            exception.printStackTrace();
            return;
        }
    }

    public void layoutComponents(JToolBar jToolBar) {
        jToolBar.removeKeyListener(this);
        jToolBar.addKeyListener(this);
        jToolBar.add(new JLabel(this.label + ":"));
        jToolBar.addSeparator();
        jToolBar.addSeparator();
        JLabel jLabel = SwingExt.initPanelLabel(SeisGramText.OTIME + ":", 4, jToolBar);
        jToolBar.addSeparator();
        jLabel = SwingExt.initPanelLabel("h", jToolBar);
        this.textFieldTravelTimeOtimeHour = SwingExt.newJTextField((ActionListener)this, (KeyListener)this, 3);
        jToolBar.add(this.textFieldTravelTimeOtimeHour);
        this.buttonTravelTimeOtimeHour = SwingExt.initPanelLeftRightButton(jToolBar, this, this);
        jToolBar.addSeparator();
        jLabel = SwingExt.initPanelLabel("m", jToolBar);
        this.textFieldTravelTimeOtimeMin = SwingExt.newJTextField((ActionListener)this, (KeyListener)this, 3);
        jToolBar.add(this.textFieldTravelTimeOtimeMin);
        this.buttonTravelTimeOtimeMin = SwingExt.initPanelLeftRightButton(jToolBar, this, this);
        jToolBar.addSeparator();
        jLabel = SwingExt.initPanelLabel("s", jToolBar);
        this.textFieldTravelTimeOtimeSec = SwingExt.newJTextField((ActionListener)this, (KeyListener)this, 5);
        jToolBar.add(this.textFieldTravelTimeOtimeSec);
        this.buttonTravelTimeOtimeSec = SwingExt.initPanelLeftRightButton(jToolBar, this, this);
        this.setOtimeTextFields();
        jToolBar.addSeparator();
        jToolBar.addSeparator();
        jLabel = SwingExt.initPanelLabel(SeisGramText.DISTANCE + ":", 4, jToolBar);
        jToolBar.addSeparator();
        this.labelTravelTimeDistanceUnits = SwingExt.initPanelLabel(travelTimeDistanceUnits, jToolBar);
        this.textFieldTravelTimeDist = SwingExt.newJTextField(this, this, this.decFormat.format(this.seisFrame.getActiveGather().getTravelTimeDist() / travelTimeDistMultiplier), 5);
        jToolBar.add(this.textFieldTravelTimeDist);
        this.buttonTravelTimeDist = SwingExt.initPanelLeftRightButton(jToolBar, this, this);
        this.setDistanceTextFields();
        jToolBar.addSeparator();
        jToolBar.addSeparator();
        jLabel = SwingExt.initPanelLabel(SeisGramText.DEPTH + ":", 4, jToolBar);
        jToolBar.addSeparator();
        jLabel = SwingExt.initPanelLabel("km", jToolBar);
        this.textFieldTravelTimeDepth = SwingExt.newJTextField(this, this, this.decFormat.format(this.seisFrame.getActiveGather().getTravelTimeDepth()), 5);
        jToolBar.add(this.textFieldTravelTimeDepth);
        this.buttonTravelTimeDepth = SwingExt.initPanelLeftRightButton(jToolBar, this, this);
        this.setDepthTextFields();
        jToolBar.addSeparator();
        jToolBar.addSeparator();
        this.buttonOptionsTravelTime = SwingExt.initPanelButton(SeisGramText.OPTIONS + "...", jToolBar, this, this);
        if (!this.seisFrame.isSchool()) {
            this.buttonToPicks = SwingExt.initPanelButton(SeisGramText.TO_PICKS, jToolBar, this, this);
        }
        this.buttonRayInfoTravelTime = SwingExt.initPanelButton(SeisGramText.RAY_INFO, jToolBar, this, this);
        jToolBar.validate();
        if (this.seisFrame.isSchool()) {
            this.doTravelTimeDialog();
            this.updateTauP(true);
        }
    }

    void setDistanceTextFields() {
        if (this.textFieldTravelTimeDist != null) {
            this.textFieldTravelTimeDist.setText(this.decFormat.format(this.seisFrame.getActiveGather().getTravelTimeDist() / travelTimeDistMultiplier));
        }
    }

    void setDepthTextFields() {
        if (this.textFieldTravelTimeDepth != null) {
            this.textFieldTravelTimeDepth.setText(this.decFormat.format(this.seisFrame.getActiveGather().getTravelTimeDepth()));
        }
    }

    void setOtimeTextFields() {
        this.travelTimeOtime = this.seisFrame.getActiveGather().refTimeToTimeInstant(this.seisFrame.getActiveGather().getTravelTimeOtime());
        if (this.textFieldTravelTimeOtimeHour != null) {
            this.textFieldTravelTimeOtimeHour.setText(String.valueOf(this.travelTimeOtime.getHours()));
        }
        if (this.textFieldTravelTimeOtimeMin != null) {
            this.textFieldTravelTimeOtimeMin.setText(String.valueOf(this.travelTimeOtime.getMinutes()));
        }
        if (this.textFieldTravelTimeOtimeSec != null) {
            this.textFieldTravelTimeOtimeSec.setText(this.decFormat.format((float)this.travelTimeOtime.getSeconds()));
        }
    }

    int setTravelTimeOtimeFromText() {
        int n;
        int n2;
        double d;
        try {
            d = Double.valueOf(this.textFieldTravelTimeOtimeSec.getText());
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
        try {
            n2 = Integer.valueOf(this.textFieldTravelTimeOtimeMin.getText());
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
        try {
            n = Integer.valueOf(this.textFieldTravelTimeOtimeHour.getText());
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
        TimeInstant timeInstant = new TimeInstant(this.travelTimeOtime.getYear(), this.travelTimeOtime.getMonth(), this.travelTimeOtime.getDate(), n, n2, d);
        if (this.seisFrame.getActiveGather().setTravelTimeOtime(timeInstant) < 0) {
            this.setOtimeTextFields();
            return -1;
        }
        this.setOtimeTextFields();
        this.travelTimeOtime = timeInstant;
        return 0;
    }

    public void updateComponents() {
        this.setOtimeTextFields();
        this.setDistanceTextFields();
        this.setDepthTextFields();
    }

    public void setAWTStates() {
        GatherPanel gatherPanel;
        String string;
        boolean bl = true;
        double d = 0.0;
        if (this.seisFrame.isSchool() && !this.seisFrame.enableTraveltimeToolbar) {
            d = 30.0;
        }
        if ((string = this.seisFrame.getParameter("taup.dist.min")) != null) {
            try {
                d = Double.parseDouble(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((gatherPanel = this.seisFrame.getActiveGather()) != null) {
            Seismogram[] seismogramArray = gatherPanel.getSeismograms();
            for (int i = 0; i < seismogramArray.length; ++i) {
                if (!(seismogramArray[i].gcarc < d) && !(seismogramArray[i].gcarc >= 360.0)) continue;
                bl = false;
            }
        }
        this.iconButton.setEnabled(bl);
    }

    public void close() {
        for (int i = 0; i < this.seisFrame.getGatherListSize(); ++i) {
            this.seisFrame.getGatherListElementAt(i).closeTauP(true);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this.buttonTravelTimeDist.right)) {
            double d = 1.0;
            if (this.shiftKeyDown) {
                d = 10.0;
            }
            this.seisFrame.getActiveGather().setTravelTimeDist(this.seisFrame.getActiveGather().getTravelTimeDist() + d * travelTimeDistMultiplier);
            this.setDistanceTextFields();
            this.updateTauP(true);
            return;
        }
        if (actionEvent.getSource().equals(this.buttonTravelTimeDist.left)) {
            double d = 1.0;
            if (this.shiftKeyDown) {
                d = 10.0;
            }
            this.seisFrame.getActiveGather().setTravelTimeDist(this.seisFrame.getActiveGather().getTravelTimeDist() - d * travelTimeDistMultiplier);
            this.setDistanceTextFields();
            this.updateTauP(true);
            return;
        }
        if (actionEvent.getSource().equals(this.textFieldTravelTimeDist)) {
            if (this.seisFrame.getActiveGather().setTravelTimeDist(this.textFieldTravelTimeDist.getText(), travelTimeDistMultiplier) < 0) {
                this.setDistanceTextFields();
                return;
            }
            this.setDistanceTextFields();
            this.updateTauP(true);
            return;
        }
        if (actionEvent.getSource().equals(this.buttonTravelTimeDepth.right)) {
            double d = travelTimeDepthStep;
            if (this.shiftKeyDown) {
                d *= 10.0;
            }
            this.seisFrame.getActiveGather().setTravelTimeDepth(this.seisFrame.getActiveGather().getTravelTimeDepth() + d);
            this.setDepthTextFields();
            this.updateTauP(true);
            return;
        }
        if (actionEvent.getSource().equals(this.buttonTravelTimeDepth.left)) {
            double d = travelTimeDepthStep;
            if (this.shiftKeyDown) {
                d *= 10.0;
            }
            this.seisFrame.getActiveGather().setTravelTimeDepth(this.seisFrame.getActiveGather().getTravelTimeDepth() - d);
            this.setDepthTextFields();
            this.updateTauP(true);
            return;
        }
        if (actionEvent.getSource().equals(this.textFieldTravelTimeDepth)) {
            if (this.seisFrame.getActiveGather().setTravelTimeDepth(this.textFieldTravelTimeDepth.getText()) < 0) {
                this.setDepthTextFields();
                return;
            }
            this.setDepthTextFields();
            this.updateTauP(true);
            return;
        }
        if (actionEvent.getSource().equals(this.buttonTravelTimeOtimeSec.right)) {
            double d = 1.0;
            if (this.shiftKeyDown) {
                d = 10.0;
            }
            this.seisFrame.getActiveGather().setTravelTimeOtime(this.seisFrame.getActiveGather().getTravelTimeOtime() + d);
            this.setOtimeTextFields();
            this.updateTauP(true);
            return;
        }
        if (actionEvent.getSource().equals(this.buttonTravelTimeOtimeSec.left)) {
            double d = 1.0;
            if (this.shiftKeyDown) {
                d = 10.0;
            }
            this.seisFrame.getActiveGather().setTravelTimeOtime(this.seisFrame.getActiveGather().getTravelTimeOtime() - d);
            this.setOtimeTextFields();
            this.updateTauP(true);
            return;
        }
        if (actionEvent.getSource().equals(this.textFieldTravelTimeOtimeSec)) {
            if (this.setTravelTimeOtimeFromText() < 0) {
                return;
            }
            this.updateTauP(true);
            return;
        }
        if (actionEvent.getSource().equals(this.buttonTravelTimeOtimeMin.right)) {
            double d = 60.0;
            if (this.shiftKeyDown) {
                d = 600.0;
            }
            this.seisFrame.getActiveGather().setTravelTimeOtime(this.seisFrame.getActiveGather().getTravelTimeOtime() + d);
            this.setOtimeTextFields();
            this.updateTauP(true);
            return;
        }
        if (actionEvent.getSource().equals(this.buttonTravelTimeOtimeMin.left)) {
            double d = 60.0;
            if (this.shiftKeyDown) {
                d = 600.0;
            }
            this.seisFrame.getActiveGather().setTravelTimeOtime(this.seisFrame.getActiveGather().getTravelTimeOtime() - d);
            this.setOtimeTextFields();
            this.updateTauP(true);
            return;
        }
        if (actionEvent.getSource().equals(this.textFieldTravelTimeOtimeMin)) {
            if (this.setTravelTimeOtimeFromText() < 0) {
                return;
            }
            this.updateTauP(true);
            return;
        }
        if (actionEvent.getSource().equals(this.buttonTravelTimeOtimeHour.right)) {
            double d = 3600.0;
            if (this.shiftKeyDown) {
                d = 36000.0;
            }
            this.seisFrame.getActiveGather().setTravelTimeOtime(this.seisFrame.getActiveGather().getTravelTimeOtime() + d);
            this.setOtimeTextFields();
            this.updateTauP(true);
            return;
        }
        if (actionEvent.getSource().equals(this.buttonTravelTimeOtimeHour.left)) {
            double d = 3600.0;
            if (this.shiftKeyDown) {
                d = 36000.0;
            }
            this.seisFrame.getActiveGather().setTravelTimeOtime(this.seisFrame.getActiveGather().getTravelTimeOtime() - d);
            this.setOtimeTextFields();
            this.updateTauP(true);
            return;
        }
        if (actionEvent.getSource().equals(this.textFieldTravelTimeOtimeHour)) {
            if (this.setTravelTimeOtimeFromText() < 0) {
                return;
            }
            this.updateTauP(true);
            return;
        }
        if (actionEvent.getSource().equals(this.buttonOptionsTravelTime)) {
            this.doTravelTimeDialog();
            return;
        }
        if (actionEvent.getSource().equals(this.buttonRayInfoTravelTime)) {
            this.displayRayInfo();
            return;
        }
        if (actionEvent.getSource().equals(this.buttonToPicks)) {
            this.seisFrame.getActiveGather().convertArrivalsToPicks(true);
            return;
        }
    }

    public void updateTauP(boolean bl) {
        for (int i = 0; i < this.seisFrame.getGatherListSize(); ++i) {
            this.seisFrame.getGatherListElementAt(i).updateTauP(this.tauPtime, travelTimeFixFirstArrival, bl);
        }
        this.setOtimeTextFields();
        this.setDistanceTextFields();
        this.setDepthTextFields();
    }

    public static String getTravelTimeDistanceUnits() {
        return travelTimeDistanceUnits;
    }

    public static void setTravelTimeDistanceUnits(String string) {
        travelTimeDistanceUnits = string;
        if (string.compareTo(SeisGramText.KM) == 0) {
            travelTimeDistMultiplier = 0.009;
            travelTimeDepthStep = 1.0;
        } else {
            travelTimeDistMultiplier = 1.0;
            travelTimeDepthStep = 5.0;
        }
    }

    public static boolean getTravelTimeFixOtime() {
        return travelTimeFixOtime;
    }

    public static void setTravelTimeFixOtime() {
        travelTimeFixOtime = true;
        travelTimeFixFirstArrival = false;
    }

    public static boolean getTravelTimeFixFirstArrival() {
        return travelTimeFixFirstArrival;
    }

    public static void setTravelTimeFixFirstArrival() {
        travelTimeFixFirstArrival = true;
        travelTimeFixOtime = false;
    }

    void doTravelTimeDialog() {
        TravelTimeDialog travelTimeDialog = new TravelTimeDialog(this, this.seisFrame);
        travelTimeDialog.show();
        travelTimeDialog.dispose();
        this.labelTravelTimeDistanceUnits.setText(travelTimeDistanceUnits);
        this.setDistanceTextFields();
    }

    void displayRayInfo() {
        this.seisFrame.setMessageWindowShown(true);
        this.seisFrame.getActiveGather().displayRayInfo(this.travelTimePhaseList);
    }

    public void keyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (n == 16) {
            this.shiftKeyDown = true;
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (n == 16) {
            this.shiftKeyDown = false;
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (n == 16) {
            this.shiftKeyDown = false;
        }
    }

    protected void initTauP(GatherPanel gatherPanel, boolean bl) throws NoClassDefFoundError {
        String string = null;
        try {
            if (this.tauPtime == null) {
                this.seisFrame.writeMessage("Initializing travel time tables (" + this.tauPmodelName + ")...");
                if (this.tauPtime == null) {
                    this.tauPtime = new TauP_Time(this.tauPmodelName);
                    this.tauPtime.init();
                    String string2 = this.seisFrame.getParameter("taup.phases");
                    if (string2 == null) {
                        string2 = this.seisFrame.isSchool() ? "$" : DEFAULT_PHASES;
                    }
                    this.setTravelTimePhaseList(string2);
                    string = this.seisFrame.getParameter("taup.source");
                }
                this.seisFrame.writeMessage("_READY");
            }
        }
        catch (Exception exception) {
            this.seisFrame.writeMessage("_READY");
            String string3 = "ERROR: Initializing TauP: " + exception;
            System.out.println(string3);
            this.seisFrame.writeMessage(string3);
            return;
        }
        if (gatherPanel == null) {
            for (int i = 0; i < this.seisFrame.getGatherListSize(); ++i) {
                this.initTauPGather(this.seisFrame.getGatherListElementAt(i), this.tauPtime, string, ",", travelTimeFixFirstArrival, bl);
            }
        } else {
            this.initTauPGather(gatherPanel, this.tauPtime, string, ",", travelTimeFixFirstArrival, bl);
        }
    }

    public String getTravelTimePhaseList() {
        return this.travelTimePhaseList;
    }

    public String getModelName() {
        String string = this.tauPmodelName;
        try {
            string = string.substring(0, string.lastIndexOf(".taup"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    public double getMohoDepth() {
        try {
            return this.tauPtime.getTauModel().getMohoDepth();
        }
        catch (Exception exception) {
            return -1.0;
        }
    }

    public void setTravelTimePhaseList(String string) {
        if (this.tauPtime != null) {
            try {
                String string2 = string.replaceAll("Lr", "");
                string2 = string2.replaceAll("LR", "");
                this.tauPtime.clearPhaseNames();
                this.tauPtime.parsePhaseList(string2);
            }
            catch (Exception exception) {
                String string3 = "ERROR: Initializing TauP: " + exception;
                System.out.println(string3);
                this.seisFrame.writeMessage(string3);
                return;
            }
            this.travelTimePhaseList = new String(string);
        }
    }

    public int initTauPGather(GatherPanel gatherPanel, TauP_Time tauP_Time, String string, String string2, boolean bl, boolean bl2) {
        if (!gatherPanel.travelTimeInitlialized) {
            try {
                gatherPanel.travelTimeMaximumDepth = tauP_Time.getTauModel().getRadiusOfEarth();
                String string3 = gatherPanel.getTauPsource();
                if (string3 == null) {
                    string3 = string;
                }
                if (string3 != null ? this.setInitialTauP(gatherPanel, string3, string2) < 0 : this.setOptimalInitialTauP(gatherPanel, tauP_Time) < 0) {
                    return -1;
                }
                gatherPanel.travelTimeInitlialized = true;
            }
            catch (Exception exception) {
                String string4 = "ERROR: TauP: " + exception;
                System.out.println(string4);
                this.seisFrame.writeMessage(string4);
                return -1;
            }
        }
        if (gatherPanel.updateTauP(tauP_Time, bl, bl2) < 0) {
            return -1;
        }
        return 0;
    }

    public int setInitialTauP(GatherPanel gatherPanel, String string, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        if (!stringTokenizer.hasMoreTokens()) {
            return -1;
        }
        int n = Integer.valueOf(stringTokenizer.nextToken());
        if (!stringTokenizer.hasMoreTokens()) {
            return -1;
        }
        int n2 = Integer.valueOf(stringTokenizer.nextToken());
        if (!stringTokenizer.hasMoreTokens()) {
            return -1;
        }
        int n3 = Integer.valueOf(stringTokenizer.nextToken());
        if (!stringTokenizer.hasMoreTokens()) {
            return -1;
        }
        int n4 = Integer.valueOf(stringTokenizer.nextToken());
        if (!stringTokenizer.hasMoreTokens()) {
            return -1;
        }
        int n5 = Integer.valueOf(stringTokenizer.nextToken());
        if (!stringTokenizer.hasMoreTokens()) {
            return -1;
        }
        double d = Double.valueOf(stringTokenizer.nextToken());
        if (!stringTokenizer.hasMoreTokens()) {
            return -1;
        }
        double d2 = Double.valueOf(stringTokenizer.nextToken());
        if (!stringTokenizer.hasMoreTokens()) {
            return -1;
        }
        double d3 = Double.valueOf(stringTokenizer.nextToken());
        if (!stringTokenizer.hasMoreTokens()) {
            return -1;
        }
        String string3 = stringTokenizer.nextToken();
        TimeInstant timeInstant = new TimeInstant(n, n2, n3, n4, n5, d);
        gatherPanel.setTravelTimeOtime(timeInstant);
        gatherPanel.travelTimeDepth = d2;
        gatherPanel.travelTimeDist = d3;
        if (string3.equalsIgnoreCase("km")) {
            TravelTimeToolManager.setTravelTimeDistanceUnits(SeisGramText.KM);
            gatherPanel.travelTimeDist *= 0.009;
        } else {
            TravelTimeToolManager.setTravelTimeDistanceUnits(SeisGramText.DEG);
        }
        return 0;
    }

    public int setOptimalInitialTauP(GatherPanel gatherPanel, TauP_Time tauP_Time) {
        String[] stringArray = tauP_Time.getPhaseNames();
        String[] stringArray2 = new String[]{"P", "Pdiff", "PKP"};
        try {
            double d;
            tauP_Time.setPhaseNames(stringArray2);
            gatherPanel.travelTimeOtime = Math.floor(gatherPanel.timeMin + 0.5);
            gatherPanel.travelTimeDepth = 33.0;
            tauP_Time.setSourceDepth(gatherPanel.travelTimeDepth);
            double d2 = 32.0;
            double d3 = 8.0 * (gatherPanel.timeMax - gatherPanel.timeMin) / 16.0 / 111.1;
            gatherPanel.travelTimeDist = 0.0;
            for (d = d2; d > d3; d /= 2.0) {
                Arrival[] arrivalArray;
                do {
                    gatherPanel.travelTimeDist += d;
                    if (gatherPanel.travelTimeDist > 180.0) {
                        gatherPanel.travelTimeDist = 180.0;
                    }
                    tauP_Time.calculate(gatherPanel.travelTimeDist);
                } while ((arrivalArray = tauP_Time.getArrivals()).length > 0 && arrivalArray[0].getTime() < (gatherPanel.timeMax - gatherPanel.timeMin) / 4.0);
                gatherPanel.travelTimeDist -= d;
            }
            gatherPanel.travelTimeDist -= d;
            tauP_Time.setPhaseNames(stringArray);
        }
        catch (Exception exception) {
            String string = "ERROR: TauP: " + exception;
            System.out.println(string);
            this.seisFrame.writeMessage(string);
            return -1;
        }
        return 0;
    }

    protected void apply() {
        if (this.variant == 0) {
            this.seisFrame.writeProcessingMessage(this.getCommandString());
            this.activate(this.seisFrame.getActiveGather(), true);
            this.seisFrame.getActiveGather().convertArrivalsToPicks(false);
            this.seisFrame.getActiveGather().closeTauP(true);
        }
    }

    public boolean isCommandHandler(String string) {
        String string2 = string.trim().toLowerCase();
        try {
            string2 = string2.substring(0, string2.indexOf(32));
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (int i = 0; i < this.commandNames.length; ++i) {
            if (!string2.equals(this.commandNames[i]) && !string2.equals(this.commandNamesShort[i])) continue;
            this.variant = i;
            return true;
        }
        return false;
    }

    public void applyCommand(String string) throws JToolManagerException {
        if (!this.isCommandHandler(string)) {
            throw new JToolManagerException("Not command handler: " + string);
        }
        String string2 = " ";
        this.argumentString = string;
        StringTokenizer stringTokenizer = new StringTokenizer(this.argumentString);
        try {
            stringTokenizer.nextToken();
            if (this.variant == 0) {
                while (stringTokenizer.hasMoreTokens()) {
                    string2 = stringTokenizer.nextToken();
                    if (string2.toLowerCase().startsWith("xxx")) continue;
                    throw new JToolManagerException("Parsing or applying command", string, string2);
                }
                this.apply();
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            noSuchElementException.printStackTrace();
            throw new JToolManagerException("Parsing or applying command", string, string2);
        }
        catch (JToolManagerException jToolManagerException) {
            jToolManagerException.printStackTrace();
            throw jToolManagerException;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new JToolManagerException("Parsing or applying command: " + exception.getMessage(), string, string2);
        }
    }

    public String getCommandString() {
        if (this.variant < 0) {
            return "???";
        }
        String string = this.commandNamesShort[this.variant];
        return string;
    }

    static {
        tauPmodelNameStatic = null;
    }
}

