/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.swing;

import java.awt.Image;
import java.awt.event.ActionEvent;
import java.lang.reflect.Constructor;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JToolBar;
import javax.swing.border.CompoundBorder;
import net.alomax.swing.ApplicationJComp;
import net.alomax.swing.ExternalTool;
import net.alomax.swing.SwingExt;
import net.alomax.util.Instantiatable;
import net.alomax.util.StringExt;

public class ExternalToolsPanel
extends JToolBar {
    protected ApplicationJComp parent = null;
    protected int imageSize = 32;
    protected Action[] actions = null;

    public static ExternalToolsPanel create(ApplicationJComp applicationJComp, int n, Locale locale, boolean bl) {
        try {
            ExternalToolsPanel externalToolsPanel = new ExternalToolsPanel(applicationJComp, n, locale, bl);
            return externalToolsPanel;
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            return null;
        }
    }

    protected ExternalToolsPanel(ApplicationJComp applicationJComp, int n, Locale locale, boolean bl) throws Exception {
        this.parent = applicationJComp;
        String string = applicationJComp.getParameter("ext_tools");
        if (string == null) {
            throw new Exception("INFO: no ext_tools parameter found.");
        }
        String[] stringArray = StringExt.parse(string, "@");
        this.actions = new AbstractAction[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            Object object;
            ExternalTool externalTool = null;
            try {
                externalTool = new ExternalTool(stringArray[i], locale);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw exception;
            }
            ImageIcon imageIcon = null;
            if (externalTool.imageResourcePath != null) {
                try {
                    object = SwingExt.getImageResource(this, externalTool.imageResourcePath);
                    object = ((Image)object).getScaledInstance(n, n, 4);
                    imageIcon = new ImageIcon((Image)object);
                }
                catch (Exception exception) {
                    System.out.println("ERROR: loading image: " + externalTool.imageResourcePath + ": " + exception.getMessage());
                }
            }
            object = new AbstractAction(externalTool.label, imageIcon){

                public void actionPerformed(ActionEvent actionEvent) {
                    ExternalTool externalTool = (ExternalTool)this.getValue("TOOL");
                    ExternalToolsPanel.this.launchExternalTool(externalTool);
                }
            };
            object.putValue("ShortDescription", externalTool.shortDescription);
            object.putValue("TOOL", externalTool);
            this.actions[i] = object;
            JButton jButton = this.add((Action)object);
            try {
                jButton.setBorder(((CompoundBorder)jButton.getBorder()).getOutsideBorder());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            if (bl) {
                jButton.setLabel((String)object.getValue("Name"));
            }
            jButton.setToolTipText((String)object.getValue("ShortDescription"));
            this.addSeparator();
        }
    }

    public void addToolItemsToMenu(JMenu jMenu) {
        for (int i = 0; i < this.actions.length; ++i) {
            JMenuItem jMenuItem = new JMenuItem(this.actions[i]);
            jMenu.add(jMenuItem);
        }
    }

    protected void launchExternalTool(ExternalTool externalTool) {
        System.out.println("Launching child " + externalTool.label + "...");
        try {
            String[] stringArray = externalTool.argv;
            Class<?> clazz = Class.forName(externalTool.className);
            Class[] classArray = new Class[]{Boolean.TYPE, stringArray.getClass()};
            final Constructor<?> constructor = clazz.getConstructor(classArray);
            final Object[] objectArray = new Object[]{new Boolean(false), stringArray};
            for (int i = 0; i < stringArray.length; ++i) {
                System.out.println("  " + stringArray[i]);
            }
            final ExternalTool externalTool2 = externalTool;
            externalTool2.closeApplication();
            Thread thread = new Thread(){

                public void run() {
                    try {
                        externalTool2.application = (Instantiatable)constructor.newInstance(objectArray);
                        externalTool2.application.setExitOK(false);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            };
            thread.start();
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.out.println(classNotFoundException);
            this.parent.writeMessage("ERROR: loading extermal tool: " + classNotFoundException);
            return;
        }
        catch (Exception exception) {
            System.out.println(exception);
            this.parent.writeMessage("ERROR: loading extermal tool: " + exception);
            return;
        }
    }
}

