/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.swing;

import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.PrintGraphics;
import java.awt.PrintJob;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import net.alomax.swing.ApplicationJComp;
import net.alomax.swing.PrintUtils;
import net.alomax.swing.SwingText;

public abstract class JBasicFrame
extends JFrame {
    protected boolean isTopLevel = true;
    protected JMenuBar menuBar = new JMenuBar();
    protected JMenuItem menuItemFilePrint;
    protected JMenuItem menuItemFileExit;
    protected ApplicationJComp parentApp = null;

    public JBasicFrame(String string) {
        this(null, string, true, null);
    }

    public JBasicFrame(ApplicationJComp applicationJComp, String string) {
        this(applicationJComp, string, true, null);
    }

    public JBasicFrame(ApplicationJComp applicationJComp, String string, boolean bl, Image image) {
        super(string);
        this.parentApp = applicationJComp;
        this.isTopLevel = bl;
        if (image != null) {
            this.setIconImage(image);
        }
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                JBasicFrame.this.windowIsClosing();
                JBasicFrame.this.dispose();
            }
        });
        this.setJMenuBar(this.menuBar);
        JMenu jMenu = new JMenu(SwingText.FILE);
        this.menuItemFilePrint = new JMenuItem(SwingText.PRINT + "...");
        this.menuItemFilePrint.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JBasicFrame.this.doPrintJob();
            }
        });
        jMenu.add(this.menuItemFilePrint);
        this.menuItemFileExit = new JMenuItem(bl ? SwingText.EXIT : SwingText.CLOSE);
        this.menuItemFileExit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JBasicFrame.this.windowIsClosing();
                JBasicFrame.this.dispose();
            }
        });
        jMenu.add(this.menuItemFileExit);
        this.menuBar.add(jMenu);
    }

    protected void setDefaultSize(int n, int n2) {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n3 = n < dimension.width ? n : dimension.width;
        int n4 = n2 < dimension.height ? n2 : dimension.height;
        this.setSize(n3, n4);
    }

    public void print(Graphics graphics) {
        int n = 24;
        try {
            n = Integer.valueOf(this.parentApp.getParameter("print.font.size"));
        }
        catch (Exception exception) {
            n = 24;
        }
        graphics.setFont(new Font("SansSerif", 0, n));
        PrintGraphics printGraphics = null;
        Dimension dimension = null;
        try {
            printGraphics = (PrintGraphics)((Object)graphics);
            PrintJob printJob = printGraphics.getPrintJob();
            dimension = printJob.getPageDimension();
            System.out.println("INFO: Print Page Dimension is: width=" + printJob.getPageDimension().width + " height=" + printJob.getPageDimension().height);
        }
        catch (ClassCastException classCastException) {
            String string = "ERROR: Cannot get PrintGraphics object: " + classCastException;
            System.out.println(string);
            if (this.parentApp != null) {
                this.parentApp.writeMessage(string);
            }
            return;
        }
        int n2 = 15;
        int n3 = dimension.width / n2;
        int n4 = dimension.height / n2;
        Dimension dimension2 = new Dimension(dimension.width - 2 * n3, dimension.height - 2 * n4);
        dimension2.height = dimension2.width = dimension2.width < dimension2.height ? dimension2.width : dimension2.height;
        System.out.println("drawOriginX, drawOriginY, drawSize.width, drawSize.height " + n3 + " " + n4 + " " + dimension2.width + " " + dimension2.height);
        Graphics graphics2 = graphics.create(n3, n4, dimension2.width, dimension2.height);
        this.display(graphics2, true);
        graphics2.dispose();
    }

    public void doPrintJob() {
        Cursor cursor = this.getCursor();
        int n = 150;
        try {
            n = Integer.valueOf(this.parentApp.getParameter("print.resolution"));
        }
        catch (Exception exception) {
            n = 150;
        }
        PrintJob printJob = null;
        try {
            printJob = PrintUtils.getPrintJob(this, this.getTitle(), n);
        }
        catch (Exception exception) {
            if (this.parentApp != null) {
                this.parentApp.writeAppletSecurityMessage(SwingText.PRINT, exception);
            }
            return;
        }
        if (printJob == null) {
            this.setCursor(cursor);
            return;
        }
        this.setCursor(new Cursor(3));
        if (this.parentApp != null) {
            this.parentApp.writeMessage("Printing...");
        }
        Graphics graphics = printJob.getGraphics();
        this.print(graphics);
        graphics.dispose();
        printJob.end();
        this.setCursor(cursor);
        if (this.parentApp != null) {
            this.parentApp.writeMessage("_READY");
        }
    }

    public abstract void windowIsClosing();

    public abstract void display(Graphics var1, boolean var2);
}

