/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.swing;

import java.awt.Cursor;
import java.awt.Frame;
import java.awt.JobAttributes;
import java.awt.PageAttributes;
import java.awt.PrintJob;
import java.awt.Toolkit;

public class PrintUtils {
    protected static JobAttributes jobAttributes = null;
    protected static PageAttributes pageAttributes = null;

    public static PrintJob getPrintJob(Frame frame, String string, int n) throws Exception {
        Cursor cursor = frame.getCursor();
        frame.setCursor(new Cursor(3));
        if (jobAttributes == null) {
            jobAttributes = new JobAttributes();
        }
        if (pageAttributes == null) {
            pageAttributes = new PageAttributes();
            pageAttributes.setMediaToDefault();
            pageAttributes.setOrientationRequestedToDefault();
            pageAttributes.setPrintQualityToDefault();
            pageAttributes.setPrinterResolutionToDefault();
            if (n < 1 || n > 10000) {
                n = 150;
            }
            pageAttributes.setPrinterResolution(n);
        }
        PrintJob printJob = null;
        try {
            printJob = Toolkit.getDefaultToolkit().getPrintJob(frame, string, jobAttributes, pageAttributes);
        }
        catch (InternalError internalError) {
            System.out.println(" Java printing internal error: " + internalError);
            frame.setCursor(cursor);
            return null;
        }
        catch (Exception exception) {
            frame.setCursor(cursor);
            throw exception;
        }
        frame.setCursor(cursor);
        return printJob;
    }
}

