/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.swing;

import java.applet.Applet;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.MenuShortcut;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Toolkit;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.awt.event.KeyListener;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.border.Border;
import net.alomax.swing.AJLJButton;
import net.alomax.swing.JPolygonButton;
import net.alomax.swing.LeftRightJButton;

public class SwingExt {
    public static int defaultBorderWidth = 10;
    public static Border defaultEmptyBorder = BorderFactory.createEmptyBorder(defaultBorderWidth, defaultBorderWidth, defaultBorderWidth, defaultBorderWidth);

    public static JMenuItem newJMenuItem(ActionListener actionListener, String string) {
        JMenuItem jMenuItem = new JMenuItem(string);
        jMenuItem.addActionListener(actionListener);
        return jMenuItem;
    }

    public static JMenuItem newJMenuItem(ActionListener actionListener, String string, MenuShortcut menuShortcut) {
        JMenuItem jMenuItem = new JMenuItem(string, menuShortcut.getKey());
        jMenuItem.addActionListener(actionListener);
        return jMenuItem;
    }

    public static JCheckBoxMenuItem newJCheckBoxMenuItem(ItemListener itemListener, String string) {
        JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(string);
        if (itemListener != null) {
            jCheckBoxMenuItem.addItemListener(itemListener);
        }
        return jCheckBoxMenuItem;
    }

    public static JButton newJButton(ActionListener actionListener, KeyListener keyListener, String string) {
        JButton jButton = new JButton(string);
        jButton.addActionListener(actionListener);
        jButton.addKeyListener(keyListener);
        return jButton;
    }

    public static JCheckBox newJCheckBox(ItemListener itemListener, String string) {
        JCheckBox jCheckBox = new JCheckBox(string);
        if (itemListener != null) {
            jCheckBox.addItemListener(itemListener);
        }
        return jCheckBox;
    }

    public static JTextField newJTextField(ActionListener actionListener, KeyListener keyListener, String string, int n) {
        JTextField jTextField = new JTextField(string, n);
        jTextField.addActionListener(actionListener);
        jTextField.addKeyListener(keyListener);
        return jTextField;
    }

    public static JTextField newJTextField(ActionListener actionListener, KeyListener keyListener, int n) {
        JTextField jTextField = new JTextField(n);
        jTextField.addActionListener(actionListener);
        jTextField.addKeyListener(keyListener);
        return jTextField;
    }

    public static JTextField newJTextField(ActionListener actionListener, KeyListener keyListener, String string) {
        JTextField jTextField = new JTextField(string);
        jTextField.addActionListener(actionListener);
        jTextField.addKeyListener(keyListener);
        return jTextField;
    }

    public static JComboBox newChoice(ItemListener itemListener, String[] stringArray) {
        JComboBox<String> jComboBox = new JComboBox<String>(stringArray);
        if (itemListener != null) {
            jComboBox.addItemListener(itemListener);
        }
        return jComboBox;
    }

    public static JLabel initPanelLabel(String string, JToolBar jToolBar) {
        JLabel jLabel = new JLabel(string, 2);
        jToolBar.add(jLabel);
        return jLabel;
    }

    public static JLabel initPanelLabel(String string, int n, JToolBar jToolBar) {
        JLabel jLabel = new JLabel(string, n);
        jToolBar.add(jLabel);
        return jLabel;
    }

    public static AJLJButton initPanelButton(String string, JToolBar jToolBar, ActionListener actionListener, KeyListener keyListener) {
        AJLJButton aJLJButton = new AJLJButton(actionListener, keyListener, string);
        jToolBar.add(aJLJButton);
        return aJLJButton;
    }

    public static LeftRightJButton initPanelLeftRightButton(JToolBar jToolBar, ActionListener actionListener, KeyListener keyListener) {
        LeftRightJButton leftRightJButton = new LeftRightJButton(actionListener, keyListener);
        jToolBar.add(leftRightJButton);
        return leftRightJButton;
    }

    public static JPolygonButton initPanelPolygonButton(Polygon[] polygonArray, JPanel jPanel, ActionListener actionListener, KeyListener keyListener, boolean bl) {
        JPolygonButton jPolygonButton = new JPolygonButton(polygonArray, "", actionListener, keyListener, bl);
        jPanel.add(jPolygonButton);
        return jPolygonButton;
    }

    public static void setLocationToCenter(Component component, Component component2, Point point) {
        SwingExt.setLocationToCenter(component, component2, point, 0.0);
    }

    public static void setLocationToCenter(Component component, Component component2, Point point, double d) {
        Dimension dimension = component.getSize();
        Dimension dimension2 = component2.getSize();
        int n = dimension2.width / 2 - dimension.width / 2;
        int n2 = dimension2.height / 2 - dimension.height / 2;
        int n3 = (int)(d * (double)dimension2.width);
        int n4 = (int)(d * (double)dimension2.height);
        component.setLocation(point.x + n + n3, point.y + n2 + n4);
    }

    public static void setLocationToCenterOfScreen(Component component) {
        Dimension dimension = component.getSize();
        Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
        int n = dimension2.width / 2 - dimension.width / 2;
        int n2 = dimension2.height / 2 - dimension.height / 2;
        component.setLocation(n, n2);
    }

    public static void setLocationToLeftCenterOfScreen(Component component) {
        int n;
        Dimension dimension = component.getSize();
        Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
        int n2 = n = dimension2.height / 2 - dimension.height / 2;
        component.setLocation(n2, n);
    }

    public static void setLocationOnScreen(Component component, double d, double d2) {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n = (int)((double)dimension.width * d);
        int n2 = (int)((double)dimension.height * d2);
        component.setLocation(n, n2);
    }

    public static void setProportionalSize(Component component, double d, double d2) {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        component.setSize((int)((double)dimension.width * d), (int)((double)dimension.height * d2));
    }

    public static void setProportionalSize(Component component, double d, double d2, double d3) {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        if (d2 * (double)dimension.height / (d * (double)dimension.width) > d3) {
            d = d2 * (double)dimension.height / d3 * (double)dimension.width;
            if (d > 1.0) {
                d = 0.95;
            }
        } else if (d * (double)dimension.width / (d2 * (double)dimension.height) > d3 && (d2 = d * (double)dimension.width / d3 * (double)dimension.height) > 1.0) {
            d2 = 0.95;
        }
        component.setSize((int)((double)dimension.width * d), (int)((double)dimension.height * d2));
    }

    public static void setProportionalSize(Component component, Component component2, double d, double d2) {
        Dimension dimension = component2.getSize();
        component.setSize((int)((double)dimension.width * d), (int)((double)dimension.height * d2));
    }

    public static boolean getTrueFalseParameter(Applet applet, String string, boolean bl) {
        String string2 = applet.getParameter(string);
        if (string2 != null) {
            return SwingExt.evaluateTrueFalseParameter(string, string2, bl);
        }
        return bl;
    }

    public static boolean evaluateTrueFalseParameter(String string, String string2, boolean bl) {
        if (string2 != null) {
            if (string2.toUpperCase().indexOf("YES") >= 0 || string2.toUpperCase().equals("Y") || string2.toUpperCase().indexOf("TRUE") >= 0 || string2.toUpperCase().indexOf("ON") >= 0) {
                return true;
            }
            if (string2.toUpperCase().indexOf("NO") >= 0 || string2.toUpperCase().equals("N") || string2.toUpperCase().indexOf("FALSE") >= 0 || string2.toUpperCase().indexOf("OFF") >= 0) {
                return false;
            }
        } else {
            System.err.println("ERROR: invalid value: " + string2 + ": for true/false parameter: " + string);
        }
        return bl;
    }

    public static Image getImageResource(Component component, String string) {
        Image image = null;
        try {
            URL uRL = component.getClass().getResource(string);
            if (uRL == null && (uRL = component.getClass().getClassLoader().getResource(string)) == null) {
                throw new Exception();
            }
            image = component.getToolkit().createImage(uRL);
            if (image == null) {
                throw new Exception();
            }
        }
        catch (Exception exception) {
            return null;
        }
        try {
            int n;
            boolean bl = component.prepareImage(image, null);
            int n2 = 0;
            while (n2++ < 50 && ((n = component.checkImage(image, null)) & 0x20) == 0) {
                try {
                    Thread.currentThread();
                    Thread.sleep(10L);
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return image;
    }

    public static boolean setImage(Component component, AJLJButton aJLJButton, String string) {
        Image image = SwingExt.getImageResource(component, string);
        if (image == null) {
            return false;
        }
        aJLJButton.setImage(image);
        return true;
    }
}

