/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.timedom;

import net.alomax.math.TimeSeries;
import net.alomax.timedom.BasicPicker;
import net.alomax.timedom.PickData;
import net.alomax.timedom.TimeDomainException;
import net.alomax.timedom.TimeDomainText;

public class BaerKradolferPicker
extends BasicPicker {
    private static final double WINDOW_MIN = Double.MIN_VALUE;
    private static final double WINDOW_MAX = Double.MAX_VALUE;
    public double longTermWindow = 100.0;
    public double threshold1 = 10.0;
    public double threshold2 = 20.0;
    public double tUpEvent = 0.5;
    public double tDownMax = 0.25;
    public String errorMessage;
    private static final double THRESHOLD_MIN = Double.MIN_VALUE;
    private static final double THRESHOLD_MAX = Double.MAX_VALUE;
    private static final double TIME_MIN = -1.7976931348623157E308;
    private static final double TIME_MAX = Double.MAX_VALUE;

    public BaerKradolferPicker(String string, double d, double d2, double d3, double d4, double d5, int n) {
        super(string, n);
        this.longTermWindow = d;
        this.threshold1 = d2;
        this.threshold2 = d3;
        this.tUpEvent = d4;
        this.tDownMax = d5;
    }

    public void setLongTermWindow(double d) throws TimeDomainException {
        if (d < Double.MIN_VALUE || d > Double.MAX_VALUE) {
            throw new TimeDomainException(TimeDomainText.invalid_long_term_window_value + ": " + d);
        }
        this.longTermWindow = d;
    }

    public void setLongTermWindow(String string) throws TimeDomainException {
        double d;
        try {
            d = Double.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new TimeDomainException(TimeDomainText.invalid_long_term_window_value + ": " + string);
        }
        this.setLongTermWindow(d);
    }

    public void setThreshold1(double d) throws TimeDomainException {
        if (d < Double.MIN_VALUE || d > Double.MAX_VALUE) {
            throw new TimeDomainException(TimeDomainText.invalid_threshold1_value + ": " + d);
        }
        this.threshold1 = d;
    }

    public void setThreshold1(String string) throws TimeDomainException {
        double d;
        try {
            d = Double.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new TimeDomainException(TimeDomainText.invalid_threshold1_value + ": " + string);
        }
        this.setThreshold1(d);
    }

    public void setThreshold2(double d) throws TimeDomainException {
        if (d < Double.MIN_VALUE || d > Double.MAX_VALUE) {
            throw new TimeDomainException(TimeDomainText.invalid_threshold2_value + ": " + d);
        }
        this.threshold2 = d;
    }

    public void setThreshold2(String string) throws TimeDomainException {
        double d;
        try {
            d = Double.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new TimeDomainException(TimeDomainText.invalid_threshold2_value + ": " + string);
        }
        this.setThreshold2(d);
    }

    public void setTUpEvent(double d) throws TimeDomainException {
        if (d < -1.7976931348623157E308 || d > Double.MAX_VALUE) {
            throw new TimeDomainException(TimeDomainText.invalid_tUpEvent_value + ": " + d);
        }
        this.tUpEvent = d;
    }

    public void setTUpEvent(String string) throws TimeDomainException {
        double d;
        try {
            d = Double.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new TimeDomainException(TimeDomainText.invalid_tUpEvent_value + ": " + string);
        }
        this.setTUpEvent(d);
    }

    public void setTDownMax(double d) throws TimeDomainException {
        if (d < -1.7976931348623157E308 || d > Double.MAX_VALUE) {
            throw new TimeDomainException(TimeDomainText.invalid_tDownMax_value + ": " + d);
        }
        this.tDownMax = d;
    }

    public void setTDownMax(String string) throws TimeDomainException {
        double d;
        try {
            d = Double.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new TimeDomainException(TimeDomainText.invalid_tDownMax_value + ": " + string);
        }
        this.setTDownMax(d);
    }

    public void checkSettings() throws TimeDomainException {
        super.checkSettings();
        String string = "";
        int n = 0;
        if (this.longTermWindow < Double.MIN_VALUE || this.longTermWindow > Double.MAX_VALUE) {
            string = string + ": " + TimeDomainText.invalid_long_term_window_value;
            ++n;
        }
        if (this.threshold1 < Double.MIN_VALUE || this.threshold1 > Double.MAX_VALUE) {
            string = string + ": " + TimeDomainText.invalid_threshold1_value;
            ++n;
        }
        if (this.threshold2 < Double.MIN_VALUE || this.threshold2 > Double.MAX_VALUE) {
            string = string + ": " + TimeDomainText.invalid_threshold2_value;
            ++n;
        }
        if (this.tUpEvent < -1.7976931348623157E308 || this.tUpEvent > Double.MAX_VALUE) {
            string = string + ": " + TimeDomainText.invalid_tUpEvent_value;
            ++n;
        }
        if (this.tDownMax < -1.7976931348623157E308 || this.tDownMax > Double.MAX_VALUE) {
            string = string + ": " + TimeDomainText.invalid_tDownMax_value;
            ++n;
        }
        if (n > 0) {
            throw new TimeDomainException(string + ".");
        }
    }

    public final float[] apply(double d, float[] fArray) {
        double d2 = 1.0;
        int n = -1;
        double d3 = 1.0 - d / this.longTermWindow;
        double d4 = 1.0 - d3;
        int n2 = 1 + (int)(this.longTermWindow / d);
        float f = 0.0f;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        double d9 = 0.0;
        double d10 = 0.0;
        double d11 = 0.0;
        boolean bl = false;
        boolean bl2 = this.direction == -1;
        int n3 = -1;
        int n4 = -1;
        int n5 = -1;
        int n6 = 1 + (int)(this.tUpEvent / d);
        int n7 = 1 + (int)(this.tDownMax / d);
        boolean bl3 = false;
        double d12 = 0.0;
        boolean bl4 = false;
        if (this.resultType == 2 || this.resultType == 1) {
            fArray[fArray.length - 1] = 0.0f;
            fArray[0] = 0.0f;
        }
        for (int i = 1; i < fArray.length - 1; ++i) {
            int n8 = bl2 ? fArray.length - i - 1 : i;
            double d13 = fArray[n8];
            double d14 = fArray[n8] - f;
            f = fArray[n8];
            double d15 = d6 > (double)1.4E-45f ? d13 * d13 + d14 * d14 * (d5 / d6) : d13 * d13 + d14 * d14 / (d * d);
            double d16 = d15 * d15;
            if (Double.isInfinite(d16) || d16 > Math.sqrt(Double.MAX_VALUE)) {
                d16 = Math.sqrt(Double.MAX_VALUE);
            }
            if ((d11 = d9 <= (double)1.4E-45f ? 0.0 : (d16 - d10) / d9) < this.threshold2) {
                d5 = d5 * d3 + d13 * d13 * d4;
                d6 = d6 * d3 + d14 * d14 * d4;
                d10 = d7 = d7 * d3 + d16 * d4;
                double d17 = d16 - d10;
                d8 = d8 * d3 + d17 * d17 * d4;
                d9 = Math.sqrt(d8);
            }
            if (d11 >= d2) {
                if (n < 0) {
                    n = n8;
                }
            } else {
                n = -1;
            }
            if (d11 >= this.threshold1) {
                if (!bl) {
                    bl = true;
                    n3 = n8;
                    n4 = i + n6;
                    d12 = d11;
                } else if (i >= n4) {
                    bl3 = true;
                    bl = false;
                }
                n5 = -1;
            } else if (bl) {
                if (i < n4) {
                    if (n5 < 0) {
                        n5 = i + n7;
                    } else if (i >= n5) {
                        bl = false;
                    }
                } else {
                    bl = false;
                }
            }
            if (this.resultType == 2) {
                fArray[n8] = bl3 ? 1.0f : 0.0f;
            } else if (this.resultType == 1) {
                fArray[n8] = (float)d11;
            } else if (bl3) {
                PickData pickData = new PickData(n == n3 ? n - 1 : n, n3, 0, d12, "_CF");
                this.triggerPickData.add(pickData);
                n = -1;
            }
            bl3 = false;
        }
        return fArray;
    }

    public void updateFields(TimeSeries timeSeries) {
        super.updateFields(timeSeries);
    }
}

