/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.timedom;

import net.alomax.math.TimeSeries;
import net.alomax.timedom.TimeDomainException;
import net.alomax.timedom.TimeDomainProcess;
import net.alomax.timedom.TimeDomainText;

public class InstantPeriod
extends TimeDomainProcess {
    public double alpha;
    public String errorMessage;
    private static final double ALPHA_MIN = Double.MIN_VALUE;
    private static final double ALPHA_MAX = Double.MAX_VALUE;

    public InstantPeriod(String string, double d) {
        this.alpha = d;
        this.errorMessage = " ";
        TimeDomainText.setLocale(string);
    }

    public void setAlpha(double d) throws TimeDomainException {
        if (d < Double.MIN_VALUE || d > Double.MAX_VALUE) {
            throw new TimeDomainException(TimeDomainText.invalid_alpha_value);
        }
        this.alpha = d;
    }

    public void setAlpha(String string) throws TimeDomainException {
        double d;
        try {
            d = Double.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new TimeDomainException(TimeDomainText.invalid_alpha_value);
        }
        this.setAlpha(d);
    }

    public void checkSettings() throws TimeDomainException {
        String string = "";
        int n = 0;
        if (this.alpha < Double.MIN_VALUE || this.alpha > Double.MAX_VALUE) {
            string = string + ": " + TimeDomainText.invalid_alpha_value;
            ++n;
        }
        if (n > 0) {
            throw new TimeDomainException(string + ".");
        }
    }

    public final float[] apply(double d, float[] fArray) {
        double d2 = 6.2831854820251465;
        float f = (float)d;
        float f2 = (float)(1.0 - d / this.alpha);
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        for (int i = 0; i < fArray.length; ++i) {
            f3 = f3 * f2 + fArray[i] * fArray[i];
            float f6 = (fArray[i] - f5) / f;
            f4 = f4 * f2 + f6 * f6;
            f5 = fArray[i];
            fArray[i] = (float)(d2 * Math.sqrt(f3 / f4));
        }
        return fArray;
    }

    public void updateFields(TimeSeries timeSeries) {
        timeSeries.ampUnits = timeSeries.timeUnits;
    }

    public boolean amplititudeModified() {
        return true;
    }
}

