/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.timedom;

import java.util.Vector;
import net.alomax.math.TimeSeries;
import net.alomax.timedom.PickData;
import net.alomax.timedom.TimeDomainException;
import net.alomax.timedom.TimeDomainProcess;
import net.alomax.timedom.TimeDomainText;

public class PeakExtractor
extends TimeDomainProcess {
    public int maxNumberPeaks = 5;
    public double minAmplitude = 0.25;
    public double stdDevWidth = 1.0;
    public String errorMessage;
    protected Vector peakPicks = new Vector();
    private static final int NUMBER_PEAKS_MIN = 1;
    private static final int NUMBER_PEAKS_MAX = Integer.MAX_VALUE;
    private static final double MIN_AMP_MIN = 0.0;
    private static final double MIN_AMP_MAX = 1.0;
    private static final double NUM_DEV_MIN = Double.MIN_VALUE;
    private static final double NUM_DEV_MAX = Double.MAX_VALUE;
    public static final int MODE_CENTER_BETWEEN_LR_STD = 0;
    public static final int MODE_CENTER_ON_PEAK_STD_L = 1;
    public int mode = 1;

    public PeakExtractor(String string, int n, double d, double d2) {
        this.maxNumberPeaks = n;
        this.minAmplitude = d;
        this.stdDevWidth = d2;
        this.errorMessage = " ";
        TimeDomainText.setLocale(string);
    }

    public void setMaxNumberPeaks(int n) throws TimeDomainException {
        if (n < 1 || n > Integer.MAX_VALUE) {
            throw new TimeDomainException(TimeDomainText.invalid_peakext_max_num_peaks_value + ": " + n);
        }
        this.maxNumberPeaks = n;
    }

    public void setMaxNumberPeaks(String string) throws TimeDomainException {
        int n;
        try {
            n = Integer.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new TimeDomainException(TimeDomainText.invalid_peakext_max_num_peaks_value + ": " + string);
        }
        this.setMaxNumberPeaks(n);
    }

    public void setMinAmplitude(double d) throws TimeDomainException {
        if (d < 0.0 || d > 1.0) {
            throw new TimeDomainException(TimeDomainText.invalid_min_amplitude_value + ": " + d);
        }
        this.minAmplitude = d;
    }

    public void setMinAmplitude(String string) throws TimeDomainException {
        double d;
        try {
            d = Double.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new TimeDomainException(TimeDomainText.invalid_min_amplitude_value + ": " + string);
        }
        this.setMinAmplitude(d);
    }

    public void setDevWidth(double d) throws TimeDomainException {
        if (d < Double.MIN_VALUE || d > Double.MAX_VALUE) {
            throw new TimeDomainException(TimeDomainText.invalid_deviation_value + ": " + d);
        }
        this.stdDevWidth = d;
    }

    public void setDevWidth(String string) throws TimeDomainException {
        double d;
        try {
            d = Double.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new TimeDomainException(TimeDomainText.invalid_deviation_value + ": " + string);
        }
        this.setDevWidth(d);
    }

    public Vector getPickData() {
        return this.peakPicks;
    }

    public void checkSettings() throws TimeDomainException {
        String string = "";
        int n = 0;
        if (this.maxNumberPeaks < 1 || this.maxNumberPeaks > Integer.MAX_VALUE) {
            string = string + ": " + TimeDomainText.invalid_peakext_max_num_peaks_value;
            ++n;
        }
        if (n > 0) {
            throw new TimeDomainException(string + ".");
        }
    }

    public final float[] apply(double d, float[] fArray) {
        float f = (float)Math.exp(-0.5 * this.stdDevWidth);
        float f2 = (float)Math.exp(-0.5 * this.stdDevWidth / 10.0);
        this.peakPicks = new Vector();
        int[] nArray = new int[this.maxNumberPeaks];
        int[] nArray2 = new int[this.maxNumberPeaks];
        float f3 = 0.0f;
        for (int i = 0; i < this.maxNumberPeaks; ++i) {
            float f4;
            float f5 = -3.4028235E38f;
            int n = -1;
            boolean bl = false;
            boolean bl2 = false;
            for (int j = 0; j < fArray.length; ++j) {
                if (this.indexInvalid(j, nArray, nArray2, i)) {
                    f5 = -3.4028235E38f;
                    n = -1;
                    bl = false;
                    continue;
                }
                f4 = fArray[j];
                if (f4 - f5 > Float.MIN_VALUE) {
                    if (n > 0) {
                        bl = true;
                    }
                    f5 = f4;
                    n = j;
                    continue;
                }
                if (!bl || !(f5 - f4 > Float.MIN_VALUE)) continue;
                bl2 = true;
                break;
            }
            if (!bl2 || n <= 0 || n == fArray.length - 1) break;
            if (i > 0) {
                if ((double)f5 < (double)f3 * this.minAmplitude) {
                    break;
                }
            } else {
                f3 = f5;
            }
            float f6 = f5 * f;
            f4 = f5 * f2;
            float f7 = 0.0f;
            float f8 = Float.MAX_VALUE;
            int n2 = -1;
            int n3 = -1;
            for (n2 = n; n2 > 0 && !this.indexInvalid(n2, nArray, nArray2, i); --n2) {
                f7 = fArray[n2];
                if (f7 < f4) {
                    if (f6 - f7 > Float.MIN_VALUE) {
                        n3 = n2;
                        break;
                    }
                    if (f7 - f8 > Float.MIN_VALUE) {
                        n3 = n2;
                        break;
                    }
                }
                f8 = f7;
            }
            f8 = Float.MAX_VALUE;
            int n4 = -1;
            int n5 = -1;
            for (n4 = n; n4 < fArray.length && !this.indexInvalid(n4, nArray, nArray2, i); ++n4) {
                f7 = fArray[n4];
                if (f7 < f4) {
                    if (f6 - f7 > Float.MIN_VALUE) {
                        n5 = n4;
                        break;
                    }
                    if (f7 - f8 > Float.MIN_VALUE) {
                        n5 = n4;
                        break;
                    }
                }
                f8 = f7;
            }
            if (n3 < 0 && n5 < 0) break;
            if (n3 < 0) {
                n3 = n - (n5 - n);
            } else if (n5 < 0) {
                n5 = n + (n - n3);
            }
            double[] dArray = new double[2];
            if (this.mode == 0) {
                dArray[0] = n3;
                dArray[1] = n5;
            } else if (this.mode == 1) {
                int n6 = n - n3;
                dArray[0] = n - n6;
                dArray[1] = n + n6;
            }
            PickData pickData = new PickData(dArray[0], dArray[1], 0, f5, "_DATA");
            this.peakPicks.add(pickData);
            nArray[i] = n2;
            nArray2[i] = n4;
        }
        return fArray;
    }

    protected final boolean indexInvalid(int n, int[] nArray, int[] nArray2, int n2) {
        for (int i = 0; i < n2; ++i) {
            if (n < nArray[i] || n > nArray2[i]) continue;
            return true;
        }
        return false;
    }

    public void updateFields(TimeSeries timeSeries) {
        timeSeries.ampUnits = "counts";
    }

    public boolean amplititudeModified() {
        return false;
    }
}

