/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.timedom;

import net.alomax.math.TimeSeries;
import net.alomax.timedom.BasicPicker;
import net.alomax.timedom.PickData;
import net.alomax.timedom.TimeDomainException;
import net.alomax.timedom.TimeDomainMemory;
import net.alomax.timedom.TimeDomainText;

public class TestPicker4
extends BasicPicker {
    private static final double WINDOW_MIN = Double.MIN_VALUE;
    private static final double WINDOW_MAX = Double.MAX_VALUE;
    public double longTermWindow = 25.0;
    public double threshold1 = 10.0;
    public double threshold2 = 10.0;
    public double tUpEvent = 0.5;
    public double filterWindow = 10.0;
    public String errorMessage;
    private static final double THRESHOLD_MIN = Double.MIN_VALUE;
    private static final double THRESHOLD_MAX = Double.MAX_VALUE;
    private static final double TIME_MIN = -1.7976931348623157E308;
    private static final double TIME_MAX = Double.MAX_VALUE;
    private static final int INT_UNSET = -1073741823;
    private TestPicker4_Memory mem = null;
    private double deltaTime;

    public TestPicker4(String string, double d, double d2, double d3, double d4, double d5, int n) {
        super(string, n);
        this.longTermWindow = d;
        this.threshold1 = d2;
        this.threshold2 = d3;
        this.tUpEvent = d4;
        this.filterWindow = d5;
    }

    public TestPicker4(TestPicker4 testPicker4) {
        super(testPicker4.direction);
        this.resultType = testPicker4.resultType;
        this.longTermWindow = testPicker4.longTermWindow;
        this.threshold1 = testPicker4.threshold1;
        this.threshold2 = testPicker4.threshold2;
        this.tUpEvent = testPicker4.tUpEvent;
        this.filterWindow = testPicker4.filterWindow;
    }

    public void setLongTermWindow(double d) throws TimeDomainException {
        if (d < Double.MIN_VALUE || d > Double.MAX_VALUE) {
            throw new TimeDomainException(TimeDomainText.invalid_long_term_window_value + ": " + d);
        }
        this.longTermWindow = d;
    }

    public void setLongTermWindow(String string) throws TimeDomainException {
        double d;
        try {
            d = Double.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new TimeDomainException(TimeDomainText.invalid_long_term_window_value + ": " + string);
        }
        this.setLongTermWindow(d);
    }

    public void setThreshold1(double d) throws TimeDomainException {
        if (d < Double.MIN_VALUE || d > Double.MAX_VALUE) {
            throw new TimeDomainException(TimeDomainText.invalid_threshold1_value + ": " + d);
        }
        this.threshold1 = d;
    }

    public void setThreshold1(String string) throws TimeDomainException {
        double d;
        try {
            d = Double.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new TimeDomainException(TimeDomainText.invalid_threshold1_value + ": " + string);
        }
        this.setThreshold1(d);
    }

    public void setThreshold2(double d) throws TimeDomainException {
        if (d < Double.MIN_VALUE || d > Double.MAX_VALUE) {
            throw new TimeDomainException(TimeDomainText.invalid_threshold2_value + ": " + d);
        }
        this.threshold2 = d;
    }

    public void setThreshold2(String string) throws TimeDomainException {
        double d;
        try {
            d = Double.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new TimeDomainException(TimeDomainText.invalid_threshold2_value + ": " + string);
        }
        this.setThreshold2(d);
    }

    public void setTUpEvent(double d) throws TimeDomainException {
        if (d < -1.7976931348623157E308 || d > Double.MAX_VALUE) {
            throw new TimeDomainException(TimeDomainText.invalid_tUpEvent_value + ": " + d);
        }
        this.tUpEvent = d;
    }

    public void setTUpEvent(String string) throws TimeDomainException {
        double d;
        try {
            d = Double.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new TimeDomainException(TimeDomainText.invalid_tUpEvent_value + ": " + string);
        }
        this.setTUpEvent(d);
    }

    public void setMeanWindow(double d) throws TimeDomainException {
        if (d < Double.MIN_VALUE || d > Double.MAX_VALUE) {
            throw new TimeDomainException(TimeDomainText.invalid_filterWindow_value + ": " + d);
        }
        this.filterWindow = d;
    }

    public void setMeanWindow(String string) throws TimeDomainException {
        double d;
        try {
            d = Double.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new TimeDomainException(TimeDomainText.invalid_filterWindow_value + ": " + string);
        }
        this.setMeanWindow(d);
    }

    public void checkSettings() throws TimeDomainException {
        super.checkSettings();
        String string = "";
        int n = 0;
        if (this.longTermWindow < Double.MIN_VALUE || this.longTermWindow > Double.MAX_VALUE) {
            string = string + ": " + TimeDomainText.invalid_long_term_window_value;
            ++n;
        }
        if (this.threshold1 < Double.MIN_VALUE || this.threshold1 > Double.MAX_VALUE) {
            string = string + ": " + TimeDomainText.invalid_threshold1_value;
            ++n;
        }
        if (this.threshold2 < Double.MIN_VALUE || this.threshold2 > Double.MAX_VALUE) {
            string = string + ": " + TimeDomainText.invalid_threshold2_value;
            ++n;
        }
        if (this.tUpEvent < -1.7976931348623157E308 || this.tUpEvent > Double.MAX_VALUE) {
            string = string + ": " + TimeDomainText.invalid_tUpEvent_value;
            ++n;
        }
        if (this.filterWindow < -1.7976931348623157E308 || this.filterWindow > Double.MAX_VALUE) {
            string = string + ": " + TimeDomainText.invalid_filterWindow_value;
            ++n;
        }
        if (n > 0) {
            throw new TimeDomainException(string + ".");
        }
    }

    public void updateFields(TimeSeries timeSeries) {
        super.updateFields(timeSeries);
    }

    public final float[] apply(double d, float[] fArray) {
        this.deltaTime = d;
        if (this.mem == null) {
            this.mem = new TestPicker4_Memory(fArray);
        }
        float[] fArray2 = null;
        if (this.resultType == 2 || this.resultType == 1) {
            fArray2 = new float[fArray.length];
        }
        double d2 = 5.0 * this.threshold1;
        for (int i = 0; i < fArray.length; ++i) {
            boolean bl;
            for (int j = 0; j < this.mem.numRecursive; ++j) {
                this.mem.mean_xRec_ACTIVE[j] = this.mem.mean_xRec[j];
                this.mem.mean_stdDev_xRec_ACTIVE[j] = this.mem.mean_stdDev_xRec[j];
            }
            double d3 = 0.0;
            int n = -1;
            float f = fArray[i];
            this.mem.numPreviousPtr = (this.mem.numPreviousPtr + 1) % this.mem.numPrevious;
            this.mem.numPreviousPtrLast = (this.mem.numPreviousPtrLast + 1) % this.mem.numPrevious;
            for (int j = this.mem.numRecursive - 1; j >= 0; --j) {
                this.mem.filteredSample[j][this.mem.numPreviousPtr] = this.mem.filteredSample[j][this.mem.numPreviousPtrLast] * this.mem.decayConst[j] + (double)f * this.mem.decayFactor[j];
                int n2 = (2 * this.mem.numPrevious + this.mem.numPreviousPtr - this.mem.indexDelay[j]) % this.mem.numPrevious;
                this.mem.xRec[j] = this.mem.filteredSample[j][this.mem.numPreviousPtr] - this.mem.filteredSample[j][n2];
                this.mem.test[j] = this.mem.filteredSample[j][n2];
                int n3 = j;
                this.mem.xRec[n3] = this.mem.xRec[n3] * this.mem.xRec[j];
                if (this.mem.mean_stdDev_xRec_ACTIVE[j] <= (double)1.4E-45f) {
                    if (!this.mem.enableTriggering) continue;
                    System.out.println("ERROR: mem.mean_stdDev_xRec_ACTIVE[k] <= Float.MIN_VALUE (this should not happen!)");
                    continue;
                }
                double d4 = (this.mem.xRec[j] - this.mem.mean_xRec_ACTIVE[j]) / this.mem.mean_stdDev_xRec_ACTIVE[j];
                if (d4 > d2) {
                    d4 = d2;
                    this.mem.xRec[j] = d2 * this.mem.mean_stdDev_xRec_ACTIVE[j] + this.mem.mean_xRec_ACTIVE[j];
                }
                if (!(d4 > d3)) continue;
                d3 = d4;
                n = j;
            }
            double d5 = d3 < d2 ? d3 : d2;
            this.mem.charFunctUncertainty = (d3 + this.mem.charFunctLast1) / 2.0;
            boolean bl2 = bl = this.mem.charFunctLast1Smooth < this.mem.charFunctLast2Smooth && this.mem.charFunctLast1Smooth < this.mem.charFunctUncertainty || d3 >= this.mem.uncertaintyThreshold && this.mem.charFunctLast1 < this.mem.uncertaintyThreshold;
            if (bl) {
                this.mem.uncertaintyAtResetCharFunctUncertainty = this.mem.charFunctUncertainty;
            }
            this.mem.charFunctLast2 = this.mem.charFunctLast1;
            this.mem.charFunctLast1 = d3;
            this.mem.charFunctLast2Smooth = this.mem.charFunctLast1Smooth;
            this.mem.charFunctLast1Smooth = this.mem.charFunctUncertainty;
            if (bl || this.mem.charFunctUncertainty > this.mem.uncertaintyAtResetCharFunctUncertainty) {
                if ((bl || this.mem.indexUncertainty == -1073741823) && !this.mem.inTriggerEvent) {
                    this.mem.indexUncertainty = i - 1;
                    this.mem.amplitudeUncertainty = this.mem.lastSample;
                    this.mem.countPolarity = 0;
                }
            } else if (!this.mem.inTriggerEvent) {
                this.mem.indexUncertainty = -1073741823;
            }
            int n4 = 0;
            if (this.mem.indexUncertainty != -1073741823 && !this.mem.inTriggerEvent) {
                n4 = (double)f - this.mem.lastSample > 0.0 ? 1 : -1;
                this.mem.countPolarity += n4;
            }
            if (this.mem.enableTriggering || this.mem.nTotal++ > this.mem.indexEnableTriggering) {
                this.mem.enableTriggering = true;
                this.mem.upEventBufPtr = (this.mem.upEventBufPtr + 1) % this.mem.nTUpEvent;
                this.mem.integralCharFunct -= this.mem.upEventCharFunctValue[this.mem.upEventBufPtr];
                this.mem.upEventCharFunctValue[this.mem.upEventBufPtr] = d3;
                if (this.mem.inTriggerEvent) {
                    this.mem.integralCharFunct += d5;
                    this.mem.upEventCharFunctValue[this.mem.upEventBufPtr] = d5;
                    this.mem.ampCharFunctSum += d3;
                    if (i <= this.mem.indexUpEventEnd) {
                        if (!this.mem.willAcceptPick && this.mem.integralCharFunct >= this.mem.criticalIntegralCharFunct) {
                            this.mem.willAcceptPick = true;
                        }
                    } else {
                        if (this.mem.willAcceptPick) {
                            this.mem.acceptedPick = true;
                            this.mem.underThresholdSinceLastTrigger = false;
                        } else {
                            this.mem.indexUpEventEnd = -1073741823;
                        }
                        this.mem.willAcceptPick = false;
                        this.mem.inTriggerEvent = false;
                    }
                } else if (this.mem.underThresholdSinceLastTrigger && d3 >= this.threshold1) {
                    this.mem.inTriggerEvent = true;
                    this.mem.triggerNumRecursiveIndex = n;
                    this.mem.ampCharFunctSum = d3;
                    this.mem.indexUpEvent = i;
                    this.mem.indexUpEventEnd = i + this.mem.nTUpEvent;
                    this.mem.integralCharFunct += d5;
                    this.mem.upEventCharFunctValue[this.mem.upEventBufPtr] = d5;
                    if (i > this.mem.indexUncertainty + 1) {
                        this.mem.countPolarity -= n4;
                    }
                    this.mem.pickPolarity = this.mem.countPolarity > 0 ? 1 : (this.mem.countPolarity < 0 ? -1 : 0);
                } else {
                    this.mem.integralCharFunct += d5;
                    this.mem.upEventCharFunctValue[this.mem.upEventBufPtr] = d5;
                    if (this.mem.charFunctUncertainty < this.mem.uncertaintyThreshold) {
                        this.mem.underThresholdSinceLastTrigger = true;
                    }
                }
            }
            for (int j = 0; j < this.mem.numRecursive; ++j) {
                this.mem.mean_xRec[j] = this.mem.mean_xRec[j] * this.mem.longDecayConst + this.mem.xRec[j] * this.mem.longDecayFactor;
                double d6 = this.mem.xRec[j] - this.mem.mean_xRec[j];
                this.mem.mean_var_xRec[j] = this.mem.mean_var_xRec[j] * this.mem.longDecayConst + d6 * d6 * this.mem.longDecayFactor;
                this.mem.mean_stdDev_xRec[j] = Math.sqrt(this.mem.mean_var_xRec[j]);
            }
            if (this.resultType == 2) {
                fArray2[i] = this.mem.acceptedPick ? 1.0f : 0.0f;
                fArray2[i] = (float)this.mem.test[this.mem.numRecursive - 1];
            } else if (this.resultType == 1) {
                fArray2[i] = (float)d3;
            } else if (this.mem.acceptedPick) {
                double d7 = d / this.mem.decayFactor[this.mem.triggerNumRecursiveIndex];
                PickData pickData = new PickData(this.mem.indexUncertainty, this.mem.indexUpEvent, this.mem.pickPolarity, Math.log(this.mem.ampCharFunctSum / this.mem.criticalIntegralCharFunct), "_CF", d7);
                this.triggerPickData.add(pickData);
            }
            this.mem.acceptedPick = false;
            this.mem.lastSample = f;
        }
        if (this.useMemory) {
            this.mem.indexUncertainty -= fArray.length;
            this.mem.indexUpEvent -= fArray.length;
            this.mem.indexUpEvent = this.mem.indexUpEvent < -1073741823 ? -1073741823 : this.mem.indexUpEvent;
            this.mem.indexUpEventEnd -= fArray.length;
            this.mem.indexUpEventEnd = this.mem.indexUpEventEnd < -1073741823 ? -1073741823 : this.mem.indexUpEventEnd;
        } else {
            this.mem = null;
        }
        if (this.resultType == 2 || this.resultType == 1) {
            fArray = fArray2;
        }
        return fArray;
    }

    public boolean supportsMemory() {
        return true;
    }

    public class TestPicker4_Memory
    extends TimeDomainMemory {
        double longDecayFactor;
        double longDecayConst;
        int nLongTermWindow;
        int indexEnableTriggering;
        boolean enableTriggering;
        int nTotal;
        int numPrevious;
        int numRecursive;
        int nTemp;
        double[] xRec;
        double[] test;
        double[][] filteredSample;
        double[] mean_xRec;
        double[] mean_xRec_ACTIVE;
        double[] mean_stdDev_xRec;
        double[] mean_stdDev_xRec_ACTIVE;
        double[] mean_var_xRec;
        double[] decayFactor;
        double[] decayConst;
        int[] indexDelay;
        int numPreviousPtr;
        int numPreviousPtrLast;
        double window;
        int nDelay;
        double lastSample;
        boolean dataGap;
        double charFunctUncertainty;
        double charFunctLast1;
        double charFunctLast2;
        double charFunctLast1Smooth;
        double charFunctLast2Smooth;
        double uncertaintyAtResetCharFunctUncertainty;
        double uncertaintyThreshold;
        double amplitudeUncertainty;
        int indexUncertainty;
        int countPolarity;
        boolean inTriggerEvent;
        double ampCharFunctSum;
        int indexUpEvent;
        int indexUpEventEnd;
        int nTUpEvent;
        double criticalIntegralCharFunct;
        double integralCharFunct;
        boolean underThresholdSinceLastTrigger;
        double[] upEventCharFunctValue;
        int upEventBufPtr;
        boolean acceptedPick;
        boolean willAcceptPick;
        int pickPolarity;
        int triggerNumRecursiveIndex;
        int nvar;

        public TestPicker4_Memory(float[] fArray) {
            int n;
            this.longDecayFactor = TestPicker4.this.deltaTime / TestPicker4.this.longTermWindow;
            this.longDecayConst = 1.0 - this.longDecayFactor;
            this.indexEnableTriggering = this.nLongTermWindow = 1 + (int)(TestPicker4.this.longTermWindow / TestPicker4.this.deltaTime);
            this.enableTriggering = false;
            this.nTotal = -1;
            this.numPrevious = (int)(TestPicker4.this.filterWindow / TestPicker4.this.deltaTime);
            this.numRecursive = 1;
            this.nTemp = 1;
            while (this.nTemp < this.numPrevious) {
                ++this.numRecursive;
                this.nTemp *= 2;
            }
            this.numPrevious = this.nTemp;
            this.xRec = new double[this.numRecursive];
            this.test = new double[this.numRecursive];
            this.filteredSample = new double[this.numRecursive][this.numPrevious];
            this.mean_xRec = new double[this.numRecursive];
            this.mean_xRec_ACTIVE = new double[this.numRecursive];
            this.mean_stdDev_xRec = new double[this.numRecursive];
            this.mean_stdDev_xRec_ACTIVE = new double[this.numRecursive];
            this.mean_var_xRec = new double[this.numRecursive];
            this.decayFactor = new double[this.numRecursive];
            this.decayConst = new double[this.numRecursive];
            this.indexDelay = new int[this.numRecursive];
            this.numPreviousPtr = -1;
            this.numPreviousPtrLast = this.numPrevious - 2;
            this.window = TestPicker4.this.deltaTime;
            this.nDelay = 1;
            for (n = 0; n < this.numRecursive; ++n) {
                this.mean_xRec[n] = 0.0;
                this.mean_stdDev_xRec[n] = 0.0;
                this.decayFactor[n] = TestPicker4.this.deltaTime / this.window;
                this.decayConst[n] = 1.0 - this.decayFactor[n];
                this.window *= 2.0;
                this.indexDelay[n] = this.nDelay + 1;
                this.nDelay *= 2;
                System.out.println("k, decayFactor[k], indexDelay[k] " + n + " " + this.decayFactor[n] + " " + this.indexDelay[n]);
            }
            this.lastSample = 0.0;
            this.dataGap = false;
            this.uncertaintyAtResetCharFunctUncertainty = Double.MAX_VALUE;
            this.uncertaintyThreshold = 2.0;
            this.indexUncertainty = -1073741823;
            this.inTriggerEvent = false;
            this.ampCharFunctSum = 0.0;
            this.indexUpEvent = -1073741823;
            this.indexUpEventEnd = -1073741823;
            this.nTUpEvent = (int)(0.5 + TestPicker4.this.tUpEvent / TestPicker4.this.deltaTime) - 1;
            if (this.nTUpEvent < 1) {
                this.nTUpEvent = 1;
            }
            this.criticalIntegralCharFunct = (double)this.nTUpEvent * TestPicker4.this.threshold2;
            this.integralCharFunct = 0.0;
            this.underThresholdSinceLastTrigger = false;
            this.upEventCharFunctValue = new double[this.nTUpEvent];
            this.upEventBufPtr = -1;
            this.acceptedPick = false;
            this.willAcceptPick = false;
            this.pickPolarity = 0;
            this.triggerNumRecursiveIndex = -1;
            this.nvar = 0;
            for (n = 0; n < this.numRecursive; ++n) {
                for (int i = 0; i < this.numPrevious; ++i) {
                    this.filteredSample[n][i] = fArray[0];
                }
            }
            System.out.println("TestPicker4_Memory initialized: numRecursive, numPrevious " + this.numRecursive + " " + this.numPrevious);
        }
    }
}

