/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.util;

import java.io.Serializable;
import net.alomax.util.Date2;
import net.alomax.util.NumberFormat;
import net.alomax.util.StringExt;

public class TimeInstant
extends Date2
implements Serializable {
    public static final double SEC_PER_MIN = 60.0;
    public static final double SEC_PER_HOUR = 3600.0;
    public static final double SEC_PER_DAY = 86400.0;
    protected int ihour;
    protected int imin;
    protected double sec;

    public static TimeInstant create(String string, String string2) throws Exception {
        String[] stringArray = StringExt.parse(string, string2);
        int n = Integer.parseInt(stringArray[0]);
        int n2 = Integer.parseInt(stringArray[1]);
        int n3 = Integer.parseInt(stringArray[2]);
        int n4 = Integer.parseInt(stringArray[3]);
        int n5 = Integer.parseInt(stringArray[4]);
        double d = Double.parseDouble(stringArray[5]);
        return new TimeInstant(n, n2, n3, n4, n5, d);
    }

    public static TimeInstant create(String string, String string2, String string3, String string4) throws Exception {
        String[] stringArray = StringExt.parse(string, string3);
        String[] stringArray2 = StringExt.parse(stringArray[0], string2);
        int n = Integer.parseInt(stringArray2[0]);
        int n2 = Integer.parseInt(stringArray2[1]);
        int n3 = Integer.parseInt(stringArray2[2]);
        String[] stringArray3 = StringExt.parse(stringArray[1], string4);
        int n4 = Integer.parseInt(stringArray3[0]);
        int n5 = Integer.parseInt(stringArray3[1]);
        double d = Double.parseDouble(stringArray3[2]);
        return new TimeInstant(n, n2, n3, n4, n5, d);
    }

    public TimeInstant(TimeInstant timeInstant) {
        super(timeInstant.year, timeInstant.dayOfYear);
        this.ihour = timeInstant.ihour;
        this.imin = timeInstant.imin;
        this.sec = timeInstant.sec;
    }

    public TimeInstant(int n, int n2, int n3, int n4, int n5, double d) {
        super(n, n2, n3);
        this.ihour = n4;
        this.imin = n5;
        this.sec = d;
    }

    public TimeInstant(int n, int n2, int n3) {
        this(n, n2, n3, 0, 0, 0.0);
    }

    public TimeInstant(int n, int n2, int n3, int n4, double d) {
        super(n, n2);
        this.ihour = n3;
        this.imin = n4;
        this.sec = d;
    }

    public TimeInstant(int n, int n2, String string, int n3, int n4, double d) {
        super(n, n2, string);
        this.ihour = n3;
        this.imin = n4;
        this.sec = d;
    }

    public TimeInstant(double d) throws Exception {
        this(d, null);
    }

    public TimeInstant(double d, String string) throws Exception {
        Date2 date2;
        double d2;
        super.setLocale(string);
        long l = (long)d;
        double d3 = d - (double)l;
        if (d3 < 0.0) {
            d3 += 1.0;
            --l;
        }
        if ((d2 = (d3 + (double)(l - (date2 = Date2.create(l)).getTime())) / 1000.0) < 0.0 || d2 > 86400.0) {
            String string2 = this.getClass().getName() + ": " + "ERROR: Invalid seconds offset from 00h:" + date2.getYear() + "/" + date2.getMonth() + "/" + date2.getDate() + ", offset: " + d2 + ", milliseconds: " + d;
            throw new Exception(string2);
        }
        int n = 0;
        int n2 = 0;
        while (d2 >= 60.0) {
            d2 -= 60.0;
            ++n;
        }
        if (d2 == -0.0) {
            d2 = 0.0;
        }
        while (d2 < 0.0) {
            d2 += 60.0;
            --n;
        }
        while (n >= 60) {
            n -= 60;
            ++n2;
        }
        while (n < 0) {
            n += 60;
            --n2;
        }
        this.ihour = n2;
        this.imin = n;
        this.sec = d2;
        this.year = date2.getYear();
        this.month = date2.getMonth() - 1;
        this.date = date2.getDate();
        this.dayOfYear = date2.getDoY();
    }

    public boolean equals(TimeInstant timeInstant) {
        if (!super.equals(timeInstant)) {
            return false;
        }
        if (this.ihour != timeInstant.ihour) {
            return false;
        }
        if (this.imin != timeInstant.imin) {
            return false;
        }
        return this.sec == timeInstant.sec;
    }

    public int getHours() {
        return this.ihour;
    }

    public int getMinutes() {
        return this.imin;
    }

    public double getSeconds() {
        return this.sec;
    }

    public TimeInstant add(double d) throws Exception {
        return new TimeInstant(this.getMillisecondTime() + 1000.0 * d);
    }

    public TimeInstant subtract(double d) throws Exception {
        return new TimeInstant(this.getMillisecondTime() - 1000.0 * d);
    }

    public static double secondsDifference(TimeInstant timeInstant, TimeInstant timeInstant2) {
        double d = timeInstant.getMillisecondTime() - timeInstant2.getMillisecondTime();
        return d /= 1000.0;
    }

    public static TimeInstant min(TimeInstant timeInstant, TimeInstant timeInstant2) {
        if (timeInstant == null) {
            return timeInstant2;
        }
        if (timeInstant2 == null) {
            return timeInstant;
        }
        if (TimeInstant.secondsDifference(timeInstant, timeInstant2) > 0.0) {
            return timeInstant2;
        }
        return timeInstant;
    }

    public static TimeInstant max(TimeInstant timeInstant, TimeInstant timeInstant2) {
        if (timeInstant == null) {
            return timeInstant2;
        }
        if (timeInstant2 == null) {
            return timeInstant;
        }
        if (TimeInstant.secondsDifference(timeInstant, timeInstant2) < 0.0) {
            return timeInstant2;
        }
        return timeInstant;
    }

    public double getMillisecondTime() {
        long l = super.getTime();
        double d = (double)l + 1000.0 * (this.sec + 60.0 * ((double)this.imin + 60.0 * (double)this.ihour));
        return d;
    }

    public String toString() {
        return this.toString(0, 3, true);
    }

    public String toString(int n, int n2, boolean bl) {
        if (bl) {
            return new String(this.toString2(n) + "  " + NumberFormat.intString(this.ihour, 2) + "h" + NumberFormat.intString(this.imin, 2) + "m" + NumberFormat.floatString((float)this.sec, n2 + 3, n2) + "s");
        }
        return new String(this.toString2(n) + " " + NumberFormat.intString(this.ihour, 2) + NumberFormat.intString(this.imin, 2) + " " + NumberFormat.floatString((float)this.sec, n2 + 3, n2));
    }

    public String toStringSeparated(String string, String string2, String string3, int n) {
        String string4 = NumberFormat.floatString((float)this.sec, n > 0 ? n + 3 : 3, n);
        if (n <= 0) {
            string4 = string4.substring(0, string4.indexOf(46));
        }
        return new String(super.toDelimitedString(string) + string2 + NumberFormat.intString(this.ihour, 2) + string3 + NumberFormat.intString(this.imin, 2) + string3 + string4);
    }

    public String toStringInvert(int n, int n2, boolean bl) {
        if (bl) {
            return new String(NumberFormat.intString(this.ihour, 2) + "h" + NumberFormat.intString(this.imin, 2) + "m" + NumberFormat.floatString((float)this.sec, n2 + 3, n2) + "s" + "  " + this.toString2(n));
        }
        return new String(NumberFormat.intString(this.ihour, 2) + NumberFormat.intString(this.imin, 2) + " " + NumberFormat.floatString((float)this.sec, n2 + 3, n2) + " " + this.toString2(n));
    }

    public String toStringDateOnly(int n, int n2, boolean bl) {
        return new String(this.toString2(n));
    }

    public String toDelimitedString(String string) {
        return this.toDelimitedString(string, null);
    }

    public String toDelimitedString(String string, java.text.NumberFormat numberFormat) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toDelimitedString(string)).append(string);
        stringBuffer.append(NumberFormat.intString(this.ihour, 2)).append(string);
        stringBuffer.append(NumberFormat.intString(this.imin, 2)).append(string);
        if (numberFormat != null) {
            stringBuffer.append(numberFormat.format(this.sec));
        } else {
            stringBuffer.append((float)this.sec);
        }
        return stringBuffer.toString();
    }

    public String toDelimitedStringIntSec(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toDelimitedString(string)).append(string);
        stringBuffer.append(NumberFormat.intString(this.ihour, 2)).append(string);
        stringBuffer.append(NumberFormat.intString(this.imin, 2)).append(string);
        stringBuffer.append(NumberFormat.intString((int)this.sec, 2));
        return stringBuffer.toString();
    }

    public String getTimeZoneID() {
        return calendar.getTimeZone().getID();
    }
}

