/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.volume3d;

import net.alomax.geog.GeogCoords;
import net.alomax.graphics3d.Vect3D;
import net.alomax.volume3d.GradientHalfSpaceModelAlgorithms;
import net.alomax.volume3d.SlownessModel;

public class GradientHalfSpaceModel
extends SlownessModel {
    GradientHalfSpaceModelAlgorithms pModel = null;
    String pWavetype = "";
    GradientHalfSpaceModelAlgorithms sModel = null;
    String sWavetype = "";

    public GradientHalfSpaceModel(double d, double d2, double d3, String string, double d4, double d5, double d6, String string2, double d7, double d8, Vect3D vect3D, Vect3D vect3D2, GeogCoords geogCoords) {
        super(vect3D, vect3D2, geogCoords);
        this.pWavetype = string;
        if (string != null) {
            this.pModel = new GradientHalfSpaceModelAlgorithms(d, d2, d3, d7, d8);
        }
        this.sWavetype = string2;
        if (string2 != null) {
            this.sModel = new GradientHalfSpaceModelAlgorithms(d4, d5, d6, d7, d8);
        }
    }

    public String toString() {
        String string = this.getClass().getName();
        try {
            string = string.substring(string.lastIndexOf(".") + 1);
        }
        catch (Exception exception) {
            // empty catch block
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.append(": ");
        stringBuffer.append(ENDLINE);
        if (this.pWavetype != null) {
            stringBuffer.append("wavetype: " + this.pWavetype + ", ");
            stringBuffer.append(this.pModel.toString());
            stringBuffer.append(ENDLINE);
        }
        if (this.sWavetype != null) {
            stringBuffer.append("wavetype: " + this.sWavetype + ", ");
            stringBuffer.append(this.sModel.toString());
            stringBuffer.append(ENDLINE);
        }
        return stringBuffer.toString();
    }

    public double getSlowness(Vect3D vect3D, String string) {
        if (this.pModel != null && string.equals(this.pWavetype)) {
            return 1.0 / this.pModel.getVelocity(vect3D.z);
        }
        if (this.sModel != null && string.equals(this.sWavetype)) {
            return 1.0 / this.sModel.getVelocity(vect3D.z);
        }
        return -1.0;
    }

    public double[] getPartialDerivatives(Vect3D vect3D, Vect3D vect3D2, String string) {
        double d = vect3D.x - vect3D2.x;
        double d2 = vect3D.y - vect3D2.y;
        double d3 = Math.sqrt(d * d + d2 * d2);
        double[] dArray = new double[]{0.0, 0.0};
        if (this.pModel != null && string.equals(this.pWavetype)) {
            dArray = this.pModel.getPartialDerivatives(vect3D.z, vect3D2.z, d3);
        } else if (this.sModel != null && string.equals(this.sWavetype)) {
            dArray = this.sModel.getPartialDerivatives(vect3D.z, vect3D2.z, d3);
        }
        if (d3 < Double.MIN_VALUE) {
            dArray[0] = 0.0;
            d3 = 1.0;
        }
        double[] dArray2 = new double[]{dArray[0] * d / d3, dArray[0] * d2 / d3, dArray[1], 1.0};
        return dArray2;
    }

    public double getTravelTime(Vect3D vect3D, Vect3D vect3D2, String string) {
        double d = vect3D.x - vect3D2.x;
        double d2 = vect3D.y - vect3D2.y;
        double d3 = Math.sqrt(d * d + d2 * d2);
        double d4 = 0.0;
        if (this.pModel != null && string.equals(this.pWavetype)) {
            d4 = this.pModel.getTravelTime(vect3D.z, vect3D2.z, d3);
        } else if (this.sModel != null && string.equals(this.sWavetype)) {
            d4 = this.sModel.getTravelTime(vect3D.z, vect3D2.z, d3);
        }
        return d4;
    }

    public static void main(String[] stringArray) {
        GradientHalfSpaceModel gradientHalfSpaceModel = new GradientHalfSpaceModel(5.0, 0.1, 8.0, "P", 3.0, 0.06, 6.0, "S", 20.0, 0.0, new Vect3D(0.0, 0.0, 0.0), new Vect3D(100.0, 100.0, 30.0), null);
        System.out.println("Model: " + gradientHalfSpaceModel);
        System.out.println("The velocity below the origin = ");
        Vect3D vect3D = gradientHalfSpaceModel.getOrigin();
        for (int i = 0; i < 25; ++i) {
            vect3D.z = i;
            System.out.println("z=" + i + ", v=" + 1.0 / gradientHalfSpaceModel.getSlowness(vect3D, "P"));
        }
        System.out.println("");
        System.out.println("The other values = ");
        System.out.println("");
        vect3D = gradientHalfSpaceModel.getOrigin();
        Vect3D vect3D2 = new Vect3D(0.0, 0.0, 0.0);
        for (int i = 0; i < 101; i += 10) {
            vect3D.x = i;
            for (int j = 0; j < 26; j += 5) {
                vect3D.z = (double)j + 0.001;
                System.out.print("loc=(" + i + "," + j + "), v=" + (float)(1.0 / gradientHalfSpaceModel.getSlowness(vect3D, "P")) + ", pd=[");
                double[] dArray = gradientHalfSpaceModel.getPartialDerivatives(vect3D, vect3D2, "P");
                for (int k = 0; k < dArray.length; ++k) {
                    System.out.print((float)dArray[k] + ", ");
                }
                System.out.print("], t=" + (float)gradientHalfSpaceModel.getTravelTime(vect3D, vect3D2, "P"));
                System.out.print(", i=" + (float)gradientHalfSpaceModel.pModel.getAngleOfIncidence(vect3D.z, 0.0, vect3D.x));
                System.out.println("");
            }
            System.out.println("");
        }
    }
}

