/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.xml;

import java.io.IOException;
import java.io.InputStream;
import net.alomax.xml.Attribute;

public class SimpleXMLParser {
    public static int TAG_BEGIN = 60;
    public static int TAG_END = 62;
    public static int ATTRIBUTE_SEPARATOR = 61;
    public static int ATTRIBUTE_DELIMITER1 = 34;
    public static int ATTRIBUTE_DELIMITER2 = 39;
    protected InputStream is = null;
    protected int lastRead = -999;
    protected boolean insideTag = false;

    public SimpleXMLParser(InputStream inputStream) {
        this.is = inputStream;
    }

    public String getNextTag() throws IOException {
        int n = this.lastRead;
        while (n != TAG_BEGIN) {
            this.lastRead = n = this.is.read();
            if (n != -1) continue;
            return null;
        }
        this.insideTag = true;
        this.lastRead = n = this.is.read();
        if (n == -1) {
            return null;
        }
        while (Character.isWhitespace((char)n) && n != TAG_END) {
            this.lastRead = n = this.is.read();
            if (n != -1) continue;
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        while (!Character.isWhitespace((char)n) && n != TAG_END) {
            stringBuffer.append((char)n);
            this.lastRead = n = this.is.read();
            if (n != -1) continue;
            return null;
        }
        if (n == TAG_END) {
            this.insideTag = false;
        }
        return stringBuffer.toString();
    }

    public Attribute getNextAttribute() throws IOException {
        if (!this.insideTag) {
            return null;
        }
        int n = this.lastRead;
        while (Character.isWhitespace((char)n)) {
            this.lastRead = n = this.is.read();
            if (n != -1) continue;
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        while (!Character.isWhitespace((char)n) && n != ATTRIBUTE_SEPARATOR && n != TAG_END) {
            stringBuffer.append((char)n);
            this.lastRead = n = this.is.read();
            if (n != -1) continue;
            return null;
        }
        if (n == TAG_END) {
            this.insideTag = false;
            return null;
        }
        Attribute attribute = new Attribute();
        attribute.name = stringBuffer.toString();
        while (Character.isWhitespace((char)n) || n == ATTRIBUTE_SEPARATOR || n == ATTRIBUTE_DELIMITER1 || n == ATTRIBUTE_DELIMITER2) {
            this.lastRead = n = this.is.read();
            if (n != -1) continue;
            return null;
        }
        stringBuffer = new StringBuffer();
        while (!Character.isWhitespace((char)n) && n != ATTRIBUTE_SEPARATOR && n != ATTRIBUTE_DELIMITER1 && n != ATTRIBUTE_DELIMITER2 && n != TAG_END) {
            stringBuffer.append((char)n);
            this.lastRead = n = this.is.read();
            if (n != -1) continue;
            return null;
        }
        if (n == TAG_END) {
            this.insideTag = false;
        }
        attribute.value = stringBuffer.toString();
        return attribute;
    }

    public void skipToTagEnd() throws IOException {
        int n = this.lastRead;
        while (n != TAG_END && n > 0) {
            this.lastRead = n = this.is.read();
        }
        this.insideTag = false;
    }

    public String getData() throws IOException {
        int n = this.lastRead;
        if (n != TAG_END) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        while (n != TAG_BEGIN) {
            stringBuffer.append((char)n);
            this.lastRead = n = this.is.read();
            if (n != -1) continue;
            return null;
        }
        return stringBuffer.toString();
    }
}

