/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.discovery;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Vector;
import org.apache.commons.discovery.ResourceIterator;

public class Resource {
    protected final String name;
    protected final URL resource;
    protected final ClassLoader loader;

    public Resource(String string, URL uRL, ClassLoader classLoader) {
        this.name = string;
        this.resource = uRL;
        this.loader = classLoader;
    }

    public String getName() {
        return this.name;
    }

    public URL getResource() {
        return this.resource;
    }

    public InputStream getResourceAsStream() {
        try {
            return this.resource.openStream();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public ClassLoader getClassLoader() {
        return this.loader;
    }

    public String toString() {
        return "Resource[" + this.getName() + ", " + this.getResource() + ", " + this.getClassLoader() + "]";
    }

    public static Resource[] toArray(ResourceIterator resourceIterator) {
        Vector<Resource> vector = new Vector<Resource>();
        while (resourceIterator.hasNext()) {
            vector.add(resourceIterator.nextResource());
        }
        Object[] objectArray = new Resource[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }
}

