/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.discovery.resource;

import java.util.Vector;
import org.apache.commons.discovery.jdk.JDKHooks;

public class ClassLoaders {
    protected Vector classLoaders = new Vector();

    public int size() {
        return this.classLoaders.size();
    }

    public ClassLoader get(int n) {
        return (ClassLoader)this.classLoaders.elementAt(n);
    }

    public void put(ClassLoader classLoader) {
        if (classLoader != null) {
            this.classLoaders.addElement(classLoader);
        }
    }

    public void put(ClassLoader classLoader, boolean bl) {
        if (!(classLoader == null || bl && this.isAncestor(classLoader))) {
            this.classLoaders.addElement(classLoader);
        }
    }

    public boolean isAncestor(ClassLoader classLoader) {
        if (classLoader == null) {
            return true;
        }
        for (int i = 0; i < this.size(); ++i) {
            for (ClassLoader classLoader2 = this.get(i); classLoader2 != null; classLoader2 = classLoader2.getParent()) {
                if (classLoader2 != classLoader) continue;
                return true;
            }
        }
        return false;
    }

    public static ClassLoaders getLibLoaders(Class clazz, Class clazz2, boolean bl) {
        ClassLoaders classLoaders = new ClassLoaders();
        if (clazz != null) {
            classLoaders.put(clazz.getClassLoader());
        }
        if (clazz2 != null) {
            classLoaders.put(clazz2.getClassLoader(), bl);
        }
        classLoaders.put(JDKHooks.getJDKHooks().getSystemClassLoader(), bl);
        return classLoaders;
    }

    public static ClassLoaders getAppLoaders(Class clazz, Class clazz2, boolean bl) {
        ClassLoaders classLoaders = new ClassLoaders();
        classLoaders.put(JDKHooks.getJDKHooks().getThreadContextClassLoader());
        if (clazz != null) {
            classLoaders.put(clazz.getClassLoader(), bl);
        }
        if (clazz2 != null) {
            classLoaders.put(clazz2.getClassLoader(), bl);
        }
        classLoaders.put(JDKHooks.getJDKHooks().getSystemClassLoader(), bl);
        return classLoaders;
    }
}

